DNS RESTful API             
========      

# API
The API gives access to the progress information for SIPs previously submitted to the DNS. Various kinds of SIP-Identification can be used to get the appropriate information.

## Service URL
Contractors *must* use the Service URL of their associated Service Provider. Secure HTTP (https) is supported exclusively. Redirect from http to https depends on the Providers facilities.  According to RFC-2616 all characters with special function in URL have to be encoded when using one of the services.

# Services

## Service "status/index"

* Service request: [/status/index](https://server/daweb3/status/index)
* Request method: GET
* Parameters:
    * identifier: the DNS internal identifier,
    * origName: the name of the object was submitted to the DNS,
    * urn: the urn generated by DNS,
    * containerName: the name of the SIP container orgininally submitted to the DNS
* Returns: JSON

### Description

Service returns information about the actual state of a SIP delivered to the DNS System. The SIP in request must be identified by one of the above defined parameters. It can be identified either with the DNS internal *identifier*, with the filename of the SIP as it was submitted originally into the system (*origName*) or the *urn* generated by DNS (or already being sent by SIP). 

The originalName should be the name, the item is listed in your own domain, while the other identifiers (identifier and urn) are build during the ingest process (or being sent by SIP). Container name correlates with the name of the file submitted including the file extension.

In case of sending Deltas to objects (and to determine their respective states during processing), *containerName* or *urn* should be used, while the *origName* of objects is not changed anymore. 

The JSON returned includes all types of information about the SIP submitted or the AIP being stored. 

* DNS specific process status: 
    * archived if AIP was successfully processed, 
    * "package in progress error" if DNS is unable to process SIP. The DNS internal status code is added as embraced number 
* all identifiers supported and/or generated by DNS
* Contractors identification

### Example-Request

    curl -v -H "Accept: application/json" X GET -u username --url "https://server/daweb3/status/index?urn=urn%3Anbn%3Ade%3Ahbz%3A6%3A1-31323"

### Example Response    

    {"result":
    [{"type":"Object","status":"archived","urn":"urn:nbn:de:hbz:6:1-31323","contractor":"hbzadmin","origName":"06-Apr-2016-T-15-10-01-urn+nbn+de+hbz+6+1-31323","identifier":"8-2016040610214","packages":["<package name for backward compliancy as numeric value"]}
## Authentification

Contractors must authenticate with BASIC AUTH. Credentials are same as contractor's.

[https://server/daweb3/](https://Server/daweb3/)
]}
    ]}

## Service "automatedRetrieval/queueForRetrievalJSON"

* Service request: [/automatedRetrieval/queueForRetrievalJSON](https://server/daweb3/automatedRetrieval/queueForRetrievalJSON)
* Request method: POST
* Parameters:
    * identifier: the DNS internal identifier,
    * origName: the name of the object was submitted to the DNS,
    * urn: the urn generated by DNS
* Returns: JSON


### Description
Service triggers the queuing of an Information Package for retrieval. The Information Package has to be stored within the DNS system previously and will be delivered to the Contractor's directory dedicated for package retrieval (e.g. outcoming). If successfully delivered Contractor can access the package via sftp, or if supported by Service Provider via daweb console.

The JSON POST Data must at least contain one of the following fields: urn, identifier, origName.

The response indicates the creation of retrieval request only. It does *neither* indicate successful delivery to the Contractor's outcoming directory *nor* the retrieval of DIP by Contractor.

### Example-Request

    curl -v -H "Accept: application/json" X POST -u username --url "https://server/daweb3/status/index?urn=urn%3Anbn%3Ade%3Ahbz%3A6%3A1-31323"

### Example Response    

The request should create a retrieval job. The response is: 

    {"success":"true"}
    
Otherwise 

    {"success":"false"}

   
    
# Version

* DNS RESTFul-API Version 1

# Revision

* No changes to previous version  
