	/*
	  DA-NRW Software Suite | ContentBroker
	  Copyright (C) 2013 Historisch-Kulturwissenschaftliche Informationsverarbeitung
	  Universität zu Köln
	
	  This program is free software: you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation, either version 3 of the License, or
	  (at your option) any later version.
	
	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program.  If not, see <http://www.gnu.org/licenses/>.
	*/

# Object model reference

The OAIS reference model provides the basic conceptual framework for our application.
As the term "reference" model already says, for the practical use of building and using an
application a refined object model, which fits the needs and requirements at hand is needed.
This model will be described in this document.

One of the fundamental requirements when building the software was the "delta" feature which should allow
users to add content to already existing objects. This feature has been considered as one of the trademark features
of the software to be build since inception of the project and therefore is reflected in the basic object model.
While it would seem natural for an application without the delta feature would be to create an object model
which derives its root entity directly from a generalization of the OAIS package types (AIP,SIP,DIP). We would then 
refer to this generalization simply as "package" or as "object". With deltas, however, the situation is slightly more
complex. Here an entity was needed, which can bind the contents of several SIPs together and makes them accessible under
one identifier. So it was decided to name this root entity the "object" and to refer to SIPs, AIPs, and DIPs as packages.
While this proofed to be a sound base for our technical solution, there are some occasion were the deviation from the
simple model (without deltas) has some implications which need more than a quick look to grasp. For example can a DIP
as a package contain either the objects complete data, or only a part of it. The same applies to an AIP. Depending on the
situtaion, it either can contain data derived only from one singly SIP or it can contain data from several SIPs. Therefore
the different concepts of our object model will be explained in detail in the following sections.


### Object

The Java [Object](../java/de/uzk/hki/da/model/Object.java) class.

The most fundamental entity in our data model is simply called the "object". 
An instance of an object is a logically coherent set of files.
Note that what makes these files coherent is up to the user (see pre_ingest.md). 
Every object in DNSCore will get a unique technical identifier within the system. This technical
identifier is the primary means of identifying and finding an object within the system. Therefore
it gets "handed over" to the user at the end of the ingest workflow.

![](https://raw.githubusercontent.com/da-nrw/DNSCore/master/ContentBroker/src/main/markdown/object_model_objects_packages.jpg)

Also each object is always in a certain object_state which indicates if the object is 

* 100: archived and valid 
* 50: at least on of the packages object is under control of the ContentBroker which runs a workflow to process it.
* 60: the object is beeing checked for integrity.
* 51: the object is corrupts (which can be for various reasons). 

**Note for Developers**

The object states are also used to ensure objects cannot be selected for starting 
new workflows if they are already in a workflow or under integrity check.

* state 51 should be set if GridFacade.isValid returns false.

Likewise, any object which is in a workflow cannot be selected for integrity check.

### Package

The Java [Package](../java/de/uzk/hki/da/model/Package.java) class.

While the object is more general entity a package in DNSCore 
is an actual physical container (tar) which contains the objects data or at least a part of it.
Most of the times one uses the term package rather than the more conceptual terms DIP,AIP,SIP from the OAIS model.
When users send their SIPs to the system, we also call these SIPs simply packages. When the ContentBroker
builds AIPs for storage, we also use the term package. In the standard use case ingest, 
the incoming package gets augmented by new data generated by the systems via
file format conversions or metadata updates. The original data and the new data gets then repacked into a new package and
put on long term resources. The same applies if you have a delta. The user ingests a second SIP and the system augments it
with new data before repacking it. The result is that you now have two packages, belonging to the same object!

Note that we extended the OAIS terms for our needs by the package type PIP (presentation information package).
The concept was introduced to facilitate communication when speaking about DIPs. The architecture of the software was 
designed from the ground up to give users constant access to copies of objects without accessing the AIPs for
DIP generation. Since this was a source of confusion in the early days of the project we decided to reflect
the different functions of original DIPs and DIPs for constant access (which we call presentation or publication) by
introducing the PIP concept.

### User

![](https://raw.githubusercontent.com/da-nrw/DNSCore/master/ContentBroker/src/main/markdown/object_model_object_users.jpg)

The Java [User](../java/de/uzk/hki/da/model/User.java) class.

The contractor is modeled to describe a party which delivers content to a system consisting of nodes running DNSCore.
Every contractor has one specific node to which it can deliver its content. This node processes the data and stores the
primary copy of AIPs while the other nodes of the grid store the replicas. The contractor is a more general notion for a user
of the system, which is typically a single person working for an institution having a contract with the system owner. However,
this doesn't matter for the application logic so there is only the contractor role and there is no distinction between different users
working for the same organization.

Note that in addition to and independently of the object identifier every contractor can create new objects or retrieve objects
with a special name property, which is unique among his objects and which is used to identify the object as well as with the oid. 
This property is called the "original name" of the object. (TODO link to delta / ingest)

TODO administrator, default, presenter

TODO contractor_short_name

### PreservationSystem


The Java [PreservationSystem](../java/de/uzk/hki/da/model/PreservationSystem.java) class.

The PreservationSystem represents the system as a  whole. It consists of several [Nodes](object_model.md#Node), to which contractors deliver content. The PreservationSystem provides rules for application of conversions ([ConversionPolicy](object_model.md#ConversionPolicy))s which are in effect globally as well as information about the [ConversionRoutine](object_model.md#ConversionRoutine)s which all nodes have to provide in a uniform manner.

### Node

The Java [Node](../java/de/uzk/hki/da/model/Node.java) class.

Contractors deliver content to nodes. The relationship between a contractor and "its" node (which is called primary node) is unique. Every Contractor delivers its objects always to the primary node. The node is a notion for a concrete technical system on the location of an operating company. Different nodes of different operating companies form a [PreservationSystem](object_model.md#PreservationSystem). The contractors content get mirrored between the nodes which form the PreservationSystem. The copies of the objects delivered to the primary node are formally called primary copies. 

### ConversionPolicy

The Java [ConversionPolicy](../java/de/uzk/hki/da/model/ConversionPolicy.java) class.

![](https://github.com/da-nrw/DNSCore/blob/master/ContentBroker/src/main/markdown/object_model_conversion_dafiles.jpg)

A ConversionPolicy is a system wide property which describes which ConversionRoutine is to be executed by the system
for every given file found in a SIP, either in the context of long term archival or in the context of publication.
It links the [PRONOM](http://www.nationalarchives.gov.uk/PRONOM/Default.aspx) format PUID against an associated ConversionRoutine via
the special contractor used for either publication (contractor PRESENTER) or long term archvial (contractor DEFAULT). The PUID is
determined by the system by making use of the [FIDO](https://github.com/da-nrw/DNSCore/blob/master/ContentBroker/src/main/markdown/3rdPartyTools.md) 
tool for format identification which is then stored as a property of DAFile which in turn is part of a ConversionInstruction which 
gets generated based on the ConversionProperty. To see how the system operates in context have a look at this [document](https://github.com/da-nrw/DNSCore/blob/master/ContentBroker/src/main/markdown/format_module.md#how-it-works---a-simple-example).

### ConversionRoutine

The Java [ConversionRoutine](../java/de/uzk/hki/da/model/ConversionRoutine.java) class.

A ConversionRoutine describes, how exactly a conversion has to be executed. It is a global property of the system 
and has to deliver reproducable outcomes on every node. A ConversionRoutine can consist of a block of JavaCode
or can make use of Unix CLI programs to execute the actual conversion. The exact behaviour of a conversion routine
consists of a block of Java code (the type property which refers to a ConversionStrategy) plus the arguments "params"
and optionally "target_suffix".

See also how it is used in [context](https://github.com/da-nrw/DNSCore/blob/master/ContentBroker/src/main/markdown/format_module.md#how-it-works---a-simple-example).

#### ConversionRoutine in the context of long term archival

It is in the responsibility of a domain expert to ensure that a specific ConversionRoutine does what it does in 
a quality assured and reproducible way, indepentently of the actual machine executing the conversion. The domain expert
has to decide that the configuration of the ConversionRoutine in the system wide database plus the code and the underlying
command line tools deliver the desired outcome. **Not yet implemented**, but planned for future versions is, that if cli plugins
are used, that DNSCore is able to enforce specific versions of a tool (requires an additional property "version"), which makes
it possible to make it testable in component tests after the domain expert has prepared it conceptually and tested it manually.




### DAFile

The java [DAFile](../java/de/uzk/hki/da/model/DAFile.java) class.

Note that the concrete model is implemented a little bit different from the conceptual model outlined in the following sketch. The representation is modeled as part of dafile and the document is only modelled implicitely by the rep_name in combination with relative_path.


![](https://raw.github.com/da-nrw/DNSCore/master/ContentBroker/src/main/markdown/object_model_dafiles_documents.jpg)

Each file stored within a package has a correspondent DAFile instance, which captures some properties
relevant to the business logic of the application.

The puid is used to store the file format of the file, determined by 
[FIDO](http://www.openplanetsfoundation.org/software/fido), 
and encoded in the [PRONOM](http://www.nationalarchives.gov.uk/PRONOM/Default.aspx) format.

Examples for the usage of representations can be found in [AIP specification](https://github.com/da-nrw/DNSCore/blob/master/ContentBroker/src/main/markdown/aip_specification.md).

### Representation

Representations make it possible to model the objects history on a file system level. For every package belonging to an object there are initially two representations. The +a representation contains the users data in unmodified form. The +b representatioins contains converted or modified versions of selected files. A representation has the form "yyyy_mm_dd+hh_mm+x". By sorting the rep_names alphabetically one can get a quick glance on the objects history (see also section "document").

An example for an object consisting of one initial import and two deltas could look like this (contents of the data folder):

    2014_10_01+12_12+a
    2014_10_01+12_12+b
    2015_10_03+10_00+a
    2015_10_03+10_00+b
    2016_09_03+01_10+a
    2016_09_03+01_10+b

The relative path of a file is always relative to the representation the file is contained in. A file

    [WorkArea]/[csn]/[oid]/data/2014_10_01+12_12+a/subfolder/abc.tif
    
therefore has the rep_name "2014_10_01+12_12+a" has the relative path "subfolder/abc.tif".

It is important to understand that the representations are independent of the package. They belong directly to the object (TODO repackaging)

#### Document

A document is uniquely definied by its DAFile's relative path subtracting the extension. The two files

    2014_10_01+12_12+a/subfolder/1.jpg
    2014_10_01+12_12+b/subfolder/1.tif
    
both share the document name "subfolder/1". The system treats them as one logical document. The file "1.tif" is treated as the successor of "1.jpg", independently of its origin, which can be either by modification, conversion or a delta by a user. For this system to work properly it is important that only one DAFile with a certain document name exists inside a representation.
    


