/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.gui;

import de.uzk.hki.da.gui.GuiMessageWriter;
import de.uzk.hki.da.gui.GuiProgressManager;
import de.uzk.hki.da.main.SIPBuilder;
import de.uzk.hki.da.metadata.ContractRights;
import de.uzk.hki.da.metadata.ContractSettings;
import de.uzk.hki.da.metadata.PremisXmlWriter;
import de.uzk.hki.da.metadata.PublicationRights;
import de.uzk.hki.da.sb.Feedback;
import de.uzk.hki.da.sb.SIPFactory;
import de.uzk.hki.da.sb.UserInputValidator;
import de.uzk.hki.da.utils.SetMaxText;
import de.uzk.hki.da.utils.StringUtilities;
import de.uzk.hki.da.utils.Utilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class Gui
extends JFrame {
    private static Logger logger = Logger.getLogger(Gui.class);
    private static final long serialVersionUID = -2783837120567684391L;
    private String buildNumber = Utilities.getBuildNumber();
    SIPFactory sipFactory = new SIPFactory();
    ContractSettings contractSettings = null;
    PremisXmlWriter premisWriter = new PremisXmlWriter();
    GuiMessageWriter messageWriter = new GuiMessageWriter();
    JFileChooser sourcePathChooser = new JFileChooser(new File("."));
    JFileChooser destinationPathChooser = new JFileChooser(new File("."));
    JFileChooser workingPathChooser = new JFileChooser(new File("."));
    JFileChooser contractFileLoadPathChooser = new JFileChooser(new File("."));
    JFileChooser contractFileSavePathChooser = new JFileChooser(new File("."));
    ClassLoader classloader = Gui.class.getClassLoader();
    Font standardFont;
    Font boldFont;
    String confFolderPath;
    String dataFolderPath;
    int startPanelWidth = 750;
    int startPanelHeight = 526;
    JPanel startPanel;
    JPanel loadStandardPanel;
    JPanel institutionPanel;
    JPanel institutionTempPanel;
    JPanel institutionRestrictionPanel;
    JPanel publicPanel;
    JPanel publicLicensePanel;
    JPanel publicTempPanel;
    JPanel publicRestrictionPanel;
    JPanel migrationPanel;
    JPanel savePanel;
    JPanel createPanel;
    JTabbedPane institutionTabbedPane;
    JPanel institutionTextPanel;
    JPanel institutionImagePanel;
    JPanel institutionAudioPanel;
    JPanel institutionVideoPanel;
    JTabbedPane publicTabbedPane;
    JPanel publicTextPanel;
    JPanel publicImagePanel;
    JPanel publicAudioPanel;
    JPanel publicVideoPanel;
    JLabel backgroundStartImageLabel;
    JLabel backgroundLoadStandardImageLabel;
    JLabel backgroundLicenseImageLabel;
    JLabel backgroundInstitutionImageLabel;
    JLabel backgroundInstitutionTempImageLabel;
    JLabel backgroundInstitutionRestrictionImageLabel;
    JLabel backgroundPublicImageLabel;
    JLabel backgroundPublicTempImageLabel;
    JLabel backgroundPublicRestrictionImageLabel;
    JLabel backgroundMigrationImageLabel;
    JLabel backgroundSaveImageLabel;
    JLabel backgroundCreateImageLabel;
    JLabel versionInfoLabel;
    JLabel welcomeLabel;
    JLabel sourceLabel;
    JLabel destinationLabel;
    JLabel workingLabel;
    JLabel rightsLabel;
    JLabel institutionLabel;
    JLabel institutionStartLabel;
    JLabel institutionTempStartDateLabel;
    JLabel institutionRestrictionHeadlineLabel;
    JLabel institutionRestrictionTextPagesLabel;
    JLabel institutionRestrictionImageLabel;
    JLabel institutionRestrictionImageTextTypeLabel;
    JLabel institutionRestrictionImageTextOpacityLabel;
    JLabel institutionRestrictionImageTextSizeLabel;
    JLabel institutionRestrictionAudioDurationLabel;
    JLabel institutionRestrictionVideoQualityLabel;
    JLabel institutionRestrictionVideoDurationLabel;
    JLabel licenseLabel;
    JLabel publicLabel;
    JLabel publicStartLabel;
    JLabel publicTempStartDateLabel;
    JLabel publicRestrictionHeadlineLabel;
    JLabel publicRestrictionTextPagesLabel;
    JLabel publicRestrictionImageLabel;
    JLabel publicRestrictionImageTextTypeLabel;
    JLabel publicRestrictionImageTextOpacityLabel;
    JLabel publicRestrictionImageTextSizeLabel;
    JLabel publicRestrictionAudioDurationLabel;
    JLabel publicRestrictionVideoQualityLabel;
    JLabel publicRestrictionVideoDurationLabel;
    JLabel migrationConversionLabel;
    JLabel migrationConditionLabel;
    JLabel saveLabel;
    JLabel createLabel;
    JLabel sipProgressDisplayLabel;
    JLabel sipProgressStepLabel;
    JTextArea welcomeArea;
    JTextArea rightsAreaOne;
    JTextArea rightsAreaTwo;
    JTextArea rightsAreaThree;
    JTextArea institutionArea;
    JTextArea institutionRestrictionArea;
    JTextArea institutionRestrictionTextArea;
    JTextArea institutionRestrictionImageArea;
    JTextArea licenseAreaOne;
    JTextArea publicArea;
    JTextArea publicDDBArea;
    JTextArea publicRestrictionArea;
    JTextArea publicRestrictionTextArea;
    JTextArea publicRestrictionImageArea;
    JTextArea migrationArea;
    JTextArea settingsOverviewInfoArea;
    JTextArea saveArea;
    JScrollPane settingsOverviewArea;
    JTextArea settingsOverviewTextArea;
    JTextArea createArea;
    JButton helpIconButton;
    JButton sourceChooserButton;
    JButton destinationChooserButton;
    JButton workingChooserButton;
    JButton goToLoadStandardButton;
    JButton loadContractButton;
    JButton standardContractButton;
    JButton goBackToStartButton;
    JButton goToLicenseButton;
    JButton goBackToLicenseOrInstitutionButton;
    JButton goToInstitutionButton;
    JButton goBackToLoadStandardButton;
    JButton goToInstitutionTempButton;
    JButton goBackToInstitutionButton;
    JButton goToInstitutionRestrictionOrPublicButton;
    JButton goBackToInstitutionTempButton;
    JButton goToPublicButton;
    JButton goBackToInstitutionRestrictionOrTempButton;
    JButton goToPublicTempButton;
    JButton goBackToPublicButton;
    JButton goToPublicRestrictionButton;
    JButton goBackToPublicTempButton;
    JButton goToMigrationButton;
    JButton goBackToPublicRestrictionOrPublicButton;
    JButton goToSaveButton;
    JButton saveButton;
    JButton goBackToMigrationButton;
    JButton goToCreateButton;
    JButton createButton;
    JButton goBackToSaveButton;
    JButton abortButton;
    JButton quitButton;
    JButton startActivatedIconButton;
    JButton startIconButton;
    JButton loadActivatedIconButton;
    JButton loadIconButton;
    JButton licenseActivatedIconButton;
    JButton licenseIconButton;
    JButton publicationActivatedIconButton;
    JButton publicationIconButton;
    JButton institutionActivatedIconButton;
    JButton institutionIconButton;
    JButton institutionTempActivatedIconButton;
    JButton institutionTempIconButton;
    JButton institutionRestrictionActivatedIconButton;
    JButton institutionRestrictionIconButton;
    JButton publicActivatedIconButton;
    JButton publicIconButton;
    JButton publicTempActivatedIconButton;
    JButton publicTempIconButton;
    JButton publicRestrictionActivatedIconButton;
    JButton publicRestrictionIconButton;
    JButton migrationActivatedIconButton;
    JButton migrationIconButton;
    JButton saveActivatedIconButton;
    JButton saveIconButton;
    JButton createActivatedIconButton;
    JButton createIconButton;
    ButtonGroup institutionAllowDenyGroup;
    JRadioButton institutionAllowRadioButton;
    JRadioButton institutionDenyRadioButton;
    ButtonGroup institutionTempLawGroup;
    JRadioButton institutionTempRadioButton;
    JRadioButton institutionLawRadioButton;
    JRadioButton institutionNoTempRestrictionRadioButton;
    ButtonGroup publicAllowDenyGroup;
    JRadioButton publicAllowRadioButton;
    JRadioButton publicDenyRadioButton;
    ButtonGroup publicTempLawGroup;
    JRadioButton publicTempRadioButton;
    JRadioButton publicLawRadioButton;
    JRadioButton publicNoTempRestrictionRadioButton;
    JRadioButton metadataLicenseRadioButton;
    JRadioButton premisLicenseRadioButton;
    JCheckBox collectionCheckBox;
    JCheckBox institutionTextRestrictionCheckBox;
    JCheckBox institutionImageRestrictionCheckBox;
    JCheckBox institutionImageTextCheckBox;
    JCheckBox institutionAudioRestrictionCheckBox;
    JCheckBox institutionVideoRestrictionCheckBox;
    JCheckBox institutionVideoDurationCheckBox;
    JCheckBox publicDDBCheckBox;
    JCheckBox publicTextRestrictionCheckBox;
    JCheckBox publicImageRestrictionCheckBox;
    JCheckBox publicImageTextCheckBox;
    JCheckBox publicAudioRestrictionCheckBox;
    JCheckBox publicVideoRestrictionCheckBox;
    JCheckBox publicVideoDurationCheckBox;
    JCheckBox compressionCheckBox;
    JTextField sourcePathTextField;
    JTextField destinationPathTextField;
    JTextField workingPathTextField;
    JTextField licenseTextField;
    JTextField collectionNameTextField;
    JTextField institutionTempStartDateTextField;
    JTextField institutionRestrictionTextPagesTextField;
    JTextField institutionRestrictionImageTextField;
    JTextField publicTempStartDateTextField;
    JTextField publicRestrictionTextPagesTextField;
    JTextField publicRestrictionImageTextField;
    JComboBox<String> kindOfSIPBuildingDropDown;
    JComboBox<ContractRights.CCLicense> licenseDropDown;
    JComboBox<String> institutionLawIdDropDown;
    JComboBox<String> institutionImageDropDown;
    JComboBox<String> institutionImageTextDropDown;
    JComboBox<String> institutionImageTextOpacityDropDown;
    JComboBox<String> institutionImageTextSizeDropDown;
    JComboBox<String> institutionAudioDurationDropDown;
    JComboBox<String> institutionVideoQualityDropDown;
    JComboBox<String> institutionVideoDurationDropDown;
    JComboBox<String> publicLawIdDropDown;
    JComboBox<String> publicImageDropDown;
    JComboBox<String> publicImageTextDropDown;
    JComboBox<String> publicImageTextOpacityDropDown;
    JComboBox<String> publicImageTextSizeDropDown;
    JComboBox<String> publicAudioDurationDropDown;
    JComboBox<String> publicVideoQualityDropDown;
    JComboBox<String> publicVideoDurationDropDown;
    JComboBox<String> migrationDropDown;
    JProgressBar progressBar;
    int oldTabPublic = -1;
    int oldTabInstitution = -1;

    public Gui(String confFolderPath, String dataFolderPath) {
        this.confFolderPath = confFolderPath;
        this.dataFolderPath = dataFolderPath;
        if (!new File(dataFolderPath).exists()) {
            new File(dataFolderPath).mkdir();
        }
        URL icon = this.classloader.getResource("images/sipBuilderIcon.png");
        URL logo = this.classloader.getResource(SIPBuilder.getProperties().getProperty("LOGO_FILE"));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image iconImage = toolkit.createImage(icon);
        Image logoImage = toolkit.createImage(logo);
        this.setIconImage(iconImage);
        this.messageWriter.setGui(this);
        this.messageWriter.setIconImage(logoImage);
        try {
            this.standardFont = Font.createFont(0, this.classloader.getResourceAsStream("fonts/DejaVuSans.ttf"));
            this.boldFont = Font.createFont(0, this.classloader.getResourceAsStream("fonts/DejaVuSans-Bold.ttf"));
        }
        catch (Exception e) {
            logger.error("Couldn't find font file", e);
            this.messageWriter.showMessage("Schriftart konnte nicht gefunden werden!\n" + e.getMessage(), -1);
        }
        try {
            this.contractSettings = new ContractSettings(confFolderPath);
        }
        catch (Exception e) {
            logger.error("Failed to load contract settings file", e);
            this.messageWriter.showMessage("Die Contract Settings konnten nicht geladen werden.\nDie Datei \"settings.xml\" im Verzeichnis \"conf\" wurde m\u00f6glicherweise\nver\u00e4ndert oder gel\u00f6scht.", 0);
            System.exit(Feedback.GUI_ERROR.toInt());
        }
        this.initialize();
        if (!this.loadStandardRights()) {
            System.exit(Feedback.GUI_ERROR.toInt());
        }
    }

    public void initialize() {
        this.initializePanels();
        this.initializeImageLabels();
        this.initializeTextLabels();
        this.initializeButtons();
        this.initializeTextAreas();
        this.initializeRadioButtons();
        this.initializeCheckBoxes();
        this.initializeTextFields();
        this.initializeComboBoxes();
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        this.defineElementPositions();
        this.addElementsToContentPane();
        this.oldTabPublic = this.publicTabbedPane.getSelectedIndex();
        this.oldTabInstitution = this.institutionTabbedPane.getSelectedIndex();
        this.createListeners();
        this.loadLastSessionSettings();
    }

    private void initializePanels() {
        this.institutionTabbedPane = new JTabbedPane();
        UIManager.put("TabbedPane.borderHightlightColor", Color.gray);
        this.institutionTabbedPane.updateUI();
        this.institutionTextPanel = new JPanel();
        this.institutionTextPanel.setOpaque(true);
        this.institutionTabbedPane.addTab("Text", this.institutionTextPanel);
        this.institutionImagePanel = new JPanel();
        this.institutionImagePanel.setOpaque(true);
        this.institutionTabbedPane.addTab("Bild", this.institutionImagePanel);
        this.institutionAudioPanel = new JPanel();
        this.institutionAudioPanel.setOpaque(true);
        this.institutionTabbedPane.addTab("Audio", this.institutionAudioPanel);
        this.institutionVideoPanel = new JPanel();
        this.institutionVideoPanel.setOpaque(true);
        this.institutionTabbedPane.addTab("Video", this.institutionVideoPanel);
        this.publicTabbedPane = new JTabbedPane();
        UIManager.put("TabbedPane.borderHightlightColor", Color.gray);
        this.publicTabbedPane.updateUI();
        this.publicTextPanel = new JPanel();
        this.publicTextPanel.setOpaque(true);
        this.publicTabbedPane.addTab("Text", this.publicTextPanel);
        this.publicImagePanel = new JPanel();
        this.publicImagePanel.setOpaque(true);
        this.publicTabbedPane.addTab("Bild", this.publicImagePanel);
        this.publicAudioPanel = new JPanel();
        this.publicAudioPanel.setOpaque(true);
        this.publicTabbedPane.addTab("Audio", this.publicAudioPanel);
        this.publicVideoPanel = new JPanel();
        this.publicVideoPanel.setOpaque(true);
        this.publicTabbedPane.addTab("Video", this.publicVideoPanel);
        this.startPanel = new JPanel();
        this.startPanel.setVisible(true);
        this.loadStandardPanel = new JPanel();
        this.loadStandardPanel.setVisible(false);
        this.institutionPanel = new JPanel();
        this.institutionPanel.setVisible(false);
        this.institutionTempPanel = new JPanel();
        this.institutionTempPanel.setVisible(false);
        this.institutionRestrictionPanel = new JPanel();
        this.institutionRestrictionPanel.setVisible(false);
        this.publicPanel = new JPanel();
        this.publicPanel.setVisible(false);
        this.publicLicensePanel = new JPanel();
        this.publicLicensePanel.setVisible(false);
        this.publicTempPanel = new JPanel();
        this.publicTempPanel.setVisible(false);
        this.publicRestrictionPanel = new JPanel();
        this.publicRestrictionPanel.setVisible(false);
        this.migrationPanel = new JPanel();
        this.migrationPanel.setVisible(false);
        this.savePanel = new JPanel();
        this.savePanel.setVisible(false);
        this.createPanel = new JPanel();
        this.createPanel.setVisible(false);
    }

    private void initializeImageLabels() {
        URL backgroundImage = this.classloader.getResource(SIPBuilder.getProperties().getProperty("BACKGROUND_FILE"));
        this.backgroundStartImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundLoadStandardImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundLicenseImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundInstitutionImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundInstitutionTempImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundInstitutionRestrictionImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundPublicImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundPublicTempImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundPublicRestrictionImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundMigrationImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundSaveImageLabel = new JLabel(new ImageIcon(backgroundImage));
        this.backgroundCreateImageLabel = new JLabel(new ImageIcon(backgroundImage));
    }

    private void initializeTextLabels() {
        this.versionInfoLabel = new JLabel("SIP-Builder Build: " + this.buildNumber + ", LVR-InfoKom (ab 2014). HKI, Universit\u00e4t zu K\u00f6ln 2011-2014.");
        this.versionInfoLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.versionInfoLabel.setHorizontalAlignment(0);
        this.versionInfoLabel.setForeground(Color.WHITE);
        this.welcomeLabel = new JLabel("Herzlich Willkommen im SIP-Builder!");
        this.welcomeLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.sourceLabel = new JLabel("Quellordner:");
        this.sourceLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.destinationLabel = new JLabel("Zielordner:");
        this.destinationLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.workingLabel = new JLabel("Arbeitsordner:");
        this.workingLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.rightsLabel = new JLabel("Rechteeinstellungen");
        this.rightsLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.licenseLabel = new JLabel("Lizenzangaben");
        this.licenseLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.institutionLabel = new JLabel("Publikation f\u00fcr die eigene Institution");
        this.institutionLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.institutionStartLabel = new JLabel("Startzeitpunkt der Publikation");
        this.institutionStartLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.institutionTempStartDateLabel = new JLabel("Startdatum der institutionellen Publikation:");
        this.institutionTempStartDateLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionTempStartDateLabel.setEnabled(false);
        this.institutionRestrictionHeadlineLabel = new JLabel("Vorschaurestriktionen f\u00fcr die eigene Institution");
        this.institutionRestrictionHeadlineLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.institutionRestrictionTextPagesLabel = new JLabel("Welche Seiten sollen angezeigt werden?");
        this.institutionRestrictionTextPagesLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionTextPagesLabel.setEnabled(false);
        this.institutionRestrictionImageLabel = new JLabel("Bitte geben Sie den gew\u00fcnschten Text an (max. 65 Zeichen):");
        this.institutionRestrictionImageLabel.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionRestrictionImageLabel.setEnabled(false);
        this.institutionRestrictionImageTextTypeLabel = new JLabel("Texttyp:");
        this.institutionRestrictionImageTextTypeLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.institutionRestrictionImageTextTypeLabel.setEnabled(false);
        this.institutionRestrictionImageTextOpacityLabel = new JLabel("Sichtbarkeit:");
        this.institutionRestrictionImageTextOpacityLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.institutionRestrictionImageTextOpacityLabel.setEnabled(false);
        this.institutionRestrictionImageTextSizeLabel = new JLabel("Schriftgr\u00f6\u00dfe:");
        this.institutionRestrictionImageTextSizeLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.institutionRestrictionImageTextSizeLabel.setEnabled(false);
        this.institutionRestrictionAudioDurationLabel = new JLabel("Wieviele Sekunden sollen abspielbar sein?");
        this.institutionRestrictionAudioDurationLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionAudioDurationLabel.setEnabled(false);
        this.institutionRestrictionVideoQualityLabel = new JLabel("In welcher Qualit\u00e4t sollen Ihre Videos abgespielt werden?");
        this.institutionRestrictionVideoQualityLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionVideoQualityLabel.setEnabled(false);
        this.institutionRestrictionVideoDurationLabel = new JLabel("Wieviele Sekunden sollen abspielbar sein?");
        this.institutionRestrictionVideoDurationLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionVideoDurationLabel.setEnabled(false);
        this.publicLabel = new JLabel("Publikation f\u00fcr die \u00d6ffentlichkeit");
        this.publicLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.publicStartLabel = new JLabel("Startzeitpunkt der Publikation");
        this.publicStartLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.publicTempStartDateLabel = new JLabel("Startdatum der \u00f6ffentlichen Publikation:");
        this.publicTempStartDateLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.publicTempStartDateLabel.setEnabled(false);
        this.publicRestrictionHeadlineLabel = new JLabel("Vorschaurestriktionen f\u00fcr die \u00d6ffentlichkeit");
        this.publicRestrictionHeadlineLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.publicRestrictionTextPagesLabel = new JLabel("Welche Seiten sollen angezeigt werden?");
        this.publicRestrictionTextPagesLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionTextPagesLabel.setEnabled(false);
        this.publicRestrictionImageLabel = new JLabel("Bitte geben Sie den gew\u00fcnschten Text an (max. 65 Zeichen):");
        this.publicRestrictionImageLabel.setFont(this.standardFont.deriveFont(11.0f));
        this.publicRestrictionImageLabel.setEnabled(false);
        this.publicRestrictionImageTextTypeLabel = new JLabel("Texttyp:");
        this.publicRestrictionImageTextTypeLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.publicRestrictionImageTextTypeLabel.setEnabled(false);
        this.publicRestrictionImageTextOpacityLabel = new JLabel("Sichtbarkeit:");
        this.publicRestrictionImageTextOpacityLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.publicRestrictionImageTextOpacityLabel.setEnabled(false);
        this.publicRestrictionImageTextSizeLabel = new JLabel("Schriftgr\u00f6\u00dfe:");
        this.publicRestrictionImageTextSizeLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.publicRestrictionImageTextSizeLabel.setEnabled(false);
        this.publicRestrictionAudioDurationLabel = new JLabel("Wieviele Sekunden sollen abspielbar sein?");
        this.publicRestrictionAudioDurationLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionAudioDurationLabel.setEnabled(false);
        this.publicRestrictionVideoQualityLabel = new JLabel("In welcher Qualit\u00e4t sollen Ihre Videos abgespielt werden?");
        this.publicRestrictionVideoQualityLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionVideoQualityLabel.setEnabled(false);
        this.publicRestrictionVideoDurationLabel = new JLabel("Wieviele Sekunden sollen abspielbar sein?");
        this.publicRestrictionVideoDurationLabel.setEnabled(false);
        this.publicRestrictionVideoDurationLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.migrationConversionLabel = new JLabel("Konversions- und Migrationseinstellungen");
        this.migrationConversionLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.migrationConditionLabel = new JLabel("Migrationsbedingung:");
        this.migrationConditionLabel.setFont(this.standardFont.deriveFont(10.0f));
        this.saveLabel = new JLabel("Einstellungen speichern");
        this.saveLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.createLabel = new JLabel("SIP-Generierungsprozess starten");
        this.createLabel.setFont(this.boldFont.deriveFont(12.0f));
        this.sipProgressDisplayLabel = new JLabel();
        this.sipProgressDisplayLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.sipProgressDisplayLabel.setHorizontalAlignment(0);
        this.sipProgressStepLabel = new JLabel();
        this.sipProgressStepLabel.setFont(this.standardFont.deriveFont(12.0f));
        this.sipProgressStepLabel.setHorizontalAlignment(0);
    }

    private void initializeButtons() {
        URL helpImage = this.classloader.getResource("images/help.png");
        URL createButtonImage = this.classloader.getResource("images/createButton.png");
        URL dotsButtonImage = this.classloader.getResource("images/dotsButton.png");
        URL saveButtonImage = this.classloader.getResource("images/saveButton.png");
        URL loadButtonImage = this.classloader.getResource("images/loadButton.png");
        URL standardButtonImage = this.classloader.getResource("images/standardButton.png");
        URL goToButtonImage = this.classloader.getResource("images/goToButton.png");
        URL goBackToButtonImage = this.classloader.getResource("images/goBackToButton.png");
        URL abortButtonImage = this.classloader.getResource("images/abortButton.png");
        URL quitButtonImage = this.classloader.getResource("images/quitButton.png");
        this.helpIconButton = new JButton(new ImageIcon(helpImage));
        this.helpIconButton.setBorder(null);
        this.helpIconButton.setCursor(new Cursor(12));
        this.helpIconButton.setBackground(new Color(0, 0, 0, 0));
        this.helpIconButton.setContentAreaFilled(false);
        this.sourceChooserButton = new JButton(new ImageIcon(dotsButtonImage));
        this.sourceChooserButton.setBorder(null);
        this.sourceChooserButton.setCursor(new Cursor(12));
        this.sourceChooserButton.setBackground(new Color(0, 0, 0, 0));
        this.sourceChooserButton.setContentAreaFilled(false);
        this.destinationChooserButton = new JButton(new ImageIcon(dotsButtonImage));
        this.destinationChooserButton.setBorder(null);
        this.destinationChooserButton.setCursor(new Cursor(12));
        this.destinationChooserButton.setBackground(new Color(0, 0, 0, 0));
        this.destinationChooserButton.setContentAreaFilled(false);
        this.workingChooserButton = new JButton(new ImageIcon(dotsButtonImage));
        this.workingChooserButton.setBorder(null);
        this.workingChooserButton.setCursor(new Cursor(12));
        this.workingChooserButton.setBackground(new Color(0, 0, 0, 0));
        this.workingChooserButton.setContentAreaFilled(false);
        this.goToLoadStandardButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToLoadStandardButton.setBorder(null);
        this.goToLoadStandardButton.setCursor(new Cursor(12));
        this.goToLoadStandardButton.setBackground(new Color(0, 0, 0, 0));
        this.goToLoadStandardButton.setContentAreaFilled(false);
        this.loadContractButton = new JButton(new ImageIcon(loadButtonImage));
        this.loadContractButton.setBorder(null);
        this.loadContractButton.setCursor(new Cursor(12));
        this.loadContractButton.setBackground(new Color(0, 0, 0, 0));
        this.loadContractButton.setContentAreaFilled(false);
        this.standardContractButton = new JButton(new ImageIcon(standardButtonImage));
        this.standardContractButton.setBorder(null);
        this.standardContractButton.setCursor(new Cursor(12));
        this.standardContractButton.setBackground(new Color(0, 0, 0, 0));
        this.standardContractButton.setContentAreaFilled(false);
        this.goBackToStartButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToStartButton.setBorder(null);
        this.goBackToStartButton.setCursor(new Cursor(12));
        this.goBackToStartButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToStartButton.setContentAreaFilled(false);
        this.goToLicenseButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToLicenseButton.setBorder(null);
        this.goToLicenseButton.setCursor(new Cursor(12));
        this.goToLicenseButton.setBackground(new Color(0, 0, 0, 0));
        this.goToLicenseButton.setContentAreaFilled(false);
        this.goBackToLicenseOrInstitutionButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToLicenseOrInstitutionButton.setBorder(null);
        this.goBackToLicenseOrInstitutionButton.setCursor(new Cursor(12));
        this.goBackToLicenseOrInstitutionButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToLicenseOrInstitutionButton.setContentAreaFilled(false);
        this.goToInstitutionButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToInstitutionButton.setBorder(null);
        this.goToInstitutionButton.setCursor(new Cursor(12));
        this.goToInstitutionButton.setBackground(new Color(0, 0, 0, 0));
        this.goToInstitutionButton.setContentAreaFilled(false);
        this.goBackToLoadStandardButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToLoadStandardButton.setBorder(null);
        this.goBackToLoadStandardButton.setCursor(new Cursor(12));
        this.goBackToLoadStandardButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToLoadStandardButton.setContentAreaFilled(false);
        this.goToInstitutionTempButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToInstitutionTempButton.setBorder(null);
        this.goToInstitutionTempButton.setCursor(new Cursor(12));
        this.goToInstitutionTempButton.setBackground(new Color(0, 0, 0, 0));
        this.goToInstitutionTempButton.setContentAreaFilled(false);
        this.goBackToInstitutionButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToInstitutionButton.setBorder(null);
        this.goBackToInstitutionButton.setCursor(new Cursor(12));
        this.goBackToInstitutionButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToInstitutionButton.setContentAreaFilled(false);
        this.goToInstitutionRestrictionOrPublicButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToInstitutionRestrictionOrPublicButton.setBorder(null);
        this.goToInstitutionRestrictionOrPublicButton.setCursor(new Cursor(12));
        this.goToInstitutionRestrictionOrPublicButton.setBackground(new Color(0, 0, 0, 0));
        this.goToInstitutionRestrictionOrPublicButton.setContentAreaFilled(false);
        this.goBackToInstitutionTempButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToInstitutionTempButton.setBorder(null);
        this.goBackToInstitutionTempButton.setCursor(new Cursor(12));
        this.goBackToInstitutionTempButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToInstitutionTempButton.setContentAreaFilled(false);
        this.goToPublicButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToPublicButton.setBorder(null);
        this.goToPublicButton.setCursor(new Cursor(12));
        this.goToPublicButton.setBackground(new Color(0, 0, 0, 0));
        this.goToPublicButton.setContentAreaFilled(false);
        this.goBackToInstitutionRestrictionOrTempButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToInstitutionRestrictionOrTempButton.setBorder(null);
        this.goBackToInstitutionRestrictionOrTempButton.setCursor(new Cursor(12));
        this.goBackToInstitutionRestrictionOrTempButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToInstitutionRestrictionOrTempButton.setContentAreaFilled(false);
        this.goToPublicTempButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToPublicTempButton.setBorder(null);
        this.goToPublicTempButton.setCursor(new Cursor(12));
        this.goToPublicTempButton.setBackground(new Color(0, 0, 0, 0));
        this.goToPublicTempButton.setContentAreaFilled(false);
        this.goBackToPublicButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToPublicButton.setBorder(null);
        this.goBackToPublicButton.setCursor(new Cursor(12));
        this.goBackToPublicButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToPublicButton.setContentAreaFilled(false);
        this.goToPublicRestrictionButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToPublicRestrictionButton.setBorder(null);
        this.goToPublicRestrictionButton.setCursor(new Cursor(12));
        this.goToPublicRestrictionButton.setBackground(new Color(0, 0, 0, 0));
        this.goToPublicRestrictionButton.setContentAreaFilled(false);
        this.goBackToPublicTempButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToPublicTempButton.setBorder(null);
        this.goBackToPublicTempButton.setCursor(new Cursor(12));
        this.goBackToPublicTempButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToPublicTempButton.setContentAreaFilled(false);
        this.goToMigrationButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToMigrationButton.setBorder(null);
        this.goToMigrationButton.setCursor(new Cursor(12));
        this.goToMigrationButton.setBackground(new Color(0, 0, 0, 0));
        this.goToMigrationButton.setContentAreaFilled(false);
        this.goBackToPublicRestrictionOrPublicButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToPublicRestrictionOrPublicButton.setBorder(null);
        this.goBackToPublicRestrictionOrPublicButton.setCursor(new Cursor(12));
        this.goBackToPublicRestrictionOrPublicButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToPublicRestrictionOrPublicButton.setContentAreaFilled(false);
        this.goToSaveButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToSaveButton.setBorder(null);
        this.goToSaveButton.setCursor(new Cursor(12));
        this.goToSaveButton.setBackground(new Color(0, 0, 0, 0));
        this.goToSaveButton.setContentAreaFilled(false);
        this.saveButton = new JButton(new ImageIcon(saveButtonImage));
        this.saveButton.setBorder(null);
        this.saveButton.setCursor(new Cursor(12));
        this.saveButton.setBackground(new Color(0, 0, 0, 0));
        this.saveButton.setContentAreaFilled(false);
        this.goBackToMigrationButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToMigrationButton.setBorder(null);
        this.goBackToMigrationButton.setCursor(new Cursor(12));
        this.goBackToMigrationButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToMigrationButton.setContentAreaFilled(false);
        this.goToCreateButton = new JButton(new ImageIcon(goToButtonImage));
        this.goToCreateButton.setBorder(null);
        this.goToCreateButton.setCursor(new Cursor(12));
        this.goToCreateButton.setBackground(new Color(0, 0, 0, 0));
        this.goToCreateButton.setContentAreaFilled(false);
        this.createButton = new JButton(new ImageIcon(createButtonImage));
        this.createButton.setBorder(null);
        this.createButton.setCursor(new Cursor(12));
        this.createButton.setBackground(new Color(0, 0, 0, 0));
        this.createButton.setContentAreaFilled(false);
        this.goBackToSaveButton = new JButton(new ImageIcon(goBackToButtonImage));
        this.goBackToSaveButton.setBorder(null);
        this.goBackToSaveButton.setCursor(new Cursor(12));
        this.goBackToSaveButton.setBackground(new Color(0, 0, 0, 0));
        this.goBackToSaveButton.setContentAreaFilled(false);
        this.abortButton = new JButton(new ImageIcon(abortButtonImage));
        this.abortButton.setBorder(null);
        this.abortButton.setCursor(new Cursor(12));
        this.abortButton.setBackground(new Color(0, 0, 0, 0));
        this.abortButton.setContentAreaFilled(false);
        this.abortButton.setEnabled(false);
        this.abortButton.setVisible(false);
        this.quitButton = new JButton(new ImageIcon(quitButtonImage));
        this.quitButton.setBorder(null);
        this.quitButton.setCursor(new Cursor(12));
        this.quitButton.setBackground(new Color(0, 0, 0, 0));
        this.quitButton.setContentAreaFilled(false);
        this.quitButton.setEnabled(false);
        this.quitButton.setVisible(false);
        URL startActivatedIconImage = this.classloader.getResource("images/startActivated.png");
        URL startIconImage = this.classloader.getResource("images/start.png");
        URL loadActivatedIconImage = this.classloader.getResource("images/loadActivated.png");
        URL loadIconImage = this.classloader.getResource("images/load.png");
        URL licenseActivatedIconImage = this.classloader.getResource("images/licenseActivated.png");
        URL licenseIconImage = this.classloader.getResource("images/license.png");
        URL publicationActivatedIconImage = this.classloader.getResource("images/publicationActivated.png");
        URL publicationIconImage = this.classloader.getResource("images/publication.png");
        URL institutionActivatedIconImage = this.classloader.getResource("images/institutionActivated.png");
        URL institutionIconImage = this.classloader.getResource("images/institution.png");
        URL institutionTempActivatedIconImage = this.classloader.getResource("images/tempActivated.png");
        URL institutionTempIconImage = this.classloader.getResource("images/temp.png");
        URL institutionRestrictionActivatedIconImage = this.classloader.getResource("images/restrictionActivated.png");
        URL institutionRestrictionIconImage = this.classloader.getResource("images/restriction.png");
        URL publicActivatedIconImage = this.classloader.getResource("images/publicActivated.png");
        URL publicIconImage = this.classloader.getResource("images/public.png");
        URL publicTempActivatedIconImage = this.classloader.getResource("images/tempActivated.png");
        URL publicTempIconImage = this.classloader.getResource("images/temp.png");
        URL publicRestrictionActivatedIconImage = this.classloader.getResource("images/restrictionActivated.png");
        URL publicRestrictionIconImage = this.classloader.getResource("images/restriction.png");
        URL migrationActivatedIconImage = this.classloader.getResource("images/migrationActivated.png");
        URL migrationIconImage = this.classloader.getResource("images/migration.png");
        URL saveActivatedIconImage = this.classloader.getResource("images/saveActivated.png");
        URL saveIconImage = this.classloader.getResource("images/save.png");
        URL createActivatedIconImage = this.classloader.getResource("images/createActivated.png");
        URL createIconImage = this.classloader.getResource("images/create.png");
        this.startActivatedIconButton = new JButton(new ImageIcon(startActivatedIconImage));
        this.startActivatedIconButton.setVisible(true);
        this.startActivatedIconButton.setBorder(null);
        this.startActivatedIconButton.setCursor(new Cursor(12));
        this.startIconButton = new JButton(new ImageIcon(startIconImage));
        this.startIconButton.setVisible(false);
        this.startIconButton.setBorder(null);
        this.startIconButton.setCursor(new Cursor(12));
        this.loadActivatedIconButton = new JButton(new ImageIcon(loadActivatedIconImage));
        this.loadActivatedIconButton.setVisible(false);
        this.loadActivatedIconButton.setBorder(null);
        this.loadActivatedIconButton.setCursor(new Cursor(12));
        this.loadIconButton = new JButton(new ImageIcon(loadIconImage));
        this.loadIconButton.setVisible(true);
        this.loadIconButton.setBorder(null);
        this.loadIconButton.setCursor(new Cursor(12));
        this.licenseActivatedIconButton = new JButton(new ImageIcon(licenseActivatedIconImage));
        this.licenseActivatedIconButton.setVisible(false);
        this.licenseActivatedIconButton.setBorder(null);
        this.licenseActivatedIconButton.setCursor(new Cursor(12));
        this.licenseIconButton = new JButton(new ImageIcon(licenseIconImage));
        this.licenseIconButton.setVisible(true);
        this.licenseIconButton.setBorder(null);
        this.licenseIconButton.setCursor(new Cursor(12));
        this.publicationActivatedIconButton = new JButton(new ImageIcon(publicationActivatedIconImage));
        this.publicationActivatedIconButton.setVisible(false);
        this.publicationActivatedIconButton.setBorder(null);
        this.publicationActivatedIconButton.setCursor(new Cursor(12));
        this.publicationIconButton = new JButton(new ImageIcon(publicationIconImage));
        this.publicationIconButton.setVisible(true);
        this.publicationIconButton.setBorder(null);
        this.publicationIconButton.setCursor(new Cursor(12));
        this.institutionActivatedIconButton = new JButton(new ImageIcon(institutionActivatedIconImage));
        this.institutionActivatedIconButton.setVisible(false);
        this.institutionActivatedIconButton.setBorder(null);
        this.institutionActivatedIconButton.setCursor(new Cursor(12));
        this.institutionIconButton = new JButton(new ImageIcon(institutionIconImage));
        this.institutionIconButton.setVisible(true);
        this.institutionIconButton.setBorder(null);
        this.institutionIconButton.setCursor(new Cursor(12));
        this.institutionTempActivatedIconButton = new JButton(new ImageIcon(institutionTempActivatedIconImage));
        this.institutionTempActivatedIconButton.setVisible(false);
        this.institutionTempActivatedIconButton.setBorder(null);
        this.institutionTempActivatedIconButton.setCursor(new Cursor(12));
        this.institutionTempIconButton = new JButton(new ImageIcon(institutionTempIconImage));
        this.institutionTempIconButton.setVisible(true);
        this.institutionTempIconButton.setBorder(null);
        this.institutionTempIconButton.setCursor(new Cursor(12));
        this.institutionRestrictionActivatedIconButton = new JButton(new ImageIcon(institutionRestrictionActivatedIconImage));
        this.institutionRestrictionActivatedIconButton.setVisible(false);
        this.institutionRestrictionActivatedIconButton.setBorder(null);
        this.institutionRestrictionActivatedIconButton.setCursor(new Cursor(12));
        this.institutionRestrictionIconButton = new JButton(new ImageIcon(institutionRestrictionIconImage));
        this.institutionRestrictionIconButton.setVisible(true);
        this.institutionRestrictionIconButton.setBorder(null);
        this.institutionRestrictionIconButton.setCursor(new Cursor(12));
        this.publicActivatedIconButton = new JButton(new ImageIcon(publicActivatedIconImage));
        this.publicActivatedIconButton.setVisible(false);
        this.publicActivatedIconButton.setBorder(null);
        this.publicActivatedIconButton.setCursor(new Cursor(12));
        this.publicIconButton = new JButton(new ImageIcon(publicIconImage));
        this.publicIconButton.setVisible(true);
        this.publicIconButton.setBorder(null);
        this.publicIconButton.setCursor(new Cursor(12));
        this.publicTempActivatedIconButton = new JButton(new ImageIcon(publicTempActivatedIconImage));
        this.publicTempActivatedIconButton.setVisible(false);
        this.publicTempActivatedIconButton.setBorder(null);
        this.publicTempActivatedIconButton.setCursor(new Cursor(12));
        this.publicTempIconButton = new JButton(new ImageIcon(publicTempIconImage));
        this.publicTempIconButton.setVisible(true);
        this.publicTempIconButton.setBorder(null);
        this.publicTempIconButton.setCursor(new Cursor(12));
        this.publicRestrictionActivatedIconButton = new JButton(new ImageIcon(publicRestrictionActivatedIconImage));
        this.publicRestrictionActivatedIconButton.setVisible(false);
        this.publicRestrictionActivatedIconButton.setBorder(null);
        this.publicRestrictionActivatedIconButton.setCursor(new Cursor(12));
        this.publicRestrictionIconButton = new JButton(new ImageIcon(publicRestrictionIconImage));
        this.publicRestrictionIconButton.setVisible(true);
        this.publicRestrictionIconButton.setBorder(null);
        this.publicRestrictionIconButton.setCursor(new Cursor(12));
        this.migrationActivatedIconButton = new JButton(new ImageIcon(migrationActivatedIconImage));
        this.migrationActivatedIconButton.setVisible(false);
        this.migrationActivatedIconButton.setBorder(null);
        this.migrationActivatedIconButton.setCursor(new Cursor(12));
        this.migrationIconButton = new JButton(new ImageIcon(migrationIconImage));
        this.migrationIconButton.setVisible(true);
        this.migrationIconButton.setBorder(null);
        this.migrationIconButton.setCursor(new Cursor(12));
        this.saveActivatedIconButton = new JButton(new ImageIcon(saveActivatedIconImage));
        this.saveActivatedIconButton.setVisible(false);
        this.saveActivatedIconButton.setBorder(null);
        this.saveActivatedIconButton.setCursor(new Cursor(12));
        this.saveIconButton = new JButton(new ImageIcon(saveIconImage));
        this.saveIconButton.setVisible(true);
        this.saveIconButton.setBorder(null);
        this.saveIconButton.setCursor(new Cursor(12));
        this.createActivatedIconButton = new JButton(new ImageIcon(createActivatedIconImage));
        this.createActivatedIconButton.setVisible(false);
        this.createActivatedIconButton.setBorder(null);
        this.createActivatedIconButton.setCursor(new Cursor(12));
        this.createIconButton = new JButton(new ImageIcon(createIconImage));
        this.createIconButton.setVisible(true);
        this.createIconButton.setBorder(null);
        this.createIconButton.setCursor(new Cursor(12));
    }

    private void initializeTextAreas() {
        this.welcomeArea = new JTextArea();
        this.welcomeArea.setEditable(false);
        this.welcomeArea.setOpaque(false);
        this.welcomeArea.setLineWrap(true);
        this.welcomeArea.setWrapStyleWord(true);
        this.welcomeArea.setFocusable(false);
        this.welcomeArea.setFont(this.standardFont.deriveFont(12.0f));
        this.welcomeArea.setText("W\u00e4hlen Sie zun\u00e4chst aus, wo die Daten aufzufinden sind, die Sie einliefern wollen.\n\nGeben Sie dann den Pfad zum Zielordner an, in dem die SIPs gespeichert werden sollen.\n\nOptional k\u00f6nnen Sie ein zur Zwischenspeicherung benutztes Arbeitsverzeichnis angeben.");
        this.rightsAreaOne = new JTextArea();
        this.rightsAreaOne.setEditable(false);
        this.rightsAreaOne.setOpaque(false);
        this.rightsAreaOne.setLineWrap(true);
        this.rightsAreaOne.setWrapStyleWord(true);
        this.rightsAreaOne.setFocusable(false);
        this.rightsAreaOne.setFont(this.standardFont.deriveFont(12.0f));
        this.rightsAreaOne.setText("In den folgenden Schritten k\u00f6nnen Sie die Publikations- und Migrationsrechte f\u00fcr Ihre SIPs festlegen.\n\nFalls Sie diese Einstellungen schon einmal vorgenommen und gespeichert haben, k\u00f6nnen Sie sie jetzt laden:");
        this.licenseAreaOne = new JTextArea();
        this.licenseAreaOne.setEditable(false);
        this.licenseAreaOne.setOpaque(false);
        this.licenseAreaOne.setLineWrap(true);
        this.licenseAreaOne.setWrapStyleWord(true);
        this.licenseAreaOne.setFocusable(false);
        this.licenseAreaOne.setFont(this.standardFont.deriveFont(12.0f));
        this.licenseAreaOne.setText("In den folgenden Schritten k\u00f6nnen Sie die Lizenzrechte f\u00fcr Ihre SIPs festlegen. Die Lizenzangabe gilt f\u00fcr die Ver\u00f6ffentlichungsportale.\n\nF\u00fcr eine Publikation ist eine Lizenz zwingend erforderlich!\n\nHinterlegen Sie im SIP-Builder eine Lizenz nur wenn diese nicht bereits in den Metadaten hinterlegt ist!!! ");
        this.rightsAreaTwo = new JTextArea();
        this.rightsAreaTwo.setEditable(false);
        this.rightsAreaTwo.setOpaque(false);
        this.rightsAreaTwo.setLineWrap(true);
        this.rightsAreaTwo.setWrapStyleWord(true);
        this.rightsAreaTwo.setFocusable(false);
        this.rightsAreaTwo.setFont(this.standardFont.deriveFont(12.0f));
        this.rightsAreaTwo.setText("Alternativ k\u00f6nnen Sie die Standard-Einstellungen w\u00e4hlen:");
        this.rightsAreaThree = new JTextArea();
        this.rightsAreaThree.setEditable(false);
        this.rightsAreaThree.setOpaque(false);
        this.rightsAreaThree.setLineWrap(true);
        this.rightsAreaThree.setWrapStyleWord(true);
        this.rightsAreaThree.setFocusable(false);
        this.rightsAreaThree.setFont(this.standardFont.deriveFont(12.0f));
        this.rightsAreaThree.setText("Sie haben im Folgenden die M\u00f6glichkeit, die Einstellungen\nanzupassen bzw. komplett neu zu w\u00e4hlen. Wenn Sie dabei\ngetroffene Entscheidungen r\u00fcckg\u00e4ngig machen m\u00f6chten,\nk\u00f6nnen Sie jederzeit hierher zur\u00fcckkehren und die Standard-\nEinstellungen neu laden.");
        this.institutionArea = new JTextArea();
        this.institutionArea.setEditable(false);
        this.institutionArea.setOpaque(false);
        this.institutionArea.setLineWrap(true);
        this.institutionArea.setWrapStyleWord(true);
        this.institutionArea.setFocusable(false);
        this.institutionArea.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionArea.setText("M\u00f6chten Sie - unabh\u00e4ngig von den Einstellungen f\u00fcr die \u00d6ffentlichkeit - zus\u00e4tzliche Pr\u00e4sentationsdaten generieren lassen, die nur Ihrer Institution \u00fcber die Schnittstellen des Presentation Repository zug\u00e4nglich sind?\nEs k\u00f6nnen dabei Rechteeinstellungen gew\u00e4hlt werden, die von denen der \u00f6ffentlich einsehbaren Daten abweichen.");
        this.institutionRestrictionArea = new JTextArea();
        this.institutionRestrictionArea.setEditable(false);
        this.institutionRestrictionArea.setOpaque(false);
        this.institutionRestrictionArea.setLineWrap(true);
        this.institutionRestrictionArea.setWrapStyleWord(true);
        this.institutionRestrictionArea.setFocusable(false);
        this.institutionRestrictionArea.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionArea.setText("Bitte w\u00e4hlen Sie die Vorschaurestriktionen f\u00fcr die verschiedenen Medientypen.");
        this.institutionRestrictionTextArea = new JTextArea();
        this.institutionRestrictionTextArea.setEditable(false);
        this.institutionRestrictionTextArea.setOpaque(false);
        this.institutionRestrictionTextArea.setLineWrap(true);
        this.institutionRestrictionTextArea.setWrapStyleWord(true);
        this.institutionRestrictionTextArea.setFocusable(false);
        this.institutionRestrictionTextArea.setDisabledTextColor(Color.LIGHT_GRAY);
        this.institutionRestrictionTextArea.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionTextArea.setText("Geben Sie die gew\u00fcnschten Seitenzahlen durch Kommas voneinander getrennt an. Um mehrere aufeinander folgende Seiten festzulegen, gen\u00fcgt es, die erste und letzte Seitenzahl mit einem dazwischen liegenden Bindestrich anzugeben.\n\nBeispiel:\nDie Eingabe \"1,14-17,24,30\" dr\u00fcckt aus, dass die Seiten 1, 14, 15, 16, 17, 24 und 30 angezeigt werden sollen.");
        this.institutionRestrictionTextArea.setEnabled(false);
        this.institutionRestrictionImageArea = new JTextArea();
        this.institutionRestrictionImageArea.setEditable(false);
        this.institutionRestrictionImageArea.setOpaque(false);
        this.institutionRestrictionImageArea.setLineWrap(true);
        this.institutionRestrictionImageArea.setWrapStyleWord(true);
        this.institutionRestrictionImageArea.setFocusable(false);
        this.institutionRestrictionImageArea.setDisabledTextColor(Color.LIGHT_GRAY);
        this.institutionRestrictionImageArea.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionRestrictionImageArea.setText("Geben Sie die Bildqualit\u00e4t absolut oder im Verh\u00e4ltnis zum Original an.");
        this.institutionRestrictionImageArea.setEnabled(false);
        this.publicArea = new JTextArea();
        this.publicArea.setEditable(false);
        this.publicArea.setOpaque(false);
        this.publicArea.setLineWrap(true);
        this.publicArea.setWrapStyleWord(true);
        this.publicArea.setFocusable(false);
        this.publicArea.setFont(this.standardFont.deriveFont(12.0f));
        this.publicArea.setText("M\u00f6chten Sie den Zugriff auf Ihre Daten \u00fcber \u00f6ffentliche Portale erm\u00f6glichen?");
        this.publicDDBArea = new JTextArea();
        this.publicDDBArea.setEditable(false);
        this.publicDDBArea.setOpaque(false);
        this.publicDDBArea.setLineWrap(true);
        this.publicDDBArea.setWrapStyleWord(true);
        this.publicDDBArea.setFocusable(false);
        this.publicDDBArea.setDisabledTextColor(Color.LIGHT_GRAY);
        this.publicDDBArea.setFont(this.standardFont.deriveFont(12.0f));
        this.publicDDBArea.setText("Im Regelfall werden ver\u00f6ffentlichte Daten automatisch der Deutschen Digitalen Bibliothek zur Verf\u00fcgung gestellt. W\u00fcnschen Sie dies nicht, k\u00f6nnen Sie diesen Prozess durch Deaktivieren der Option verhindern.");
        this.publicRestrictionArea = new JTextArea();
        this.publicRestrictionArea.setEditable(false);
        this.publicRestrictionArea.setOpaque(false);
        this.publicRestrictionArea.setLineWrap(true);
        this.publicRestrictionArea.setWrapStyleWord(true);
        this.publicRestrictionArea.setFocusable(false);
        this.publicRestrictionArea.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionArea.setText("Bitte w\u00e4hlen Sie die Vorschaurestriktionen f\u00fcr die verschiedenen Medientypen.");
        this.publicRestrictionTextArea = new JTextArea();
        this.publicRestrictionTextArea.setEditable(false);
        this.publicRestrictionTextArea.setOpaque(false);
        this.publicRestrictionTextArea.setLineWrap(true);
        this.publicRestrictionTextArea.setWrapStyleWord(true);
        this.publicRestrictionTextArea.setFocusable(false);
        this.publicRestrictionTextArea.setDisabledTextColor(Color.LIGHT_GRAY);
        this.publicRestrictionTextArea.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionTextArea.setText("Geben Sie die gew\u00fcnschten Seitenzahlen durch Kommas voneinander getrennt an. Um mehrere aufeinander folgende Seiten festzulegen, gen\u00fcgt es, die erste und letzte Seitenzahl mit einem dazwischen liegenden Bindestrich anzugeben.\n\nBeispiel:\nDie Eingabe \"1,14-17,24,30\" dr\u00fcckt aus, dass die Seiten 1, 14, 15, 16, 17, 24 und 30 angezeigt werden sollen.");
        this.publicRestrictionTextArea.setEnabled(false);
        this.publicRestrictionImageArea = new JTextArea();
        this.publicRestrictionImageArea.setEditable(false);
        this.publicRestrictionImageArea.setOpaque(false);
        this.publicRestrictionImageArea.setLineWrap(true);
        this.publicRestrictionImageArea.setWrapStyleWord(true);
        this.publicRestrictionImageArea.setFocusable(false);
        this.publicRestrictionImageArea.setDisabledTextColor(Color.LIGHT_GRAY);
        this.publicRestrictionImageArea.setFont(this.standardFont.deriveFont(12.0f));
        this.publicRestrictionImageArea.setText("Geben Sie die Bildqualit\u00e4t absolut oder im Verh\u00e4ltnis zum Original an.");
        this.publicRestrictionImageArea.setEnabled(false);
        this.migrationArea = new JTextArea();
        this.migrationArea.setEditable(false);
        this.migrationArea.setOpaque(false);
        this.migrationArea.setLineWrap(true);
        this.migrationArea.setWrapStyleWord(true);
        this.migrationArea.setFocusable(false);
        this.migrationArea.setFont(this.standardFont.deriveFont(12.0f));
        this.migrationArea.setText("Bei der Einlieferung Ihrer Daten findet im Regelfall eine Erstkonversion in Dateiformate statt, die f\u00fcr die Langzeitarchivierung geeignet sind. Dar\u00fcber hinaus k\u00f6nnen sp\u00e4tere Konversionen folgen, um die dauerhafte Lesbarkeit der Daten zu gew\u00e4hrleisten (Migration).\nWenn Sie im Falle einer Migration benachrichtigt oder um ausdr\u00fcckliche Zustimmung gefragt werden m\u00f6chten, k\u00f6nnen Sie die entsprechenden Einstellungen hier vornehmen.");
        this.settingsOverviewInfoArea = new JTextArea();
        this.settingsOverviewInfoArea.setEditable(false);
        this.settingsOverviewInfoArea.setOpaque(false);
        this.settingsOverviewInfoArea.setLineWrap(true);
        this.settingsOverviewInfoArea.setWrapStyleWord(true);
        this.settingsOverviewInfoArea.setFocusable(false);
        this.settingsOverviewInfoArea.setFont(this.standardFont.deriveFont(12.0f));
        this.settingsOverviewInfoArea.setText("Sie haben folgende Rechteeinstellungen gew\u00e4hlt:");
        this.settingsOverviewTextArea = new JTextArea();
        this.settingsOverviewTextArea.setEditable(false);
        this.settingsOverviewTextArea.setOpaque(false);
        this.settingsOverviewTextArea.setLineWrap(true);
        this.settingsOverviewTextArea.setWrapStyleWord(true);
        this.settingsOverviewTextArea.setFocusable(false);
        this.settingsOverviewTextArea.setFont(this.standardFont.deriveFont(12.0f));
        this.settingsOverviewArea = new JScrollPane(this.settingsOverviewTextArea);
        this.settingsOverviewArea.setVerticalScrollBarPolicy(20);
        this.settingsOverviewArea.setHorizontalScrollBarPolicy(30);
        this.saveArea = new JTextArea();
        this.saveArea.setEditable(false);
        this.saveArea.setOpaque(false);
        this.saveArea.setLineWrap(true);
        this.saveArea.setWrapStyleWord(true);
        this.saveArea.setFocusable(false);
        this.saveArea.setFont(this.standardFont.deriveFont(12.0f));
        this.saveArea.setText("Falls Sie Ihre Rechteeinstellungen sp\u00e4ter f\u00fcr weitere SIP-Generierungen wiederverwenden m\u00f6chten, k\u00f6nnen Sie diese nun sichern:");
        this.createArea = new JTextArea();
        this.createArea.setEditable(false);
        this.createArea.setOpaque(false);
        this.createArea.setLineWrap(true);
        this.createArea.setWrapStyleWord(true);
        this.createArea.setFocusable(false);
        this.createArea.setFont(this.standardFont.deriveFont(12.0f));
        this.createArea.setText("Wenn Sie mit den vorgenommenen Einstellungen zufrieden sind, k\u00f6nnen Sie die SIP-Generierung starten, indem Sie den Button \"Erstellen\" bet\u00e4tigen.\n\nSie k\u00f6nnen den Prozess beschleunigen, indem Sie die Kompression deaktivieren. Bitte beachten Sie, dass in diesem Fall gr\u00f6\u00dfere SIP-Dateien erzeugt werden.");
    }

    private void initializeRadioButtons() {
        this.institutionAllowRadioButton = new JRadioButton("Ja", false);
        this.institutionAllowRadioButton.setOpaque(false);
        this.institutionAllowRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionDenyRadioButton = new JRadioButton("Nein", true);
        this.institutionDenyRadioButton.setOpaque(false);
        this.institutionDenyRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionAllowDenyGroup = new ButtonGroup();
        this.institutionAllowDenyGroup.add(this.institutionAllowRadioButton);
        this.institutionAllowDenyGroup.add(this.institutionDenyRadioButton);
        this.institutionNoTempRestrictionRadioButton = new JRadioButton("Publikation nicht begrenzen", true);
        this.institutionNoTempRestrictionRadioButton.setOpaque(false);
        this.institutionNoTempRestrictionRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionTempRadioButton = new JRadioButton("Publikation zeitlich begrenzen", false);
        this.institutionTempRadioButton.setOpaque(false);
        this.institutionTempRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionLawRadioButton = new JRadioButton("Publikation mit Sperrgesetz begrenzen", false);
        this.institutionLawRadioButton.setOpaque(false);
        this.institutionLawRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionTempLawGroup = new ButtonGroup();
        this.institutionTempLawGroup.add(this.institutionNoTempRestrictionRadioButton);
        this.institutionTempLawGroup.add(this.institutionTempRadioButton);
        this.institutionTempLawGroup.add(this.institutionLawRadioButton);
        this.publicAllowRadioButton = new JRadioButton("Ja", true);
        this.publicAllowRadioButton.setOpaque(false);
        this.publicAllowRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.publicDenyRadioButton = new JRadioButton("Nein", false);
        this.publicDenyRadioButton.setOpaque(false);
        this.publicDenyRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.publicAllowDenyGroup = new ButtonGroup();
        this.publicAllowDenyGroup.add(this.publicAllowRadioButton);
        this.publicAllowDenyGroup.add(this.publicDenyRadioButton);
        this.publicNoTempRestrictionRadioButton = new JRadioButton("Publikation nicht begrenzen", true);
        this.publicNoTempRestrictionRadioButton.setOpaque(false);
        this.publicNoTempRestrictionRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.publicTempRadioButton = new JRadioButton("Publikation zeitlich begrenzen", false);
        this.publicTempRadioButton.setOpaque(false);
        this.publicTempRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.publicLawRadioButton = new JRadioButton("Publikation mit Sperrgesetz begrenzen", false);
        this.publicLawRadioButton.setOpaque(false);
        this.publicLawRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.publicTempLawGroup = new ButtonGroup();
        this.publicTempLawGroup.add(this.publicNoTempRestrictionRadioButton);
        this.publicTempLawGroup.add(this.publicTempRadioButton);
        this.publicTempLawGroup.add(this.publicLawRadioButton);
    }

    private void initializeCheckBoxes() {
        this.collectionCheckBox = new JCheckBox("SIPs zu einer Lieferung b\u00fcndeln", false);
        this.collectionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.collectionCheckBox.setFocusable(false);
        this.collectionCheckBox.setOpaque(false);
        this.collectionCheckBox.setEnabled(false);
        this.institutionTextRestrictionCheckBox = new JCheckBox("Einsehbare Seiten festlegen", false);
        this.institutionTextRestrictionCheckBox.setOpaque(false);
        this.institutionTextRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionImageRestrictionCheckBox = new JCheckBox("Bildqualit\u00e4t begrenzen", false);
        this.institutionImageRestrictionCheckBox.setOpaque(false);
        this.institutionImageRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionImageTextCheckBox = new JCheckBox("Fu\u00dfzeile oder Wasserzeichen angeben", false);
        this.institutionImageTextCheckBox.setOpaque(false);
        this.institutionImageTextCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionAudioRestrictionCheckBox = new JCheckBox("L\u00e4nge von Audio-Dateien begrenzen", false);
        this.institutionAudioRestrictionCheckBox.setOpaque(false);
        this.institutionAudioRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionVideoRestrictionCheckBox = new JCheckBox("Bildqualit\u00e4t von Videos begrenzen", false);
        this.institutionVideoRestrictionCheckBox.setOpaque(false);
        this.institutionVideoRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.institutionVideoDurationCheckBox = new JCheckBox("L\u00e4nge von Videos begrenzen", false);
        this.institutionVideoDurationCheckBox.setOpaque(false);
        this.institutionVideoDurationCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicDDBCheckBox = new JCheckBox("DDB-Harvesting erlauben", true);
        this.publicDDBCheckBox.setOpaque(false);
        this.publicDDBCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        ButtonGroup licenseRadioButtonGroup = new ButtonGroup();
        this.metadataLicenseRadioButton = new JRadioButton("Lizenz aus Metadaten \u00fcbernehmen.");
        this.metadataLicenseRadioButton.setOpaque(false);
        this.metadataLicenseRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        this.premisLicenseRadioButton = new JRadioButton("Lizenz festlegen");
        this.premisLicenseRadioButton.setOpaque(false);
        this.premisLicenseRadioButton.setFont(this.standardFont.deriveFont(12.0f));
        licenseRadioButtonGroup.add(this.metadataLicenseRadioButton);
        licenseRadioButtonGroup.add(this.premisLicenseRadioButton);
        this.publicTextRestrictionCheckBox = new JCheckBox("Einsehbare Seiten festlegen", false);
        this.publicTextRestrictionCheckBox.setOpaque(false);
        this.publicTextRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicImageRestrictionCheckBox = new JCheckBox("Bildqualit\u00e4t begrenzen", false);
        this.publicImageRestrictionCheckBox.setOpaque(false);
        this.publicImageRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicImageTextCheckBox = new JCheckBox("Fu\u00dfzeile oder Wasserzeichen angeben", false);
        this.publicImageTextCheckBox.setOpaque(false);
        this.publicImageTextCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicAudioRestrictionCheckBox = new JCheckBox("L\u00e4nge von Audio-Dateien begrenzen", false);
        this.publicAudioRestrictionCheckBox.setOpaque(false);
        this.publicAudioRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicVideoRestrictionCheckBox = new JCheckBox("Bildqualit\u00e4t von Videos begrenzen", false);
        this.publicVideoRestrictionCheckBox.setOpaque(false);
        this.publicVideoRestrictionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.publicVideoDurationCheckBox = new JCheckBox("L\u00e4nge von Videos begrenzen", false);
        this.publicVideoDurationCheckBox.setOpaque(false);
        this.publicVideoDurationCheckBox.setFont(this.standardFont.deriveFont(12.0f));
        this.compressionCheckBox = new JCheckBox("SIP-Datei komprimieren", true);
        this.compressionCheckBox.setOpaque(false);
        this.compressionCheckBox.setFont(this.standardFont.deriveFont(12.0f));
    }

    private void initializeTextFields() {
        this.sourcePathTextField = new JTextField();
        this.sourcePathTextField.setEditable(true);
        this.sourcePathTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.destinationPathTextField = new JTextField();
        this.destinationPathTextField.setEditable(true);
        this.destinationPathTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.workingPathTextField = new JTextField();
        this.workingPathTextField.setEditable(true);
        this.workingPathTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.licenseTextField = new JTextField();
        this.licenseTextField.setEditable(true);
        this.licenseTextField.setOpaque(false);
        this.licenseTextField.setBorder(null);
        this.licenseTextField.setFont(this.standardFont.deriveFont(12.0f));
        this.collectionNameTextField = new JTextField();
        this.collectionNameTextField.setEditable(false);
        this.collectionNameTextField.setEnabled(false);
        this.collectionNameTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.institutionTempStartDateTextField = new JTextField();
        this.institutionTempStartDateTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.institutionTempStartDateTextField.setEditable(false);
        this.institutionTempStartDateTextField.setEnabled(false);
        this.institutionRestrictionTextPagesTextField = new JTextField();
        this.institutionRestrictionTextPagesTextField.setEditable(false);
        this.institutionRestrictionTextPagesTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.institutionRestrictionTextPagesTextField.setEnabled(false);
        this.institutionRestrictionImageTextField = new JTextField();
        this.institutionRestrictionImageTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.institutionRestrictionImageTextField.setEnabled(false);
        this.institutionRestrictionImageTextField.setEditable(false);
        this.publicTempStartDateTextField = new JTextField();
        this.publicTempStartDateTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.publicTempStartDateTextField.setEditable(false);
        this.publicTempStartDateTextField.setEnabled(false);
        this.publicRestrictionTextPagesTextField = new JTextField();
        this.publicRestrictionTextPagesTextField.setEditable(false);
        this.publicRestrictionTextPagesTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.publicRestrictionTextPagesTextField.setEnabled(false);
        this.publicRestrictionImageTextField = new JTextField();
        this.publicRestrictionImageTextField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.publicRestrictionImageTextField.setEnabled(false);
        this.publicRestrictionImageTextField.setEditable(false);
    }

    private void initializeComboBoxes() {
        this.kindOfSIPBuildingDropDown = new JComboBox();
        this.kindOfSIPBuildingDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.kindOfSIPBuildingDropDown.addItem("Ein SIP aus dem Quellverzeichnis erstellen");
        this.kindOfSIPBuildingDropDown.addItem("SIPs aus Unterordnern des Quellverzeichnisses erstellen");
        this.kindOfSIPBuildingDropDown.addItem("SIPs aus verzweigter Ordnerstruktur erstellen (nur METS)");
        this.licenseDropDown = new JComboBox();
        this.licenseDropDown.setFont(this.standardFont.deriveFont(11.0f));
        for (ContractRights.CCLicense tmp : ContractRights.CCLicense.values()) {
            this.licenseDropDown.addItem(tmp);
        }
        this.institutionLawIdDropDown = new JComboBox();
        this.institutionLawIdDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionLawIdDropDown.setEnabled(false);
        this.institutionLawIdDropDown.addItem("ePflicht");
        this.institutionLawIdDropDown.addItem("UrhG DE");
        this.institutionImageDropDown = new JComboBox();
        this.institutionImageDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionImageDropDown.addItem("Niedrig (" + this.contractSettings.getWidthImage(0) + "x" + this.contractSettings.getHeightImage(0) + ")");
        this.institutionImageDropDown.addItem("Mittel (" + this.contractSettings.getWidthImage(1) + "x" + this.contractSettings.getHeightImage(1) + ")");
        this.institutionImageDropDown.addItem("Hoch (" + this.contractSettings.getWidthImage(2) + "x" + this.contractSettings.getHeightImage(2) + ")");
        this.institutionImageDropDown.addItem(this.contractSettings.getPercentImage(0));
        this.institutionImageDropDown.addItem(this.contractSettings.getPercentImage(1));
        this.institutionImageDropDown.addItem(this.contractSettings.getPercentImage(2));
        this.institutionImageDropDown.setEnabled(false);
        this.institutionImageTextDropDown = new JComboBox();
        this.institutionImageTextDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionImageTextDropDown.addItem("Fu\u00dfzeile");
        this.institutionImageTextDropDown.addItem("Wasserzeichen (oben)");
        this.institutionImageTextDropDown.addItem("Wasserzeichen (mittig)");
        this.institutionImageTextDropDown.addItem("Wasserzeichen (unten)");
        this.institutionImageTextDropDown.setEnabled(false);
        this.institutionImageTextOpacityDropDown = new JComboBox();
        this.institutionImageTextOpacityDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(0) + "%");
        this.institutionImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(1) + "%");
        this.institutionImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(2) + "%");
        this.institutionImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(3) + "%");
        this.institutionImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(4) + "%");
        this.institutionImageTextOpacityDropDown.setEnabled(false);
        this.institutionImageTextSizeDropDown = new JComboBox();
        this.institutionImageTextSizeDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(0));
        this.institutionImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(1));
        this.institutionImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(2));
        this.institutionImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(3));
        this.institutionImageTextSizeDropDown.setEnabled(false);
        this.institutionAudioDurationDropDown = new JComboBox();
        this.institutionAudioDurationDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionAudioDurationDropDown.addItem(this.contractSettings.getDuration(0));
        this.institutionAudioDurationDropDown.addItem(this.contractSettings.getDuration(1));
        this.institutionAudioDurationDropDown.addItem(this.contractSettings.getDuration(2));
        this.institutionAudioDurationDropDown.addItem(this.contractSettings.getDuration(3));
        this.institutionAudioDurationDropDown.setEnabled(false);
        this.institutionVideoQualityDropDown = new JComboBox();
        this.institutionVideoQualityDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionVideoQualityDropDown.addItem("Niedrig");
        this.institutionVideoQualityDropDown.addItem("Mittel");
        this.institutionVideoQualityDropDown.addItem("Hoch");
        this.institutionVideoQualityDropDown.setEnabled(false);
        this.institutionVideoDurationDropDown = new JComboBox();
        this.institutionVideoDurationDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.institutionVideoDurationDropDown.addItem(this.contractSettings.getDuration(0));
        this.institutionVideoDurationDropDown.addItem(this.contractSettings.getDuration(1));
        this.institutionVideoDurationDropDown.addItem(this.contractSettings.getDuration(2));
        this.institutionVideoDurationDropDown.addItem(this.contractSettings.getDuration(3));
        this.institutionVideoDurationDropDown.setEnabled(false);
        this.publicLawIdDropDown = new JComboBox();
        this.publicLawIdDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicLawIdDropDown.setEnabled(false);
        this.publicLawIdDropDown.addItem("ePflicht");
        this.publicLawIdDropDown.addItem("UrhG DE");
        this.publicImageDropDown = new JComboBox();
        this.publicImageDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicImageDropDown.addItem("Niedrig (" + this.contractSettings.getWidthImage(0) + "x" + this.contractSettings.getHeightImage(0) + ")");
        this.publicImageDropDown.addItem("Mittel (" + this.contractSettings.getWidthImage(1) + "x" + this.contractSettings.getHeightImage(1) + ")");
        this.publicImageDropDown.addItem("Hoch (" + this.contractSettings.getWidthImage(2) + "x" + this.contractSettings.getHeightImage(2) + ")");
        this.publicImageDropDown.addItem(this.contractSettings.getPercentImage(0));
        this.publicImageDropDown.addItem(this.contractSettings.getPercentImage(1));
        this.publicImageDropDown.addItem(this.contractSettings.getPercentImage(2));
        this.publicImageDropDown.setEnabled(false);
        this.publicImageTextDropDown = new JComboBox();
        this.publicImageTextDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicImageTextDropDown.addItem("Fu\u00dfzeile");
        this.publicImageTextDropDown.addItem("Wasserzeichen (oben)");
        this.publicImageTextDropDown.addItem("Wasserzeichen (mittig)");
        this.publicImageTextDropDown.addItem("Wasserzeichen (unten)");
        this.publicImageTextDropDown.setEnabled(false);
        this.publicImageTextOpacityDropDown = new JComboBox();
        this.publicImageTextOpacityDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(0) + "%");
        this.publicImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(1) + "%");
        this.publicImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(2) + "%");
        this.publicImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(3) + "%");
        this.publicImageTextOpacityDropDown.addItem(this.contractSettings.getOpacityImage(4) + "%");
        this.publicImageTextOpacityDropDown.setEnabled(false);
        this.publicImageTextSizeDropDown = new JComboBox();
        this.publicImageTextSizeDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(0));
        this.publicImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(1));
        this.publicImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(2));
        this.publicImageTextSizeDropDown.addItem(this.contractSettings.getTextSizeImage(3));
        this.publicImageTextSizeDropDown.setEnabled(false);
        this.publicAudioDurationDropDown = new JComboBox();
        this.publicAudioDurationDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicAudioDurationDropDown.addItem(this.contractSettings.getDuration(0));
        this.publicAudioDurationDropDown.addItem(this.contractSettings.getDuration(1));
        this.publicAudioDurationDropDown.addItem(this.contractSettings.getDuration(2));
        this.publicAudioDurationDropDown.addItem(this.contractSettings.getDuration(3));
        this.publicAudioDurationDropDown.setEnabled(false);
        this.publicVideoQualityDropDown = new JComboBox();
        this.publicVideoQualityDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicVideoQualityDropDown.addItem("Niedrig");
        this.publicVideoQualityDropDown.addItem("Mittel");
        this.publicVideoQualityDropDown.addItem("Hoch");
        this.publicVideoQualityDropDown.setEnabled(false);
        this.publicVideoDurationDropDown = new JComboBox();
        this.publicVideoDurationDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.publicVideoDurationDropDown.addItem(this.contractSettings.getDuration(0));
        this.publicVideoDurationDropDown.addItem(this.contractSettings.getDuration(1));
        this.publicVideoDurationDropDown.addItem(this.contractSettings.getDuration(2));
        this.publicVideoDurationDropDown.addItem(this.contractSettings.getDuration(3));
        this.publicVideoDurationDropDown.setEnabled(false);
        this.migrationDropDown = new JComboBox();
        this.migrationDropDown.setFont(this.standardFont.deriveFont(11.0f));
        this.migrationDropDown.addItem("Keine");
        this.migrationDropDown.addItem("\u00dcber Migration informieren");
        this.migrationDropDown.addItem("Zustimmung f\u00fcr Migration einholen");
    }

    private void defineElementPositions() {
        this.versionInfoLabel.setBounds(0, 472, 750, 20);
        this.startActivatedIconButton.setBounds(10, 70, 171, 20);
        this.startIconButton.setBounds(10, 70, 171, 20);
        this.loadActivatedIconButton.setBounds(10, 95, 171, 20);
        this.loadIconButton.setBounds(10, 95, 171, 20);
        this.publicationActivatedIconButton.setBounds(10, 120, 171, 20);
        this.publicationIconButton.setBounds(10, 120, 171, 20);
        this.publicActivatedIconButton.setBounds(10, 140, 171, 20);
        this.publicIconButton.setBounds(10, 140, 171, 20);
        this.licenseActivatedIconButton.setBounds(10, 160, 171, 20);
        this.licenseIconButton.setBounds(10, 160, 171, 20);
        this.publicTempActivatedIconButton.setBounds(10, 180, 171, 20);
        this.publicTempIconButton.setBounds(10, 180, 171, 20);
        this.publicRestrictionActivatedIconButton.setBounds(10, 200, 171, 20);
        this.publicRestrictionIconButton.setBounds(10, 200, 171, 20);
        this.institutionActivatedIconButton.setBounds(10, 225, 171, 20);
        this.institutionIconButton.setBounds(10, 225, 171, 20);
        this.institutionTempActivatedIconButton.setBounds(10, 245, 171, 20);
        this.institutionTempIconButton.setBounds(10, 245, 171, 20);
        this.institutionRestrictionActivatedIconButton.setBounds(10, 265, 171, 20);
        this.institutionRestrictionIconButton.setBounds(10, 265, 171, 20);
        this.migrationActivatedIconButton.setBounds(10, 290, 171, 20);
        this.migrationIconButton.setBounds(10, 290, 171, 20);
        this.saveActivatedIconButton.setBounds(10, 315, 171, 20);
        this.saveIconButton.setBounds(10, 315, 171, 20);
        this.createActivatedIconButton.setBounds(10, 340, 171, 20);
        this.createIconButton.setBounds(10, 340, 171, 20);
        this.helpIconButton.setBounds(709, 15, 20, 22);
        this.startPanel.setBounds(0, 0, this.startPanelWidth, this.startPanelHeight);
        this.backgroundStartImageLabel.setBounds(0, 0, 750, 526);
        this.welcomeLabel.setBounds(255, 70, 300, 40);
        this.welcomeArea.setBounds(255, 100, 420, 120);
        this.sourceLabel.setBounds(255, 245, 70, 20);
        this.sourcePathTextField.setBounds(335, 245, 260, 20);
        this.sourceChooserButton.setBounds(600, 245, 45, 20);
        this.destinationLabel.setBounds(255, 270, 70, 20);
        this.destinationPathTextField.setBounds(335, 270, 260, 20);
        this.destinationChooserButton.setBounds(600, 270, 45, 20);
        this.workingLabel.setBounds(255, 295, 70, 20);
        this.workingPathTextField.setBounds(335, 295, 260, 20);
        this.workingChooserButton.setBounds(600, 295, 45, 20);
        this.kindOfSIPBuildingDropDown.setBounds(255, 320, 390, 20);
        this.goToLoadStandardButton.setBounds(575, 445, 90, 20);
        this.loadStandardPanel.setBounds(0, 0, 750, 526);
        this.rightsLabel.setBounds(255, 70, 300, 20);
        this.rightsAreaOne.setBounds(255, 100, 430, 85);
        this.loadContractButton.setBounds(350, 189, 90, 20);
        this.rightsAreaTwo.setBounds(255, 223, 430, 20);
        this.standardContractButton.setBounds(350, 250, 90, 20);
        this.rightsAreaThree.setBounds(255, 283, 430, 100);
        this.goBackToStartButton.setBounds(450, 445, 90, 20);
        this.goToPublicButton.setBounds(575, 445, 90, 20);
        this.backgroundLoadStandardImageLabel.setBounds(0, 0, 750, 526);
        this.publicPanel.setBounds(0, 0, 750, 526);
        this.publicLabel.setBounds(255, 70, 300, 20);
        this.publicArea.setBounds(255, 100, 400, 40);
        this.publicAllowRadioButton.setBounds(251, 150, 40, 20);
        this.publicDenyRadioButton.setBounds(251, 175, 60, 20);
        this.publicDDBArea.setBounds(255, 215, 400, 60);
        this.publicDDBCheckBox.setBounds(251, 285, 190, 20);
        this.goBackToLoadStandardButton.setBounds(450, 445, 90, 20);
        this.goToLicenseButton.setBounds(575, 445, 90, 20);
        this.backgroundPublicImageLabel.setBounds(0, 0, 750, 526);
        this.publicLicensePanel.setBounds(0, 0, 750, 526);
        this.licenseLabel.setBounds(255, 70, 300, 20);
        this.licenseDropDown.setEditable(false);
        this.licenseDropDown.setEnabled(false);
        this.licenseTextField.setEditable(false);
        this.licenseAreaOne.setBounds(255, 100, 430, 115);
        this.metadataLicenseRadioButton.setBounds(255, 220, 430, 20);
        this.premisLicenseRadioButton.setBounds(255, 245, 430, 20);
        this.licenseDropDown.setBounds(275, 270, 230, 20);
        this.licenseTextField.setBounds(275, 295, 430, 20);
        this.goBackToPublicButton.setBounds(450, 445, 90, 20);
        this.goToPublicTempButton.setBounds(575, 445, 90, 20);
        this.backgroundLicenseImageLabel.setBounds(0, 0, 750, 526);
        this.publicTempPanel.setBounds(0, 0, 750, 526);
        this.publicStartLabel.setBounds(255, 70, 300, 20);
        this.publicNoTempRestrictionRadioButton.setBounds(251, 100, 215, 20);
        this.publicTempRadioButton.setBounds(251, 125, 215, 20);
        this.publicTempStartDateLabel.setBounds(255, 147, 280, 20);
        this.publicTempStartDateTextField.setBounds(255, 172, 310, 20);
        this.publicLawRadioButton.setBounds(251, 202, 275, 20);
        this.publicLawIdDropDown.setBounds(255, 232, 310, 20);
        this.goBackToLicenseOrInstitutionButton.setBounds(450, 445, 90, 20);
        this.goToPublicRestrictionButton.setBounds(575, 445, 90, 20);
        this.backgroundPublicTempImageLabel.setBounds(0, 0, 750, 526);
        this.publicRestrictionPanel.setBounds(0, 0, 750, 526);
        this.publicRestrictionHeadlineLabel.setBounds(255, 70, 350, 20);
        this.publicRestrictionArea.setBounds(255, 100, 360, 40);
        this.publicTabbedPane.setBounds(255, 140, 380, 295);
        this.goBackToPublicTempButton.setBounds(450, 445, 90, 20);
        this.goToInstitutionButton.setBounds(575, 445, 90, 20);
        this.backgroundPublicRestrictionImageLabel.setBounds(0, 0, 750, 526);
        this.publicTextRestrictionCheckBox.setBounds(6, 10, 212, 20);
        this.publicRestrictionTextPagesLabel.setBounds(10, 32, 320, 20);
        this.publicRestrictionTextPagesTextField.setBounds(10, 57, 355, 20);
        this.publicRestrictionTextArea.setBounds(10, 87, 360, 170);
        this.publicImageRestrictionCheckBox.setBounds(6, 10, 192, 20);
        this.publicRestrictionImageArea.setBounds(10, 35, 320, 40);
        this.publicImageDropDown.setBounds(10, 75, 150, 20);
        this.publicImageTextCheckBox.setBounds(6, 105, 270, 20);
        this.publicRestrictionImageLabel.setBounds(10, 127, 355, 20);
        this.publicRestrictionImageTextField.setBounds(10, 152, 355, 20);
        this.publicRestrictionImageTextTypeLabel.setBounds(10, 182, 80, 20);
        this.publicImageTextDropDown.setBounds(105, 182, 165, 20);
        this.publicRestrictionImageTextOpacityLabel.setBounds(10, 212, 80, 20);
        this.publicImageTextOpacityDropDown.setBounds(105, 212, 165, 20);
        this.publicRestrictionImageTextSizeLabel.setBounds(10, 242, 80, 20);
        this.publicImageTextSizeDropDown.setBounds(105, 242, 165, 20);
        this.publicAudioRestrictionCheckBox.setBounds(6, 10, 252, 20);
        this.publicRestrictionAudioDurationLabel.setBounds(10, 32, 320, 20);
        this.publicAudioDurationDropDown.setBounds(10, 57, 100, 20);
        this.publicVideoRestrictionCheckBox.setBounds(6, 10, 240, 20);
        this.publicRestrictionVideoQualityLabel.setBounds(10, 32, 420, 20);
        this.publicVideoQualityDropDown.setBounds(10, 57, 100, 20);
        this.publicVideoDurationCheckBox.setBounds(6, 87, 214, 20);
        this.publicRestrictionVideoDurationLabel.setBounds(10, 109, 320, 20);
        this.publicVideoDurationDropDown.setBounds(10, 134, 100, 20);
        this.institutionPanel.setBounds(0, 0, 750, 526);
        this.institutionLabel.setBounds(255, 70, 300, 20);
        this.institutionArea.setBounds(255, 100, 400, 90);
        this.institutionAllowRadioButton.setBounds(251, 210, 40, 20);
        this.institutionDenyRadioButton.setBounds(251, 235, 60, 20);
        this.goBackToPublicRestrictionOrPublicButton.setBounds(450, 445, 90, 20);
        this.goToInstitutionTempButton.setBounds(575, 445, 90, 20);
        this.backgroundInstitutionImageLabel.setBounds(0, 0, 750, 526);
        this.institutionTempPanel.setBounds(0, 0, 750, 526);
        this.institutionStartLabel.setBounds(255, 70, 300, 20);
        this.institutionNoTempRestrictionRadioButton.setBounds(251, 100, 215, 20);
        this.institutionTempRadioButton.setBounds(251, 125, 215, 20);
        this.institutionTempStartDateLabel.setBounds(255, 147, 280, 20);
        this.institutionTempStartDateTextField.setBounds(255, 172, 310, 20);
        this.institutionLawRadioButton.setBounds(251, 202, 275, 20);
        this.institutionLawIdDropDown.setBounds(255, 232, 310, 20);
        this.goBackToInstitutionButton.setBounds(450, 445, 90, 20);
        this.goToInstitutionRestrictionOrPublicButton.setBounds(575, 445, 90, 20);
        this.backgroundInstitutionTempImageLabel.setBounds(0, 0, 750, 526);
        this.institutionRestrictionPanel.setBounds(0, 0, 750, 526);
        this.institutionRestrictionHeadlineLabel.setBounds(255, 70, 350, 20);
        this.institutionRestrictionArea.setBounds(255, 100, 360, 40);
        this.institutionTabbedPane.setBounds(255, 140, 380, 295);
        this.goBackToInstitutionTempButton.setBounds(450, 445, 90, 20);
        this.goToMigrationButton.setBounds(575, 445, 90, 20);
        this.backgroundInstitutionRestrictionImageLabel.setBounds(0, 0, 750, 526);
        this.institutionTextRestrictionCheckBox.setBounds(6, 10, 212, 20);
        this.institutionRestrictionTextPagesLabel.setBounds(10, 32, 320, 20);
        this.institutionRestrictionTextPagesTextField.setBounds(10, 57, 355, 20);
        this.institutionRestrictionTextArea.setBounds(10, 87, 360, 170);
        this.institutionImageRestrictionCheckBox.setBounds(6, 10, 192, 20);
        this.institutionRestrictionImageArea.setBounds(10, 35, 320, 40);
        this.institutionImageDropDown.setBounds(10, 75, 150, 20);
        this.institutionImageTextCheckBox.setBounds(6, 105, 270, 20);
        this.institutionRestrictionImageLabel.setBounds(10, 127, 355, 20);
        this.institutionRestrictionImageTextField.setBounds(10, 152, 355, 20);
        this.institutionRestrictionImageTextTypeLabel.setBounds(10, 182, 80, 20);
        this.institutionImageTextDropDown.setBounds(105, 182, 165, 20);
        this.institutionRestrictionImageTextOpacityLabel.setBounds(10, 212, 80, 20);
        this.institutionImageTextOpacityDropDown.setBounds(105, 212, 165, 20);
        this.institutionRestrictionImageTextSizeLabel.setBounds(10, 242, 80, 20);
        this.institutionImageTextSizeDropDown.setBounds(105, 242, 165, 20);
        this.institutionAudioRestrictionCheckBox.setBounds(6, 10, 252, 20);
        this.institutionRestrictionAudioDurationLabel.setBounds(10, 32, 320, 20);
        this.institutionAudioDurationDropDown.setBounds(10, 57, 100, 20);
        this.institutionVideoRestrictionCheckBox.setBounds(6, 10, 240, 20);
        this.institutionRestrictionVideoQualityLabel.setBounds(10, 32, 420, 20);
        this.institutionVideoQualityDropDown.setBounds(10, 57, 100, 20);
        this.institutionVideoDurationCheckBox.setBounds(6, 87, 214, 20);
        this.institutionRestrictionVideoDurationLabel.setBounds(10, 109, 320, 20);
        this.institutionVideoDurationDropDown.setBounds(10, 134, 100, 20);
        this.migrationPanel.setBounds(0, 0, 750, 526);
        this.migrationConversionLabel.setBounds(255, 70, 330, 20);
        this.migrationArea.setBounds(255, 100, 450, 125);
        this.migrationConditionLabel.setBounds(255, 225, 115, 20);
        this.migrationDropDown.setBounds(370, 227, 240, 20);
        this.goBackToInstitutionRestrictionOrTempButton.setBounds(450, 445, 90, 20);
        this.goToSaveButton.setBounds(575, 445, 90, 20);
        this.backgroundMigrationImageLabel.setBounds(0, 0, 750, 526);
        this.savePanel.setBounds(0, 0, 750, 526);
        this.saveLabel.setBounds(255, 70, 300, 20);
        this.settingsOverviewInfoArea.setBounds(255, 100, 450, 25);
        this.settingsOverviewArea.setBounds(255, 130, 450, 205);
        this.saveArea.setBounds(255, 350, 460, 30);
        this.saveButton.setBounds(400, 390, 90, 20);
        this.goBackToMigrationButton.setBounds(450, 445, 90, 20);
        this.goToCreateButton.setBounds(575, 445, 90, 20);
        this.backgroundSaveImageLabel.setBounds(0, 0, 750, 526);
        this.createPanel.setBounds(0, 0, 750, 526);
        this.createLabel.setBounds(255, 70, 350, 20);
        this.createArea.setBounds(255, 100, 400, 110);
        this.compressionCheckBox.setBounds(251, 220, 175, 20);
        this.progressBar.setBounds(255, 260, 350, 20);
        this.sipProgressDisplayLabel.setBounds(240, 285, 380, 20);
        this.sipProgressStepLabel.setBounds(255, 310, 350, 20);
        this.goBackToSaveButton.setBounds(450, 445, 90, 20);
        this.createButton.setBounds(575, 445, 90, 20);
        this.abortButton.setBounds(575, 445, 90, 20);
        this.quitButton.setBounds(575, 445, 90, 20);
        this.backgroundCreateImageLabel.setBounds(0, 0, 750, 526);
    }

    private void addElementsToContentPane() {
        this.getContentPane().add(this.startActivatedIconButton);
        this.getContentPane().add(this.startIconButton);
        this.getContentPane().add(this.loadActivatedIconButton);
        this.getContentPane().add(this.loadIconButton);
        this.getContentPane().add(this.licenseActivatedIconButton);
        this.getContentPane().add(this.licenseIconButton);
        this.getContentPane().add(this.publicationActivatedIconButton);
        this.getContentPane().add(this.publicationIconButton);
        this.getContentPane().add(this.institutionActivatedIconButton);
        this.getContentPane().add(this.institutionIconButton);
        this.getContentPane().add(this.institutionTempActivatedIconButton);
        this.getContentPane().add(this.institutionTempIconButton);
        this.getContentPane().add(this.institutionRestrictionActivatedIconButton);
        this.getContentPane().add(this.institutionRestrictionIconButton);
        this.getContentPane().add(this.publicActivatedIconButton);
        this.getContentPane().add(this.publicIconButton);
        this.getContentPane().add(this.publicTempActivatedIconButton);
        this.getContentPane().add(this.publicTempIconButton);
        this.getContentPane().add(this.publicRestrictionActivatedIconButton);
        this.getContentPane().add(this.publicRestrictionIconButton);
        this.getContentPane().add(this.migrationActivatedIconButton);
        this.getContentPane().add(this.migrationIconButton);
        this.getContentPane().add(this.saveActivatedIconButton);
        this.getContentPane().add(this.saveIconButton);
        this.getContentPane().add(this.createActivatedIconButton);
        this.getContentPane().add(this.createIconButton);
        this.getContentPane().add(this.helpIconButton);
        this.getContentPane().add(this.versionInfoLabel);
        this.getContentPane().add(this.startPanel);
        this.startPanel.add(this.welcomeLabel);
        this.startPanel.add(this.welcomeArea);
        this.startPanel.add(this.sourceLabel);
        this.startPanel.add(this.sourcePathTextField);
        this.startPanel.add(this.sourceChooserButton);
        this.startPanel.add(this.destinationLabel);
        this.startPanel.add(this.destinationPathTextField);
        this.startPanel.add(this.destinationChooserButton);
        this.startPanel.add(this.workingLabel);
        this.startPanel.add(this.workingPathTextField);
        this.startPanel.add(this.workingChooserButton);
        this.startPanel.add(this.kindOfSIPBuildingDropDown);
        this.startPanel.add(this.collectionNameTextField);
        this.startPanel.add(this.goToLoadStandardButton);
        this.startPanel.add(this.backgroundStartImageLabel);
        this.startPanel.setLayout(null);
        this.getContentPane().add(this.loadStandardPanel);
        this.loadStandardPanel.add(this.rightsLabel);
        this.loadStandardPanel.add(this.rightsAreaOne);
        this.loadStandardPanel.add(this.loadContractButton);
        this.loadStandardPanel.add(this.rightsAreaTwo);
        this.loadStandardPanel.add(this.standardContractButton);
        this.loadStandardPanel.add(this.rightsAreaThree);
        this.loadStandardPanel.add(this.goBackToStartButton);
        this.loadStandardPanel.add(this.goToPublicButton);
        this.loadStandardPanel.add(this.backgroundLoadStandardImageLabel);
        this.loadStandardPanel.setLayout(null);
        this.getContentPane().add(this.publicPanel);
        this.publicPanel.add(this.publicLabel);
        this.publicPanel.add(this.publicArea);
        this.publicPanel.add(this.publicAllowRadioButton);
        this.publicPanel.add(this.publicDenyRadioButton);
        this.publicPanel.add(this.goToLicenseButton);
        this.publicPanel.add(this.publicDDBArea);
        this.publicPanel.add(this.publicDDBCheckBox);
        this.publicPanel.add(this.goBackToLoadStandardButton);
        this.publicPanel.add(this.backgroundPublicImageLabel);
        this.publicPanel.setLayout(null);
        this.getContentPane().add(this.publicLicensePanel);
        this.publicLicensePanel.add(this.licenseLabel);
        this.publicLicensePanel.add(this.licenseAreaOne);
        this.publicLicensePanel.add(this.metadataLicenseRadioButton);
        this.publicLicensePanel.add(this.premisLicenseRadioButton);
        this.publicLicensePanel.add(this.licenseDropDown);
        this.publicLicensePanel.add(this.licenseTextField);
        this.publicLicensePanel.add(this.goToPublicTempButton);
        this.publicLicensePanel.add(this.goBackToPublicButton);
        this.publicLicensePanel.add(this.backgroundLicenseImageLabel);
        this.publicLicensePanel.setLayout(null);
        this.getContentPane().add(this.publicTempPanel);
        this.publicTempPanel.add(this.publicStartLabel);
        this.publicTempPanel.add(this.publicNoTempRestrictionRadioButton);
        this.publicTempPanel.add(this.publicTempRadioButton);
        this.publicTempPanel.add(this.publicTempStartDateLabel);
        this.publicTempPanel.add(this.publicTempStartDateTextField);
        this.publicTempPanel.add(this.publicLawIdDropDown);
        this.publicTempPanel.add(this.publicLawRadioButton);
        this.publicTempPanel.add(this.goBackToLicenseOrInstitutionButton);
        this.publicTempPanel.add(this.goToPublicRestrictionButton);
        this.publicTempPanel.add(this.backgroundPublicTempImageLabel);
        this.publicTempPanel.setLayout(null);
        this.getContentPane().add(this.publicRestrictionPanel);
        this.publicRestrictionPanel.add(this.publicRestrictionHeadlineLabel);
        this.publicRestrictionPanel.add(this.publicRestrictionArea);
        this.publicRestrictionPanel.add(this.publicTabbedPane);
        this.publicRestrictionPanel.add(this.goBackToPublicTempButton);
        this.publicRestrictionPanel.add(this.goToInstitutionButton);
        this.publicRestrictionPanel.add(this.backgroundPublicRestrictionImageLabel);
        this.publicRestrictionPanel.setLayout(null);
        this.publicTextPanel.add(this.publicTextRestrictionCheckBox);
        this.publicTextPanel.add(this.publicRestrictionTextPagesLabel);
        this.publicTextPanel.add(this.publicRestrictionTextPagesTextField);
        this.publicTextPanel.add(this.publicRestrictionTextArea);
        this.publicTextPanel.setLayout(null);
        this.publicImagePanel.add(this.publicImageRestrictionCheckBox);
        this.publicImagePanel.add(this.publicRestrictionImageArea);
        this.publicImagePanel.add(this.publicImageDropDown);
        this.publicImagePanel.add(this.publicImageTextCheckBox);
        this.publicImagePanel.add(this.publicRestrictionImageTextTypeLabel);
        this.publicImagePanel.add(this.publicRestrictionImageTextOpacityLabel);
        this.publicImagePanel.add(this.publicRestrictionImageTextSizeLabel);
        this.publicImagePanel.add(this.publicImageTextDropDown);
        this.publicImagePanel.add(this.publicImageTextOpacityDropDown);
        this.publicImagePanel.add(this.publicImageTextSizeDropDown);
        this.publicImagePanel.add(this.publicRestrictionImageLabel);
        this.publicImagePanel.add(this.publicRestrictionImageTextField);
        this.publicImagePanel.setLayout(null);
        this.publicAudioPanel.add(this.publicAudioRestrictionCheckBox);
        this.publicAudioPanel.add(this.publicRestrictionAudioDurationLabel);
        this.publicAudioPanel.add(this.publicAudioDurationDropDown);
        this.publicAudioPanel.setLayout(null);
        this.publicVideoPanel.add(this.publicVideoRestrictionCheckBox);
        this.publicVideoPanel.add(this.publicVideoDurationCheckBox);
        this.publicVideoPanel.add(this.publicRestrictionVideoQualityLabel);
        this.publicVideoPanel.add(this.publicVideoQualityDropDown);
        this.publicVideoPanel.add(this.publicRestrictionVideoDurationLabel);
        this.publicVideoPanel.add(this.publicVideoDurationDropDown);
        this.publicVideoPanel.setLayout(null);
        this.getContentPane().add(this.institutionPanel);
        this.institutionPanel.add(this.institutionLabel);
        this.institutionPanel.add(this.institutionArea);
        this.institutionPanel.add(this.institutionAllowRadioButton);
        this.institutionPanel.add(this.institutionDenyRadioButton);
        this.institutionPanel.add(this.goBackToPublicRestrictionOrPublicButton);
        this.institutionPanel.add(this.goToInstitutionTempButton);
        this.institutionPanel.add(this.backgroundInstitutionImageLabel);
        this.institutionPanel.setLayout(null);
        this.getContentPane().add(this.institutionTempPanel);
        this.institutionTempPanel.add(this.institutionStartLabel);
        this.institutionTempPanel.add(this.institutionNoTempRestrictionRadioButton);
        this.institutionTempPanel.add(this.institutionTempRadioButton);
        this.institutionTempPanel.add(this.institutionTempStartDateLabel);
        this.institutionTempPanel.add(this.institutionTempStartDateTextField);
        this.institutionTempPanel.add(this.institutionLawRadioButton);
        this.institutionTempPanel.add(this.institutionLawIdDropDown);
        this.institutionTempPanel.add(this.goBackToInstitutionButton);
        this.institutionTempPanel.add(this.goToInstitutionRestrictionOrPublicButton);
        this.institutionTempPanel.add(this.backgroundInstitutionTempImageLabel);
        this.institutionTempPanel.setLayout(null);
        this.getContentPane().add(this.institutionRestrictionPanel);
        this.institutionRestrictionPanel.add(this.institutionRestrictionHeadlineLabel);
        this.institutionRestrictionPanel.add(this.institutionRestrictionArea);
        this.institutionRestrictionPanel.add(this.institutionTabbedPane);
        this.institutionRestrictionPanel.add(this.goBackToInstitutionTempButton);
        this.institutionRestrictionPanel.add(this.goToMigrationButton);
        this.institutionRestrictionPanel.add(this.backgroundInstitutionRestrictionImageLabel);
        this.institutionRestrictionPanel.setLayout(null);
        this.institutionTextPanel.add(this.institutionTextRestrictionCheckBox);
        this.institutionTextPanel.add(this.institutionRestrictionTextPagesLabel);
        this.institutionTextPanel.add(this.institutionRestrictionTextPagesTextField);
        this.institutionTextPanel.add(this.institutionRestrictionTextArea);
        this.institutionTextPanel.setLayout(null);
        this.institutionImagePanel.add(this.institutionImageRestrictionCheckBox);
        this.institutionImagePanel.add(this.institutionRestrictionImageArea);
        this.institutionImagePanel.add(this.institutionImageDropDown);
        this.institutionImagePanel.add(this.institutionImageTextCheckBox);
        this.institutionImagePanel.add(this.institutionRestrictionImageTextTypeLabel);
        this.institutionImagePanel.add(this.institutionRestrictionImageTextOpacityLabel);
        this.institutionImagePanel.add(this.institutionRestrictionImageTextSizeLabel);
        this.institutionImagePanel.add(this.institutionImageTextDropDown);
        this.institutionImagePanel.add(this.institutionImageTextOpacityDropDown);
        this.institutionImagePanel.add(this.institutionImageTextSizeDropDown);
        this.institutionImagePanel.add(this.institutionRestrictionImageLabel);
        this.institutionImagePanel.add(this.institutionRestrictionImageTextField);
        this.institutionImagePanel.setLayout(null);
        this.institutionAudioPanel.add(this.institutionAudioRestrictionCheckBox);
        this.institutionAudioPanel.add(this.institutionRestrictionAudioDurationLabel);
        this.institutionAudioPanel.add(this.institutionAudioDurationDropDown);
        this.institutionAudioPanel.setLayout(null);
        this.institutionVideoPanel.add(this.institutionVideoRestrictionCheckBox);
        this.institutionVideoPanel.add(this.institutionVideoDurationCheckBox);
        this.institutionVideoPanel.add(this.institutionRestrictionVideoQualityLabel);
        this.institutionVideoPanel.add(this.institutionVideoQualityDropDown);
        this.institutionVideoPanel.add(this.institutionRestrictionVideoDurationLabel);
        this.institutionVideoPanel.add(this.institutionVideoDurationDropDown);
        this.institutionVideoPanel.setLayout(null);
        this.getContentPane().add(this.migrationPanel);
        this.migrationPanel.add(this.migrationConversionLabel);
        this.migrationPanel.add(this.migrationArea);
        this.migrationPanel.add(this.migrationConditionLabel);
        this.migrationPanel.add(this.migrationDropDown);
        this.migrationPanel.add(this.goBackToInstitutionRestrictionOrTempButton);
        this.migrationPanel.add(this.goToSaveButton);
        this.migrationPanel.add(this.backgroundMigrationImageLabel);
        this.migrationPanel.setLayout(null);
        this.getContentPane().add(this.savePanel);
        this.savePanel.add(this.saveLabel);
        this.savePanel.add(this.settingsOverviewInfoArea);
        this.savePanel.add(this.saveArea);
        this.savePanel.add(this.settingsOverviewArea);
        this.savePanel.add(this.saveButton);
        this.savePanel.add(this.goBackToMigrationButton);
        this.savePanel.add(this.goToCreateButton);
        this.savePanel.add(this.backgroundSaveImageLabel);
        this.savePanel.setLayout(null);
        this.getContentPane().add(this.createPanel);
        this.createPanel.add(this.createLabel);
        this.createPanel.add(this.createArea);
        this.createPanel.add(this.compressionCheckBox);
        this.createPanel.add(this.createButton);
        this.createPanel.add(this.abortButton);
        this.createPanel.add(this.quitButton);
        this.createPanel.add(this.progressBar);
        this.createPanel.add(this.sipProgressDisplayLabel);
        this.createPanel.add(this.sipProgressStepLabel);
        this.createPanel.add(this.goBackToSaveButton);
        this.createPanel.add(this.backgroundCreateImageLabel);
        this.createPanel.setLayout(null);
        this.getContentPane().setLayout(null);
    }

    private void createListeners() {
        this.helpIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.messageWriter.showMessage(SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder v" + Gui.this.buildNumber + "\n\nLVR-InfoKom (ab 2014). HKI, Universit\u00e4t zu K\u00f6ln 2011-2014.\n\nwww.danrw.de");
            }
        });
        this.sourceChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sourcePath = Gui.this.searchFolder(Gui.this.sourcePathChooser);
                if (sourcePath != null) {
                    Gui.this.sourcePathTextField.setText(sourcePath);
                    try {
                        Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "srcPath.sav"), sourcePath);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to create file " + new File(Gui.this.dataFolderPath + File.separator + "srcPath.sav").getAbsolutePath(), ex);
                    }
                }
            }
        });
        this.destinationChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String destinationPath = Gui.this.searchFolder(Gui.this.destinationPathChooser);
                if (destinationPath != null) {
                    Gui.this.destinationPathTextField.setText(destinationPath);
                    try {
                        Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "destPath.sav"), destinationPath);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to create file " + new File(Gui.this.dataFolderPath + File.separator + "destPath.sav").getAbsolutePath(), ex);
                    }
                }
            }
        });
        this.workingChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String workingPath = Gui.this.searchFolder(Gui.this.workingPathChooser);
                if (workingPath != null) {
                    Gui.this.workingPathTextField.setText(workingPath);
                    try {
                        Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "workPath.sav"), workingPath);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to create file " + new File(Gui.this.dataFolderPath + File.separator + "workPath.sav").getAbsolutePath(), ex);
                    }
                }
            }
        });
        this.goToLoadStandardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterLoadSection();
            }
        });
        this.goBackToStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterStartSection();
            }
        });
        this.loadContractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String contractRightsFilePath = Gui.this.searchXmlFile();
                if (contractRightsFilePath != null) {
                    try {
                        Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "crloadPath.sav"), contractRightsFilePath);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to create file " + new File(Gui.this.dataFolderPath + File.separator + "crloadPath.sav").getAbsolutePath(), ex);
                    }
                    File contractRightsFile = new File(contractRightsFilePath);
                    try {
                        Gui.this.sipFactory.getContractRights().loadContractRightsFromFile(contractRightsFile);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to load contract rights from file " + contractRightsFile.getAbsolutePath(), ex);
                        Gui.this.messageWriter.showMessage("Beim Einlesen der Datei ist ein Fehler aufgetreten.", 0);
                        return;
                    }
                    Gui.this.updateValues();
                    Gui.this.messageWriter.showMessage("Die Rechteeinstellungen wurden erfolgreich geladen.", -1);
                }
            }
        });
        this.standardContractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.loadStandardRights()) {
                    Gui.this.messageWriter.showMessage("Die Standardeinstellungen wurden erfolgreich geladen.", -1);
                }
            }
        });
        this.goToInstitutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionSection();
            }
        });
        this.goToLicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationPublicLicenseSection()) {
                    Gui.this.enterPublicationInstitutionSection();
                }
            }
        });
        this.goBackToLicenseOrInstitutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicLicenseSection();
            }
        });
        this.goBackToLoadStandardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterLoadSection();
            }
        });
        this.goToPublicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.goBackToPublicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.goToPublicTempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicTempSection();
            }
        });
        this.goBackToPublicTempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicTempSection();
            }
        });
        this.goToPublicRestrictionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicRestrictionsSection();
            }
        });
        this.goBackToPublicRestrictionOrPublicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationPublicRestrictionsSection()) {
                    Gui.this.enterPublicationPublicSection();
                }
            }
        });
        this.goToInstitutionTempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationInstitutionTempSection()) {
                    Gui.this.enterMigrationSection();
                }
            }
        });
        this.goBackToInstitutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionSection();
            }
        });
        this.goToInstitutionRestrictionOrPublicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionRestrictionsSection();
            }
        });
        this.goBackToInstitutionTempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionTempSection();
            }
        });
        this.goBackToInstitutionRestrictionOrTempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationInstitutionRestrictionsSection()) {
                    Gui.this.enterPublicationInstitutionSection();
                }
            }
        });
        this.goToMigrationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterMigrationSection();
            }
        });
        this.goToSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterSaveSection();
            }
        });
        this.goBackToMigrationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterMigrationSection();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = Gui.this.saveFile("contractRights.xml");
                if (fileName != null && !fileName.equals("")) {
                    try {
                        Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "crsavePath.sav"), fileName);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to write file " + new File(Gui.this.dataFolderPath + File.separator + "crsavePath.sav").getAbsolutePath(), ex);
                    }
                    try {
                        Gui.this.premisWriter.createContractRightsFile(Gui.this.sipFactory.getContractRights(), new File(fileName));
                        Gui.this.messageWriter.showMessage("Ihre Rechte-Einstellungen wurden erfolgreich gespeichert!", -1);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to create file " + new File(fileName).getAbsolutePath(), ex);
                        Gui.this.messageWriter.showMessage(ex.getMessage() + "\n" + ex.getStackTrace(), 0);
                        Gui.this.messageWriter.showMessage("Beim Erstellen der Datei ist ein Fehler aufgetreten.", 0);
                    }
                }
            }
        });
        this.goToCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterCreateSection();
            }
        });
        this.goBackToSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterSaveSection();
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.compressionCheckBox.setEnabled(false);
                Gui.this.createButton.setEnabled(false);
                Gui.this.createButton.setVisible(false);
                Gui.this.abortButton.setEnabled(true);
                Gui.this.abortButton.setVisible(true);
                Gui.this.goBackToSaveButton.setEnabled(false);
                Gui.this.startActivatedIconButton.setEnabled(false);
                Gui.this.startIconButton.setEnabled(false);
                Gui.this.loadActivatedIconButton.setEnabled(false);
                Gui.this.loadIconButton.setEnabled(false);
                Gui.this.licenseActivatedIconButton.setEnabled(false);
                Gui.this.licenseIconButton.setEnabled(false);
                Gui.this.publicationActivatedIconButton.setEnabled(false);
                Gui.this.publicationIconButton.setEnabled(false);
                Gui.this.institutionActivatedIconButton.setEnabled(false);
                Gui.this.institutionIconButton.setEnabled(false);
                Gui.this.institutionTempActivatedIconButton.setEnabled(false);
                Gui.this.institutionTempIconButton.setEnabled(false);
                Gui.this.institutionRestrictionActivatedIconButton.setEnabled(false);
                Gui.this.institutionRestrictionIconButton.setEnabled(false);
                Gui.this.publicActivatedIconButton.setEnabled(false);
                Gui.this.publicIconButton.setEnabled(false);
                Gui.this.publicTempActivatedIconButton.setEnabled(false);
                Gui.this.publicTempIconButton.setEnabled(false);
                Gui.this.publicRestrictionActivatedIconButton.setEnabled(false);
                Gui.this.publicRestrictionIconButton.setEnabled(false);
                Gui.this.migrationActivatedIconButton.setEnabled(false);
                Gui.this.migrationIconButton.setEnabled(false);
                Gui.this.saveActivatedIconButton.setEnabled(false);
                Gui.this.saveIconButton.setEnabled(false);
                Gui.this.createActivatedIconButton.setEnabled(false);
                Gui.this.createIconButton.setEnabled(false);
                Gui.this.progressBar.setVisible(true);
                Gui.this.sipProgressDisplayLabel.setVisible(true);
                Gui.this.sipProgressStepLabel.setVisible(true);
                GuiProgressManager progressManager = new GuiProgressManager(Gui.this.progressBar, Gui.this.sipProgressDisplayLabel, Gui.this.sipProgressStepLabel);
                Gui.this.sipFactory.setCompress(Gui.this.compressionCheckBox.isSelected());
                Gui.this.sipFactory.setProgressManager(progressManager);
                Gui.this.sipFactory.setMessageWriter(Gui.this.messageWriter);
                Gui.this.sipFactory.startSIPBuilding();
            }
        });
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.abortButton.setEnabled(false);
                Gui.this.sipFactory.abort();
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.startIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterStartSection();
            }
        });
        this.loadIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterLoadSection();
            }
        });
        this.licenseIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationPublicLicenseSection()) {
                    Gui.this.enterPublicationPublicSection();
                }
            }
        });
        this.publicationIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.publicationActivatedIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.institutionIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionSection();
            }
        });
        this.institutionActivatedIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationInstitutionSection();
            }
        });
        this.institutionTempIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationInstitutionTempSection()) {
                    Gui.this.enterPublicationInstitutionSection();
                }
            }
        });
        this.institutionRestrictionIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationInstitutionRestrictionsSection()) {
                    Gui.this.enterPublicationInstitutionSection();
                }
            }
        });
        this.publicIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.publicActivatedIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterPublicationPublicSection();
            }
        });
        this.publicTempIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationPublicTempSection()) {
                    Gui.this.enterPublicationPublicSection();
                }
            }
        });
        this.publicRestrictionIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Gui.this.enterPublicationPublicRestrictionsSection()) {
                    Gui.this.enterPublicationPublicSection();
                }
            }
        });
        this.migrationIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterMigrationSection();
            }
        });
        this.saveIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterSaveSection();
            }
        });
        this.createIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enterCreateSection();
            }
        });
        this.publicAllowRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.publicDDBArea.setEnabled(true);
                Gui.this.publicDDBCheckBox.setEnabled(true);
            }
        });
        this.publicDenyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.publicDDBArea.setEnabled(false);
                Gui.this.publicDDBCheckBox.setEnabled(false);
            }
        });
        this.institutionNoTempRestrictionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionNoTempRestrictionRadioButton.isSelected()) {
                    Gui.this.institutionTempStartDateLabel.setEnabled(false);
                    Gui.this.institutionTempStartDateTextField.setEditable(false);
                    Gui.this.institutionTempStartDateTextField.setEnabled(false);
                    Gui.this.institutionLawIdDropDown.setEnabled(false);
                }
            }
        });
        this.institutionTempRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionTempRadioButton.isSelected()) {
                    Gui.this.institutionTempStartDateLabel.setEnabled(true);
                    Gui.this.institutionTempStartDateTextField.setEditable(true);
                    Gui.this.institutionTempStartDateTextField.setEnabled(true);
                    Gui.this.institutionLawIdDropDown.setEnabled(false);
                } else {
                    Gui.this.institutionTempStartDateLabel.setEnabled(false);
                    Gui.this.institutionTempStartDateTextField.setEditable(false);
                    Gui.this.institutionTempStartDateTextField.setEnabled(false);
                }
            }
        });
        this.institutionLawRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionLawRadioButton.isSelected()) {
                    Gui.this.institutionLawIdDropDown.setEnabled(true);
                    Gui.this.institutionTempStartDateLabel.setEnabled(false);
                    Gui.this.institutionTempStartDateTextField.setEditable(false);
                    Gui.this.institutionTempStartDateTextField.setEnabled(false);
                } else {
                    Gui.this.institutionLawIdDropDown.setEnabled(false);
                }
            }
        });
        this.institutionTextRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionTextRestrictionCheckBox.isSelected()) {
                    Gui.this.institutionRestrictionTextPagesTextField.setEnabled(true);
                    Gui.this.institutionRestrictionTextPagesTextField.setEditable(true);
                    Gui.this.institutionRestrictionTextPagesLabel.setEnabled(true);
                    Gui.this.institutionRestrictionTextArea.setEnabled(true);
                } else {
                    Gui.this.institutionRestrictionTextPagesTextField.setEnabled(false);
                    Gui.this.institutionRestrictionTextPagesTextField.setEditable(false);
                    Gui.this.institutionRestrictionTextPagesLabel.setEnabled(false);
                    Gui.this.institutionRestrictionTextArea.setEnabled(false);
                }
            }
        });
        ActionListener licenseRadioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton btn = (JRadioButton)e.getSource();
                if (btn == Gui.this.premisLicenseRadioButton) {
                    Gui.this.licenseDropDown.setEditable(true);
                    Gui.this.licenseDropDown.setEnabled(true);
                    Gui.this.licenseTextField.setVisible(true);
                    Gui.this.licenseDropDown.setSelectedIndex(0);
                } else {
                    Gui.this.licenseDropDown.setEditable(false);
                    Gui.this.licenseDropDown.setEnabled(false);
                    Gui.this.licenseTextField.setVisible(false);
                }
            }
        };
        this.metadataLicenseRadioButton.addActionListener(licenseRadioButtonListener);
        this.premisLicenseRadioButton.addActionListener(licenseRadioButtonListener);
        this.institutionImageRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionImageRestrictionCheckBox.isSelected()) {
                    Gui.this.institutionImageDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionImageArea.setEnabled(true);
                } else {
                    Gui.this.institutionImageDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionImageArea.setEnabled(false);
                }
            }
        });
        this.institutionImageTextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionImageTextCheckBox.isSelected()) {
                    Gui.this.institutionRestrictionImageTextField.setEnabled(true);
                    Gui.this.institutionRestrictionImageTextField.setEditable(true);
                    Gui.this.institutionRestrictionImageLabel.setEnabled(true);
                    Gui.this.institutionRestrictionImageLabel.setEnabled(true);
                    Gui.this.institutionImageTextDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionImageTextTypeLabel.setEnabled(true);
                    if (!((String)Gui.this.institutionImageTextDropDown.getSelectedItem()).equals("Fu\u00dfzeile")) {
                        Gui.this.institutionRestrictionImageTextOpacityLabel.setEnabled(true);
                        Gui.this.institutionImageTextOpacityDropDown.setEnabled(true);
                        Gui.this.institutionRestrictionImageTextSizeLabel.setEnabled(true);
                        Gui.this.institutionImageTextSizeDropDown.setEnabled(true);
                    }
                } else {
                    Gui.this.institutionRestrictionImageTextField.setEnabled(false);
                    Gui.this.institutionRestrictionImageTextField.setEditable(false);
                    Gui.this.institutionRestrictionImageLabel.setEnabled(false);
                    Gui.this.institutionRestrictionImageLabel.setEnabled(false);
                    Gui.this.institutionImageTextDropDown.setEnabled(false);
                    Gui.this.institutionImageTextOpacityDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionImageTextTypeLabel.setEnabled(false);
                    Gui.this.institutionRestrictionImageTextOpacityLabel.setEnabled(false);
                    Gui.this.institutionRestrictionImageTextSizeLabel.setEnabled(false);
                    Gui.this.institutionImageTextSizeDropDown.setEnabled(false);
                }
            }
        });
        this.institutionAudioRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionAudioRestrictionCheckBox.isSelected()) {
                    Gui.this.institutionAudioDurationDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionAudioDurationLabel.setEnabled(true);
                } else {
                    Gui.this.institutionAudioDurationDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionAudioDurationLabel.setEnabled(false);
                }
            }
        });
        this.institutionVideoRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionVideoRestrictionCheckBox.isSelected()) {
                    Gui.this.institutionVideoQualityDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionVideoQualityLabel.setEnabled(true);
                } else {
                    Gui.this.institutionVideoQualityDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionVideoQualityLabel.setEnabled(false);
                }
            }
        });
        this.institutionVideoDurationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.institutionVideoDurationCheckBox.isSelected()) {
                    Gui.this.institutionVideoDurationDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionVideoDurationLabel.setEnabled(true);
                } else {
                    Gui.this.institutionVideoDurationDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionVideoDurationLabel.setEnabled(false);
                }
            }
        });
        this.publicNoTempRestrictionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicNoTempRestrictionRadioButton.isSelected()) {
                    Gui.this.publicTempStartDateLabel.setEnabled(false);
                    Gui.this.publicTempStartDateTextField.setEditable(false);
                    Gui.this.publicTempStartDateTextField.setEnabled(false);
                    Gui.this.publicLawIdDropDown.setEnabled(false);
                }
            }
        });
        this.publicTempRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicTempRadioButton.isSelected()) {
                    Gui.this.publicTempStartDateLabel.setEnabled(true);
                    Gui.this.publicTempStartDateTextField.setEditable(true);
                    Gui.this.publicTempStartDateTextField.setEnabled(true);
                    Gui.this.publicLawIdDropDown.setEnabled(false);
                } else {
                    Gui.this.publicTempStartDateLabel.setEnabled(false);
                    Gui.this.publicTempStartDateTextField.setEditable(false);
                    Gui.this.publicTempStartDateTextField.setEnabled(false);
                }
            }
        });
        this.publicLawRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicLawRadioButton.isSelected()) {
                    Gui.this.publicLawIdDropDown.setEnabled(true);
                    Gui.this.publicTempStartDateLabel.setEnabled(false);
                    Gui.this.publicTempStartDateTextField.setEditable(false);
                    Gui.this.publicTempStartDateTextField.setEnabled(false);
                } else {
                    Gui.this.publicLawIdDropDown.setEnabled(false);
                }
            }
        });
        this.publicTextRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicTextRestrictionCheckBox.isSelected()) {
                    Gui.this.publicRestrictionTextPagesTextField.setEnabled(true);
                    Gui.this.publicRestrictionTextPagesTextField.setEditable(true);
                    Gui.this.publicRestrictionTextPagesLabel.setEnabled(true);
                    Gui.this.publicRestrictionTextArea.setEnabled(true);
                } else {
                    Gui.this.publicRestrictionTextPagesTextField.setEnabled(false);
                    Gui.this.publicRestrictionTextPagesTextField.setEditable(false);
                    Gui.this.publicRestrictionTextPagesLabel.setEnabled(false);
                    Gui.this.publicRestrictionTextArea.setEnabled(false);
                }
            }
        });
        this.publicImageRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicImageRestrictionCheckBox.isSelected()) {
                    Gui.this.publicImageDropDown.setEnabled(true);
                    Gui.this.publicRestrictionImageArea.setEnabled(true);
                } else {
                    Gui.this.publicImageDropDown.setEnabled(false);
                    Gui.this.publicRestrictionImageArea.setEnabled(false);
                }
            }
        });
        this.publicImageTextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicImageTextCheckBox.isSelected()) {
                    Gui.this.publicRestrictionImageTextField.setEnabled(true);
                    Gui.this.publicRestrictionImageTextField.setEditable(true);
                    Gui.this.publicRestrictionImageLabel.setEnabled(true);
                    Gui.this.publicRestrictionImageLabel.setEnabled(true);
                    Gui.this.publicImageTextDropDown.setEnabled(true);
                    Gui.this.publicRestrictionImageTextTypeLabel.setEnabled(true);
                    if (!((String)Gui.this.publicImageTextDropDown.getSelectedItem()).equals("Fu\u00dfzeile")) {
                        Gui.this.publicRestrictionImageTextOpacityLabel.setEnabled(true);
                        Gui.this.publicImageTextOpacityDropDown.setEnabled(true);
                        Gui.this.publicRestrictionImageTextSizeLabel.setEnabled(true);
                        Gui.this.publicImageTextSizeDropDown.setEnabled(true);
                    }
                } else {
                    Gui.this.publicRestrictionImageTextField.setEnabled(false);
                    Gui.this.publicRestrictionImageTextField.setEditable(false);
                    Gui.this.publicRestrictionImageLabel.setEnabled(false);
                    Gui.this.publicRestrictionImageLabel.setEnabled(false);
                    Gui.this.publicImageTextDropDown.setEnabled(false);
                    Gui.this.publicImageTextOpacityDropDown.setEnabled(false);
                    Gui.this.publicRestrictionImageTextTypeLabel.setEnabled(false);
                    Gui.this.publicRestrictionImageTextOpacityLabel.setEnabled(false);
                    Gui.this.publicRestrictionImageTextSizeLabel.setEnabled(false);
                    Gui.this.publicImageTextSizeDropDown.setEnabled(false);
                }
            }
        });
        this.publicAudioRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicAudioRestrictionCheckBox.isSelected()) {
                    Gui.this.publicAudioDurationDropDown.setEnabled(true);
                    Gui.this.publicRestrictionAudioDurationLabel.setEnabled(true);
                } else {
                    Gui.this.publicAudioDurationDropDown.setEnabled(false);
                    Gui.this.publicRestrictionAudioDurationLabel.setEnabled(false);
                }
            }
        });
        this.publicVideoRestrictionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicVideoRestrictionCheckBox.isSelected()) {
                    Gui.this.publicVideoQualityDropDown.setEnabled(true);
                    Gui.this.publicRestrictionVideoQualityLabel.setEnabled(true);
                } else {
                    Gui.this.publicVideoQualityDropDown.setEnabled(false);
                    Gui.this.publicRestrictionVideoQualityLabel.setEnabled(false);
                }
            }
        });
        this.publicVideoDurationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gui.this.publicVideoDurationCheckBox.isSelected()) {
                    Gui.this.publicVideoDurationDropDown.setEnabled(true);
                    Gui.this.publicRestrictionVideoDurationLabel.setEnabled(true);
                } else {
                    Gui.this.publicVideoDurationDropDown.setEnabled(false);
                    Gui.this.publicRestrictionVideoDurationLabel.setEnabled(false);
                }
            }
        });
        this.compressionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.quitButton.setEnabled(false);
                Gui.this.quitButton.setVisible(false);
                Gui.this.createButton.setEnabled(true);
                Gui.this.createButton.setVisible(true);
                String compressionSetting = String.valueOf(Gui.this.compressionCheckBox.isSelected());
                try {
                    Utilities.writeFile(new File(Gui.this.dataFolderPath + File.separator + "compSetting.sav"), compressionSetting);
                }
                catch (Exception ex) {
                    logger.warn("Failed to create file " + new File(Gui.this.dataFolderPath + File.separator + "compSetting.sav").getAbsolutePath(), ex);
                }
            }
        });
        this.kindOfSIPBuildingDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Utilities.translateKindOfSIPBuilding((String)Gui.this.kindOfSIPBuildingDropDown.getSelectedItem()) == SIPFactory.KindOfSIPBuilding.MULTIPLE_FOLDERS) {
                    // empty if block
                }
            }
        });
        this.licenseDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.licenseTextField.setText(((ContractRights.CCLicense)((Object)Gui.this.licenseDropDown.getSelectedItem())).getHref());
            }
        });
        this.licenseTextField.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(Gui.this.licenseTextField.getText()));
                        }
                        catch (Throwable t) {
                            System.out.println("Default System Browser not startab: " + t.getMessage());
                        }
                    }
                } else if (e.getClickCount() == 1) {
                    Gui.this.licenseTextField.selectAll();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.institutionImageTextDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = Gui.this.institutionRestrictionImageTextField.getText();
                if (((String)Gui.this.institutionImageTextDropDown.getSelectedItem()).equals("Fu\u00dfzeile")) {
                    Gui.this.institutionRestrictionImageTextField.setDocument(new SetMaxText(65));
                    Gui.this.institutionRestrictionImageTextField.setText(text);
                    if (Gui.this.institutionImageTextCheckBox.isSelected()) {
                        Gui.this.institutionRestrictionImageLabel.setText("Bitte geben Sie den gew\u00fcnschten Text an (max. 65 Zeichen)");
                    }
                    Gui.this.institutionRestrictionImageTextOpacityLabel.setEnabled(false);
                    Gui.this.institutionImageTextOpacityDropDown.setEnabled(false);
                    Gui.this.institutionRestrictionImageTextSizeLabel.setEnabled(false);
                    Gui.this.institutionImageTextSizeDropDown.setEnabled(false);
                } else {
                    Gui.this.institutionRestrictionImageTextField.setDocument(new SetMaxText(20));
                    if (text.length() > 20) {
                        text = text.substring(0, 20);
                        Gui.this.messageWriter.showMessage("Der Text enth\u00e4lt mehr als 20 Zeichen und wird entsprechend gek\u00fcrzt.");
                    }
                    Gui.this.institutionRestrictionImageTextField.setText(text);
                    if (Gui.this.institutionImageTextCheckBox.isSelected()) {
                        Gui.this.institutionRestrictionImageLabel.setText("Bitte geben Sie den gew\u00fcnschten Text an: (max. 20 Zeichen)");
                    }
                    Gui.this.institutionRestrictionImageTextOpacityLabel.setEnabled(true);
                    Gui.this.institutionImageTextOpacityDropDown.setEnabled(true);
                    Gui.this.institutionRestrictionImageTextSizeLabel.setEnabled(true);
                    Gui.this.institutionImageTextSizeDropDown.setEnabled(true);
                }
            }
        });
        this.publicImageTextDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = Gui.this.publicRestrictionImageTextField.getText();
                if (((String)Gui.this.publicImageTextDropDown.getSelectedItem()).equals("Fu\u00dfzeile")) {
                    Gui.this.publicRestrictionImageTextField.setDocument(new SetMaxText(65));
                    Gui.this.publicRestrictionImageTextField.setText(text);
                    if (Gui.this.publicImageTextCheckBox.isSelected()) {
                        Gui.this.publicRestrictionImageLabel.setText("Bitte geben Sie den gew\u00fcnschten Text an (max. 65 Zeichen)");
                    }
                    Gui.this.publicRestrictionImageTextOpacityLabel.setEnabled(false);
                    Gui.this.publicImageTextOpacityDropDown.setEnabled(false);
                    Gui.this.publicRestrictionImageTextSizeLabel.setEnabled(false);
                    Gui.this.publicImageTextSizeDropDown.setEnabled(false);
                } else {
                    Gui.this.publicRestrictionImageTextField.setDocument(new SetMaxText(20));
                    if (text.length() > 20) {
                        text = text.substring(0, 20);
                        Gui.this.messageWriter.showMessage("Der Text enth\u00e4lt mehr als 20 Zeichen und wird entsprechend gek\u00fcrzt.");
                    }
                    Gui.this.publicRestrictionImageTextField.setText(text);
                    if (Gui.this.publicImageTextCheckBox.isSelected()) {
                        Gui.this.publicRestrictionImageLabel.setText("Bitte geben Sie den gew\u00fcnschten Text an: (max. 20 Zeichen)");
                    }
                    Gui.this.publicRestrictionImageTextOpacityLabel.setEnabled(true);
                    Gui.this.publicImageTextOpacityDropDown.setEnabled(true);
                    Gui.this.publicRestrictionImageTextSizeLabel.setEnabled(true);
                    Gui.this.publicImageTextSizeDropDown.setEnabled(true);
                }
            }
        });
        this.progressBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Gui.this.progressBar.getValue() == 100 || !Gui.this.progressBar.isEnabled()) {
                    Gui.this.compressionCheckBox.setEnabled(true);
                    Gui.this.abortButton.setEnabled(false);
                    Gui.this.abortButton.setVisible(false);
                    if (Gui.this.progressBar.getValue() == 100) {
                        Gui.this.quitButton.setEnabled(true);
                        Gui.this.quitButton.setVisible(true);
                    } else if (!Gui.this.progressBar.isEnabled()) {
                        Gui.this.createButton.setEnabled(true);
                        Gui.this.createButton.setVisible(true);
                    }
                    Gui.this.goBackToSaveButton.setEnabled(true);
                    Gui.this.startActivatedIconButton.setEnabled(true);
                    Gui.this.startIconButton.setEnabled(true);
                    Gui.this.loadActivatedIconButton.setEnabled(true);
                    Gui.this.loadIconButton.setEnabled(true);
                    Gui.this.licenseActivatedIconButton.setEnabled(true);
                    Gui.this.licenseIconButton.setEnabled(true);
                    Gui.this.publicationActivatedIconButton.setEnabled(true);
                    Gui.this.publicationIconButton.setEnabled(true);
                    Gui.this.institutionActivatedIconButton.setEnabled(true);
                    Gui.this.institutionIconButton.setEnabled(true);
                    Gui.this.institutionTempActivatedIconButton.setEnabled(true);
                    Gui.this.institutionTempIconButton.setEnabled(true);
                    Gui.this.institutionRestrictionActivatedIconButton.setEnabled(true);
                    Gui.this.institutionRestrictionIconButton.setEnabled(true);
                    Gui.this.publicActivatedIconButton.setEnabled(true);
                    Gui.this.publicIconButton.setEnabled(true);
                    Gui.this.publicTempActivatedIconButton.setEnabled(true);
                    Gui.this.publicTempIconButton.setEnabled(true);
                    Gui.this.publicRestrictionActivatedIconButton.setEnabled(true);
                    Gui.this.publicRestrictionIconButton.setEnabled(true);
                    Gui.this.migrationActivatedIconButton.setEnabled(true);
                    Gui.this.migrationIconButton.setEnabled(true);
                    Gui.this.saveActivatedIconButton.setEnabled(true);
                    Gui.this.saveIconButton.setEnabled(true);
                    Gui.this.createActivatedIconButton.setEnabled(true);
                    Gui.this.createIconButton.setEnabled(true);
                }
            }
        });
        this.publicTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Gui.this.oldTabPublic != Gui.this.publicTabbedPane.getSelectedIndex()) {
                    if (Gui.this.oldTabPublic == 0 && Gui.this.publicTextRestrictionCheckBox.isSelected()) {
                        if (Gui.this.publicRestrictionTextPagesTextField == null || Gui.this.publicRestrictionTextPagesTextField.getText().equals("")) {
                            Gui.this.publicTabbedPane.setSelectedIndex(Gui.this.oldTabPublic);
                            Gui.this.messageWriter.showMessage("Bitte geben Sie die Seitennummern der zu\nber\u00fccksichtigenden Seiten an.", 0);
                            Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                            return;
                        }
                        Gui.this.sipFactory.getContractRights().getPublicRights().setPages(Gui.this.publicRestrictionTextPagesTextField.getText());
                        if (Gui.this.sipFactory.getContractRights().getPublicRights().parsePages().equals("")) {
                            Gui.this.publicTabbedPane.setSelectedIndex(Gui.this.oldTabPublic);
                            Gui.this.messageWriter.showMessage("Die Angabe der Seitenzahlen ist nicht \nkorrekt formuliert.", 0);
                            Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                            return;
                        }
                    }
                    if (Gui.this.oldTabPublic == 1 && Gui.this.publicImageTextCheckBox.isSelected()) {
                        if (Gui.this.publicRestrictionImageTextField.getText() == null || Gui.this.publicRestrictionImageTextField.getText().equals("")) {
                            if (Utilities.translateTextType((String)Gui.this.publicImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer) {
                                Gui.this.publicTabbedPane.setSelectedIndex(Gui.this.oldTabPublic);
                                Gui.this.messageWriter.showMessage("Bitte geben Sie den Text der Fu\u00dfzeile an.", 0);
                                Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                                return;
                            }
                            Gui.this.publicTabbedPane.setSelectedIndex(Gui.this.oldTabPublic);
                            Gui.this.messageWriter.showMessage("Bitte geben Sie den Text des Wasserzeichens an.", 0);
                            Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                            return;
                        }
                        int imageTextSize = Gui.this.publicRestrictionImageTextField.getText().length();
                        if (Utilities.translateTextType((String)Gui.this.publicImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer && imageTextSize > 65) {
                            Gui.this.messageWriter.showMessage("Fu\u00dfzeilen d\u00fcrfen nicht mehr als 65 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 65) + " Zeichen zu lang.");
                            Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                            return;
                        }
                        if (Utilities.translateTextType((String)Gui.this.publicImageTextDropDown.getSelectedItem()) != PublicationRights.TextType.footer && imageTextSize > 20) {
                            Gui.this.messageWriter.showMessage("Wasserzeichen d\u00fcrfen nicht mehr als 20 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 20) + " Zeichen zu lang.");
                            Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                            return;
                        }
                    }
                    Gui.this.oldTabPublic = Gui.this.publicTabbedPane.getSelectedIndex();
                }
            }
        });
        this.institutionTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Gui.this.oldTabInstitution != Gui.this.institutionTabbedPane.getSelectedIndex()) {
                    if (Gui.this.oldTabInstitution == 0 && Gui.this.institutionTextRestrictionCheckBox.isSelected()) {
                        if (Gui.this.institutionRestrictionTextPagesTextField == null || Gui.this.institutionRestrictionTextPagesTextField.getText().equals("")) {
                            Gui.this.institutionTabbedPane.setSelectedIndex(Gui.this.oldTabInstitution);
                            Gui.this.messageWriter.showMessage("Bitte geben Sie die Seitennummern der zu\nber\u00fccksichtigenden Seiten an.", 0);
                            Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                            return;
                        }
                        Gui.this.sipFactory.getContractRights().getPublicRights().setPages(Gui.this.institutionRestrictionTextPagesTextField.getText());
                        if (Gui.this.sipFactory.getContractRights().getPublicRights().parsePages().equals("")) {
                            Gui.this.institutionTabbedPane.setSelectedIndex(Gui.this.oldTabInstitution);
                            Gui.this.messageWriter.showMessage("Die Angabe der Seitenzahlen ist nicht \nkorrekt formuliert.", 0);
                            Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                            return;
                        }
                    }
                    if (Gui.this.oldTabInstitution == 1 && Gui.this.institutionImageTextCheckBox.isSelected()) {
                        if (Gui.this.institutionRestrictionImageTextField.getText() == null || Gui.this.institutionRestrictionImageTextField.getText().equals("")) {
                            if (Utilities.translateTextType((String)Gui.this.institutionImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer) {
                                Gui.this.institutionTabbedPane.setSelectedIndex(Gui.this.oldTabInstitution);
                                Gui.this.messageWriter.showMessage("Bitte geben Sie den Text der Fu\u00dfzeile an.", 0);
                                Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                                return;
                            }
                            Gui.this.institutionTabbedPane.setSelectedIndex(Gui.this.oldTabInstitution);
                            Gui.this.messageWriter.showMessage("Bitte geben Sie den Text des Wasserzeichens an.", 0);
                            Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                            return;
                        }
                        int imageTextSize = Gui.this.institutionRestrictionImageTextField.getText().length();
                        if (Utilities.translateTextType((String)Gui.this.institutionImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer && imageTextSize > 65) {
                            Gui.this.messageWriter.showMessage("Fu\u00dfzeilen d\u00fcrfen nicht mehr als 65 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 65) + " Zeichen zu lang.");
                            Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                            return;
                        }
                        if (Utilities.translateTextType((String)Gui.this.institutionImageTextDropDown.getSelectedItem()) != PublicationRights.TextType.footer && imageTextSize > 20) {
                            Gui.this.messageWriter.showMessage("Wasserzeichen d\u00fcrfen nicht mehr als 20 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 20) + " Zeichen zu lang.");
                            Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                            return;
                        }
                    }
                    Gui.this.oldTabInstitution = Gui.this.institutionTabbedPane.getSelectedIndex();
                }
            }
        });
    }

    private void loadLastSessionSettings() {
        File sourceFolderFile = new File(this.dataFolderPath + File.separator + "srcPath.sav");
        File destinationFolderFile = new File(this.dataFolderPath + File.separator + "destPath.sav");
        File workingFolderFile = new File(this.dataFolderPath + File.separator + "workPath.sav");
        File contractRightsLoadFolderFile = new File(this.dataFolderPath + File.separator + "crloadPath.sav");
        File contractRightsSaveFolderFile = new File(this.dataFolderPath + File.separator + "crsavePath.sav");
        File compressionSettingFile = new File(this.dataFolderPath + File.separator + "compSetting.sav");
        if (sourceFolderFile.exists()) {
            try {
                String sourceFolderPath = StringUtilities.readFile(sourceFolderFile);
                this.sourcePathChooser.setCurrentDirectory(new File(sourceFolderPath));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + sourceFolderFile.getAbsolutePath(), e);
            }
        }
        if (destinationFolderFile.exists()) {
            try {
                String destinationFolderPath = StringUtilities.readFile(destinationFolderFile);
                this.destinationPathChooser.setCurrentDirectory(new File(destinationFolderPath));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + destinationFolderFile.getAbsolutePath(), e);
            }
        }
        if (workingFolderFile.exists()) {
            try {
                String workingFolderPath = StringUtilities.readFile(workingFolderFile);
                this.workingPathChooser.setCurrentDirectory(new File(workingFolderPath));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + workingFolderFile.getAbsolutePath(), e);
            }
        }
        if (contractRightsLoadFolderFile.exists()) {
            try {
                String contractFileLoadPath = StringUtilities.readFile(contractRightsLoadFolderFile);
                this.contractFileLoadPathChooser.setSelectedFile(new File(contractFileLoadPath));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + contractRightsLoadFolderFile.getAbsolutePath(), e);
            }
        }
        if (contractRightsSaveFolderFile.exists()) {
            try {
                String contractFileSavePath = StringUtilities.readFile(contractRightsSaveFolderFile);
                this.contractFileSavePathChooser.setSelectedFile(new File(contractFileSavePath));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + contractRightsSaveFolderFile.getAbsolutePath(), e);
            }
        }
        if (compressionSettingFile.exists()) {
            try {
                String compressionSetting = StringUtilities.readFile(compressionSettingFile);
                this.compressionCheckBox.setSelected(Boolean.valueOf(compressionSetting));
            }
            catch (Exception e) {
                logger.warn("Failed to read file " + compressionSettingFile.getAbsolutePath(), e);
            }
        }
    }

    private boolean leaveSection() {
        UserInputValidator.Feedback feedback;
        if (this.startPanel.isVisible()) {
            feedback = UserInputValidator.checkPaths(this.sourcePathTextField.getText(), this.destinationPathTextField.getText(), Utilities.translateKindOfSIPBuilding((String)this.kindOfSIPBuildingDropDown.getSelectedItem()));
            switch (feedback) {
                case NO_SOURCE_PATH: {
                    this.messageWriter.showMessage("Bitte geben Sie einen Quellordner an.", 0);
                    return false;
                }
                case SOURCE_PATH_DOES_NOT_EXIST: {
                    this.messageWriter.showMessage("Der von Ihnen angegebene Quellordner existiert nicht.", 0);
                    return false;
                }
                case NO_DESTINATION_PATH: {
                    this.messageWriter.showMessage("Bitte geben Sie einen Zielordner an.", 0);
                    return false;
                }
                case FOLDER_EQUALITY: {
                    this.messageWriter.showMessage("Bitte stellen Sie sicher, dass Quell- und Zielordner nicht identisch sind.", 0);
                    return false;
                }
                case SUBFOLDER: {
                    this.messageWriter.showMessage("Bitte stellen Sie sicher, dass der Zielordner kein Unterordner des Quellordners ist. ", 0);
                    return false;
                }
                case NON_DIRECTORY_FILES_EXIST: {
                    this.messageWriter.showMessage("Das von Ihnen angegebene Quellverzeichnis enth\u00e4lt Dateien, die keine Ordner sind.\nBitte \u00fcberpr\u00fcfen Sie, ob Sie die richtige Einstellung zur SIP-Generierung gew\u00e4hlt haben.", 0);
                    return false;
                }
            }
            if (this.collectionCheckBox.isSelected()) {
                feedback = UserInputValidator.checkCollectionName(this.collectionNameTextField.getText(), this.destinationPathTextField.getText());
                switch (feedback) {
                    case NO_COLLECTION_NAME: {
                        this.messageWriter.showMessage("Bitte geben Sie den gew\u00fcnschten Namen der Lieferung an.", 0);
                        return false;
                    }
                    case INVALID_COLLECTION_NAME: {
                        this.messageWriter.showMessage("Der von Ihnen gew\u00e4hlte Lieferungsname enth\u00e4lt Zeichen, die auf manchen Betriebssystemen f\u00fcr\ndie Benennung von Dateien nicht erlaubt sind.", 0);
                        return false;
                    }
                    case COLLECTION_ALREADY_EXISTS: {
                        this.messageWriter.showMessage("Im Zielverzeichnis existiert bereits eine Lieferung namens \"" + this.collectionNameTextField.getText() + "\".\nBitte l\u00f6schen Sie die bestehende Lieferung oder w\u00e4hlen Sie einen anderen Namen.", 0);
                        return false;
                    }
                }
            }
        }
        if (this.institutionTempPanel.isVisible() && this.institutionTempRadioButton.isSelected()) {
            feedback = UserInputValidator.checkDate(this.institutionTempStartDateTextField.getText());
            switch (feedback) {
                case NO_DATE: {
                    this.messageWriter.showMessage("Bitte geben Sie ein Startdatum f\u00fcr die Publikation an.", 0);
                    return false;
                }
                case INVALID_DATE: {
                    this.messageWriter.showMessage("Das von Ihnen angegebene Startdatum f\u00fcr die Publikation\nexistiert nicht oder ist nicht korrekt formuliert.\n\nBitte geben Sie das Datum in der Form [Tag].[Monat].[Jahr] an.\n(Beispiel: 14.07.2020)", 0);
                    return false;
                }
            }
        }
        if (this.publicTempPanel.isVisible() && this.publicTempRadioButton.isSelected()) {
            feedback = UserInputValidator.checkDate(this.publicTempStartDateTextField.getText());
            switch (feedback) {
                case NO_DATE: {
                    this.messageWriter.showMessage("Bitte geben Sie ein Startdatum f\u00fcr die Publikation an.", 0);
                    return false;
                }
                case INVALID_DATE: {
                    this.messageWriter.showMessage("Das von Ihnen angegebene Startdatum f\u00fcr die Publikation\nexistiert nicht oder ist nicht korrekt formuliert.\n\nBitte geben Sie das Datum in der Form [Tag].[Monat].[Jahr] an.\n(Beispiel: 14.07.2020)", 0);
                    return false;
                }
            }
        }
        if (this.institutionRestrictionPanel.isVisible()) {
            if (this.institutionImageTextCheckBox.isSelected()) {
                if (this.institutionRestrictionImageTextField.getText() == null || this.institutionRestrictionImageTextField.getText().equals("")) {
                    if (Utilities.translateTextType((String)this.institutionImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer) {
                        this.messageWriter.showMessage("Bitte geben Sie den Text der Fu\u00dfzeile an.", 0);
                    } else {
                        this.messageWriter.showMessage("Bitte geben Sie den Text des Wasserzeichens an.", 0);
                    }
                    return false;
                }
                int imageTextSize = this.institutionRestrictionImageTextField.getText().length();
                if (Utilities.translateTextType((String)this.institutionImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer && imageTextSize > 65) {
                    this.messageWriter.showMessage("Fu\u00dfzeilen d\u00fcrfen nicht mehr als 65 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 65) + " Zeichen zu lang.");
                    return false;
                }
                if (Utilities.translateTextType((String)this.institutionImageTextDropDown.getSelectedItem()) != PublicationRights.TextType.footer && imageTextSize > 20) {
                    this.messageWriter.showMessage("Wasserzeichen d\u00fcrfen nicht mehr als 20 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 20) + " Zeichen zu lang.");
                    return false;
                }
            }
            if (this.institutionTextRestrictionCheckBox.isSelected()) {
                String pages = this.institutionRestrictionTextPagesTextField.getText();
                if (pages.equals("")) {
                    this.messageWriter.showMessage("Bitte geben Sie die Seitennummern der zu\nber\u00fccksichtigenden Seiten an.", 0);
                    return false;
                }
                this.sipFactory.getContractRights().getInstitutionRights().setPages(pages);
                if (this.sipFactory.getContractRights().getInstitutionRights().parsePages().equals("")) {
                    this.messageWriter.showMessage("Die Angabe der Seitenzahlen ist nicht \nkorrekt formuliert.", 0);
                    return false;
                }
            }
        }
        if (this.publicRestrictionPanel.isVisible()) {
            if (this.publicImageTextCheckBox.isSelected()) {
                if (this.publicRestrictionImageTextField.getText() == null || this.publicRestrictionImageTextField.getText().equals("")) {
                    if (Utilities.translateTextType((String)this.publicImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer) {
                        this.messageWriter.showMessage("Bitte geben Sie den Text der Fu\u00dfzeile an.", 0);
                    } else {
                        this.messageWriter.showMessage("Bitte geben Sie den Text des Wasserzeichens an.", 0);
                    }
                    return false;
                }
                int imageTextSize = this.publicRestrictionImageTextField.getText().length();
                if (Utilities.translateTextType((String)this.publicImageTextDropDown.getSelectedItem()) == PublicationRights.TextType.footer && imageTextSize > 65) {
                    this.messageWriter.showMessage("Fu\u00dfzeilen d\u00fcrfen nicht mehr als 65 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 65) + " Zeichen zu lang.");
                    return false;
                }
                if (Utilities.translateTextType((String)this.publicImageTextDropDown.getSelectedItem()) != PublicationRights.TextType.footer && imageTextSize > 20) {
                    this.messageWriter.showMessage("Wasserzeichen d\u00fcrfen nicht mehr als 20 Zeichen lang sein.\nIhr Text ist " + (imageTextSize - 20) + " Zeichen zu lang.");
                    return false;
                }
            }
            if (this.publicTextRestrictionCheckBox.isSelected()) {
                String pages = this.publicRestrictionTextPagesTextField.getText();
                if (pages.equals("")) {
                    this.messageWriter.showMessage("Bitte geben Sie die Seitennummern der zu\nber\u00fccksichtigenden Seiten an.", 0);
                    return false;
                }
                this.sipFactory.getContractRights().getPublicRights().setPages(pages);
                if (this.sipFactory.getContractRights().getPublicRights().parsePages().equals("")) {
                    this.messageWriter.showMessage("Die Angabe der Seitenzahlen ist nicht \nkorrekt formuliert.", 0);
                    return false;
                }
            }
        }
        if (this.createPanel.isVisible()) {
            this.progressBar.setVisible(false);
            this.sipProgressDisplayLabel.setVisible(false);
            this.sipProgressStepLabel.setVisible(false);
            this.quitButton.setEnabled(false);
            this.quitButton.setVisible(false);
            this.createButton.setEnabled(true);
            this.createButton.setVisible(true);
        }
        this.startActivatedIconButton.setVisible(false);
        this.startIconButton.setVisible(true);
        this.loadActivatedIconButton.setVisible(false);
        this.loadIconButton.setVisible(true);
        this.licenseActivatedIconButton.setVisible(false);
        this.licenseIconButton.setVisible(true);
        this.publicationActivatedIconButton.setVisible(false);
        this.publicationIconButton.setVisible(true);
        this.institutionActivatedIconButton.setVisible(false);
        this.institutionIconButton.setVisible(true);
        this.institutionTempActivatedIconButton.setVisible(false);
        this.institutionTempIconButton.setVisible(true);
        this.institutionRestrictionActivatedIconButton.setVisible(false);
        this.institutionRestrictionIconButton.setVisible(true);
        this.publicActivatedIconButton.setVisible(false);
        this.publicIconButton.setVisible(true);
        this.publicTempActivatedIconButton.setVisible(false);
        this.publicTempIconButton.setVisible(true);
        this.publicRestrictionActivatedIconButton.setVisible(false);
        this.publicRestrictionIconButton.setVisible(true);
        this.migrationActivatedIconButton.setVisible(false);
        this.migrationIconButton.setVisible(true);
        this.saveActivatedIconButton.setVisible(false);
        this.saveIconButton.setVisible(true);
        this.createActivatedIconButton.setVisible(false);
        this.createIconButton.setVisible(true);
        this.startPanel.setVisible(false);
        this.loadStandardPanel.setVisible(false);
        this.institutionPanel.setVisible(false);
        this.institutionTempPanel.setVisible(false);
        this.institutionRestrictionPanel.setVisible(false);
        this.publicPanel.setVisible(false);
        this.publicLicensePanel.setVisible(false);
        this.publicTempPanel.setVisible(false);
        this.publicRestrictionPanel.setVisible(false);
        this.migrationPanel.setVisible(false);
        this.savePanel.setVisible(false);
        this.createPanel.setVisible(false);
        return true;
    }

    private void enterStartSection() {
        if (!this.startPanel.isVisible() && this.leaveSection()) {
            this.startPanel.setVisible(true);
            this.startActivatedIconButton.setVisible(true);
            this.startIconButton.setVisible(false);
        }
    }

    private void enterLoadSection() {
        if (!this.loadStandardPanel.isVisible() && this.leaveSection()) {
            this.loadStandardPanel.setVisible(true);
            this.loadActivatedIconButton.setVisible(true);
            this.loadIconButton.setVisible(false);
        }
    }

    private void enterPublicationInstitutionSection() {
        if (!this.institutionPanel.isVisible() && this.leaveSection()) {
            this.institutionPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.institutionActivatedIconButton.setVisible(true);
            this.institutionIconButton.setVisible(false);
        }
    }

    private boolean enterPublicationInstitutionTempSection() {
        if (this.institutionDenyRadioButton.isSelected()) {
            return false;
        }
        if (!this.institutionTempPanel.isVisible() && this.leaveSection()) {
            this.institutionTempPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.institutionActivatedIconButton.setVisible(true);
            this.institutionIconButton.setVisible(false);
            this.institutionTempActivatedIconButton.setVisible(true);
            this.institutionTempIconButton.setVisible(false);
        }
        return true;
    }

    private boolean enterPublicationInstitutionRestrictionsSection() {
        if (this.institutionDenyRadioButton.isSelected()) {
            return false;
        }
        if (!this.institutionRestrictionPanel.isVisible() && this.leaveSection()) {
            this.institutionRestrictionPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.institutionActivatedIconButton.setVisible(true);
            this.institutionIconButton.setVisible(false);
            this.institutionRestrictionActivatedIconButton.setVisible(true);
            this.institutionRestrictionIconButton.setVisible(false);
        }
        return true;
    }

    private void enterPublicationPublicSection() {
        if (!this.publicPanel.isVisible() && this.leaveSection()) {
            this.publicPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.publicActivatedIconButton.setVisible(true);
            this.publicIconButton.setVisible(false);
        }
    }

    private boolean enterPublicationPublicLicenseSection() {
        if (this.publicDenyRadioButton.isSelected()) {
            return false;
        }
        if (!this.publicLicensePanel.isVisible() && this.leaveSection()) {
            this.publicLicensePanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.publicActivatedIconButton.setVisible(true);
            this.publicIconButton.setVisible(false);
            this.licenseActivatedIconButton.setVisible(true);
            this.licenseIconButton.setVisible(false);
        }
        return true;
    }

    private boolean enterPublicationPublicTempSection() {
        if (this.publicDenyRadioButton.isSelected()) {
            return false;
        }
        if (!this.publicTempPanel.isVisible() && this.leaveSection()) {
            this.publicTempPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.publicActivatedIconButton.setVisible(true);
            this.publicIconButton.setVisible(false);
            this.publicTempActivatedIconButton.setVisible(true);
            this.publicTempIconButton.setVisible(false);
        }
        return true;
    }

    private boolean enterPublicationPublicRestrictionsSection() {
        if (this.publicDenyRadioButton.isSelected()) {
            return false;
        }
        if (!this.publicRestrictionPanel.isVisible() && this.leaveSection()) {
            this.publicRestrictionPanel.setVisible(true);
            this.publicationActivatedIconButton.setVisible(true);
            this.publicationIconButton.setVisible(false);
            this.publicActivatedIconButton.setVisible(true);
            this.publicIconButton.setVisible(false);
            this.publicRestrictionActivatedIconButton.setVisible(true);
            this.publicRestrictionIconButton.setVisible(false);
        }
        return true;
    }

    private void enterMigrationSection() {
        if (!this.migrationPanel.isVisible() && this.leaveSection()) {
            this.migrationPanel.setVisible(true);
            this.migrationActivatedIconButton.setVisible(true);
            this.migrationIconButton.setVisible(false);
        }
    }

    private void enterSaveSection() {
        if (!this.savePanel.isVisible() && this.leaveSection()) {
            this.updateContractRights();
            this.settingsOverviewTextArea.setText(this.createSettingsOverviewText());
            this.settingsOverviewTextArea.setCaretPosition(0);
            this.savePanel.setVisible(true);
            this.saveActivatedIconButton.setVisible(true);
            this.saveIconButton.setVisible(false);
        }
    }

    private void enterCreateSection() {
        if (!this.createPanel.isVisible() && this.leaveSection()) {
            this.updateContractRights();
            this.createPanel.setVisible(true);
            this.createActivatedIconButton.setVisible(true);
            this.createIconButton.setVisible(false);
        }
    }

    private boolean loadStandardRights() {
        File standardRightsFile = new File(this.confFolderPath + File.separator + "standardRights.xml");
        if (!standardRightsFile.exists()) {
            this.messageWriter.showMessage("Die Datei \"" + this.confFolderPath + File.separator + "standardRights.xml\", in der die Standardrechte\nhinterlegt sind, konnte nicht gefunden werden.", 0);
            return false;
        }
        try {
            this.sipFactory.getContractRights().loadContractRightsFromFile(standardRightsFile);
        }
        catch (Exception ex) {
            logger.error("Failed to load standard rights from file " + standardRightsFile.getAbsolutePath(), ex);
            this.messageWriter.showMessage("Beim Einlesen der Standardrechte ist ein Fehler aufgetreten.", 0);
            return false;
        }
        this.updateValues();
        return true;
    }

    private void updateContractRights() {
        ContractRights contractRights = this.sipFactory.getContractRights();
        PublicationRights institutionRights = contractRights.getInstitutionRights();
        PublicationRights publicRights = contractRights.getPublicRights();
        this.sipFactory.setKindofSIPBuilding((String)this.kindOfSIPBuildingDropDown.getSelectedItem());
        this.sipFactory.setSourcePath(this.sourcePathTextField.getText());
        this.sipFactory.setDestinationPath(this.destinationPathTextField.getText());
        String workDir = this.workingPathTextField.getText();
        if (workDir == null || workDir.isEmpty()) {
            workDir = this.destinationPathTextField.getText();
        }
        this.sipFactory.setWorkingPath(workDir);
        this.sipFactory.setCreateCollection(this.collectionCheckBox.isSelected());
        this.sipFactory.setCollectionName(this.collectionNameTextField.getText());
        institutionRights.setAllowPublication(this.institutionAllowRadioButton.isSelected());
        institutionRights.setTempPublication(this.institutionTempRadioButton.isSelected());
        institutionRights.setLawPublication(this.institutionLawRadioButton.isSelected());
        institutionRights.setStartDate(this.institutionTempStartDateTextField.getText());
        institutionRights.setLaw(Utilities.translateLaw((String)this.institutionLawIdDropDown.getSelectedItem()));
        institutionRights.setTextRestriction(this.institutionTextRestrictionCheckBox.isSelected());
        institutionRights.setImageRestriction(this.institutionImageRestrictionCheckBox.isSelected());
        institutionRights.setAudioRestriction(this.institutionAudioRestrictionCheckBox.isSelected());
        institutionRights.setVideoRestriction(this.institutionVideoRestrictionCheckBox.isSelected());
        institutionRights.setVideoDurationRestriction(this.institutionVideoDurationCheckBox.isSelected());
        institutionRights.setImageWidth(this.contractSettings.getWidthImage(this.institutionImageDropDown.getSelectedIndex()));
        institutionRights.setImageHeight(this.contractSettings.getHeightImage(this.institutionImageDropDown.getSelectedIndex()));
        institutionRights.setImageRestrictionText(this.institutionImageTextCheckBox.isSelected());
        institutionRights.setFooterText(this.institutionRestrictionImageTextField.getText());
        institutionRights.setImageTextType(Utilities.translateTextType((String)this.institutionImageTextDropDown.getSelectedItem()));
        institutionRights.setWatermarkSize(this.contractSettings.getTextSizeImage(this.institutionImageTextSizeDropDown.getSelectedIndex()));
        institutionRights.setWatermarkOpacity(this.contractSettings.getOpacityImage(this.institutionImageTextOpacityDropDown.getSelectedIndex()));
        institutionRights.setAudioDuration(this.contractSettings.getDuration(this.institutionAudioDurationDropDown.getSelectedIndex()));
        institutionRights.setVideoSize(this.contractSettings.getHeightVideo(this.institutionVideoQualityDropDown.getSelectedIndex()));
        institutionRights.setVideoDuration(this.contractSettings.getDuration(this.institutionVideoDurationDropDown.getSelectedIndex()));
        publicRights.setAllowPublication(this.publicAllowRadioButton.isSelected());
        publicRights.setTempPublication(this.publicTempRadioButton.isSelected());
        publicRights.setLawPublication(this.publicLawRadioButton.isSelected());
        publicRights.setStartDate(this.publicTempStartDateTextField.getText());
        publicRights.setLaw(Utilities.translateLaw((String)this.publicLawIdDropDown.getSelectedItem()));
        publicRights.setTextRestriction(this.publicTextRestrictionCheckBox.isSelected());
        publicRights.setImageRestriction(this.publicImageRestrictionCheckBox.isSelected());
        publicRights.setAudioRestriction(this.publicAudioRestrictionCheckBox.isSelected());
        publicRights.setVideoRestriction(this.publicVideoRestrictionCheckBox.isSelected());
        publicRights.setVideoDurationRestriction(this.publicVideoDurationCheckBox.isSelected());
        publicRights.setImageWidth(this.contractSettings.getWidthImage(this.publicImageDropDown.getSelectedIndex()));
        publicRights.setImageHeight(this.contractSettings.getHeightImage(this.publicImageDropDown.getSelectedIndex()));
        publicRights.setImageRestrictionText(this.publicImageTextCheckBox.isSelected());
        publicRights.setFooterText(this.publicRestrictionImageTextField.getText());
        publicRights.setImageTextType(Utilities.translateTextType((String)this.publicImageTextDropDown.getSelectedItem()));
        publicRights.setWatermarkSize(this.contractSettings.getTextSizeImage(this.publicImageTextSizeDropDown.getSelectedIndex()));
        publicRights.setWatermarkOpacity(this.contractSettings.getOpacityImage(this.publicImageTextOpacityDropDown.getSelectedIndex()));
        publicRights.setAudioDuration(this.contractSettings.getDuration(this.publicAudioDurationDropDown.getSelectedIndex()));
        publicRights.setVideoSize(this.contractSettings.getHeightVideo(this.publicVideoQualityDropDown.getSelectedIndex()));
        publicRights.setVideoDuration(this.contractSettings.getDuration(this.publicVideoDurationDropDown.getSelectedIndex()));
        contractRights.setConversionCondition((String)this.migrationDropDown.getSelectedItem());
        contractRights.setDdbExclusion(!this.publicDDBCheckBox.isSelected());
        if (this.premisLicenseRadioButton.isSelected()) {
            contractRights.setCclincense((ContractRights.CCLicense)((Object)this.licenseDropDown.getSelectedItem()));
        } else if (this.metadataLicenseRadioButton.isSelected()) {
            contractRights.setCclincense(null);
        }
    }

    private void updateValues() {
        int heightImageIndex;
        ContractRights contractRights = this.sipFactory.getContractRights();
        PublicationRights institutionRights = contractRights.getInstitutionRights();
        PublicationRights publicRights = contractRights.getPublicRights();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        int widthImageIndex = this.contractSettings.getWidthImageIndex(institutionRights.getImageWidth());
        if (widthImageIndex == (heightImageIndex = this.contractSettings.getHeightImageIndex(institutionRights.getImageHeight())) && widthImageIndex >= 0) {
            this.institutionImageDropDown.setSelectedIndex(widthImageIndex);
        } else {
            this.institutionImageDropDown.setSelectedIndex(0);
        }
        this.institutionRestrictionImageTextField.setText(institutionRights.getFooterText());
        this.institutionImageTextDropDown.setSelectedItem(Utilities.translateTextType(institutionRights.getImageTextType()));
        int imageTextOpacityIndex = this.contractSettings.getOpacityImageIndex(institutionRights.getWatermarkOpacity());
        if (imageTextOpacityIndex >= 0) {
            this.institutionImageTextOpacityDropDown.setSelectedIndex(imageTextOpacityIndex);
        } else {
            this.institutionImageTextOpacityDropDown.setSelectedIndex(0);
        }
        int imageTextSizeIndex = this.contractSettings.getTextSizeImageIndex(institutionRights.getWatermarkSize());
        if (imageTextSizeIndex >= 0) {
            this.institutionImageTextSizeDropDown.setSelectedIndex(imageTextSizeIndex);
        } else {
            this.institutionImageTextSizeDropDown.setSelectedIndex(0);
        }
        int audioDurationIndex = this.contractSettings.getDurationIndex(institutionRights.getAudioDuration());
        if (audioDurationIndex >= 0) {
            this.institutionAudioDurationDropDown.setSelectedIndex(audioDurationIndex);
        } else {
            this.institutionAudioDurationDropDown.setSelectedIndex(0);
        }
        int videoSizeIndex = this.contractSettings.getHeightVideoIndex(institutionRights.getVideoSize());
        if (videoSizeIndex >= 0) {
            this.institutionVideoQualityDropDown.setSelectedIndex(videoSizeIndex);
        } else {
            this.institutionVideoQualityDropDown.setSelectedIndex(0);
        }
        int videoDurationIndex = this.contractSettings.getDurationIndex(institutionRights.getVideoDuration());
        if (videoDurationIndex >= 0) {
            this.institutionVideoDurationDropDown.setSelectedIndex(videoDurationIndex);
        } else {
            this.institutionVideoDurationDropDown.setSelectedIndex(0);
        }
        if (institutionRights.getTempPublication()) {
            this.institutionTempStartDateLabel.setEnabled(true);
            this.institutionTempStartDateTextField.setEditable(true);
            this.institutionTempStartDateTextField.setEnabled(true);
        } else {
            this.institutionTempStartDateLabel.setEnabled(false);
            this.institutionTempStartDateTextField.setEditable(false);
            this.institutionTempStartDateTextField.setEnabled(false);
        }
        if (institutionRights.getLawPublication()) {
            this.institutionLawIdDropDown.setEnabled(true);
        } else {
            this.institutionLawIdDropDown.setEnabled(false);
        }
        if (institutionRights.getTextRestriction()) {
            this.institutionRestrictionTextPagesTextField.setEnabled(true);
            this.institutionRestrictionTextPagesTextField.setEditable(true);
            this.institutionRestrictionTextPagesLabel.setEnabled(true);
            this.institutionRestrictionTextArea.setEnabled(true);
        } else {
            this.institutionRestrictionTextPagesTextField.setEnabled(false);
            this.institutionRestrictionTextPagesTextField.setEditable(false);
            this.institutionRestrictionTextPagesLabel.setEnabled(false);
            this.institutionRestrictionTextArea.setEnabled(false);
        }
        this.institutionImageDropDown.setEnabled(false);
        this.institutionRestrictionImageArea.setEnabled(false);
        this.institutionRestrictionImageTextField.setEnabled(false);
        this.institutionRestrictionImageTextField.setEditable(false);
        this.institutionRestrictionImageLabel.setEnabled(false);
        this.institutionImageTextDropDown.setEnabled(false);
        this.institutionImageTextOpacityDropDown.setEnabled(false);
        this.institutionImageTextSizeDropDown.setEnabled(false);
        this.institutionRestrictionImageTextTypeLabel.setEnabled(false);
        this.institutionRestrictionImageTextOpacityLabel.setEnabled(false);
        this.institutionRestrictionImageTextSizeLabel.setEnabled(false);
        if (institutionRights.getImageRestriction()) {
            this.institutionImageDropDown.setEnabled(true);
            this.institutionRestrictionImageArea.setEnabled(true);
        }
        if (institutionRights.getImageRestrictionText()) {
            this.institutionRestrictionImageTextField.setEnabled(true);
            this.institutionRestrictionImageTextField.setEditable(true);
            this.institutionRestrictionImageLabel.setEnabled(true);
            this.institutionImageTextDropDown.setEnabled(true);
            this.institutionRestrictionImageTextTypeLabel.setEnabled(true);
            if (institutionRights.getImageTextType() != PublicationRights.TextType.footer) {
                this.institutionRestrictionImageTextOpacityLabel.setEnabled(true);
                this.institutionImageTextOpacityDropDown.setEnabled(true);
                this.institutionRestrictionImageTextSizeLabel.setEnabled(true);
                this.institutionImageTextSizeDropDown.setEnabled(true);
            }
        }
        if (institutionRights.getAudioRestriction()) {
            this.institutionAudioDurationDropDown.setEnabled(true);
            this.institutionRestrictionAudioDurationLabel.setEnabled(true);
        } else {
            this.institutionAudioDurationDropDown.setEnabled(false);
            this.institutionRestrictionAudioDurationLabel.setEnabled(false);
        }
        if (institutionRights.getVideoRestriction()) {
            this.institutionVideoQualityDropDown.setEnabled(true);
            this.institutionRestrictionVideoQualityLabel.setEnabled(true);
        } else {
            this.institutionVideoQualityDropDown.setEnabled(false);
            this.institutionRestrictionVideoQualityLabel.setEnabled(false);
        }
        if (institutionRights.getVideoDurationRestriction()) {
            this.institutionVideoDurationDropDown.setEnabled(true);
            this.institutionRestrictionVideoDurationLabel.setEnabled(true);
        } else {
            this.institutionVideoDurationDropDown.setEnabled(false);
            this.institutionRestrictionVideoDurationLabel.setEnabled(false);
        }
        this.institutionAllowRadioButton.setSelected(institutionRights.getAllowPublication());
        this.institutionDenyRadioButton.setSelected(!institutionRights.getAllowPublication());
        this.institutionNoTempRestrictionRadioButton.setSelected(true);
        this.institutionTempRadioButton.setSelected(institutionRights.getTempPublication());
        this.institutionLawRadioButton.setSelected(institutionRights.getLawPublication());
        if (institutionRights.getStartDate() != null) {
            this.institutionTempStartDateTextField.setText(dateFormat.format(institutionRights.getStartDate()));
        } else {
            this.institutionTempStartDateTextField.setText("");
        }
        this.institutionLawIdDropDown.setSelectedItem(Utilities.translateLaw(institutionRights.getLaw()));
        this.institutionTextRestrictionCheckBox.setSelected(institutionRights.getTextRestriction());
        this.institutionImageRestrictionCheckBox.setSelected(institutionRights.getImageRestriction());
        this.institutionImageTextCheckBox.setSelected(institutionRights.getImageRestrictionText());
        this.institutionAudioRestrictionCheckBox.setSelected(institutionRights.getAudioRestriction());
        this.institutionVideoRestrictionCheckBox.setSelected(institutionRights.getVideoRestriction());
        this.institutionVideoDurationCheckBox.setSelected(institutionRights.getVideoDurationRestriction());
        this.institutionRestrictionTextPagesTextField.setText(institutionRights.getPages());
        this.publicImageTextDropDown.setSelectedItem(Utilities.translateTextType(publicRights.getImageTextType()));
        imageTextOpacityIndex = this.contractSettings.getOpacityImageIndex(publicRights.getWatermarkOpacity());
        if (imageTextOpacityIndex >= 0) {
            this.publicImageTextOpacityDropDown.setSelectedIndex(imageTextOpacityIndex);
        } else {
            this.publicImageTextOpacityDropDown.setSelectedIndex(0);
        }
        imageTextSizeIndex = this.contractSettings.getTextSizeImageIndex(publicRights.getWatermarkSize());
        if (imageTextSizeIndex >= 0) {
            this.publicImageTextSizeDropDown.setSelectedIndex(imageTextSizeIndex);
        } else {
            this.publicImageTextSizeDropDown.setSelectedIndex(0);
        }
        audioDurationIndex = this.contractSettings.getDurationIndex(publicRights.getAudioDuration());
        if (audioDurationIndex >= 0) {
            this.publicAudioDurationDropDown.setSelectedIndex(audioDurationIndex);
        } else {
            this.publicAudioDurationDropDown.setSelectedIndex(0);
        }
        videoSizeIndex = this.contractSettings.getHeightVideoIndex(publicRights.getVideoSize());
        if (videoSizeIndex >= 0) {
            this.publicVideoQualityDropDown.setSelectedIndex(videoSizeIndex);
        } else {
            this.publicVideoQualityDropDown.setSelectedIndex(0);
        }
        videoDurationIndex = this.contractSettings.getDurationIndex(publicRights.getVideoDuration());
        if (videoDurationIndex >= 0) {
            this.publicVideoDurationDropDown.setSelectedIndex(videoDurationIndex);
        } else {
            this.publicVideoDurationDropDown.setSelectedIndex(0);
        }
        if (publicRights.getTempPublication()) {
            this.publicTempStartDateLabel.setEnabled(true);
            this.publicTempStartDateTextField.setEditable(true);
            this.publicTempStartDateTextField.setEnabled(true);
        } else {
            this.publicTempStartDateLabel.setEnabled(false);
            this.publicTempStartDateTextField.setEditable(false);
            this.publicTempStartDateTextField.setEnabled(false);
        }
        if (publicRights.getLawPublication()) {
            this.publicLawIdDropDown.setEnabled(true);
        } else {
            this.publicLawIdDropDown.setEnabled(false);
        }
        if (publicRights.getTextRestriction()) {
            this.publicRestrictionTextPagesTextField.setEnabled(true);
            this.publicRestrictionTextPagesTextField.setEditable(true);
            this.publicRestrictionTextPagesLabel.setEnabled(true);
            this.publicRestrictionTextArea.setEnabled(true);
        } else {
            this.publicRestrictionTextPagesTextField.setEnabled(false);
            this.publicRestrictionTextPagesTextField.setEditable(false);
            this.publicRestrictionTextPagesLabel.setEnabled(false);
            this.publicRestrictionTextArea.setEnabled(false);
        }
        this.publicImageDropDown.setEnabled(false);
        this.publicRestrictionImageArea.setEnabled(false);
        this.publicRestrictionImageTextField.setEnabled(false);
        this.publicRestrictionImageTextField.setEditable(false);
        this.publicRestrictionImageLabel.setEnabled(false);
        this.publicImageTextDropDown.setEnabled(false);
        this.publicImageTextOpacityDropDown.setEnabled(false);
        this.publicImageTextSizeDropDown.setEnabled(false);
        this.publicRestrictionImageTextTypeLabel.setEnabled(false);
        this.publicRestrictionImageTextOpacityLabel.setEnabled(false);
        this.publicRestrictionImageTextSizeLabel.setEnabled(false);
        if (publicRights.getImageRestriction()) {
            this.publicImageDropDown.setEnabled(true);
            this.publicRestrictionImageArea.setEnabled(true);
        }
        if (publicRights.getImageRestrictionText()) {
            this.publicRestrictionImageTextField.setEnabled(true);
            this.publicRestrictionImageTextField.setEditable(true);
            this.publicRestrictionImageLabel.setEnabled(true);
            this.publicImageTextDropDown.setEnabled(true);
            this.publicRestrictionImageTextTypeLabel.setEnabled(true);
            if (publicRights.getImageTextType() != PublicationRights.TextType.footer) {
                this.publicRestrictionImageTextOpacityLabel.setEnabled(true);
                this.publicImageTextOpacityDropDown.setEnabled(true);
                this.publicRestrictionImageTextSizeLabel.setEnabled(true);
                this.publicImageTextSizeDropDown.setEnabled(true);
            }
        }
        if (publicRights.getAudioRestriction()) {
            this.publicAudioDurationDropDown.setEnabled(true);
            this.publicRestrictionAudioDurationLabel.setEnabled(true);
        } else {
            this.publicAudioDurationDropDown.setEnabled(false);
            this.publicRestrictionAudioDurationLabel.setEnabled(false);
        }
        if (publicRights.getVideoRestriction()) {
            this.publicVideoQualityDropDown.setEnabled(true);
            this.publicRestrictionVideoQualityLabel.setEnabled(true);
        } else {
            this.publicVideoQualityDropDown.setEnabled(false);
            this.publicRestrictionVideoQualityLabel.setEnabled(false);
        }
        if (publicRights.getVideoDurationRestriction()) {
            this.publicVideoDurationDropDown.setEnabled(true);
            this.publicRestrictionVideoDurationLabel.setEnabled(true);
        } else {
            this.publicVideoDurationDropDown.setEnabled(false);
            this.publicRestrictionVideoDurationLabel.setEnabled(false);
        }
        this.publicAllowRadioButton.setSelected(publicRights.getAllowPublication());
        this.publicDenyRadioButton.setSelected(!publicRights.getAllowPublication());
        if (publicRights.getAllowPublication()) {
            this.publicDDBArea.setEnabled(true);
            this.publicDDBCheckBox.setEnabled(true);
        } else {
            this.publicDDBArea.setEnabled(false);
            this.publicDDBCheckBox.setEnabled(false);
        }
        this.publicNoTempRestrictionRadioButton.setSelected(true);
        this.publicTempRadioButton.setSelected(publicRights.getTempPublication());
        this.publicLawRadioButton.setSelected(publicRights.getLawPublication());
        if (publicRights.getStartDate() != null) {
            this.publicTempStartDateTextField.setText(dateFormat.format(publicRights.getStartDate()));
        } else {
            this.publicTempStartDateTextField.setText("");
        }
        this.publicLawIdDropDown.setSelectedItem(Utilities.translateLaw(publicRights.getLaw()));
        this.publicTextRestrictionCheckBox.setSelected(publicRights.getTextRestriction());
        this.publicImageRestrictionCheckBox.setSelected(publicRights.getImageRestriction());
        this.publicImageTextCheckBox.setSelected(publicRights.getImageRestrictionText());
        this.publicAudioRestrictionCheckBox.setSelected(publicRights.getAudioRestriction());
        this.publicVideoRestrictionCheckBox.setSelected(publicRights.getVideoRestriction());
        this.publicVideoDurationCheckBox.setSelected(publicRights.getVideoDurationRestriction());
        this.publicRestrictionTextPagesTextField.setText(publicRights.getPages());
        widthImageIndex = this.contractSettings.getWidthImageIndex(publicRights.getImageWidth());
        heightImageIndex = this.contractSettings.getHeightImageIndex(publicRights.getImageHeight());
        if (widthImageIndex == heightImageIndex && widthImageIndex >= 0) {
            this.publicImageDropDown.setSelectedIndex(widthImageIndex);
        } else {
            this.publicImageDropDown.setSelectedIndex(0);
        }
        this.publicRestrictionImageTextField.setText(publicRights.getFooterText());
        this.migrationDropDown.setSelectedItem(Utilities.translateConversionCondition(contractRights.getConversionCondition()));
        this.publicDDBCheckBox.setSelected(!contractRights.getDdbExclusion());
        if (contractRights.getCclincense() != null) {
            this.licenseDropDown.setEditable(true);
            this.licenseDropDown.setEnabled(true);
            this.licenseTextField.setVisible(true);
            this.licenseDropDown.setSelectedItem((Object)contractRights.getCclincense());
            this.premisLicenseRadioButton.setSelected(true);
        } else {
            this.licenseDropDown.setEditable(false);
            this.licenseDropDown.setEnabled(false);
            this.licenseTextField.setVisible(false);
            this.licenseDropDown.setSelectedItem(0);
            this.metadataLicenseRadioButton.setSelected(true);
        }
    }

    private String createSettingsOverviewText() {
        ContractRights contractRights = this.sipFactory.getContractRights();
        PublicationRights institutionRights = contractRights.getInstitutionRights();
        PublicationRights publicRights = contractRights.getPublicRights();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String settingsOverview = "Publikation f\u00fcr die \u00d6ffentlichkeit: ";
        if (publicRights.getAllowPublication()) {
            settingsOverview = settingsOverview + "Ja\n";
            settingsOverview = settingsOverview + "     DDB-Harvesting: ";
            settingsOverview = contractRights.getDdbExclusion() ? settingsOverview + "Nein\n" : settingsOverview + "Ja\n";
            if (publicRights.getTempPublication()) {
                settingsOverview = settingsOverview + "     Startdatum: " + dateFormat.format(publicRights.getStartDate()) + "\n";
            } else if (publicRights.getLawPublication()) {
                settingsOverview = settingsOverview + "     Sperrgesetz: " + Utilities.translateLaw(publicRights.getLaw()) + "\n";
            }
            if (publicRights.getTextRestriction()) {
                settingsOverview = settingsOverview + "     Angezeigte Textseiten: " + publicRights.getPages() + "\n";
            }
            if (publicRights.getImageRestriction()) {
                settingsOverview = settingsOverview + "     Bildqualit\u00e4t: " + (String)this.publicImageDropDown.getSelectedItem() + "\n";
            }
            if (publicRights.getImageRestrictionText()) {
                if (publicRights.getImageTextType() == PublicationRights.TextType.footer) {
                    settingsOverview = settingsOverview + "     Fu\u00dfzeile: \"" + publicRights.getFooterText() + "\"\n";
                } else {
                    settingsOverview = settingsOverview + "     Wasserzeichen: \"" + publicRights.getFooterText() + "\"\n";
                    settingsOverview = settingsOverview + "          Position: " + Utilities.translateTextTypePosition(publicRights.getImageTextType()) + "\n";
                    settingsOverview = settingsOverview + "          Sichtbarkeit: " + publicRights.getWatermarkOpacity() + "%\n";
                    settingsOverview = settingsOverview + "          Schriftgr\u00f6\u00dfe: " + publicRights.getWatermarkSize() + "\n";
                }
            }
            if (publicRights.getAudioRestriction()) {
                settingsOverview = settingsOverview + "     Maximale Abspieldauer von Audiodateien: " + publicRights.getAudioDuration() + " Sekunden\n";
            }
            if (publicRights.getVideoRestriction()) {
                settingsOverview = settingsOverview + "     Bildqualit\u00e4t von Videodateien: " + (String)this.publicVideoQualityDropDown.getSelectedItem() + "\n";
            }
            if (publicRights.getVideoDurationRestriction()) {
                settingsOverview = settingsOverview + "     Maximale Abspieldauer von Videodateien: " + publicRights.getVideoDuration() + " Sekunden\n";
            }
        } else {
            settingsOverview = settingsOverview + "Nein\n";
        }
        settingsOverview = settingsOverview + "\n";
        settingsOverview = settingsOverview + "Publikation f\u00fcr die eigene Institution: ";
        if (institutionRights.getAllowPublication()) {
            settingsOverview = settingsOverview + "Ja\n";
            if (institutionRights.getTempPublication()) {
                settingsOverview = settingsOverview + "     Startdatum: " + dateFormat.format(institutionRights.getStartDate()) + "\n";
            } else if (institutionRights.getLawPublication()) {
                settingsOverview = settingsOverview + "     Sperrgesetz: " + Utilities.translateLaw(institutionRights.getLaw()) + "\n";
            }
            if (institutionRights.getTextRestriction()) {
                settingsOverview = settingsOverview + "     Angezeigte Textseiten: " + institutionRights.getPages() + "\n";
            }
            if (institutionRights.getImageRestriction()) {
                settingsOverview = settingsOverview + "     Bildqualit\u00e4t: " + (String)this.institutionImageDropDown.getSelectedItem() + "\n";
            }
            if (institutionRights.getImageRestrictionText()) {
                if (institutionRights.getImageTextType() == PublicationRights.TextType.footer) {
                    settingsOverview = settingsOverview + "     Fu\u00dfzeile: \"" + institutionRights.getFooterText() + "\"\n";
                } else {
                    settingsOverview = settingsOverview + "     Wasserzeichen: \"" + institutionRights.getFooterText() + "\"\n";
                    settingsOverview = settingsOverview + "          Position: " + Utilities.translateTextTypePosition(institutionRights.getImageTextType()) + "\n";
                    settingsOverview = settingsOverview + "          Sichtbarkeit: " + institutionRights.getWatermarkOpacity() + "%\n";
                    settingsOverview = settingsOverview + "          Schriftgr\u00f6\u00dfe: " + institutionRights.getWatermarkSize() + "\n";
                }
            }
            if (institutionRights.getAudioRestriction()) {
                settingsOverview = settingsOverview + "     Maximale Abspieldauer von Audiodateien: " + institutionRights.getAudioDuration() + " Sekunden\n";
            }
            if (institutionRights.getVideoRestriction()) {
                settingsOverview = settingsOverview + "     Bildqualit\u00e4t von Videodateien: " + (String)this.institutionVideoQualityDropDown.getSelectedItem() + "\n";
            }
            if (institutionRights.getVideoDurationRestriction()) {
                settingsOverview = settingsOverview + "     Maximale Abspieldauer von Videodateien: " + institutionRights.getVideoDuration() + " Sekunden\n";
            }
        } else {
            settingsOverview = settingsOverview + "Nein\n";
        }
        settingsOverview = settingsOverview + "\nMigrationsbedingung: " + (String)this.migrationDropDown.getSelectedItem();
        if (publicRights.getAllowPublication()) {
            if (this.premisLicenseRadioButton.isSelected()) {
                settingsOverview = settingsOverview + "\nLizenzangaben: Im SIP-Builder festgelegt : " + this.licenseDropDown.getSelectedItem().toString();
            } else if (this.metadataLicenseRadioButton.isSelected()) {
                settingsOverview = settingsOverview + "\nLizenzangaben: Aus den Metadaten \u00fcbernehmen ";
            }
        }
        return settingsOverview;
    }

    private String searchFolder(JFileChooser fileChooser) {
        File selectedFile = null;
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                return selectedFile.getPath() + File.separator;
            }
            return null;
        }
        return null;
    }

    private String searchXmlFile() {
        File selectedFile = null;
        this.contractFileLoadPathChooser.setFileSelectionMode(0);
        this.contractFileLoadPathChooser.setAcceptAllFileFilterUsed(false);
        this.contractFileLoadPathChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML-Datei (*.xml)";
            }
        });
        if (this.contractFileLoadPathChooser.showOpenDialog(this) == 0) {
            selectedFile = this.contractFileLoadPathChooser.getSelectedFile();
            if (selectedFile != null) {
                return selectedFile.getPath();
            }
            return null;
        }
        return null;
    }

    private String saveFile(String defaultFileName) {
        File selectedFile = null;
        this.contractFileSavePathChooser.setFileSelectionMode(0);
        this.contractFileSavePathChooser.setAcceptAllFileFilterUsed(false);
        if (this.contractFileSavePathChooser.getSelectedFile() == null) {
            this.contractFileSavePathChooser.setSelectedFile(new File(defaultFileName));
        }
        this.contractFileSavePathChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML-Datei (*.xml)";
            }
        });
        if (this.contractFileSavePathChooser.showSaveDialog(this) == 0) {
            selectedFile = this.contractFileSavePathChooser.getSelectedFile();
            String filePath = selectedFile.getPath();
            if (!filePath.endsWith(".xml")) {
                filePath = filePath + ".xml";
            }
            return filePath;
        }
        return null;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }
}

