/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.gui;

import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.sb.SIPCreationJob;
import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

class GuiProgressManager
extends ProgressManager {
    private JProgressBar progressBar;
    private JLabel progressDisplay;
    private JLabel stepDisplay;

    public GuiProgressManager(JProgressBar progressBar, JLabel progressDisplay, JLabel stepDisplay) {
        this.progressBar = progressBar;
        this.progressDisplay = progressDisplay;
        this.stepDisplay = stepDisplay;
    }

    @Override
    public void reset() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setEnabled(true);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.progressBar.setValue(0);
                GuiProgressManager.this.stepDisplay.setText("");
            }
        });
        super.reset();
    }

    @Override
    public void abort() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setEnabled(false);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                if (GuiProgressManager.this.progressBar.getValue() == 100) {
                    GuiProgressManager.this.progressBar.setValue(GuiProgressManager.this.progressBar.getValue() - 1);
                    GuiProgressManager.this.progressBar.setValue(GuiProgressManager.this.progressBar.getValue() + 1);
                } else {
                    GuiProgressManager.this.progressBar.setValue(GuiProgressManager.this.progressBar.getValue() + 1);
                    GuiProgressManager.this.progressBar.setValue(GuiProgressManager.this.progressBar.getValue() - 1);
                }
                GuiProgressManager.this.progressDisplay.setText("SIP-Erstellungsvorgang abgebrochen");
                GuiProgressManager.this.stepDisplay.setText("");
            }
        });
    }

    @Override
    public void createStartMessage() {
    }

    @Override
    public void startJob(int id) {
        SIPCreationJob job = (SIPCreationJob)this.jobMap.get(id);
        job.initialTotalProgress = this.totalProgress;
        final int jobId = id;
        final String packageName = job.packageName;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jobId == -1) {
                    GuiProgressManager.this.progressDisplay.setText("Erstelle Lieferung \"" + packageName + "\"");
                } else {
                    GuiProgressManager.this.progressDisplay.setText("Erstelle SIP aus Ordner \"" + packageName + "\"");
                }
            }
        });
    }

    @Override
    public void copyProgress(int id, long processedData) {
        super.copyProgress(id, processedData);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.stepDisplay.setText("Kopiere Daten...");
            }
        });
    }

    @Override
    public void premisProgress(int id, double progress) {
        super.premisProgress(id, progress);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.stepDisplay.setText("Erzeuge Premis-Datei...");
            }
        });
    }

    @Override
    public void bagitProgress(int id, double progress) {
        super.bagitProgress(id, progress);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(true);
                GuiProgressManager.this.stepDisplay.setText("Erstelle Bagit...");
            }
        });
    }

    @Override
    public void archiveProgress(int id, long archivedData) {
        super.archiveProgress(id, archivedData);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.stepDisplay.setText("Erstelle Archivdatei...");
            }
        });
    }

    @Override
    public void deleteTempProgress(int id, double progress) {
        super.deleteTempProgress(id, progress);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.stepDisplay.setText("L\u00f6sche tempor\u00e4re Daten...");
            }
        });
    }

    @Override
    public void skipJob(int id) {
        super.skipJob(id);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
            }
        });
    }

    @Override
    public void createSuccessMessage(boolean skippedFiles) {
        super.createSuccessMessage(skippedFiles);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiProgressManager.this.progressBar.setValue((int)GuiProgressManager.this.totalProgress);
                GuiProgressManager.this.progressBar.setIndeterminate(false);
                GuiProgressManager.this.stepDisplay.setText("");
                GuiProgressManager.this.progressDisplay.setText("Die SIP-Erstellung wurde erfolgreich abgeschlossen.");
            }
        });
    }
}

