/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.main;

import de.uzk.hki.da.cli.Cli;
import de.uzk.hki.da.gui.Gui;
import de.uzk.hki.da.sb.Feedback;
import java.awt.Color;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;

public class SIPBuilder {
    private static Logger logger = Logger.getRootLogger();
    private static Properties properties;

    public static void main(String[] args) {
        String dataFolderPath;
        String confFolderPath;
        TTCCLayout layout = new TTCCLayout();
        layout.setDateFormat("yyyy'-'MM'-'dd' 'HH':'mm':'ss");
        layout.setThreadPrinting(false);
        ConsoleAppender consoleAppender = new ConsoleAppender(layout);
        logger.addAppender(consoleAppender);
        logger.setLevel(Level.DEBUG);
        properties = new Properties();
        try {
            properties.load(new InputStreamReader(ClassLoader.getSystemResourceAsStream("configuration/config.properties")));
        }
        catch (FileNotFoundException e1) {
            System.exit(Feedback.GUI_ERROR.toInt());
        }
        catch (IOException e2) {
            System.exit(Feedback.GUI_ERROR.toInt());
        }
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, "CP850"));
            } else {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        String mainFolderPath = SIPBuilder.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            mainFolderPath = URLDecoder.decode(mainFolderPath, "UTF-8");
            confFolderPath = new File(mainFolderPath).getParent() + File.separator + "conf";
            dataFolderPath = new File(mainFolderPath).getParent() + File.separator + "data";
        }
        catch (UnsupportedEncodingException e) {
            confFolderPath = "conf";
            dataFolderPath = "data";
        }
        System.out.println("ConfFolderPath:" + confFolderPath);
        if (args.length == 0) {
            SIPBuilder.startGUIMode(confFolderPath, dataFolderPath);
        } else {
            SIPBuilder.startCLIMode(confFolderPath, dataFolderPath, args);
        }
    }

    private static void startGUIMode(String confFolderPath, String dataFolderPath) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            return;
        }
        UIManager.put("Label.disabledForeground", Color.LIGHT_GRAY);
        UIManager.put("ComboBox.disabledForeground", Color.LIGHT_GRAY);
        UIManager.put("CheckBox.disabledText", Color.LIGHT_GRAY);
        Gui gui = new Gui(confFolderPath, dataFolderPath);
        gui.setBounds(100, 100, 750, 520);
        gui.setResizable(false);
        gui.setVisible(true);
        gui.setDefaultCloseOperation(3);
        gui.setTitle(SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder");
    }

    private static void startCLIMode(String confFolderPath, String dataFolderPath, String[] args) {
        Cli cli = new Cli(confFolderPath, dataFolderPath, args);
        int exitCode = 0;
        exitCode = cli.start();
        if (exitCode < 0) {
            exitCode = 0;
        }
        System.exit(exitCode);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setProperties(Properties properties) {
        SIPBuilder.properties = properties;
    }
}

