/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import de.uzk.hki.da.metadata.PublicationRights;
import de.uzk.hki.da.utils.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.SAXParserFactory;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ContractRights {
    private Logger logger = Logger.getLogger(ContractRights.class);
    private PublicationRights institutionRights = new PublicationRights();
    private PublicationRights publicRights = new PublicationRights();
    private ConversionCondition conversionCondition;
    boolean ddbExclusion;
    private CCLicense cclincense;

    public void loadContractRightsFromFile(File contractRightsFile) throws Exception {
        this.institutionRights = new PublicationRights();
        this.publicRights = new PublicationRights();
        XMLReader xmlReader = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            xmlReader = spf.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new IOException("Error creating SAX parser", e);
        }
        xmlReader.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw new SAXException("Error while parsing contract rights file", e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw new SAXException("Fatal error while parsing contract rights file", e);
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                ContractRights.this.logger.warn("Warning while parsing contract rights file:\n" + e.getMessage());
            }
        });
        FileInputStream inputStream = new FileInputStream(contractRightsFile);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        Builder parser = new Builder(xmlReader);
        Document doc = parser.build(reader);
        ((Reader)reader).close();
        Element root = doc.getRootElement();
        Element institutionRightsEl = root.getFirstChildElement("institutionRights");
        this.readPublicationRights(this.institutionRights, institutionRightsEl);
        Element publicRightsEl = root.getFirstChildElement("publicRights");
        this.readPublicationRights(this.publicRights, publicRightsEl);
        Element conversionRightsEl = root.getFirstChildElement("conversionRights");
        this.conversionCondition = ConversionCondition.valueOf(conversionRightsEl.getFirstChildElement("condition").getValue());
        Element ddbExclusionEl = root.getFirstChildElement("ddbExclusion");
        this.ddbExclusion = ddbExclusionEl != null ? Boolean.parseBoolean(ddbExclusionEl.getValue()) : false;
        Element publicationLicenseEl = root.getFirstChildElement("publicationLicense");
        if (publicationLicenseEl != null) {
            String hrefAttribute = publicationLicenseEl.getAttribute("href").getValue();
            for (CCLicense cl : CCLicense.values()) {
                if (!cl.getHref().equals(hrefAttribute)) continue;
                this.cclincense = cl;
                break;
            }
            if (this.cclincense == null) {
                throw new RuntimeException("Reading ContractRights from file failed, unknown license href: " + hrefAttribute);
            }
        } else {
            this.cclincense = null;
        }
    }

    private void readPublicationRights(PublicationRights pubRights, Element pubRightEl) throws Exception {
        Element restrictionsEl;
        Element restrictionLawEl;
        pubRights.setAllowPublication(Boolean.parseBoolean(pubRightEl.getFirstChildElement("allowed").getValue()));
        pubRights.setTempPublication(Boolean.parseBoolean(pubRightEl.getFirstChildElement("tempPublication").getValue()));
        pubRights.setLawPublication(Boolean.parseBoolean(pubRightEl.getFirstChildElement("lawPublication").getValue()));
        Element startDateEl = pubRightEl.getFirstChildElement("startDate");
        if (startDateEl != null) {
            pubRights.setStartDate(startDateEl.getValue());
        }
        if ((restrictionLawEl = pubRightEl.getFirstChildElement("law")) != null) {
            pubRights.setLaw(PublicationRights.Law.valueOf(restrictionLawEl.getValue()));
        }
        if ((restrictionsEl = pubRightEl.getFirstChildElement("restrictions")) != null) {
            Element videoDurationEl;
            Element videoSizeEl;
            Element audioDurationEl;
            Element watermarkSizeEl;
            Element watermarkOpacityEl;
            Element imageTextTypeEl;
            Element footerTextEl;
            Element imageHeightEl;
            Element imageWidthEl;
            pubRights.setTextRestriction(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("textRestriction").getValue()));
            pubRights.setImageRestriction(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("imageRestriction").getValue()));
            pubRights.setImageRestrictionText(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("imageRestrictionText").getValue()));
            pubRights.setAudioRestriction(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("audioRestriction").getValue()));
            pubRights.setVideoRestriction(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("videoRestriction").getValue()));
            pubRights.setVideoDurationRestriction(Boolean.parseBoolean(restrictionsEl.getFirstChildElement("videoDurationRestriction").getValue()));
            Element numPagesEl = restrictionsEl.getFirstChildElement("pages");
            if (numPagesEl != null) {
                pubRights.setPages(numPagesEl.getValue());
            }
            if ((imageWidthEl = restrictionsEl.getFirstChildElement("imageWidth")) != null) {
                pubRights.setImageWidth(imageWidthEl.getValue());
            }
            if ((imageHeightEl = restrictionsEl.getFirstChildElement("imageHeight")) != null) {
                pubRights.setImageHeight(imageHeightEl.getValue());
            }
            if ((footerTextEl = restrictionsEl.getFirstChildElement("footerText")) != null) {
                pubRights.setFooterText(footerTextEl.getValue());
            }
            if ((imageTextTypeEl = restrictionsEl.getFirstChildElement("imageTextType")) != null) {
                pubRights.setImageTextType(PublicationRights.TextType.valueOf(imageTextTypeEl.getValue()));
            }
            if ((watermarkOpacityEl = restrictionsEl.getFirstChildElement("watermarkOpacity")) != null) {
                pubRights.setWatermarkOpacity(watermarkOpacityEl.getValue());
            }
            if ((watermarkSizeEl = restrictionsEl.getFirstChildElement("watermarkSize")) != null) {
                pubRights.setWatermarkSize(watermarkSizeEl.getValue());
            }
            if ((audioDurationEl = restrictionsEl.getFirstChildElement("audioDuration")) != null) {
                pubRights.setAudioDuration(audioDurationEl.getValue());
            }
            if ((videoSizeEl = restrictionsEl.getFirstChildElement("videoSize")) != null) {
                pubRights.setVideoSize(videoSizeEl.getValue());
            }
            if ((videoDurationEl = restrictionsEl.getFirstChildElement("videoDuration")) != null) {
                pubRights.setVideoDuration(videoDurationEl.getValue());
            }
        }
    }

    public PublicationRights getInstitutionRights() {
        return this.institutionRights;
    }

    public PublicationRights getPublicRights() {
        return this.publicRights;
    }

    public ConversionCondition getConversionCondition() {
        return this.conversionCondition;
    }

    public void setConversionCondition(String conversionCondition) {
        this.conversionCondition = Utilities.translateConversionCondition(conversionCondition);
    }

    public boolean getDdbExclusion() {
        return this.ddbExclusion;
    }

    public void setDdbExclusion(boolean ddbExclusion) {
        this.ddbExclusion = ddbExclusion;
    }

    public CCLicense getCclincense() {
        return this.cclincense;
    }

    public void setCclincense(CCLicense cclincense) {
        this.cclincense = cclincense;
    }

    public static enum CCLicense {
        DlDeBy2("http://www.govdata.de/dl-de/by-2-0", "DL-DE-BY-Lizenz (v2.0)", "Datenlizenz Deutschland \u2013 Namensnennung (v2.0)"),
        DlDeZero("http://www.govdata.de/dl-de/zero-2-0", "DL-DE-Zero-Lizenz (v2.0)", "Datenlizenz Deutschland \u2013 Zero (v2.0)"),
        DlDeBy1("http://www.govdata.de/dl-de/by-1-0", "DL-DE-BY-Lizenz (v1.0)", "Datenlizenz Deutschland \u2013 Namensnennung (v1.0)"),
        DlDeByNc("http://www.govdata.de/dl-de/by-1-0", "DL-DE-BY-NC-Lizenz (v1.0)", "Datenlizenz Deutschland \u2013 Namensnennung \u2013 nicht kommerziell (v1.0)"),
        PDM("https://creativecommons.org/publicdomain/mark/1.0/", "Public Domain Mark 1.0", "Public Domain Mark 1.0"),
        Cc0("https://creativecommons.org/publicdomain/zero/1.0/", "CC0-Lizenz (v1.0)", "CC0 1.0 Public Domain Dedication"),
        By3("https://creativecommons.org/licenses/by/3.0/", "CC-BY-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung"),
        ByNd3("https://creativecommons.org/licenses/by-nd/3.0/", "CC-BY-ND-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung - Keine Bearbeitungen"),
        ByNc3("https://creativecommons.org/licenses/by-nc/3.0/", "CC-BY-NC-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung - Nicht kommerziell"),
        ByNcNd3("https://creativecommons.org/licenses/by-nc-nd/3.0/", "CC-BY-NC-ND-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung - Nicht kommerziell - Keine Bearbeitungen"),
        ByNcSa3("https://creativecommons.org/licenses/by-nc-sa/3.0/", "CC-BY-NC-SA-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen"),
        BySa3("https://creativecommons.org/licenses/by-sa/3.0/", "CC-BY-SA-Lizenz (v3.0)", "CC v3.0 International Lizenz: Namensnennung - Weitergabe unter gleichen Bedingungen"),
        By4("https://creativecommons.org/licenses/by/4.0/", "CC-BY-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung"),
        ByNd4("https://creativecommons.org/licenses/by-nd/4.0/", "CC-BY-ND-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung - Keine Bearbeitungen"),
        ByNc4("https://creativecommons.org/licenses/by-nc/4.0/", "CC-BY-NC-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung - Nicht kommerziell"),
        ByNcNd4("https://creativecommons.org/licenses/by-nc-nd/4.0/", "CC-BY-NC-ND-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung - Nicht kommerziell - Keine Bearbeitungen"),
        ByNcSa4("https://creativecommons.org/licenses/by-nc-sa/4.0/", "CC-BY-NC-SA-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen"),
        BySa4("https://creativecommons.org/licenses/by-sa/4.0/", "CC-BY-SA-Lizenz (v4.0)", "CC v4.0 International Lizenz: Namensnennung - Weitergabe unter gleichen Bedingungen");

        private String displayLabel;
        private String href;
        private String text;

        private CCLicense(String href, String displayLabel, String defaultText) {
            this.displayLabel = displayLabel;
            this.href = href;
            this.text = defaultText;
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }

        public String getHref() {
            return this.href;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.displayLabel;
        }
    }

    public static enum ConversionCondition {
        NONE,
        NOTIFY,
        CONFIRM;

    }
}

