/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import de.uzk.hki.da.metadata.LidoLicense;
import de.uzk.hki.da.metadata.NullLastComparator;
import de.uzk.hki.da.utils.C;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LidoParser {
    public Logger logger = LoggerFactory.getLogger(LidoParser.class);
    private Document lidoDoc = new Document();
    private List<Element> lidoLinkResources;
    private List<Element> lidoElements;

    public LidoParser(Document doc) throws JDOMException {
        this.lidoDoc = doc;
        this.lidoElements = this.getLidoElements();
        this.lidoLinkResources = this.getLinkResourceElements(this.lidoElements);
    }

    public List<Element> getLidoLinkResources() {
        return this.lidoLinkResources;
    }

    public void setLidoLinkResources(List<Element> lidoLinkResources) {
        this.lidoLinkResources = lidoLinkResources;
    }

    List<Element> getLidoElements() {
        List lidoElements = this.lidoDoc.getRootElement().getChildren("lido", C.LIDO_NS);
        return lidoElements;
    }

    private String getLidoRecID(Element lidoElement) {
        String recID = lidoElement.getChild("lidoRecID", C.LIDO_NS).getValue();
        return recID;
    }

    private List<String> getTitle(Element lidoElement) {
        ArrayList<String> titles = new ArrayList<String>();
        String title = "";
        try {
            List titleSetElements = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("objectIdentificationWrap", C.LIDO_NS).getChild("titleWrap", C.LIDO_NS).getChildren("titleSet", C.LIDO_NS);
            for (Element e : titleSetElements) {
                if (e.getChild("appellationValue", C.LIDO_NS) == null) continue;
                title = e.getChild("appellationValue", C.LIDO_NS).getValue();
                titles.add(title);
            }
        }
        catch (Exception e) {
            this.logger.error("No title Element found!");
        }
        return titles;
    }

    private List<String> getDescription(Element lidoElement) {
        HashSet<String> descries = new HashSet<String>();
        List elis = null;
        try {
            Element element = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS);
            element = element.getChild("objectIdentificationWrap", C.LIDO_NS);
            element = element.getChild("objectDescriptionWrap", C.LIDO_NS);
            elis = element.getChildren("objectDescriptionSet", C.LIDO_NS);
        }
        catch (Exception e) {
            this.logger.error("No Extent Element found!");
            return new ArrayList<String>(descries);
        }
        for (Element ele : elis) {
            try {
                Element element = ele.getChild("descriptiveNoteValue", C.LIDO_NS);
                String descry = element.getValue();
                descries.add(descry);
            }
            catch (Exception e) {
                this.logger.error("No Extent Element found!");
            }
        }
        return new ArrayList<String>(descries);
    }

    private List<String> getIdentifier(Element lidoElement) {
        String inve = "";
        try {
            List workies = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("objectIdentificationWrap", C.LIDO_NS).getChild("repositoryWrap", C.LIDO_NS).getChild("repositorySet", C.LIDO_NS).getChildren("workID", C.LIDO_NS);
            for (Element worky : workies) {
                String typpi = worky.getAttributeValue("type", C.LIDO_NS);
                if (!"inventory number".equals(typpi)) continue;
                inve = worky.getValue();
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("No title Identifier:workID found!");
        }
        String ise = "";
        try {
            List isies = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("resourceSource", C.LIDO_NS).getChildren("legalBodyID", C.LIDO_NS);
            for (Element isy : isies) {
                String sourcy = isy.getAttributeValue("source", C.LIDO_NS);
                if (!"isil".equals(sourcy)) continue;
                ise = isy.getValue();
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("No identifier legalBodyID Element found!");
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (inve != null && !inve.equals("")) {
            if (ise != null && !ise.equals("")) {
                ret.add(inve + " " + ise);
            } else {
                ret.add(inve);
            }
        } else if (ise != null && !ise.equals("")) {
            ret.add(ise);
        }
        return ret;
    }

    private List<String> getDataProvider(Element lidoElement) {
        String legalBodyName = "";
        try {
            legalBodyName = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("resourceSource", C.LIDO_NS).getChild("legalBodyName", C.LIDO_NS).getChild("appellationValue", C.LIDO_NS).getValue();
        }
        catch (Exception e) {
            this.logger.error("No legalBodyName Element found!");
        }
        String legalBodyID = "";
        try {
            legalBodyID = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("resourceSource", C.LIDO_NS).getChild("legalBodyID", C.LIDO_NS).getValue();
        }
        catch (Exception e) {
            this.logger.error("No legalBodyID Element found!");
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (legalBodyName != null && !legalBodyName.equals("")) {
            if (legalBodyID != null && !legalBodyID.equals("")) {
                ret.add(legalBodyName + " " + legalBodyID);
            } else {
                ret.add(legalBodyName);
            }
        } else if (legalBodyID != null && !legalBodyID.equals("")) {
            ret.add(legalBodyID);
        }
        return ret;
    }

    private List<String> getRightsHolder(Element lidoElement) {
        ArrayList<String> rightsHolder = new ArrayList<String>();
        try {
            String holder = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("rightsResource", C.LIDO_NS).getChild("rightsHolder", C.LIDO_NS).getChild("legalBodyName", C.LIDO_NS).getChild("appellationValue", C.LIDO_NS).getValue();
            rightsHolder.add(holder);
        }
        catch (Exception e) {
            this.logger.error("No RightsHolder Element found!");
        }
        return rightsHolder;
    }

    private List<String> getRecordRights(Element lidoElement) {
        ArrayList<String> rightIds = new ArrayList<String>();
        List<LidoLicense> licenses = this.getLicenseFromOneLidoPart(lidoElement);
        Collections.sort(licenses, new NullLastComparator());
        if (licenses.size() != 0 && licenses.get(0) != null) {
            rightIds.add(licenses.get(0).getHref());
        }
        return rightIds;
    }

    private List<String> getDate(Element lidoElement) {
        ArrayList<String> dates = new ArrayList<String>();
        List eventDateChildren = new ArrayList();
        try {
            Element event = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("eventWrap", C.LIDO_NS).getChild("eventSet", C.LIDO_NS).getChild("event", C.LIDO_NS);
            String eviType = event.getAttributeValue("eventType");
            eventDateChildren = event.getChild("eventDate", C.LIDO_NS).getChildren();
        }
        catch (Exception e) {
            this.logger.debug("No eventDate element found!");
        }
        for (Element e : eventDateChildren) {
            String date = "";
            if (e.getName().equals("displayDate")) {
                date = e.getValue();
            }
            if (date.equals("") && e.getName().equals("date")) {
                try {
                    String earliestDate = e.getChild("earliestDate", C.LIDO_NS).getValue();
                    String latestDate = e.getChild("latestDate", C.LIDO_NS).getValue();
                    if (!earliestDate.equals(latestDate)) {
                        date = earliestDate + "-" + latestDate;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (date.equals("")) continue;
            dates.add(date);
        }
        return dates;
    }

    private List<String> getType(Element lidoElement) {
        HashSet<String> extents = new HashSet<String>();
        List elis = null;
        try {
            Element element = lidoElement.getChild("administrativeMetadata", C.LIDO_NS);
            element = element.getChild("resourceWrap", C.LIDO_NS);
            elis = element.getChildren("resourceSet", C.LIDO_NS);
        }
        catch (Exception e) {
            this.logger.error("No Type Element found!");
            return new ArrayList<String>(extents);
        }
        for (Element ele : elis) {
            try {
                Element element = ele.getChild("resourceType", C.LIDO_NS);
                element = element.getChild("term", C.LIDO_NS);
                String ext = element.getValue();
                ext = ext.toUpperCase();
                extents.add(ext);
            }
            catch (Exception e) {
                this.logger.error("No Type Element found!");
            }
        }
        return new ArrayList<String>(extents);
    }

    private List<String> getProvenance(Element lidoElement) {
        HashSet<String> extents = new HashSet<String>();
        List elis = null;
        try {
            Element element = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS);
            element = element.getChild("eventWrap", C.LIDO_NS);
            elis = element.getChildren("eventSet", C.LIDO_NS);
        }
        catch (Exception e) {
            this.logger.error("No Extent Element found!");
            return new ArrayList<String>(extents);
        }
        for (Element ele : elis) {
            try {
                Element element = ele.getChild("event", C.LIDO_NS);
                element = element.getChild("eventDescriptionSet", C.LIDO_NS);
                element = element.getChild("descriptiveNoteValue", C.LIDO_NS);
                String ext = element.getValue();
                extents.add(ext);
            }
            catch (Exception e) {
                this.logger.error("No Extent Element found!");
            }
        }
        return new ArrayList<String>(extents);
    }

    private List<String> getProvider(Element lidoElement) {
        HashSet<String> providers = new HashSet<String>();
        List elis = null;
        try {
            Element element = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS);
            element = element.getChild("objectIdentificationWrap", C.LIDO_NS);
            elis = element.getChildren("repositoryWrap", C.LIDO_NS);
        }
        catch (Exception e) {
            this.logger.error("No Provider Element found!");
            return new ArrayList<String>(providers);
        }
        for (Element ele : elis) {
            try {
                Element element = ele.getChild("repositorySet", C.LIDO_NS);
                element = element.getChild("repositoryName", C.LIDO_NS);
                element = element.getChild("legalBodyName", C.LIDO_NS);
                element = element.getChild("appellationValue", C.LIDO_NS);
                String provider = element.getValue();
                providers.add(provider);
            }
            catch (Exception e) {
                this.logger.error("No Provider Element found!");
            }
        }
        return new ArrayList<String>(providers);
    }

    private List<String> getMaterialsTech(Element lidoElement) {
        ArrayList<String> extents = new ArrayList<String>();
        List elis = null;
        try {
            Element element = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS);
            element = element.getChild("eventWrap", C.LIDO_NS);
            elis = element.getChildren("eventSet", C.LIDO_NS);
        }
        catch (Exception e) {
            this.logger.error("No Extent Element found!");
            return extents;
        }
        for (Element ele : elis) {
            try {
                Element element = ele.getChild("event", C.LIDO_NS);
                element = element.getChild("eventMaterialsTech", C.LIDO_NS);
                element = element.getChild("displayMaterialsTech", C.LIDO_NS);
                String ext = element.getValue();
                extents.add(ext);
            }
            catch (Exception e) {
                this.logger.error("No Extent Element found!");
            }
        }
        return extents;
    }

    private List<String> getExtent(Element lidoElement) {
        ArrayList<String> extents = new ArrayList<String>();
        try {
            Element element = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS);
            element = element.getChild("objectIdentificationWrap", C.LIDO_NS);
            element = element.getChild("objectMeasurementsWrap", C.LIDO_NS);
            element = element.getChild("objectMeasurementsSet", C.LIDO_NS);
            element = element.getChild("displayObjectMeasurements", C.LIDO_NS);
            String ext = element.getValue();
            extents.add(ext);
        }
        catch (Exception e) {
            this.logger.error("No Extent Element found!");
        }
        return extents;
    }

    private List<String> getPlaces(Element lidoElement) {
        ArrayList<String> places = new ArrayList<String>();
        List placeElementChildren = new ArrayList();
        String displayPlace = "";
        try {
            displayPlace = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("eventWrap", C.LIDO_NS).getChild("eventSet", C.LIDO_NS).getChild("event", C.LIDO_NS).getChild("eventPlace", C.LIDO_NS).getChild("displayPlace", C.LIDO_NS).getValue();
            if (!displayPlace.equals("")) {
                places.add(displayPlace);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (displayPlace.equals("")) {
            try {
                placeElementChildren = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("eventWrap", C.LIDO_NS).getChild("eventSet", C.LIDO_NS).getChild("event", C.LIDO_NS).getChild("eventPlace", C.LIDO_NS).getChild("place", C.LIDO_NS).getChildren();
            }
            catch (Exception e) {
                this.logger.error("No place element found!");
            }
            for (Element e : placeElementChildren) {
                if (!e.getName().equals("namePlaceSet")) continue;
                try {
                    places.add(e.getChild("appellationValue", C.LIDO_NS).getValue());
                }
                catch (Exception e2) {
                    this.logger.error("No appellationValue found!");
                }
            }
        }
        return places;
    }

    public HashMap<String, HashMap<String, List<String>>> getIndexInfo(String objectId) {
        HashMap<String, HashMap<String, List<String>>> indexInfo = new HashMap<String, HashMap<String, List<String>>>();
        try {
            List<Element> lidoElements = this.getLidoElements();
            for (Element lidoElement : lidoElements) {
                HashMap<String, List<String>> lidoElementInfo = new HashMap<String, List<String>>();
                String id = objectId + "-" + this.getLidoRecID(lidoElement);
                this.logger.debug("ID: " + id);
                lidoElementInfo.put("dc:title", this.getTitle(lidoElement));
                lidoElementInfo.put("dc:rights", this.getRecordRights(lidoElement));
                lidoElementInfo.put("edm:rights", this.getRecordRights(lidoElement));
                lidoElementInfo.put("dc:rightsHolder", this.getRightsHolder(lidoElement));
                lidoElementInfo.put("dcterms:spatial", this.getPlaces(lidoElement));
                lidoElementInfo.put("dc:date", this.getDate(lidoElement));
                lidoElementInfo.put("edm:type", this.getType(lidoElement));
                ArrayList<String> creators = new ArrayList<String>();
                ArrayList<String> contributors = new ArrayList<String>();
                for (Element actor : this.getEventActor(lidoElement)) {
                    String creator = this.getCreator(actor);
                    String contributor = this.getContributor(actor);
                    if (!creator.equals("")) {
                        creators.add(creator);
                    }
                    if (contributor.equals("")) continue;
                    contributors.add(contributor);
                }
                lidoElementInfo.put("dc:creator", creators);
                lidoElementInfo.put("dc:contributor", contributors);
                lidoElementInfo.put("dc:description", this.getDescription(lidoElement));
                lidoElementInfo.put("dc:identifier", this.getIdentifier(lidoElement));
                lidoElementInfo.put("dcterms:extent", this.getExtent(lidoElement));
                lidoElementInfo.put("edm:dataProvider", this.getDataProvider(lidoElement));
                lidoElementInfo.put("edm:provider", this.getProvider(lidoElement));
                lidoElementInfo.put("dcterms:provenance", this.getProvenance(lidoElement));
                List<String> references = this.getReferencesFromLidoElement(lidoElement);
                if (references != null && !references.isEmpty()) {
                    ArrayList<String> shownBy = new ArrayList<String>();
                    shownBy.add(references.get(0));
                    lidoElementInfo.put("edm:isShownBy", shownBy);
                    if (references.size() == 1) {
                        lidoElementInfo.put("edm:object", references);
                    } else {
                        lidoElementInfo.put("edm:object", shownBy);
                        lidoElementInfo.put("edm:hasView", references);
                    }
                }
                indexInfo.put(id, lidoElementInfo);
            }
        }
        catch (Exception e) {
            new RuntimeException("Unable to parse the lido file for edm serialization.");
        }
        return indexInfo;
    }

    private String getContributor(Element actor) {
        return "";
    }

    private String getCreator(Element actor) {
        String namePartValue = "";
        try {
            Element actDisplay = actor.getChild("displayActorInRole", C.LIDO_NS);
            if (actDisplay != null && !actDisplay.getValue().trim().isEmpty()) {
                namePartValue = actDisplay.getValue();
            }
        }
        catch (Exception e) {
            this.logger.debug("No creator found!");
        }
        return namePartValue;
    }

    private List<Element> getEventActor(Element lidoElement) {
        List<Element> ret = new ArrayList<Element>();
        try {
            ret = lidoElement.getChild("descriptiveMetadata", C.LIDO_NS).getChild("eventWrap", C.LIDO_NS).getChild("eventSet", C.LIDO_NS).getChild("event", C.LIDO_NS).getChildren("eventActor", C.LIDO_NS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public List<String> getReferencesFromLidoElement(Element lidoElement) {
        ArrayList<String> references = new ArrayList<String>();
        try {
            List<Element> currentLinkResources = this.getLinkResourceElemensFromLidoElement(lidoElement);
            for (Element resourceElement : currentLinkResources) {
                references.add(resourceElement.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to find references in lido element " + lidoElement.getName());
        }
        return references;
    }

    public List<Element> getLinkResourceElemensFromLidoElement(Element lidoElement) {
        ArrayList<Element> currentLinkResources = new ArrayList<Element>();
        if (lidoElement.getName().equalsIgnoreCase("lido")) {
            Element currentLinkResource = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("resourceRepresentation", C.LIDO_NS).getChild("linkResource", C.LIDO_NS);
            currentLinkResources.add(currentLinkResource);
        }
        return currentLinkResources;
    }

    private List<Element> getLinkResourceElements(List<Element> lidoElements) {
        ArrayList<Element> linkResourceElements = new ArrayList<Element>();
        for (Element element : lidoElements) {
            List<Element> elements = this.getLinkResourceElemensFromLidoElement(element);
            for (Element resourceElement : elements) {
                linkResourceElements.add(resourceElement);
            }
        }
        return linkResourceElements;
    }

    public List<String> getReferences() {
        ArrayList<String> linkResources = new ArrayList<String>();
        for (Element element : this.lidoLinkResources) {
            linkResources.add(element.getValue());
        }
        return linkResources;
    }

    public LidoLicense getLicenseForWholeLido() {
        return this.getLicenseForWholeLido(false);
    }

    protected LidoLicense getLicenseForWholeLido(boolean quiet) {
        ArrayList<LidoLicense> licenseAl = new ArrayList<LidoLicense>();
        List lidoSecs = this.lidoDoc.getRootElement().getChildren("lido", C.LIDO_NS);
        for (Element lido : lidoSecs) {
            licenseAl.addAll(this.getLicenseFromOneLidoPart(lido));
        }
        if (licenseAl.size() == 0) {
            return null;
        }
        Collections.sort(licenseAl, new NullLastComparator());
        if (licenseAl.get(0) == null) {
            return null;
        }
        if (!((LidoLicense)licenseAl.get(0)).equals(licenseAl.get(licenseAl.size() - 1)) && !quiet) {
            throw new RuntimeException("LIDO-Metadata contains different licenses(" + licenseAl.size() + ") e.g.:" + licenseAl.get(licenseAl.size() - 1) + " " + licenseAl.get(0));
        }
        return (LidoLicense)licenseAl.get(0);
    }

    protected List<LidoLicense> getLicenseFromOneLidoPart(Element lidoSec) {
        ArrayList<LidoLicense> lidoLicenses = new ArrayList<LidoLicense>();
        List admSections = lidoSec.getChildren("administrativeMetadata", C.LIDO_NS);
        for (int i = 0; i < admSections.size(); ++i) {
            Element resourceWrap = ((Element)admSections.get(i)).getChild("resourceWrap", C.LIDO_NS);
            if (resourceWrap == null) {
                lidoLicenses.add(null);
                continue;
            }
            List resourceSets = resourceWrap.getChildren("resourceSet", C.LIDO_NS);
            if (resourceSets.size() == 0) {
                lidoLicenses.add(null);
                continue;
            }
            for (int j = 0; j < resourceSets.size(); ++j) {
                List rightsResources = ((Element)resourceSets.get(j)).getChildren("rightsResource", C.LIDO_NS);
                if (rightsResources.size() == 0) {
                    lidoLicenses.add(null);
                    continue;
                }
                for (int k = 0; k < rightsResources.size(); ++k) {
                    List rightsTypes = ((Element)rightsResources.get(k)).getChildren("rightsType", C.LIDO_NS);
                    if (rightsTypes.size() == 0) {
                        lidoLicenses.add(null);
                        continue;
                    }
                    for (int m = 0; m < rightsTypes.size(); ++m) {
                        lidoLicenses.add(this.getLicenseFromOneRightsType((Element)rightsTypes.get(m)));
                    }
                }
            }
        }
        return lidoLicenses;
    }

    protected LidoLicense getLicenseFromOneRightsType(Element rightsType) {
        List conceptIDs = rightsType.getChildren("conceptID", C.LIDO_NS);
        List terms = rightsType.getChildren("term", C.LIDO_NS);
        if (conceptIDs.size() == 0 || terms.size() == 0) {
            throw new RuntimeException("LIDO-Metadata RightsType has no conceptID and/or term " + rightsType.toString());
        }
        if (conceptIDs.size() != 1 || terms.size() != 1) {
            throw new RuntimeException("LIDO-Metadata RightsType has more as one conceptID and/or term: " + rightsType.getValue());
        }
        String licenseURI = ((Element)conceptIDs.get(0)).getText();
        String type = ((Element)conceptIDs.get(0)).getAttribute("type", C.LIDO_NS).getValue();
        if (!"URI".equals(type)) {
            this.logger.debug("lido:conceptID type is not URI: " + type);
        }
        String term = ((Element)terms.get(0)).getText();
        return new LidoLicense(licenseURI, term);
    }
}

