/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import de.uzk.hki.da.metadata.MetsLicense;
import de.uzk.hki.da.metadata.NullLastComparator;
import de.uzk.hki.da.utils.C;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetsParser {
    public Logger logger = LoggerFactory.getLogger(MetsParser.class);
    private Document metsDoc = new Document();
    private String METS_XPATH_EXPRESSION = "//mets:file";
    XPath metsXPath = XPath.newInstance(this.METS_XPATH_EXPRESSION);
    private final String TITLE_PAGE = "title_page";
    private final String STRUCTMAP_TYPE_LOGICAL = "LOGICAL";
    private final Namespace XLINK_NS = Namespace.getNamespace("http://www.w3.org/1999/xlink");
    private final Namespace METS_NS = Namespace.getNamespace("http://www.loc.gov/METS/");
    private final List<Element> fileElements;
    public static final String titleSparator = " : ";
    public static final String dateIssuedCreatedCondition = "[Electronic ed.]";

    public MetsParser(Document doc) throws JDOMException {
        this.metsDoc = doc;
        this.fileElements = this.getFileElementsFromMetsDoc(this.metsDoc);
    }

    public Document getMetsDoc() {
        return this.metsDoc;
    }

    public void setMetsDoc(Document metsDoc) {
        this.metsDoc = metsDoc;
    }

    public String getUrn() {
        String urn = null;
        try {
            String rootDmdSecId = this.getUniqueRootElementInLogicalStructMap().getAttributeValue("DMDID");
            List dmdSecs = this.metsDoc.getRootElement().getChildren("dmdSec", this.METS_NS);
            for (Element dmdSec : dmdSecs) {
                if (!dmdSec.getAttributeValue("ID").equals(rootDmdSecId)) continue;
                Element rootDmdSec = dmdSec;
                List elements = MetsParser.getModsXmlData(rootDmdSec).getChildren();
                for (Element e : elements) {
                    if (!e.getName().equals("identifier") || !e.getAttributeValue("type").equals("urn")) continue;
                    urn = e.getValue();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to find urn.");
        }
        return urn;
    }

    public MetsLicense getLicenseForWholeMets() {
        return this.getLicenseForWholeMets(false);
    }

    protected MetsLicense getLicenseForWholeMets(boolean quiet) {
        ArrayList<MetsLicense> licenseAl = new ArrayList<MetsLicense>();
        List dmdSecs = this.metsDoc.getRootElement().getChildren("dmdSec", this.METS_NS);
        for (Element dmdSec : dmdSecs) {
            licenseAl.add(this.getLicense(dmdSec, quiet));
        }
        if (licenseAl.size() == 0) {
            return null;
        }
        Collections.sort(licenseAl, new NullLastComparator());
        if (licenseAl.get(0) == null) {
            return null;
        }
        if (!((MetsLicense)licenseAl.get(0)).equals(licenseAl.get(licenseAl.size() - 1)) && !quiet) {
            throw new RuntimeException("METS contains different licenses(" + licenseAl.size() + ") e.g.:" + licenseAl.get(licenseAl.size() - 1) + " " + licenseAl.get(0));
        }
        this.logger.debug("Recognized License in METS(" + licenseAl.size() + ") " + licenseAl.get(0));
        return (MetsLicense)licenseAl.get(0);
    }

    protected MetsLicense getLicense(Element dmdSec, boolean quiet) {
        MetsLicense metsLicenseReturn = null;
        ArrayList<MetsLicense> metsLicenseList = new ArrayList<MetsLicense>();
        List accessConditionList = new ArrayList();
        try {
            accessConditionList = MetsParser.getModsXmlData(dmdSec).getChildren("accessCondition", C.MODS_NS);
        }
        catch (Exception e) {
            this.logger.debug("No accessCondition element found! " + e.getMessage());
        }
        for (Element accessCondition : accessConditionList) {
            try {
                MetsLicense metsLicense = new MetsLicense();
                metsLicense.setHref(accessCondition.getAttributeValue("href", this.XLINK_NS));
                metsLicense.setType(accessCondition.getAttributeValue("type"));
                metsLicense.setText(accessCondition.getValue());
                metsLicense.setDisplayLabel(accessCondition.getAttributeValue("displayLabel"));
                if (metsLicense.getType() == null) continue;
                if (!metsLicense.getType().equals(MetsLicense.USE_AND_REP_TYPE)) continue;
                metsLicenseList.add(metsLicense);
            }
            catch (Exception e) {
                this.logger.debug("No valid accessCondition element found! " + e.getMessage());
            }
        }
        Collections.sort(metsLicenseList, new NullLastComparator());
        if (metsLicenseList.size() >= 1) {
            metsLicenseReturn = (MetsLicense)metsLicenseList.get(0);
            if (!quiet && metsLicenseList.size() > 1) {
                throw new RuntimeException("dmdSec contains multiple licenses (accessCondition-Elements), unsuported");
            }
        }
        return metsLicenseReturn;
    }

    private List<String> getPhysicalDescriptionFromDmdId(String dmdID, String objectId) {
        ArrayList<String> extent = new ArrayList<String>();
        String logicalId = dmdID.replace(objectId + "-", "");
        try {
            List dmdSecs = this.metsDoc.getRootElement().getChildren("dmdSec", this.METS_NS);
            for (Element dmdSec : dmdSecs) {
                if (!dmdSec.getAttributeValue("ID").equals(logicalId)) continue;
                Element rootDmdSec = dmdSec;
                List elements = MetsParser.getModsXmlData(rootDmdSec).getChildren("physicalDescription", C.MODS_NS);
                for (Element e : elements) {
                    if (!e.getName().equals("physicalDescription") || e.getChildren("extent", C.MODS_NS).isEmpty()) continue;
                    List childElements = e.getChildren("extent", C.MODS_NS);
                    for (Element eChild : childElements) {
                        if (eChild.getValue().trim().isEmpty()) continue;
                        extent.add(eChild.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to process xml element: " + e.getMessage());
        }
        return extent;
    }

    private List<String> getTitlePageReferencesFromFrontimage() {
        Element fileGrp;
        String usi;
        Element fileSec;
        ArrayList<String> ret = new ArrayList<String>();
        List fileSecs = this.metsDoc.getRootElement().getChildren("fileSec", this.METS_NS);
        if (fileSecs == null) {
            return ret;
        }
        List fileGrps = null;
        Iterator iterator = fileSecs.iterator();
        while (iterator.hasNext() && (fileGrps = (fileSec = (Element)iterator.next()).getChildren("fileGrp", this.METS_NS)) == null) {
        }
        if (fileGrps == null) {
            return ret;
        }
        List files = null;
        Iterator iterator2 = fileGrps.iterator();
        while (iterator2.hasNext() && (!"FRONTIMAGE".equals(usi = (fileGrp = (Element)iterator2.next()).getAttributeValue("USE")) || (files = fileGrp.getChildren("file", this.METS_NS)) == null)) {
        }
        if (files == null) {
            return ret;
        }
        for (Element file : files) {
            List fLocs = file.getChildren("FLocat", this.METS_NS);
            if (fLocs == null) continue;
            for (Element fLoc : fLocs) {
                String href = fLoc.getAttributeValue("href", this.XLINK_NS);
                if (href == null || href.length() <= 0) continue;
                ret.add(href);
            }
        }
        return ret;
    }

    private List<String> getTitlePageReferencesFromDmdId(String dmdID, String objectId) {
        ArrayList<String> titlePageRefs = new ArrayList<String>();
        String titlePageLogicalId = this.getIdFromLogicalStructMap(dmdID.replace(objectId + "-", ""), "title_page", "ID");
        List<String> physIds = this.getPhysicalIdsFromStructLink(this.metsDoc, titlePageLogicalId);
        for (String physId : physIds) {
            String titlePageRef;
            String titlePageFileId = this.getFileIdFromPhysicalId(physId);
            if (titlePageFileId.equals("") || (titlePageRef = this.getReferenceFromFileId(titlePageFileId)).equals("")) continue;
            titlePageRefs.add(titlePageRef);
        }
        return titlePageRefs;
    }

    private List<String> getReferencesFromDmdId(String dmdID, String objectId) {
        ArrayList<String> references = new ArrayList<String>();
        String logicalId = this.getIdFromLogicalStructMap(dmdID.replace(objectId + "-", ""), "", "ID");
        List<String> physicalIds = this.getPhysicalIdsFromStructLink(this.metsDoc, logicalId);
        for (String physicalId : physicalIds) {
            String fileId;
            String ref;
            if (this.getFileIdFromPhysicalId(physicalId).equals("") || (ref = this.getReferenceFromFileId(fileId = this.getFileIdFromPhysicalId(physicalId))).equals("")) continue;
            references.add(ref);
        }
        return references;
    }

    private String getFileIdFromPhysicalId(String physicalId) {
        String fileId = "";
        try {
            List<Element> structMaps = this.getStructMaps(this.metsDoc);
            for (Element s : structMaps) {
                if (!s.getAttributeValue("TYPE").equals("PHYSICAL")) continue;
                List divList = s.getChildren("div", this.METS_NS);
                for (Element div : divList) {
                    if (!div.getAttributeValue("TYPE").equals("physSequence") || !div.getAttributeValue("ID").equals("physroot")) continue;
                    List divs = div.getChildren("div", this.METS_NS);
                    for (Element d : divs) {
                        if (!d.getAttributeValue("ID").equals(physicalId)) continue;
                        fileId = d.getChild("fptr", C.METS_NS).getAttributeValue("FILEID");
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to file the file id.");
        }
        return fileId;
    }

    private List<Element> getStructMaps(Document doc) {
        ArrayList<Element> structMap = new ArrayList();
        try {
            structMap = doc.getRootElement().getChildren("structMap", this.METS_NS);
        }
        catch (Exception e) {
            this.logger.debug("Unable to find the structMap elements.");
        }
        return structMap;
    }

    public Element getUniqueRootElementInLogicalStructMap() {
        Element logicalRootElement = null;
        try {
            List<Element> structMap = this.getStructMaps(this.metsDoc);
            for (Element s : structMap) {
                if (!s.getAttributeValue("TYPE").equals("LOGICAL")) continue;
                List metsDivElements = s.getChildren("div", this.METS_NS);
                if (metsDivElements.size() == 1) {
                    logicalRootElement = (Element)metsDivElements.get(0);
                    continue;
                }
                if (metsDivElements.size() == 0) {
                    this.logger.error("No unique root element found in the logical structMap!");
                    continue;
                }
                this.logger.error("Found multiple root elements in the logical structMap!");
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to find the unique root element in the logical structMap!");
        }
        return logicalRootElement;
    }

    private HashMap<String, ArrayList<String>> getParentChildInfoOfDmdIds(String objectId) {
        HashMap<String, ArrayList<String>> parentChildDmdId = new HashMap<String, ArrayList<String>>();
        String parentDmdId = "";
        try {
            Element rootDivElement = this.getUniqueRootElementInLogicalStructMap();
            ArrayList<String> children = new ArrayList<String>();
            List divChildren = rootDivElement.getChildren("div", this.METS_NS);
            if (divChildren != null && !divChildren.isEmpty()) {
                for (Element divChild : divChildren) {
                    if (divChild.getAttribute("DMDID") == null || divChild.getAttributeValue("DMDID").equals(parentDmdId)) continue;
                    children.add(objectId + "-" + divChild.getAttributeValue("DMDID"));
                }
            }
            if (children != null && !children.isEmpty()) {
                parentChildDmdId.put(rootDivElement.getAttributeValue("DMDID"), children);
            }
        }
        catch (Exception e) {
            this.logger.debug("No parent child relationship found.");
        }
        return parentChildDmdId;
    }

    private ArrayList<String> getParentDmdIds(String childDmdId, String ObjectId) {
        ArrayList<String> parentDmdIds = new ArrayList<String>();
        HashMap<String, ArrayList<String>> parentChildDmdIdRel = this.getParentChildInfoOfDmdIds(ObjectId);
        for (String parentId : parentChildDmdIdRel.keySet()) {
            for (String child : parentChildDmdIdRel.get(parentId)) {
                if (!child.equals(childDmdId)) continue;
                parentDmdIds.add(ObjectId + "-" + parentId);
            }
        }
        return parentDmdIds;
    }

    private ArrayList<String> getChildrenDmdIds(String parentDmdId, String ObjectId) {
        ArrayList<String> childrenDmdIds = new ArrayList<String>();
        HashMap<String, ArrayList<String>> parentChildDmdIdRel = this.getParentChildInfoOfDmdIds(ObjectId);
        for (String parentId : parentChildDmdIdRel.keySet()) {
            if (!parentId.equals(parentDmdId.replace(ObjectId + "-", ""))) continue;
            childrenDmdIds = parentChildDmdIdRel.get(parentId);
        }
        return childrenDmdIds;
    }

    private String getIdFromLogicalStructMap(String dmdID, String type, String idType) {
        String id = "";
        try {
            List<Element> structMap = this.getStructMaps(this.metsDoc);
            for (Element s : structMap) {
                if (!s.getAttributeValue("TYPE").equals("LOGICAL")) continue;
                List metsDivElements = s.getChildren("div", C.METS_NS);
                for (Element d : metsDivElements) {
                    if (d.getAttributeValue("DMDID").equals(dmdID)) {
                        if (type.equals("title_page")) {
                            List divs = d.getChildren("div", C.METS_NS);
                            for (Element div : divs) {
                                if (!div.getAttributeValue("TYPE").equals(type)) continue;
                                id = div.getAttributeValue(idType);
                            }
                            continue;
                        }
                        id = d.getAttributeValue(idType);
                        continue;
                    }
                    if (d.getChildren("div", C.METS_NS) == null) continue;
                    List divChildren = d.getChildren("div", C.METS_NS);
                    for (Element divChild : divChildren) {
                        if (!divChild.getAttributeValue("DMDID").equals(dmdID)) continue;
                        id = divChild.getAttributeValue(idType);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to find the " + idType + " id from dmdID " + dmdID);
        }
        return id;
    }

    private List<String> getPhysicalIdsFromStructLink(Document doc, String logicalId) {
        ArrayList<String> physIds = new ArrayList<String>();
        List structLink = new ArrayList();
        try {
            structLink = doc.getRootElement().getChild("structLink", C.METS_NS).getChildren("smLink", C.METS_NS);
            for (Element link : structLink) {
                if (!link.getAttributeValue("from", this.XLINK_NS).equals(logicalId)) continue;
                physIds.add(link.getAttributeValue("to", this.XLINK_NS));
            }
        }
        catch (Exception e) {
            this.logger.debug("Unable to find the physical id from logical id " + logicalId);
        }
        return physIds;
    }

    private List<String> getDataProvider() {
        ArrayList<String> dataProvider = new ArrayList<String>();
        try {
            List amdSections = this.metsDoc.getRootElement().getChildren("amdSec", C.METS_NS);
            for (Element amdSec : amdSections) {
                if (!amdSec.getChild("rightsMD", C.METS_NS).getChild("mdWrap", C.METS_NS).getAttribute("OTHERMDTYPE").getValue().equals("DVRIGHTS")) continue;
                dataProvider.add(amdSec.getChild("rightsMD", C.METS_NS).getChild("mdWrap", C.METS_NS).getChild("xmlData", C.METS_NS).getChild("rights", C.DV).getChild("owner", C.DV).getValue());
            }
        }
        catch (Exception e) {
            this.logger.debug("No amd section found!");
        }
        return dataProvider;
    }

    private String getPublisher(Element origInfo) {
        String publisher = "";
        try {
            String type = origInfo.getChild("place", C.MODS_NS).getChild("placeTerm", C.MODS_NS).getAttributeValue("type");
            if (type.equals("text")) {
                publisher = origInfo.getChild("place", C.MODS_NS).getChild("placeTerm", C.MODS_NS).getValue();
            }
            if (origInfo.getChild("publisher", C.MODS_NS) != null) {
                publisher = origInfo.getChild("publisher", C.MODS_NS).getValue() + " (" + publisher + ")";
            }
        }
        catch (Exception e) {
            this.logger.debug("Element placeTerm does not exist!");
        }
        return publisher;
    }

    private List<Element> getOrigInfoElements(Element dmdSec) {
        ArrayList<Element> origInfoElements = new ArrayList();
        try {
            origInfoElements = MetsParser.getModsXmlData(dmdSec).getChildren("originInfo", C.MODS_NS);
        }
        catch (Exception e) {
            this.logger.debug("No origInfo element found!");
        }
        return origInfoElements;
    }

    private String getDateIssued(Element originInfo) {
        String date = "";
        try {
            Element edition = originInfo.getChild("edition", C.MODS_NS);
            if (edition == null || !edition.getValue().equals(dateIssuedCreatedCondition)) {
                date = originInfo.getChild("dateIssued", C.MODS_NS).getValue();
            }
        }
        catch (Exception e) {
            this.logger.debug("Element dateIssued does not exist! : " + e.toString());
        }
        return date;
    }

    private String getDateCreated(Element originInfo) {
        String date = "";
        try {
            Element edition = originInfo.getChild("edition", C.MODS_NS);
            if (edition != null && edition.getValue().equals(dateIssuedCreatedCondition)) {
                date = originInfo.getChild("dateIssued", C.MODS_NS).getValue();
            }
        }
        catch (Exception e) {
            this.logger.debug("Element dateIssued does not exist! : " + e.toString());
        }
        return date;
    }

    private List<Element> getNameElements(Element dmdSec) {
        ArrayList<Element> nameElements = new ArrayList();
        Element modsXmlData = MetsParser.getModsXmlData(dmdSec);
        try {
            nameElements = modsXmlData.getChildren("name", C.MODS_NS);
        }
        catch (Exception e) {
            this.logger.debug("No name element found!");
        }
        return nameElements;
    }

    private String getContributor(Element name) {
        String namePartValue = "";
        try {
            String roleCode = "";
            String roleText = "";
            Element roleElem = name.getChild("role", C.MODS_NS);
            List roleTermElem = roleElem.getChildren("roleTerm", C.MODS_NS);
            for (Element e : roleTermElem) {
                String type = e.getAttribute("type").getValue();
                if (type.equals("code")) {
                    roleCode = e.getValue();
                    continue;
                }
                if (!type.equals("text")) continue;
                roleText = e.getValue();
            }
            if (!roleCode.equals("aut") && !roleCode.equals("cre")) {
                namePartValue = roleText + (roleText.trim().isEmpty() ? "" : ": ") + this.getName(name);
            }
        }
        catch (Exception e) {
            this.logger.debug("No creator found!");
        }
        return namePartValue;
    }

    private String getCreator(Element name) {
        String namePartValue = "";
        try {
            String roleCode = "";
            String roleText = "";
            Element roleElem = name.getChild("role", C.MODS_NS);
            List roleTermElem = roleElem.getChildren("roleTerm", C.MODS_NS);
            for (Element e : roleTermElem) {
                String type = e.getAttribute("type").getValue();
                if (type.equals("code")) {
                    roleCode = e.getValue();
                    continue;
                }
                if (!type.equals("text")) continue;
                roleText = e.getValue();
            }
            if (roleCode.equals("aut") || roleCode.equals("cre")) {
                namePartValue = roleText + (roleText.trim().isEmpty() ? "" : ": ") + this.getName(name);
            }
        }
        catch (Exception e) {
            this.logger.debug("No contributor found!");
        }
        return namePartValue;
    }

    private String getName(Element name) {
        String namePartValue = "";
        if (name.getAttribute("type", C.MODS_NS) == null || name.getAttribute("type", C.MODS_NS).equals("personal")) {
            try {
                List nameParts = name.getChildren("namePart", C.MODS_NS);
                String given = "";
                String family = "";
                for (Element element : nameParts) {
                    if (element.getAttributes() == null) {
                        namePartValue = element.getValue();
                        continue;
                    }
                    if (element.getAttribute("given", C.MODS_NS) != null) {
                        given = element.getAttributeValue("given", C.MODS_NS);
                    }
                    if (element.getAttribute("family", C.MODS_NS) != null) {
                        family = element.getAttributeValue("family", C.MODS_NS);
                    }
                    if (given.equals("") && family.equals("")) {
                        namePartValue = element.getValue();
                        continue;
                    }
                    if (!given.equals("")) {
                        namePartValue = given + " " + family;
                        continue;
                    }
                    namePartValue = family;
                }
            }
            catch (Exception e) {
                this.logger.debug("Element namePart does not exist!");
            }
            if (namePartValue.isEmpty()) {
                try {
                    namePartValue = name.getChild("displayForm", C.MODS_NS).getValue();
                }
                catch (Exception e) {
                    this.logger.error("No name found");
                }
            }
        }
        return namePartValue;
    }

    private List<String> getIdentifier(Element dmdSec) {
        ArrayList<String> identifier = new ArrayList<String>();
        Element modsXmlData = MetsParser.getModsXmlData(dmdSec);
        List elements = modsXmlData.getChildren();
        for (Element e : elements) {
            if (!e.getName().equals("identifier")) continue;
            identifier.add(e.getValue());
        }
        return identifier;
    }

    private List<String> getTitle(Element dmdSec) {
        ArrayList<String> title = new ArrayList<String>();
        Element modsXmlData = MetsParser.getModsXmlData(dmdSec);
        String titleValue = "";
        String displayLabelValue = "";
        String nonSortValue = "";
        String subTitleValue = "";
        String MainTitleValue = "";
        try {
            Element titleInfo = modsXmlData.getChild("titleInfo", C.MODS_NS);
            try {
                nonSortValue = titleInfo.getChild("nonSort", C.MODS_NS).getText();
            }
            catch (Exception e) {
                this.logger.debug("Element nonSort does not exist!");
            }
            try {
                titleValue = titleInfo.getChild("title", C.MODS_NS).getText();
            }
            catch (Exception e) {
                this.logger.debug("Element title does not exist!");
            }
            try {
                displayLabelValue = titleInfo.getChild("displayLabel", C.MODS_NS).getText();
            }
            catch (Exception e) {
                this.logger.debug("Element displayLabel does not exist!");
            }
            try {
                subTitleValue = titleInfo.getChild("subTitle", C.MODS_NS).getText();
            }
            catch (Exception e) {
                this.logger.debug("Element subTitle does not exist!");
            }
            if (!titleValue.equals("")) {
                if (!nonSortValue.equals("")) {
                    titleValue = nonSortValue + " " + titleValue;
                }
                MainTitleValue = titleValue;
            } else {
                MainTitleValue = !nonSortValue.equals("") ? nonSortValue : displayLabelValue;
            }
        }
        catch (Exception e) {
            this.logger.error("Element titleInfo does not exist!!!");
        }
        if (!subTitleValue.equals("")) {
            title.add(MainTitleValue + titleSparator + subTitleValue);
        } else {
            title.add(MainTitleValue);
        }
        return title;
    }

    public List<Element> getDMDSections() {
        return this.metsDoc.getRootElement().getChildren("dmdSec", C.METS_NS);
    }

    public HashMap<String, Element> getSections(String objectId) {
        HashMap<String, Element> IDtoSecElement = new HashMap<String, Element>();
        List<Element> dmdSections = this.getDMDSections();
        for (Element e : dmdSections) {
            String id = "";
            id = objectId + "-" + e.getAttribute("ID").getValue();
            IDtoSecElement.put(id, e);
        }
        return IDtoSecElement;
    }

    public static Element getModsXmlData(Element dmdSec) {
        return dmdSec.getChild("mdWrap", C.METS_NS).getChild("xmlData", C.METS_NS).getChild("mods", C.MODS_NS);
    }

    public String getHref(Element fileElement) {
        return fileElement.getChild("FLocat", C.METS_NS).getAttribute("href", this.XLINK_NS).getValue();
    }

    public List<Element> getFileElementsFromMetsDoc(Document doc) throws JDOMException {
        ArrayList<Element> currentFileElements = new ArrayList<Element>();
        List allNodes = this.metsXPath.selectNodes(doc);
        for (Object node : allNodes) {
            Element fileElement = (Element)node;
            currentFileElements.add(fileElement);
        }
        return currentFileElements;
    }

    public List<Element> getFileElements() {
        return this.fileElements;
    }

    public List<String> getReferences() {
        ArrayList<String> references = new ArrayList<String>();
        for (Element fileElement : this.fileElements) {
            String ref = this.getHref(fileElement);
            references.add(ref);
            this.logger.debug("Found reference " + ref);
        }
        this.logger.debug("number of existing references " + references.size());
        return references;
    }

    private String getReferenceFromFileId(String fileId) {
        String ref = "";
        try {
            for (Element fileElement : this.fileElements) {
                if (!fileElement.getAttributeValue("ID").equals(fileId)) continue;
                ref = this.getHref(fileElement);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to find the reference from file " + fileId);
        }
        return ref;
    }

    public HashMap<String, HashMap<String, List<String>>> getIndexInfo(String ObjectId) {
        HashMap<String, HashMap<String, List<String>>> indexInfo = new HashMap<String, HashMap<String, List<String>>>();
        HashMap<String, Element> dmdSections = this.getSections(ObjectId);
        for (String id : dmdSections.keySet()) {
            ArrayList<String> parentsDmdIds;
            List<String> titlePageRefs;
            Element e = dmdSections.get(id);
            HashMap<String, List<String>> dmdSecInfo = new HashMap<String, List<String>>();
            dmdSecInfo.put("dc:title", this.getTitle(e));
            List<String> accessConditions = this.getAccessConditions(e);
            dmdSecInfo.put("dc:rights", accessConditions);
            dmdSecInfo.put("edm:rights", accessConditions);
            dmdSecInfo.put("dc:identifier", this.getIdentifier(e));
            ArrayList<String> creators = new ArrayList<String>();
            ArrayList<String> contributors = new ArrayList<String>();
            for (Element name : this.getNameElements(e)) {
                String creator = this.getCreator(name);
                String contributor = this.getContributor(name);
                if (!creator.equals("")) {
                    creators.add(creator);
                }
                if (contributor.equals("")) continue;
                contributors.add(contributor);
            }
            dmdSecInfo.put("dc:creator", creators);
            dmdSecInfo.put("dc:contributor", contributors);
            ArrayList<String> datesIssued = new ArrayList<String>();
            ArrayList<String> datesCreated = new ArrayList<String>();
            ArrayList<String> publishers = new ArrayList<String>();
            for (Element origInfo : this.getOrigInfoElements(e)) {
                String dateIssued = this.getDateIssued(origInfo);
                String dateCreated = this.getDateCreated(origInfo);
                String publisher = this.getPublisher(origInfo);
                if (!dateIssued.equals("")) {
                    datesIssued.add(dateIssued);
                }
                if (!dateCreated.equals("")) {
                    datesCreated.add(dateCreated);
                }
                if (publisher.equals("")) continue;
                publishers.add(publisher);
            }
            dmdSecInfo.put("dcterms:issued", datesIssued);
            dmdSecInfo.put("dcterms:created", datesCreated);
            dmdSecInfo.put("dc:publisher", publishers);
            List<String> allPhysicalDescr = this.getPhysicalDescriptionFromDmdId(id, ObjectId);
            if (!allPhysicalDescr.isEmpty()) {
                dmdSecInfo.put("dcterms:extent", allPhysicalDescr);
            }
            if ((titlePageRefs = this.getTitlePageReferencesFromFrontimage()).isEmpty()) {
                titlePageRefs = this.getTitlePageReferencesFromDmdId(id, ObjectId);
            }
            List<String> allReferences = this.getReferencesFromDmdId(id, ObjectId);
            if (titlePageRefs != null & !titlePageRefs.isEmpty()) {
                ArrayList<String> references = new ArrayList<String>();
                references.add(titlePageRefs.get(0));
                dmdSecInfo.put("edm:isShownBy", references);
                dmdSecInfo.put("edm:object", references);
                if (titlePageRefs.size() > 1) {
                    dmdSecInfo.put("edm:hasView", titlePageRefs);
                }
            } else if (allReferences != null && !allReferences.isEmpty()) {
                ArrayList<String> firstReference = new ArrayList<String>();
                firstReference.add(allReferences.get(0));
                dmdSecInfo.put("edm:isShownBy", firstReference);
                dmdSecInfo.put("edm:object", firstReference);
            }
            if (allReferences.size() > 1) {
                dmdSecInfo.put("edm:hasView", allReferences);
            }
            dmdSecInfo.put("edm:dataProvider", this.getDataProvider());
            ArrayList<String> childrenDmdIds = this.getChildrenDmdIds(id, ObjectId);
            if (childrenDmdIds != null && !childrenDmdIds.isEmpty()) {
                dmdSecInfo.put("dcterms:hasPart", childrenDmdIds);
            }
            if ((parentsDmdIds = this.getParentDmdIds(id, ObjectId)) != null && !parentsDmdIds.isEmpty()) {
                dmdSecInfo.put("dcterms:isPartOf", parentsDmdIds);
            }
            indexInfo.put(id, dmdSecInfo);
        }
        return indexInfo;
    }

    public List<String> getAccessConditions(Element dmdSec) {
        ArrayList<String> retList = new ArrayList<String>();
        try {
            MetsLicense mLic = this.getLicense(dmdSec, false);
            if (mLic == null || mLic.getHref().trim().isEmpty()) {
                this.logger.error("Attribute accessCondition.href does not exist!!!");
            } else {
                retList.add(mLic.getHref());
            }
        }
        catch (Exception e) {
            this.logger.error("Element accessCondition does not exist!!!");
        }
        return retList;
    }

    public void setMimetype(Element fileElement, String mimetype) {
        if (fileElement.getAttribute("MIMETYPE") != null) {
            fileElement.getAttribute("MIMETYPE").setValue(mimetype);
        } else {
            fileElement.setAttribute("MIMETYPE", mimetype);
        }
    }

    public void setLoctype(Element fileElement, String loctype) {
        if (loctype != null) {
            if (fileElement.getChild("FLocat", C.METS_NS).getAttribute("LOCTYPE") != null) {
                fileElement.getChild("FLocat", C.METS_NS).getAttribute("LOCTYPE").setValue(loctype);
            } else {
                fileElement.getChild("FLocat", C.METS_NS).setAttribute("LOCTYPE", loctype);
            }
        }
    }

    public void setHref(Element fileElement, String newHref) {
        fileElement.getChild("FLocat", C.METS_NS).getAttribute("href", this.XLINK_NS).setValue(newHref);
    }
}

