/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ConsistencyChecker;
import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.utilities.SimpleResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagitConsistencyChecker
implements ConsistencyChecker {
    private static Logger logger = LoggerFactory.getLogger(BagitConsistencyChecker.class);
    String packagePath;
    List<String> messages;

    public BagitConsistencyChecker(String packagePath) {
        this.packagePath = packagePath;
        this.messages = new ArrayList<String>();
    }

    @Override
    public boolean checkPackage() {
        logger.debug("Starting BagIt consistency check.");
        BagFactory bagFactory = new BagFactory();
        Bag bag = bagFactory.createBag(new File(this.packagePath));
        SimpleResult result = bag.verifyValid();
        this.messages = result.getMessages();
        logger.debug("verifyPayloadManifest returned: " + bag.verifyPayloadManifests().isSuccess());
        logger.debug("verifyComplete returned: " + bag.verifyComplete().isSuccess());
        logger.debug("verifyTagManifests returned: " + bag.verifyTagManifests().isSuccess());
        logger.debug("verifyValid returned: " + bag.verifyValid().isSuccess());
        return result.isSuccess();
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }
}

