/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.PreBag;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagitUtils {
    static final Logger logger = LoggerFactory.getLogger(BagitUtils.class);

    public static void buildBagit(String packagePath) {
        if (new File(packagePath + "/bagit.txt").exists()) {
            new File(packagePath + "/bagit.txt").delete();
        }
        if (new File(packagePath + "/bag-info.txt").exists()) {
            new File(packagePath + "/bag-info.txt").delete();
        }
        if (new File(packagePath + "/manifest-md5.txt").exists()) {
            new File(packagePath + "/manifest-md5.txt").delete();
        }
        if (new File(packagePath + "/tagmanifest-md5.txt").exists()) {
            new File(packagePath + "/tagmanifest-md5.txt").delete();
        }
        BagFactory bagFactory = new BagFactory();
        PreBag preBag = bagFactory.createPreBag(new File(packagePath));
        preBag.makeBagInPlace(BagFactory.LATEST, false);
        Bag bag = bagFactory.createBag(new File(packagePath));
        if (!bag.verifyValid().isSuccess()) {
            throw new RuntimeException("BagIt couldn't be validated after its creation");
        }
        try {
            bag.close();
        }
        catch (IOException e) {
            logger.error("Error closing Bag at " + packagePath + " " + e.getStackTrace());
        }
    }
}

