/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.sb.SIPFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CopyUtility {
    private ProgressManager progressManager = null;
    private int jobId;
    private List<String> forbiddenFileExtensions = null;
    private SIPFactory.SipBuildingProcess sipBuildingProcess;

    public boolean copyDirectory(File source, File destination, List<String> forbiddenFileExtensions) throws IOException {
        this.forbiddenFileExtensions = forbiddenFileExtensions;
        return this.copy(source, destination);
    }

    public boolean copyDirectory(File source, File destination) throws IOException, IllegalArgumentException {
        return this.copy(source, destination);
    }

    private boolean copy(File source, File destination) throws IOException, IllegalArgumentException {
        if (this.sipBuildingProcess.isAborted()) {
            return false;
        }
        if (source.isDirectory()) {
            if (!source.getName().equals("thumbs") && !source.getName().equals("thumbnails")) {
                String[] files;
                if (!destination.exists()) {
                    destination.mkdir();
                }
                for (String file : files = source.list()) {
                    File srcFile = new File(source, file);
                    File destFile = new File(destination, file);
                    if (this.copy(srcFile, destFile)) continue;
                    return false;
                }
                destination.setLastModified(source.lastModified());
            }
        } else {
            if (!source.getName().equals(".DS_Store") && source.length() != 0L && this.checkFileExtension(source.getName())) {
                FileUtils.copyFile(source, destination);
            }
            if (this.progressManager != null) {
                this.progressManager.copyProgress(this.jobId, FileUtils.sizeOf(source));
            }
        }
        return true;
    }

    private boolean checkFileExtension(String fileName) {
        if (this.forbiddenFileExtensions != null) {
            for (String extension : this.forbiddenFileExtensions) {
                if (!fileName.endsWith(extension)) continue;
                return false;
            }
        }
        return true;
    }

    public void setProgressManager(ProgressManager progressManager) {
        this.progressManager = progressManager;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public void setSipBuildingProcess(SIPFactory.SipBuildingProcess sipBuildingProcess) {
        this.sipBuildingProcess = sipBuildingProcess;
    }
}

