/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.metadata.MetsParser;
import de.uzk.hki.da.utils.FormatDetectionService;
import de.uzk.hki.da.utils.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class NestedContentStructure {
    private Logger logger = Logger.getLogger(NestedContentStructure.class);
    public File rootFile;
    public HashMap<File, String> sipCandidatesWithUrns = new HashMap();

    public NestedContentStructure(File sourceRootFile) throws Exception {
        this.setRootFile(sourceRootFile);
        this.searchForSipCandidates(sourceRootFile);
    }

    public File getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(File rootFile) {
        this.rootFile = rootFile;
    }

    public HashMap<File, String> getSipCandidates() {
        return this.sipCandidatesWithUrns;
    }

    public void searchForSipCandidates(File dir) throws Exception {
        this.logger.info("Searching in folder " + dir + " for SIP candidates ...");
        File currentDir = dir;
        for (File f : currentDir.listFiles()) {
            if (f.isDirectory() && this.getIncludedDirs(f).isEmpty()) {
                List<File> metsFiles;
                this.logger.info("Current folder " + f + " is leaf");
                TreeMap<File, String> metadataFileWithType = new FormatDetectionService(f).getMetadataFileWithType();
                if (metadataFileWithType.isEmpty()) continue;
                File metadataFile = metadataFileWithType.firstKey();
                String metadataType = metadataFileWithType.get(metadataFile);
                this.logger.debug("Metadata file found: " + metadataFile + "; type : " + metadataType);
                if (!metadataType.equals("METS") || (metsFiles = this.getMetsFileFromDir(f)).size() != 1) continue;
                File metsFile = metsFiles.get(0);
                String urn = this.getUrn(metsFile);
                String newPackageName = urn.replace(":", "+");
                this.sipCandidatesWithUrns.put(f, newPackageName);
                continue;
            }
            if (!f.isDirectory()) {
                this.logger.info("Current folder " + f + " isn't directory. Skipping ...");
                continue;
            }
            this.logger.info("Current folder " + f + " isn't leaf directory");
            this.searchForSipCandidates(f);
        }
    }

    private List<File> getIncludedDirs(File dir) {
        this.logger.info("Check if file " + dir + " contains directories");
        ArrayList<File> dirs = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            this.logger.info("file " + f);
            if (!f.isDirectory()) continue;
            this.logger.debug("is a directory");
            dirs.add(f);
        }
        return dirs;
    }

    private List<File> getMetsFileFromDir(File dir) throws IOException {
        ArrayList<File> metsFiles = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            FormatDetectionService fds = new FormatDetectionService(f);
            if (!fds.isXml(f) || !fds.getMetadataTypeXml(f).equals("METS")) continue;
            metsFiles.add(f);
        }
        return metsFiles;
    }

    private String getUrn(File metsFile) throws IOException, JDOMException {
        String urn = "";
        try {
            Document metsDoc = this.getDocumentFromFile(metsFile);
            urn = new MetsParser(metsDoc).getUrn();
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
        catch (JDOMException e2) {
            throw new JDOMException("Invalid metadata file " + metsFile + ": \n\n" + e2);
        }
        return urn;
    }

    private Document getDocumentFromFile(File file) throws IOException, JDOMException {
        SAXBuilder builder = XMLUtils.createNonvalidatingSaxBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        BOMInputStream bomInputStream = new BOMInputStream(fileInputStream);
        InputStreamReader reader = new InputStreamReader((InputStream)bomInputStream, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        Document metsDoc = builder.build(is);
        fileInputStream.close();
        bomInputStream.close();
        ((Reader)reader).close();
        return metsDoc;
    }
}

