/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.sb;

import de.uzk.hki.da.sb.SIPCreationJob;
import java.util.HashMap;
import java.util.Map;

public abstract class ProgressManager {
    protected Map<Integer, SIPCreationJob> jobMap = new HashMap<Integer, SIPCreationJob>();
    protected long totalSize = 0L;
    public double totalProgress = 0.0;
    final double copyPercentage = 0.2;
    final double premisPercentage = 0.05;
    final double bagitPercentage = 0.2;
    final double archivePercentage = 0.5;
    final double deleteTempPercentage = 0.05;

    public void addJob(int id, String packageName, long folderSize) {
        SIPCreationJob job = new SIPCreationJob(id, packageName, folderSize);
        if (folderSize == 0L) {
            job.copyProgress = 100.0;
        }
        this.jobMap.put(id, job);
        this.totalSize += folderSize;
    }

    public void reset() {
        this.jobMap.clear();
        this.totalProgress = 0.0;
    }

    public abstract void abort();

    public void calculateProgressParts(boolean createCollection) {
        for (SIPCreationJob job : this.jobMap.values()) {
            if (job.id == -1) {
                job.progressPart = 5.0;
                continue;
            }
            if (job.folderSize == 0L) {
                if (this.jobMap.values().size() == 1) {
                    job.progressPart = 100.0;
                    continue;
                }
                job.progressPart = 0.0;
                continue;
            }
            if (createCollection) {
                job.progressPart = (double)job.folderSize / (double)this.totalSize * 95.0;
                continue;
            }
            job.progressPart = (double)job.folderSize / (double)this.totalSize * 100.0;
        }
    }

    public abstract void createStartMessage();

    public abstract void startJob(int var1);

    public void copyProgress(int id, long processedData) {
        SIPCreationJob job = this.jobMap.get(id);
        job.processedData += processedData;
        job.copyProgress = job.folderSize == 0L ? 0.0 : (double)job.processedData / (double)job.folderSize * (job.progressPart * 0.2);
        this.totalProgress = job.getProgress();
    }

    public void premisProgress(int id, double progress) {
        SIPCreationJob job = this.jobMap.get(id);
        job.premisProgress += progress * (job.progressPart * 0.05) / 100.0;
        this.totalProgress = job.getProgress();
    }

    public void bagitProgress(int id, double progress) {
        SIPCreationJob job = this.jobMap.get(id);
        job.bagitProgress = id == -1 ? (job.bagitProgress += progress * job.progressPart / 100.0) : (job.bagitProgress += progress * (job.progressPart * 0.2) / 100.0);
        this.totalProgress = job.getProgress();
    }

    public void archiveProgress(int id, long archivedData) {
        SIPCreationJob job = this.jobMap.get(id);
        job.archivedData += archivedData;
        job.archiveProgress = job.folderSize == 0L ? 0.0 : (double)job.archivedData / (double)job.folderSize * (job.progressPart * 0.5);
        this.totalProgress = job.getProgress();
    }

    public void deleteTempProgress(int id, double progress) {
        SIPCreationJob job = this.jobMap.get(id);
        job.deleteTempProgress += progress * (job.progressPart * 0.05) / 100.0;
        this.totalProgress = job.getProgress();
    }

    public void skipJob(int id) {
        SIPCreationJob job = this.jobMap.get(id);
        this.totalProgress = job.initialTotalProgress + job.progressPart;
    }

    public void createSuccessMessage(boolean skippedFiles) {
        this.totalProgress = 100.0;
    }

    public void setJobFolderSize(int id, long folderSize) {
        this.jobMap.get((Object)Integer.valueOf((int)id)).folderSize = folderSize;
    }
}

