/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.sb;

import de.uzk.hki.da.metadata.ContractRights;
import de.uzk.hki.da.metadata.FileExtensions;
import de.uzk.hki.da.metadata.LidoLicense;
import de.uzk.hki.da.metadata.LidoParser;
import de.uzk.hki.da.metadata.MetsLicense;
import de.uzk.hki.da.metadata.MetsParser;
import de.uzk.hki.da.metadata.NullLastComparator;
import de.uzk.hki.da.metadata.PremisXmlWriter;
import de.uzk.hki.da.pkg.CopyUtility;
import de.uzk.hki.da.pkg.NestedContentStructure;
import de.uzk.hki.da.pkg.SipArchiveBuilder;
import de.uzk.hki.da.sb.Feedback;
import de.uzk.hki.da.sb.MessageWriter;
import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.utils.FolderUtils;
import de.uzk.hki.da.utils.FormatDetectionService;
import de.uzk.hki.da.utils.Utilities;
import de.uzk.hki.da.utils.XMLUtils;
import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.PreBag;
import gov.loc.repository.bagit.utilities.SimpleResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class SIPFactory {
    private static Logger logger = Logger.getLogger(SIPFactory.class);
    private String sourcePath = null;
    private String destinationPath = null;
    private String workingPath = null;
    private KindOfSIPBuilding kindofSIPBuilding = null;
    private String name = null;
    private boolean createCollection;
    private String collectionName = null;
    private File collectionFolder = null;
    private ContractRights contractRights = new ContractRights();
    private FileExtensions fileExtensions = new FileExtensions();
    private HashMap<String, List<String>> fileExtensionsList = new HashMap();
    private File rightsSourcePremisFile = null;
    private SipBuildingProcess sipBuildingProcess;
    private boolean alwaysOverwrite;
    private boolean skippedFiles;
    private boolean ignoreZeroByteFiles = false;
    private boolean compress;
    private boolean tar = true;
    private String destDir = null;
    private boolean bagit = true;
    private boolean allowDuplicateFilename = false;
    private boolean checkFileExtensionOff = false;
    private List<String> forbiddenFileExtensions = null;
    private File listCreationTempFolder = null;
    private MessageWriter messageWriter;
    private ProgressManager progressManager;
    private Feedback returnCode;

    public void startSIPBuilding() {
        this.sipBuildingProcess = new SipBuildingProcess();
        this.sipBuildingProcess.start();
    }

    HashMap<File, String> createFolderList(String folderPath) throws Exception {
        HashMap<File, String> folderListWithFolderNames = new HashMap<File, String>();
        File sourceFolder = new File(folderPath);
        switch (this.kindofSIPBuilding) {
            case MULTIPLE_FOLDERS: {
                List<File> folderContent = Arrays.asList(sourceFolder.listFiles());
                for (File file : folderContent) {
                    if (file.isHidden() || !file.isDirectory()) continue;
                    folderListWithFolderNames.put(file, null);
                }
                break;
            }
            case SINGLE_FOLDER: {
                folderListWithFolderNames.put(sourceFolder, null);
                break;
            }
            case NESTED_FOLDERS: {
                try {
                    TreeMap<File, String> metadataFileWithType = new FormatDetectionService(sourceFolder).getMetadataFileWithType();
                    if (!metadataFileWithType.isEmpty() && !metadataFileWithType.get(metadataFileWithType.firstKey()).equals("METS")) {
                        this.messageWriter.showMessage("Es wurde eine Metadatendatei des Typs " + metadataFileWithType.get(metadataFileWithType.firstKey()) + " auf der obersten Ebene gefunden. \nBitte w\u00e4hlen Sie diese Option ausschlie\u00dflich f\u00fcr die Erstellung von SIPs des Typs METS.");
                        break;
                    }
                    NestedContentStructure ncs = new NestedContentStructure(sourceFolder);
                    folderListWithFolderNames = ncs.getSipCandidates();
                    if (!folderListWithFolderNames.isEmpty()) break;
                    this.messageWriter.showMessage("Es wurde kein Unterverzeichnis mit einer METS-Metadatendatei gefunden.");
                    break;
                }
                catch (IOException e) {
                    throw new Exception(e);
                }
            }
        }
        return folderListWithFolderNames;
    }

    private Feedback initializeProgressManager(List<File> folderList) {
        this.progressManager.reset();
        if (this.createCollection) {
            this.progressManager.addJob(-1, this.collectionName, 0L);
        }
        int i = 0;
        for (File folder : folderList) {
            if (!folder.exists()) {
                logger.error("Folder " + folder.getAbsolutePath() + " does not exist anymore.");
                return Feedback.COPY_ERROR;
            }
            this.progressManager.addJob(i, folder.getName(), FileUtils.sizeOfDirectory(folder));
            ++i;
        }
        this.progressManager.calculateProgressParts(this.createCollection);
        this.progressManager.createStartMessage();
        return Feedback.SUCCESS;
    }

    private String getTempFolderPath() {
        if (this.workingPath == null || this.workingPath.length() == 0) {
            return this.destinationPath + File.separator + this.getTempFolderName();
        }
        return this.workingPath + File.separator + this.getTempFolderName();
    }

    private Feedback buildSIP(int jobId, File sourceFolder, String newPackageName) {
        this.progressManager.startJob(jobId);
        String packageName = "";
        packageName = newPackageName != null ? newPackageName : this.getPackageName(sourceFolder);
        File tempFolder = new File(this.getTempFolderPath());
        File packageFolder = new File(tempFolder, packageName);
        Feedback feedback = this.copyFolder(jobId, sourceFolder, packageFolder);
        if (feedback != Feedback.SUCCESS) {
            this.rollback(tempFolder);
            return feedback;
        }
        feedback = this.checkMetadataForLicense(jobId, sourceFolder, packageFolder);
        if (feedback != Feedback.SUCCESS) {
            this.rollback(tempFolder);
            return feedback;
        }
        feedback = this.createPremisFile(jobId, packageFolder, packageName);
        if (feedback != Feedback.SUCCESS) {
            this.rollback(tempFolder);
            return feedback;
        }
        if (this.bagit && (feedback = this.createBag(jobId, packageFolder)) != Feedback.SUCCESS) {
            this.rollback(tempFolder);
            return feedback;
        }
        return this.packageFolder(jobId, sourceFolder, packageFolder, tempFolder, packageName);
    }

    public Feedback packageFolder(int jobId, File sourceFolder, File packageFolder, File tempFolder, String packageName) {
        Feedback feedback;
        if (this.tar) {
            String archiveFileName = packageName;
            archiveFileName = this.compress ? archiveFileName + ".tgz" : archiveFileName + ".tar";
            File archiveFile = new File(this.destinationPath + File.separator + archiveFileName);
            if (!this.checkForExistingSip(archiveFile)) {
                this.progressManager.skipJob(jobId);
                this.skippedFiles = true;
                return Feedback.SUCCESS;
            }
            File tmpArchiveFile = null;
            tmpArchiveFile = new File(this.workingPath + File.separator + archiveFileName);
            if (tmpArchiveFile.exists()) {
                tmpArchiveFile.delete();
            }
            if (Utilities.checkForZeroByteFiles(sourceFolder, packageName, this.messageWriter) && !this.ignoreZeroByteFiles) {
                String message = "WARNING: Found zero byte files in folder " + sourceFolder + ":\n";
                for (String s : this.messageWriter.getZeroByteFiles()) {
                    message = message + s;
                    message = message + "\n";
                }
                logger.info(message);
                return Feedback.ZERO_BYTES_ERROR;
            }
            feedback = this.buildArchive(jobId, packageFolder, tmpArchiveFile);
            if (feedback != Feedback.SUCCESS) {
                this.rollback(tempFolder, tmpArchiveFile);
                return feedback;
            }
            if (!this.getWorkingPath().equals(this.getDestinationPath()) && (feedback = this.moveFile(tmpArchiveFile, archiveFile)) != Feedback.SUCCESS) {
                this.rollback(tmpArchiveFile);
                this.rollback(archiveFile);
                return feedback;
            }
            feedback = this.deleteTempFolder(jobId, tempFolder);
            if (feedback != Feedback.SUCCESS) {
                return feedback;
            }
            if (this.createCollection && (feedback = this.moveSipToCollectionFolder(jobId, archiveFile)) != Feedback.SUCCESS) {
                return feedback;
            }
        } else {
            logger.debug("TempFolder : " + tempFolder + "   --  destinationPath  :  " + this.getDestinationPath());
            feedback = this.copyFolder(jobId, tempFolder, new File(this.getDestinationPath()));
            if (feedback != Feedback.SUCCESS) {
                return feedback;
            }
            feedback = this.deleteTempFolder(jobId, tempFolder);
            if (feedback != Feedback.SUCCESS) {
                return feedback;
            }
        }
        return feedback;
    }

    private Feedback moveFile(File tmpArchiveFile, File archiveFile) {
        try {
            try {
                FileUtils.moveFile(tmpArchiveFile, archiveFile);
            }
            catch (FileExistsException e) {
                archiveFile.delete();
                FileUtils.moveFile(tmpArchiveFile, archiveFile);
            }
        }
        catch (IOException e) {
            logger.error("Failed to copy " + tmpArchiveFile + " to " + archiveFile);
            return Feedback.ARCHIVE_ERROR;
        }
        return Feedback.SUCCESS;
    }

    private Feedback copyFolder(int jobId, File sourceFolder, File tempFolder) {
        this.progressManager.copyProgress(jobId, 0L);
        File dataFolder = new File(tempFolder, "data");
        dataFolder.mkdirs();
        CopyUtility copyUtility = new CopyUtility();
        copyUtility.setProgressManager(this.progressManager);
        copyUtility.setJobId(jobId);
        copyUtility.setSipBuildingProcess(this.sipBuildingProcess);
        try {
            if (!copyUtility.copyDirectory(sourceFolder, dataFolder, this.forbiddenFileExtensions)) {
                return Feedback.ABORT;
            }
        }
        catch (Exception e) {
            logger.error("Failed to copy folder " + sourceFolder.getAbsolutePath() + " to " + tempFolder.getAbsolutePath(), e);
            return Feedback.COPY_ERROR;
        }
        return Feedback.SUCCESS;
    }

    private Feedback checkMetadataForLicense(int jobId, File sourceFolder, File packageFolder) {
        boolean premisLicenseBool = this.contractRights.getCclincense() != null;
        boolean metsLicenseBool = false;
        boolean lidoLicenseBool = false;
        boolean publicationBool = this.contractRights.getPublicRights().getAllowPublication();
        boolean instPublicationBool = this.contractRights.getInstitutionRights().getAllowPublication();
        if (publicationBool || instPublicationBool) {
            try {
                TreeMap<File, String> metadataFileWithType = new FormatDetectionService(sourceFolder).getMetadataFileWithType();
                if (metadataFileWithType.containsValue("METS")) {
                    ArrayList<File> metsFiles = new ArrayList<File>();
                    ArrayList<MetsLicense> licenseMetsFile = new ArrayList<MetsLicense>();
                    for (File f : metadataFileWithType.keySet()) {
                        if (!metadataFileWithType.get(f).equals("METS")) continue;
                        metsFiles.add(f);
                    }
                    for (File f : metsFiles) {
                        SAXBuilder builder = XMLUtils.createNonvalidatingSaxBuilder();
                        Document metsDoc = builder.build(f);
                        MetsParser mp = new MetsParser(metsDoc);
                        licenseMetsFile.add(mp.getLicenseForWholeMets());
                    }
                    Collections.sort(licenseMetsFile, new NullLastComparator());
                    if (licenseMetsFile.get(0) == null) {
                        metsLicenseBool = false;
                    } else {
                        if (!((MetsLicense)licenseMetsFile.get(0)).equals(licenseMetsFile.get(licenseMetsFile.size() - 1))) {
                            return Feedback.INVALID_LICENSE_DATA_IN_METADATA;
                        }
                        metsLicenseBool = true;
                    }
                } else if (metadataFileWithType.containsValue("LIDO")) {
                    ArrayList<File> lidoFiles = new ArrayList<File>();
                    ArrayList<LidoLicense> licenseLidoFile = new ArrayList<LidoLicense>();
                    for (File f : metadataFileWithType.keySet()) {
                        if (!metadataFileWithType.get(f).equals("LIDO")) continue;
                        lidoFiles.add(f);
                    }
                    for (File f : lidoFiles) {
                        SAXBuilder builder = XMLUtils.createNonvalidatingSaxBuilder();
                        Document metsDoc = builder.build(f);
                        LidoParser lp = new LidoParser(metsDoc);
                        licenseLidoFile.add(lp.getLicenseForWholeLido());
                    }
                    Collections.sort(licenseLidoFile, new NullLastComparator());
                    if (licenseLidoFile.get(0) == null) {
                        lidoLicenseBool = false;
                    } else {
                        if (!((LidoLicense)licenseLidoFile.get(0)).equals(licenseLidoFile.get(licenseLidoFile.size() - 1))) {
                            return Feedback.INVALID_LICENSE_DATA_IN_METADATA;
                        }
                        lidoLicenseBool = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return Feedback.INVALID_LICENSE_DATA_IN_METADATA;
            }
        }
        if (publicationBool && premisLicenseBool && (metsLicenseBool || lidoLicenseBool)) {
            return Feedback.DUPLICATE_LICENSE_DATA;
        }
        if (publicationBool && !premisLicenseBool && !metsLicenseBool && !lidoLicenseBool) {
            return Feedback.PUBLICATION_NO_LICENSE;
        }
        logger.info("License is satisfiable: Premis-License:" + premisLicenseBool + " Mets-License:" + metsLicenseBool + " Lido-License:" + lidoLicenseBool + " Publication-Decision:" + publicationBool + " InstPublication-Decision:" + instPublicationBool);
        return Feedback.SUCCESS;
    }

    private Feedback createPremisFile(int jobId, File folder, String packageName) {
        this.progressManager.premisProgress(jobId, 0.0);
        File premisFile = null;
        premisFile = this.tar ? new File(folder, "data" + File.separator + "premis.xml") : new File(folder, "data" + File.separator + "premis.xml");
        PremisXmlWriter premisWriter = new PremisXmlWriter();
        try {
            if (this.rightsSourcePremisFile != null) {
                premisWriter.createPremisFile(this, premisFile, this.rightsSourcePremisFile, packageName);
            } else {
                premisWriter.createPremisFile(this, premisFile, packageName);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create premis file " + premisFile.getAbsolutePath(), e);
            return Feedback.PREMIS_ERROR;
        }
        this.progressManager.premisProgress(jobId, 100.0);
        if (this.sipBuildingProcess.isAborted()) {
            return Feedback.ABORT;
        }
        return Feedback.SUCCESS;
    }

    public Feedback createBag(int jobId, File folder) {
        this.progressManager.bagitProgress(jobId, 0.0);
        BagFactory bagFactory = new BagFactory();
        PreBag preBag = bagFactory.createPreBag(folder);
        preBag.makeBagInPlace(BagFactory.LATEST, false);
        this.progressManager.bagitProgress(jobId, 10.0);
        if (this.sipBuildingProcess.isAborted()) {
            return Feedback.ABORT;
        }
        Bag bag = bagFactory.createBag(folder);
        this.progressManager.bagitProgress(jobId, 40.0);
        if (this.sipBuildingProcess.isAborted()) {
            return Feedback.ABORT;
        }
        SimpleResult result = bag.verifyValid();
        if (result.isSuccess()) {
            this.progressManager.bagitProgress(jobId, 50.0);
            return Feedback.SUCCESS;
        }
        logger.error("Bag in folder " + folder.getAbsolutePath() + " is not valid.\n" + result.getErrorMessages());
        return Feedback.BAGIT_ERROR;
    }

    public Feedback buildArchive(int jobId, File folder, File archiveFile) {
        this.progressManager.setJobFolderSize(jobId, FileUtils.sizeOfDirectory(folder));
        this.progressManager.archiveProgress(jobId, 0L);
        SipArchiveBuilder archiveBuilder = null;
        try {
            archiveBuilder = new SipArchiveBuilder();
            archiveBuilder.setProgressManager(this.progressManager);
            archiveBuilder.setJobId(jobId);
            archiveBuilder.setSipBuildingProcess(this.sipBuildingProcess);
        }
        catch (Exception e) {
            logger.error("Failed to instantiate the ArchiveBuilder ", e);
            return Feedback.ABORT;
        }
        try {
            if (!archiveBuilder.archiveFolder(folder, archiveFile, true, this.compress)) {
                return Feedback.ABORT;
            }
        }
        catch (Exception e) {
            logger.error("Failed to archive folder " + folder.getAbsolutePath() + " to archive " + archiveFile.getAbsolutePath(), e);
            return Feedback.ARCHIVE_ERROR;
        }
        return Feedback.SUCCESS;
    }

    private Feedback deleteTempFolder(int jobId, File folder) {
        this.progressManager.deleteTempProgress(jobId, 0.0);
        try {
            FolderUtils.deleteDirectorySafe(folder);
        }
        catch (IOException e) {
            logger.warn("Failed to delete temp folder " + folder.getAbsolutePath(), e);
            return Feedback.DELETE_TEMP_FOLDER_WARNING;
        }
        this.progressManager.deleteTempProgress(jobId, 100.0);
        return Feedback.SUCCESS;
    }

    private Feedback moveSipToCollectionFolder(int jobId, File archiveFile) {
        try {
            FileUtils.moveFileToDirectory(archiveFile, new File(this.collectionFolder, "data"), false);
        }
        catch (IOException e) {
            logger.error("Failed to move file " + archiveFile.getAbsolutePath() + " to folder " + this.collectionFolder.getAbsolutePath(), e);
            return Feedback.MOVE_TO_COLLECTION_FOLDER_ERROR;
        }
        return Feedback.SUCCESS;
    }

    private boolean checkForExistingSip(File sip) {
        if (this.alwaysOverwrite) {
            return true;
        }
        if (sip.exists()) {
            MessageWriter.UserInput userInput = this.messageWriter.showOverwriteDialog("Im Ordner \"" + this.destinationPath + "\" existiert bereits ein SIP mit\ndem Namen \"" + FilenameUtils.getBaseName(sip.getAbsolutePath()) + "\".\n\nM\u00f6chten Sie das bestehende SIP \u00fcberschreiben?");
            switch (userInput) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
                case ALWAYS_OVERWRITE: {
                    this.alwaysOverwrite = true;
                    return true;
                }
            }
        }
        return true;
    }

    private String getPackageName(File folder) {
        String packageName = this.name != null && !this.name.equals("") ? this.name : folder.getName();
        return packageName;
    }

    private String getTempFolderName() {
        String tempFolderName;
        String baseName = "temp";
        if (!new File(this.destinationPath + File.separator + baseName).exists()) {
            return baseName;
        }
        int i = 0;
        do {
            tempFolderName = baseName + "_" + i++;
        } while (new File(this.destinationPath + File.separator + tempFolderName).exists());
        return tempFolderName;
    }

    private void rollback(File folder) {
        this.rollback(folder, null);
    }

    private void rollback(File folder, File archiveFile) {
        FolderUtils.deleteQuietlySafe(folder);
        if (archiveFile != null) {
            FolderUtils.deleteQuietlySafe(archiveFile);
        }
    }

    private void abortSipBuilding() {
        if (this.listCreationTempFolder != null && this.listCreationTempFolder.exists()) {
            FolderUtils.deleteQuietlySafe(this.listCreationTempFolder);
        }
        FolderUtils.deleteQuietlySafe(this.collectionFolder);
        this.progressManager.abort();
    }

    public void abort() {
        this.sipBuildingProcess.abort();
    }

    public boolean isWorking() {
        return this.sipBuildingProcess != null && this.sipBuildingProcess.isAlive();
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public KindOfSIPBuilding getKindofSIPBuilding() {
        return this.kindofSIPBuilding;
    }

    public void setKindofSIPBuilding(KindOfSIPBuilding kindofSIPBuilding) {
        this.kindofSIPBuilding = kindofSIPBuilding;
    }

    public void setKindofSIPBuilding(String kindofSIPBuildingName) {
        this.kindofSIPBuilding = Utilities.translateKindOfSIPBuilding(kindofSIPBuildingName);
    }

    public ContractRights getContractRights() {
        return this.contractRights;
    }

    public void setContractRights(ContractRights contractRights) {
        this.contractRights = contractRights;
    }

    public void setProgressManager(ProgressManager progressManager) {
        this.progressManager = progressManager;
    }

    public void setMessageWriter(MessageWriter messageWriter) {
        this.messageWriter = messageWriter;
    }

    public boolean getCreateCollection() {
        return this.createCollection;
    }

    public void setCreateCollection(boolean createCollection) {
        this.createCollection = createCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public File getRightsSourcePremisFile() {
        return this.rightsSourcePremisFile;
    }

    public void setRightsSourcePremisFile(File rightsSourcePremisFile) {
        this.rightsSourcePremisFile = rightsSourcePremisFile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getForbiddenFileExtensions() {
        return this.forbiddenFileExtensions;
    }

    public void setForbiddenFileExtensions(List<String> forbiddenFileExtensions) {
        this.forbiddenFileExtensions = forbiddenFileExtensions;
    }

    public File getListCreationTempFolder() {
        return this.listCreationTempFolder;
    }

    public void setListCreationTempFolder(File listCreationTempFolder) {
        this.listCreationTempFolder = listCreationTempFolder;
    }

    public void setIgnoreZeroByteFiles(boolean ignoreZeroByteFiles) {
        this.ignoreZeroByteFiles = ignoreZeroByteFiles;
    }

    public void setLogger(Logger logger) {
        SIPFactory.logger = logger;
    }

    public Feedback getReturnCode() {
        return this.returnCode;
    }

    public ProgressManager getProgressManager() {
        return this.progressManager;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public boolean isTar() {
        return this.tar;
    }

    public void setTar(boolean tar) {
        this.tar = tar;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public boolean isAllowDuplicateFilename() {
        return this.allowDuplicateFilename;
    }

    public void setAllowDuplicateFilename(boolean allowDuplicateFilename) {
        this.allowDuplicateFilename = allowDuplicateFilename;
    }

    public boolean isCheckFileExtensionOff() {
        return this.checkFileExtensionOff;
    }

    public void setCheckFileExtensionOff(boolean checkFileExtensionOff) {
        this.checkFileExtensionOff = checkFileExtensionOff;
    }

    public FileExtensions getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(FileExtensions fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public HashMap<String, List<String>> getFileExtensionsList() {
        return this.fileExtensionsList;
    }

    public void setFileExtensionsList(HashMap<String, List<String>> hashMap) {
        this.fileExtensionsList = hashMap;
    }

    public boolean isBagit() {
        return this.bagit;
    }

    public void setBagit(boolean bagit) {
        this.bagit = bagit;
    }

    public void setSipBuildingProcess(SipBuildingProcess sipBuildingProcess2) {
        this.sipBuildingProcess = sipBuildingProcess2;
    }

    public class SipBuildingProcess
    extends Thread {
        private boolean abortRequested = false;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            SIPFactory.this.alwaysOverwrite = false;
            SIPFactory.this.skippedFiles = false;
            SIPFactory.this.messageWriter.resetZeroByteFiles();
            SIPFactory.this.progressManager.reset();
            if (SIPFactory.this.createCollection) {
                SIPFactory.this.collectionFolder = new File(new File(SIPFactory.this.destinationPath), SIPFactory.this.collectionName);
                if (SIPFactory.this.collectionFolder.exists()) {
                    MessageWriter.UserInput answer = SIPFactory.this.messageWriter.showCollectionOverwriteDialog("Eine Lieferung mit dem Namen \"" + SIPFactory.this.collectionName + "\"existiert bereits.\nM\u00f6chten Sie die bestehende Lieferung \u00fcberschreiben?");
                    switch (answer) {
                        case YES: {
                            FolderUtils.deleteQuietlySafe(SIPFactory.this.collectionFolder);
                            break;
                        }
                        case NO: {
                            SIPFactory.this.progressManager.abort();
                            return;
                        }
                    }
                }
                new File(SIPFactory.this.collectionFolder, "data").mkdirs();
            }
            HashMap folderListWithNames = null;
            try {
                folderListWithNames = SIPFactory.this.createFolderList(SIPFactory.this.sourcePath);
                HashMap tmpFolderListWithNames = (HashMap)folderListWithNames.clone();
                for (File file : folderListWithNames.keySet()) {
                    String metadataType = "";
                    try {
                        TreeMap<File, String> metadataFileWithType = new FormatDetectionService(file).getMetadataFileWithType();
                        if (!metadataFileWithType.isEmpty()) {
                            File file2 = metadataFileWithType.firstKey();
                            metadataType = metadataFileWithType.get(file2);
                            if (this.duplicateFileNames(file, tmpFolderListWithNames)) continue;
                            Utilities.validateFileReferencesInMetadata(file2, metadataType);
                            continue;
                        }
                        this.duplicateFileNames(file, tmpFolderListWithNames);
                    }
                    catch (Error e) {
                        String msg;
                        if (metadataType.equals("EAD")) {
                            msg = "Aus dem Verzeichnis " + file + " wird kein SIP erstellt. \n" + e.getMessage();
                            SIPFactory.this.messageWriter.showLongErrorMessage(msg);
                            tmpFolderListWithNames.remove(file);
                            SIPFactory.this.returnCode = Feedback.WRONG_REFERENCES_IN_METADATA;
                            continue;
                        }
                        msg = e.getMessage() + " \nM\u00f6chten Sie die SIP-Erstellung dennoch fortsetzen?";
                        logger.error(msg);
                        MessageWriter.UserInput answer = SIPFactory.this.messageWriter.showWrongReferencesInMetadataDialog(msg);
                        SIPFactory.this.returnCode = Feedback.WRONG_REFERENCES_IN_METADATA;
                        switch (answer) {
                            case YES: {
                                break;
                            }
                            case NO: {
                                SIPFactory.this.messageWriter.showMessage("Aus dem Verzeichnis " + file + " wird kein SIP erstellt.");
                                tmpFolderListWithNames.remove(file);
                                break;
                            }
                        }
                    }
                }
                folderListWithNames = tmpFolderListWithNames;
                if (folderListWithNames.isEmpty()) {
                    SIPFactory.this.abortSipBuilding();
                    return;
                }
            }
            catch (Exception e) {
                SIPFactory.this.messageWriter.showLongErrorMessage("Das SIP konnte nicht erstellt werden.\n\nIhre Daten sind m\u00f6glicherweise nicht valide. \n\n" + e.getMessage());
                SIPFactory.this.returnCode = Feedback.INVALID_METADATA;
                SIPFactory.this.abortSipBuilding();
                return;
            }
            ArrayList<File> folderList = new ArrayList<File>();
            for (File file : folderListWithNames.keySet()) {
                folderList.add(file);
            }
            if (SIPFactory.this.initializeProgressManager(folderList) != Feedback.SUCCESS) {
                SIPFactory.this.messageWriter.showMessage("Das SIP konnte nicht erstellt werden.\n\nDer angegebene Ordner existiert nicht mehr. ", 0);
                SIPFactory.this.abortSipBuilding();
                return;
            }
            int id = 0;
            for (File folder : folderListWithNames.keySet()) {
                SIPFactory.this.returnCode = SIPFactory.this.buildSIP(id, folder, (String)folderListWithNames.get(folder));
                if (SIPFactory.this.returnCode != Feedback.SUCCESS && SIPFactory.this.returnCode != Feedback.DELETE_TEMP_FOLDER_WARNING) {
                    SIPFactory.this.abortSipBuilding();
                }
                switch (SIPFactory.this.returnCode) {
                    case COPY_ERROR: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte nicht erstellt werden.\n\nW\u00e4hrend des Kopiervorgangs ist ein Fehler aufgetreten.", 0);
                        return;
                    }
                    case ZERO_BYTES_ERROR: {
                        SIPFactory.this.messageWriter.showZeroByteFileMessage();
                        return;
                    }
                    case PREMIS_ERROR: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte nicht erstellt werden.\n\nW\u00e4hrend der Erstellung der Premis-Datei ist ein Fehler aufgetreten.", 0);
                        return;
                    }
                    case BAGIT_ERROR: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte nicht erstellt werden.\n\nW\u00e4hrend der Erzeugung des Bags ist ein Fehler aufgetreten.", 0);
                        return;
                    }
                    case ARCHIVE_ERROR: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte nicht erstellt werden.\n\nW\u00e4hrend der tgz-Archivierung ist ein Fehler aufgetreten.", 0);
                        return;
                    }
                    case DELETE_TEMP_FOLDER_WARNING: {
                        SIPFactory.this.messageWriter.showMessage("W\u00e4hrend der Bereinigung tempor\u00e4rer Daten ist ein Fehler aufgetreten.\n\nBitte l\u00f6schen Sie nicht ben\u00f6tigte verbleibende Verzeichnisse\nim Ordner \"" + SIPFactory.this.destinationPath + "\" manuell.", 0);
                        break;
                    }
                    case MOVE_TO_COLLECTION_FOLDER_ERROR: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte der Lieferung nicht hinzugef\u00fcgt werden.", 0);
                        return;
                    }
                    case INVALID_LICENSE_DATA_IN_METADATA: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte der Lieferung nicht hinzugef\u00fcgt werden.\nDie Lizenzangaben in den Metadaten sind ung\u00fcltig: Lizenzen nicht eindeutig interpretierbar.", 0);
                        return;
                    }
                    case DUPLICATE_LICENSE_DATA: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte der Lieferung nicht hinzugef\u00fcgt werden.\nDie Lizenzangaben sind nicht eindeutig: Lizenangaben d\u00fcrfen nicht gleichzeitig im SIP-Builder und in den Metadaten angegeben werden.", 0);
                        return;
                    }
                    case PUBLICATION_NO_LICENSE: {
                        SIPFactory.this.messageWriter.showMessage("Das SIP \"" + folder.getName() + "\" konnte der Lieferung nicht hinzugef\u00fcgt werden.\nDie Lizenzangaben sind nicht vorhanden: Um publizieren zu k\u00f6nnen, muss eine g\u00fcltige Lizenz angegeben werden.", 0);
                        return;
                    }
                    case ABORT: {
                        return;
                    }
                }
                ++id;
            }
            if (SIPFactory.this.listCreationTempFolder != null && SIPFactory.this.listCreationTempFolder.exists()) {
                FolderUtils.deleteQuietlySafe(SIPFactory.this.listCreationTempFolder);
            }
            if (SIPFactory.this.createCollection) {
                SIPFactory.this.progressManager.startJob(-1);
                if (SIPFactory.this.createBag(-1, SIPFactory.this.collectionFolder) == Feedback.BAGIT_ERROR) {
                    SIPFactory.this.messageWriter.showMessage("Die Lieferung \"" + SIPFactory.this.collectionName + "\" konnte nicht erstellt werden.\n\nW\u00e4hrend der Erzeugung des Bags ist ein Fehler aufgetreten.", 0);
                }
            }
            SIPFactory.this.progressManager.createSuccessMessage(SIPFactory.this.skippedFiles);
            if (SIPFactory.this.ignoreZeroByteFiles && SIPFactory.this.messageWriter.getZeroByteFiles().size() > 0) {
                void var4_11;
                String string = "WARNING: Found zero byte files:";
                for (String s : SIPFactory.this.messageWriter.getZeroByteFiles()) {
                    String string3 = (String)var4_11 + "\n";
                    string3 = string3 + s;
                }
                logger.info(var4_11);
                SIPFactory.this.messageWriter.showZeroByteFileMessage();
            }
        }

        public void abort() {
            this.abortRequested = true;
        }

        public boolean isAborted() {
            return this.abortRequested;
        }

        private boolean duplicateFileNames(File f, HashMap<File, String> tmpFolderListWithNames) {
            HashMap<String, List<File>> duplicateFileNames = this.getFilesWithDuplicateFileNames(f);
            if (!duplicateFileNames.isEmpty()) {
                if (!SIPFactory.this.allowDuplicateFilename) {
                    String msg = "Aus dem Verzeichnis " + f + " wird kein SIP erstellt. \nDer Ordner enth\u00e4lt gleichnamige Dateien: \n" + duplicateFileNames;
                    SIPFactory.this.messageWriter.showLongErrorMessage(msg);
                    tmpFolderListWithNames.remove(f);
                    SIPFactory.this.returnCode = Feedback.DUPLICATE_FILENAMES;
                    return true;
                }
                Iterator<String> it = duplicateFileNames.keySet().iterator();
                while (it.hasNext()) {
                    ArrayList<String> oldKeysExtension = new ArrayList<String>();
                    String key = it.next();
                    List<File> listDupFileNames = duplicateFileNames.get(key);
                    block1: for (int i = 0; listDupFileNames.size() > i; ++i) {
                        String extOfFile = FilenameUtils.getExtension(listDupFileNames.get(i).getAbsolutePath());
                        if (SIPFactory.this.checkFileExtensionOff) continue;
                        for (String keyExtensions : SIPFactory.this.getFileExtensionsList().keySet()) {
                            if (!SIPFactory.this.getFileExtensionsList().get(keyExtensions).contains(extOfFile)) continue;
                            if (oldKeysExtension.contains(keyExtensions)) {
                                String msg = "Aus dem Verzeichnis " + f + " wird kein SIP erstellt. \nDer Ordner enth\u00e4lt gleichnamige Dateien: \n" + duplicateFileNames.get(key);
                                SIPFactory.this.messageWriter.showLongErrorMessage(msg);
                                tmpFolderListWithNames.remove(f);
                                SIPFactory.this.returnCode = Feedback.DUPLICATE_FILENAMES;
                                return true;
                            }
                            oldKeysExtension.add(keyExtensions);
                            continue block1;
                        }
                    }
                }
            }
            return false;
        }

        private HashMap<String, List<File>> getFilesWithDuplicateFileNames(File folder) {
            logger.debug("Search for duplicate file names in folder " + folder);
            HashMap<String, List<File>> duplicateFilenamesWithFiles = new HashMap<String, List<File>>();
            HashMap<String, File> filenamesWithFiles = new HashMap<String, File>();
            for (File f : folder.listFiles()) {
                logger.debug("getFilesWithDuplicateFileNames: Check file " + f);
                if (f.isDirectory()) {
                    HashMap<String, List<File>> rekursivResult = this.getFilesWithDuplicateFileNames(f);
                    for (String rekf : rekursivResult.keySet()) {
                        if (duplicateFilenamesWithFiles.containsKey(rekf)) {
                            duplicateFilenamesWithFiles.get(rekf).addAll((Collection<File>)rekursivResult.get(rekf));
                            continue;
                        }
                        duplicateFilenamesWithFiles.put(rekf, rekursivResult.get(rekf));
                    }
                    continue;
                }
                File file = new File(f.getAbsolutePath());
                String ext = FilenameUtils.getExtension(file.getAbsolutePath());
                String relFilePathWithoutExtension = new File(f.getAbsolutePath()).getAbsolutePath().toString().replace(new File(f.getParent()).getAbsolutePath() + File.separator, "").replace(ext, "");
                logger.debug("relFilePathWithoutExtension: " + relFilePathWithoutExtension);
                if (filenamesWithFiles.get(relFilePathWithoutExtension) == null) {
                    logger.debug("New file name " + relFilePathWithoutExtension);
                    filenamesWithFiles.put(relFilePathWithoutExtension, f);
                    continue;
                }
                if (duplicateFilenamesWithFiles.get(relFilePathWithoutExtension) != null) {
                    logger.debug("One more file with file name " + relFilePathWithoutExtension + "\nFirst file is " + duplicateFilenamesWithFiles.get(relFilePathWithoutExtension));
                    duplicateFilenamesWithFiles.get(relFilePathWithoutExtension).add(f);
                    continue;
                }
                ArrayList<Object> duplicateFilenames = new ArrayList<Object>();
                logger.debug("Second file with the same file name. \n First file is " + filenamesWithFiles.get(relFilePathWithoutExtension));
                duplicateFilenames.add(filenamesWithFiles.get(relFilePathWithoutExtension));
                duplicateFilenames.add(f);
                duplicateFilenamesWithFiles.put(relFilePathWithoutExtension, duplicateFilenames);
            }
            return duplicateFilenamesWithFiles;
        }
    }

    public static enum KindOfSIPBuilding {
        MULTIPLE_FOLDERS,
        SINGLE_FOLDER,
        NESTED_FOLDERS;

    }
}

