/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.utils.IOTimeoutException;
import de.uzk.hki.da.utils.ProcessInformation;
import de.uzk.hki.da.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class CommandLineConnector {
    private static final int INTERVAL = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInformation runCmdSynchronously(String[] cmd, File workingDir, long timeout) throws IOTimeoutException, IOException {
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        this.logCmd(cmd, workingDir);
        Process p = null;
        ProcessInformation pi = null;
        try {
            p = this.startProcess(cmd, workingDir);
            this.waitForProcessToTerminate(p, timeout);
            pi = this.assembleProcessInformation(p);
        }
        finally {
            this.closeStreams(p);
        }
        return pi;
    }

    public ProcessInformation runCmdSynchronously(String[] cmd) throws IOTimeoutException, IOException {
        return this.runCmdSynchronously(cmd, null, 0L);
    }

    public ProcessInformation runCmdSynchronously(String[] cmd, long timeout) throws IOTimeoutException, IOException {
        return this.runCmdSynchronously(cmd, null, timeout);
    }

    public ProcessInformation runCmdSynchronously(String[] cmd, File workingDir) throws IOTimeoutException, IOException {
        return this.runCmdSynchronously(cmd, workingDir, 0L);
    }

    private void logCmd(String[] cmd, File workingDir) {
        if (workingDir == null || workingDir.equals("")) {
            StringUtilities.logger.debug("Running cmd \"{}\"", (Object)Arrays.toString(cmd));
        } else {
            StringUtilities.logger.debug("Running cmd \"{}\" in working dir \"{}\"", (Object)Arrays.toString(cmd), (Object)workingDir);
        }
    }

    private Process startProcess(String[] cmd, File workingDir) throws IOException {
        Process p = null;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (workingDir != null) {
            pb.directory(workingDir);
        }
        p = pb.start();
        return p;
    }

    private void waitForProcessToTerminate(Process p, long timeout) throws IOTimeoutException {
        int timeElapsed = 0;
        while (true) {
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((long)(timeElapsed += 100) <= timeout) continue;
                p.destroy();
                throw new IOTimeoutException("Process did not finish. Timeout at " + timeout + ".");
            }
            break;
        }
    }

    private ProcessInformation assembleProcessInformation(Process p) throws IOException {
        ProcessInformation pi = new ProcessInformation();
        pi.setStdErr(this.convertStream(p.getErrorStream()));
        pi.setStdOut(this.convertStream(p.getInputStream()));
        pi.setExitValue(p.exitValue());
        return pi;
    }

    private void closeStreams(Process p) throws IOException {
        if (p != null) {
            p.getInputStream().close();
            p.getErrorStream().close();
            p.getOutputStream().close();
        }
    }

    private String convertStream(InputStream is) throws IOException {
        int c2;
        String stdOut = "";
        InputStream outStr = is;
        while ((c2 = outStr.read()) != -1) {
            stdOut = stdOut + (char)c2;
        }
        outStr.close();
        return stdOut;
    }
}

