/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;

public class FormatDetectionService {
    private Logger logger = Logger.getLogger(FormatDetectionService.class);
    String eadPattern = ".*(?s)\\A.{0,1000}\\x3cead[^\\x3c]{0,1000}\\x3ceadheader.*";
    String metsPattern = ".*(?s)\\A.{0,1000}\\x3c([^: ]+:)?mets[^\\xce]{0,100}xmlns:?[^=]{0,10}=\"http://www.loc.gov/METS.*";
    String lidoPattern = ".*(?s)\\A.{0,1000}\\x3c([^: ]+:)?lidoWrap[^\\xce]{0,100}xmlns:?[^=]{0,10}=\"http://www.lido-schema.org.*";
    public File file;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FormatDetectionService(File f) {
        this.file = f;
    }

    public String detectMimeType(File f) throws IOException {
        String mimeType;
        Tika tika = new Tika();
        try {
            mimeType = tika.detect(f);
        }
        catch (IOException e) {
            throw new IOException("Unable to open file for mime type detection: " + this.file.getAbsolutePath(), e);
        }
        return mimeType;
    }

    public boolean isXml(File f) throws IOException {
        return !f.isDirectory() && this.detectMimeType(f).equals("application/xml");
    }

    public String getMetadataTypeXml(File xmlFile) throws IOException {
        String metadataType = "";
        String beginningOfFile = this.convertFirst10LinesOfFileToString(xmlFile);
        if (beginningOfFile.matches(this.metsPattern)) {
            metadataType = "METS";
        } else if (beginningOfFile.matches(this.eadPattern)) {
            metadataType = "EAD";
        } else if (beginningOfFile.matches(this.lidoPattern)) {
            metadataType = "LIDO";
        }
        return metadataType;
    }

    private String convertFirst10LinesOfFileToString(File f) throws IOException {
        String line;
        String result = "";
        BufferedReader br = new BufferedReader(new FileReader(f));
        int lineCount = 0;
        while ((line = br.readLine()) != null) {
            result = result + line;
            if (++lineCount != 10) continue;
        }
        br.close();
        return result;
    }

    public TreeMap<File, String> getMetadataFileWithType() throws Exception {
        File folder = this.file;
        this.logger.info("Get metadata type of package " + folder);
        TreeMap<File, String> fileWithType = new TreeMap<File, String>();
        ArrayList<File> eadFiles = new ArrayList<File>();
        ArrayList<File> metsFiles = new ArrayList<File>();
        ArrayList<File> lidoFiles = new ArrayList<File>();
        for (File f : folder.listFiles()) {
            this.logger.info("Check file " + f);
            if (!this.isXml(f)) continue;
            this.logger.info(f + " is a xml file");
            String mt = this.getMetadataTypeXml(f);
            if (mt.equals("METS")) {
                this.logger.info("of type METS");
                metsFiles.add(f);
                continue;
            }
            if (mt.equals("EAD")) {
                this.logger.info("of type EAD");
                eadFiles.add(f);
                continue;
            }
            if (!mt.equals("LIDO")) continue;
            this.logger.info("of type LIDO");
            lidoFiles.add(f);
        }
        if (eadFiles.size() + metsFiles.size() + lidoFiles.size() == 1) {
            if (eadFiles.size() == 1) {
                fileWithType.put((File)eadFiles.get(0), "EAD");
            }
            if (metsFiles.size() == 1) {
                fileWithType.put((File)metsFiles.get(0), "METS");
            }
            if (lidoFiles.size() == 1) {
                fileWithType.put((File)lidoFiles.get(0), "LIDO");
            }
        } else if (eadFiles.size() == 1 && metsFiles.size() >= 0) {
            fileWithType.put((File)eadFiles.get(0), "EAD");
        } else {
            if (eadFiles.size() + metsFiles.size() + lidoFiles.size() > 1) {
                throw new Exception("Im Verzeichnis " + folder.getName() + " wurde mehr als eine Metadatendatei gefunden. \nEAD: \n" + eadFiles + "\nMETS: \n" + metsFiles + "\nLIDO: \n" + lidoFiles);
            }
            if (eadFiles.size() + metsFiles.size() + lidoFiles.size() == 0) {
                this.logger.error("Im Verzeichnis " + folder.getName() + " wurde keine Metadatendatei gefunden. \nBekannte Formate sind: EAD, METS, LIDO.");
            }
        }
        this.logger.info("Identified metadata file " + fileWithType);
        return fileWithType;
    }
}

