/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.utils.RelativePath;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    List<String> finalPathArray = new ArrayList<String>();

    protected Path(Object ... list) {
        int argNo = 0;
        for (Object o : list) {
            ++argNo;
            if (o != null) {
                List<Object> partialPathArray = new ArrayList();
                if (o instanceof Path || o instanceof RelativePath || o instanceof String) {
                    String s = o.toString();
                    partialPathArray = Path.stringToPathArray(s);
                    for (int i = 0; i < partialPathArray.size(); ++i) {
                        this.finalPathArray.add((String)partialPathArray.get(i));
                    }
                    continue;
                }
                throw new IllegalArgumentException("the " + argNo + "th (counting from 1) argument was of incorrect data type. path or string expected");
            }
            throw new NullPointerException("the " + argNo + "th (counting from 1) argument was null");
        }
    }

    public static List<String> stringToPathArray(String currentString) {
        ArrayList<String> currentPathArray = new ArrayList<String>();
        String s = currentString;
        if (s.contains(File.separator)) {
            String[] newString = s.split(File.separator);
            for (int i = 0; i < newString.length; ++i) {
                if (newString[i].isEmpty() && newString[i].equals("")) continue;
                currentPathArray.add(newString[i]);
            }
        } else {
            currentPathArray.add(s);
        }
        return currentPathArray;
    }

    public static Path make(Object ... list) {
        if (list[0] instanceof RelativePath) {
            return new RelativePath(list);
        }
        return new Path(list);
    }

    public static File makeFile(Object ... list) {
        return Path.make(list).toFile();
    }

    public static String extractRelPathFromDir(File file, String dirName) {
        String relPath = "";
        int index = file.getAbsolutePath().indexOf(dirName) + dirName.length() + 1;
        relPath = file.getAbsolutePath().substring(index, file.getAbsolutePath().length());
        return relPath;
    }

    public String toString() {
        String directoryString = "";
        for (String i : this.finalPathArray) {
            directoryString = directoryString + File.separator + i;
        }
        return directoryString;
    }

    public File toFile() {
        return new File(this.toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path otherPath = (Path)o;
        if (this.finalPathArray.size() != otherPath.finalPathArray.size()) {
            return false;
        }
        if (!this.areOfSameType(this, otherPath)) {
            return false;
        }
        return this.containSameElements(this.finalPathArray, otherPath.finalPathArray);
    }

    private boolean containSameElements(List<String> lhs, List<String> rhs) {
        boolean equals = true;
        for (int i = 0; i < this.finalPathArray.size(); ++i) {
            if (this.finalPathArray.toArray()[i].equals(rhs.toArray()[i])) continue;
            equals = false;
        }
        return equals;
    }

    private boolean areOfSameType(Path t, Path o) {
        return !(t instanceof RelativePath ? !(o instanceof RelativePath) : o instanceof RelativePath);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getLastElement() {
        String lastElem = "";
        Iterator<String> iterator = this.finalPathArray.iterator();
        while (iterator.hasNext()) {
            String s;
            lastElem = s = iterator.next();
        }
        return lastElem;
    }
}

