/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.utils.CommandLineConnector;
import de.uzk.hki.da.utils.ProcessInformation;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifiedCommandLineConnector {
    private static Logger logger = LoggerFactory.getLogger(SimplifiedCommandLineConnector.class);
    private CommandLineConnector cl;

    public SimplifiedCommandLineConnector() {
        this.cl = new CommandLineConnector();
    }

    public SimplifiedCommandLineConnector(CommandLineConnector cl) {
        this.cl = cl;
    }

    public boolean execute(String[] cmd) {
        logger.trace("SimplifiedCommandLineConnector executing conversion command: {}", (Object)cmd.toString());
        ProcessInformation pi = null;
        try {
            pi = this.cl.runCmdSynchronously(cmd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (pi.getExitValue() != 0) {
            logger.error(this.getClass() + ": Recieved return code from terminal based command: " + pi.getExitValue());
            logger.error("cli conversion failed!\n\nstdOut: ------ \n\n\n" + pi.getStdOut() + "\n\n ----- end of stdOut\n\nstdErr: ------ \n\n\n" + pi.getStdErr() + "\n\n ----- end of stdErr");
            return false;
        }
        return true;
    }
}

