/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.cygwin;

import gov.loc.cygwin.CygwinException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;

public class Cygpath {
    private Cygpath() {
    }

    public static String toUnix(String path) throws CygwinException {
        String finalPath;
        if (OS.isFamilyWindows()) {
            ByteArrayOutputStream cygpathOut = new ByteArrayOutputStream();
            CommandLine cygPath = new CommandLine("cygpath");
            cygPath.addArgument("--unix");
            cygPath.addArgument(path);
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler(new PumpStreamHandler(cygpathOut));
                executor.execute(cygPath);
                finalPath = cygpathOut.toString().trim();
            }
            catch (ExecuteException e) {
                int exitValue = e.getExitValue();
                throw new CygwinException(MessageFormat.format("Error when executing \"{0}\" (exit value {2}: {1}", cygPath, cygpathOut.toString().trim(), exitValue), e);
            }
            catch (IOException e) {
                throw new CygwinException(MessageFormat.format("Error when executing \"{0}\": {1}", cygPath, cygpathOut.toString().trim()), e);
            }
        } else {
            finalPath = path;
        }
        return finalPath;
    }
}

