/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.Manifest;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManifestHelper {
    private static final Log log = LogFactory.getLog(ManifestHelper.class);

    public static boolean isPayloadManifest(String filename, Bag.BagConstants bagConstants) {
        return filename.startsWith(bagConstants.getPayloadManifestPrefix()) && filename.endsWith(bagConstants.getPayloadManifestSuffix());
    }

    public static boolean isTagManifest(String filename, Bag.BagConstants bagConstants) {
        return filename.startsWith(bagConstants.getTagManifestPrefix()) && filename.endsWith(bagConstants.getTagManifestSuffix());
    }

    public static Manifest.Algorithm getAlgorithm(String filename, Bag.BagConstants bagConstants) {
        String bagItAlgorithm;
        if (ManifestHelper.isPayloadManifest(filename, bagConstants)) {
            bagItAlgorithm = filename.substring(bagConstants.getPayloadManifestPrefix().length(), filename.length() - bagConstants.getPayloadManifestSuffix().length());
        } else if (ManifestHelper.isTagManifest(filename, bagConstants)) {
            bagItAlgorithm = filename.substring(bagConstants.getTagManifestPrefix().length(), filename.length() - bagConstants.getTagManifestSuffix().length());
        } else {
            throw new RuntimeException("Algorithm not found in manifest filename");
        }
        Manifest.Algorithm algorithm = Manifest.Algorithm.valueOfBagItAlgorithm(bagItAlgorithm);
        log.debug(MessageFormat.format("Determined that algorithm for {0} is {1}.", filename, algorithm.toString()));
        return algorithm;
    }

    public static String getTagManifestFilename(Manifest.Algorithm algorithm, Bag.BagConstants bagConstants) {
        return bagConstants.getTagManifestPrefix() + algorithm.bagItAlgorithm + bagConstants.getTagManifestSuffix();
    }

    public static String getPayloadManifestFilename(Manifest.Algorithm algorithm, Bag.BagConstants bagConstants) {
        return bagConstants.getPayloadManifestPrefix() + algorithm.bagItAlgorithm + bagConstants.getPayloadManifestSuffix();
    }
}

