/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtReader;
import gov.loc.repository.bagit.FetchTxtWriter;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFetchTxtImpl
extends ArrayList<FetchTxt.FilenameSizeUrl>
implements FetchTxt {
    protected static final Log log = LogFactory.getLog(AbstractFetchTxtImpl.class);
    private static final long serialVersionUID = 1L;
    protected Bag.BagConstants bagConstants;
    protected Bag.BagPartFactory bagPartFactory;
    protected BagFile sourceBagFile = null;
    protected String originalFixity = null;

    public abstract String getName();

    public AbstractFetchTxtImpl(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        this.init(bagConstants, bagPartFactory);
        log.info(MessageFormat.format("Creating new {0}.", this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFetchTxtImpl(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory, BagFile sourceBagFile) {
        this.init(bagConstants, bagPartFactory);
        log.info(MessageFormat.format("Creating {0}.", this.getName()));
        this.sourceBagFile = sourceBagFile;
        FetchTxtReader reader = bagPartFactory.createFetchTxtReader(sourceBagFile.newInputStream(), this.bagConstants.getBagEncoding());
        try {
            while (reader.hasNext()) {
                this.add(reader.next());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.originalFixity = MessageDigestHelper.generateFixity(this.generatedInputStream(), Manifest.Algorithm.MD5);
    }

    private void init(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        this.bagConstants = bagConstants;
        this.bagPartFactory = bagPartFactory;
    }

    @Override
    public InputStream newInputStream() {
        if (MessageDigestHelper.fixityMatches(this.generatedInputStream(), Manifest.Algorithm.MD5, this.originalFixity)) {
            return this.sourceBagFile.newInputStream();
        }
        return this.generatedInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream generatedInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FetchTxtWriter writer = this.bagPartFactory.createFetchTxtWriter(out);
        try {
            for (FetchTxt.FilenameSizeUrl filenameSizeUrl : this) {
                writer.write(filenameSizeUrl.getFilename(), filenameSizeUrl.getSize(), filenameSizeUrl.getUrl(), filenameSizeUrl.getFetchStatus());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public String getFilepath() {
        return this.getName();
    }

    @Override
    public long getSize() {
        InputStream in = this.newInputStream();
        long size = 0L;
        try {
            while (in.read() != -1) {
                ++size;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return size;
    }

    @Override
    public boolean exists() {
        return true;
    }
}

