/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchTxtReaderImpl
implements FetchTxtReader {
    private static final Log log = LogFactory.getLog(FetchTxtReaderImpl.class);
    private BufferedReader reader = null;
    private FetchTxt.FilenameSizeUrl next = null;

    public FetchTxtReaderImpl(InputStream in, String encoding) {
        try {
            InputStreamReader fr = new InputStreamReader(in, encoding);
            this.reader = new BufferedReader(fr);
            this.setNext();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException ex) {
            log.error(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        try {
            while (true) {
                String line;
                if ((line = this.reader.readLine()) == null) {
                    this.next = null;
                    return;
                }
                if ((line = line.trim()).length() <= 0) continue;
                String[] splitString = line.split("\\s+", 3);
                if (splitString.length == 3) {
                    Long size = null;
                    if (!"-".equals(splitString[1])) {
                        size = Long.parseLong(splitString[1]);
                    }
                    String[] subSplitString = splitString[2].split("\\s+", 2);
                    FetchTxt.FetchStatus status = null;
                    try {
                        status = FetchTxt.FetchStatus.valueOf(subSplitString[0].toUpperCase());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.next = status != null && subSplitString.length == 2 ? new FetchTxt.FilenameSizeUrl(subSplitString[1], size, splitString[0], status) : new FetchTxt.FilenameSizeUrl(splitString[2], size, splitString[0]);
                    return;
                }
                log.warn(MessageFormat.format("Invalid fetch line: {0}", line));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public FetchTxt.FilenameSizeUrl next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        FetchTxt.FilenameSizeUrl returnFilenameSizeUrl = this.next;
        this.setNext();
        log.debug("Read from fetch.txt: " + returnFilenameSizeUrl.toString());
        return returnFilenameSizeUrl;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

