/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ManifestReader;
import gov.loc.repository.bagit.ManifestWriter;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManifestImpl
extends LinkedHashMap<String, String>
implements Manifest {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ManifestImpl.class);
    private String name;
    private BagFile sourceBagFile = null;
    private String originalFixity = null;
    private Bag.BagConstants bagConstants;
    private Bag.BagPartFactory bagPartFactory;
    private String nonDefaultManifestSeparator = null;

    public ManifestImpl(String name, Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        this.init(name, bagConstants, bagPartFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManifestImpl(String name, Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory, BagFile sourceBagFile) {
        this.init(name, bagConstants, bagPartFactory);
        this.sourceBagFile = sourceBagFile;
        ManifestReader reader = bagPartFactory.createManifestReader(sourceBagFile.newInputStream(), bagConstants.getBagEncoding());
        try {
            while (reader.hasNext()) {
                ManifestReader.FilenameFixity filenameFixity = (ManifestReader.FilenameFixity)reader.next();
                this.put(filenameFixity.getFilename(), filenameFixity.getFixityValue());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.originalFixity = MessageDigestHelper.generateFixity(this.generatedInputStream(), Manifest.Algorithm.MD5);
    }

    private void init(String name, Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        log.debug("Creating manifest for " + name);
        this.name = name;
        this.bagConstants = bagConstants;
        this.bagPartFactory = bagPartFactory;
        if (!ManifestHelper.isPayloadManifest(name, bagConstants) && !ManifestHelper.isTagManifest(name, bagConstants)) {
            throw new RuntimeException("Invalid name");
        }
    }

    @Override
    public InputStream newInputStream() {
        if (MessageDigestHelper.fixityMatches(this.generatedInputStream(), Manifest.Algorithm.MD5, this.originalFixity)) {
            return this.sourceBagFile.newInputStream();
        }
        return this.generatedInputStream();
    }

    @Override
    public InputStream originalInputStream() {
        if (this.sourceBagFile == null) {
            return null;
        }
        return this.sourceBagFile.newInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream generatedInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ManifestWriter writer = this.bagPartFactory.createManifestWriter(out, this.nonDefaultManifestSeparator);
        try {
            for (String filename : this.keySet()) {
                writer.write(filename, (String)this.get(filename));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public String getFilepath() {
        return this.name;
    }

    @Override
    public Manifest.Algorithm getAlgorithm() {
        return ManifestHelper.getAlgorithm(this.name, this.bagConstants);
    }

    @Override
    public boolean isPayloadManifest() {
        return ManifestHelper.isPayloadManifest(this.name, this.bagConstants);
    }

    @Override
    public boolean isTagManifest() {
        return ManifestHelper.isTagManifest(this.name, this.bagConstants);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getSize() {
        InputStream in = this.newInputStream();
        long size = 0L;
        try {
            while (in.read() != -1) {
                ++size;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return size;
    }

    @Override
    public String getNonDefaultManifestSeparator() {
        return this.nonDefaultManifestSeparator;
    }

    @Override
    public void setNonDefaultManifestSeparator(String manifestSeparator) {
        this.nonDefaultManifestSeparator = manifestSeparator;
    }
}

