/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.ManifestReader;
import gov.loc.repository.bagit.utilities.FilenameHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManifestReaderImpl
implements ManifestReader {
    private static final Log log = LogFactory.getLog(ManifestReaderImpl.class);
    private BufferedReader reader = null;
    private ManifestReader.FilenameFixity next = null;
    private String splitRegex = null;
    private boolean treatBackwardSlashAsPathSeparator = false;

    public ManifestReaderImpl(InputStream in, String encoding, String splitRegex, boolean treatBackwardSlashAsPathSeparator) {
        this.splitRegex = splitRegex;
        this.treatBackwardSlashAsPathSeparator = treatBackwardSlashAsPathSeparator;
        try {
            InputStreamReader fr = new InputStreamReader(in, encoding);
            this.reader = new BufferedReader(fr);
            this.setNext();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        try {
            String line;
            String[] splitString;
            do {
                line = this.reader.readLine();
                log.trace("Line: " + line);
                if (line != null) continue;
                this.next = null;
                return;
            } while ((splitString = line.split(this.splitRegex, 2)).length != 2);
            String filepath = splitString[1];
            log.trace("Filepath before normalization: " + filepath);
            if (this.treatBackwardSlashAsPathSeparator) {
                filepath = FilenameHelper.normalizePathSeparators(filepath);
            } else if (filepath.indexOf(92) != -1) {
                throw new UnsupportedOperationException(MessageFormat.format("This Library does not support \\ in filepaths: {0}. See README.txt.", filepath));
            }
            filepath = FilenameHelper.normalizePath(filepath);
            log.trace("Filepath after normalization: " + filepath);
            this.next = new ManifestReader.FilenameFixity(filepath, splitString[0]);
            log.debug("Read: " + this.next);
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ManifestReader.FilenameFixity next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        ManifestReader.FilenameFixity returnFileFixity = this.next;
        this.setNext();
        log.debug("Read from manifest: " + returnFileFixity.toString());
        return returnFileFixity;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.reader);
    }
}

