/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.fetch.FetchStreamCopier;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public class HttpFetchProtocol
implements FetchProtocol {
    private static final Log log = LogFactory.getLog(HttpFetchProtocol.class);
    private ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
    private final DefaultHttpClient client = new DefaultHttpClient(this.connectionManager);

    public HttpFetchProtocol() {
        this.client.getParams().setParameter("http.useragent", "BagIt Library Parallel Fetcher");
        this.connectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        this.connectionManager.setMaxTotal(Integer.MAX_VALUE);
        this.client.getParams().setIntParameter("http.socket.timeout", 20000);
        this.client.getParams().setIntParameter("http.connection.timeout", 20000);
    }

    public void setRelaxedSsl(boolean relaxedSsl) {
        SSLSocketFactory sf;
        if (relaxedSsl) {
            try {
                sf = new SSLSocketFactory(new TrustSelfSignedStrategy(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        } else {
            sf = SSLSocketFactory.getSocketFactory();
        }
        Scheme https = new Scheme("https", 443, sf);
        this.connectionManager.getSchemeRegistry().register(https);
    }

    @Override
    public FileFetcher createFetcher(URI uri, Long size) throws BagTransferException {
        return new HttpFetcher();
    }

    private class HttpFetcher
    extends LongRunningOperationBase
    implements FileFetcher {
        private String username = null;
        private String password = null;

        private HttpFetcher() {
        }

        @Override
        public void initialize() throws BagTransferException {
        }

        @Override
        public void close() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void fetchFile(URI uri, Long size, FetchedFileDestination destination, FetchContext context) throws BagTransferException {
            log.trace(MessageFormat.format("Fetching {0} to destination {1}", uri, destination.getFilepath()));
            HttpGet method = new HttpGet(uri);
            InputStream in = null;
            OutputStream out = null;
            try {
                if (this.username != null && this.password != null) {
                    HttpFetchProtocol.this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.username, this.password));
                    HttpClientParams.setAuthenticating(HttpFetchProtocol.this.client.getParams(), true);
                    log.trace("Setting credentials for HttpClient.");
                } else {
                    HttpClientParams.setAuthenticating(HttpFetchProtocol.this.client.getParams(), false);
                }
                log.trace("Executing GET.");
                HttpResponse resp = HttpFetchProtocol.this.client.execute(method);
                log.trace(MessageFormat.format("Server said: {0}", resp.getStatusLine().toString()));
                if (resp.getStatusLine() == null || resp.getStatusLine().getStatusCode() != 200) {
                    throw new BagTransferException(MessageFormat.format("Server returned code {0}: {1}", resp.getStatusLine() != null ? Integer.valueOf(resp.getStatusLine().getStatusCode()) : "nothing", uri));
                }
                log.trace("Opening destination.");
                out = destination.openOutputStream(false);
                in = resp.getEntity().getContent();
                log.trace("Copying from network to destination.");
                FetchStreamCopier copier = new FetchStreamCopier("Downloading", uri, size);
                this.delegateProgress(copier);
                long bytesCopied = copier.copy(in, out);
                log.trace(MessageFormat.format("Successfully copied {0} bytes.", bytesCopied));
            }
            catch (IOException e) {
                try {
                    log.warn("Caught IOException.", e);
                    throw new BagTransferException(MessageFormat.format("Could not transfer URI: {0}", uri), e);
                    catch (RuntimeException e2) {
                        log.warn("Caught RuntimeException.", e2);
                        method.abort();
                        throw new BagTransferException(MessageFormat.format("Could not transfer URI: {0}", uri), e2);
                    }
                }
                catch (Throwable throwable) {
                    log.trace("Closing input stream.");
                    IOUtils.closeQuietly(in);
                    log.trace("Closing output stream.");
                    IOUtils.closeQuietly(out);
                    log.trace("Exiting finally clause.");
                    throw throwable;
                }
            }
            log.trace("Closing input stream.");
            IOUtils.closeQuietly(in);
            log.trace("Closing output stream.");
            IOUtils.closeQuietly(out);
            log.trace("Exiting finally clause.");
        }

        @Override
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public void setUsername(String username) {
            this.username = username;
        }
    }
}

