/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.fetch.FetchStreamCopier;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFileFetchProtocol
implements FetchProtocol {
    private static final Log log = LogFactory.getLog(LocalFileFetchProtocol.class);
    private static final LocalFileFetcher singleton = new LocalFileFetcher();

    @Override
    public FileFetcher createFetcher(URI uri, Long size) throws BagTransferException {
        return singleton;
    }

    private static class LocalFileFetcher
    extends LongRunningOperationBase
    implements FileFetcher {
        private LocalFileFetcher() {
        }

        @Override
        public void initialize() throws BagTransferException {
        }

        @Override
        public void close() {
        }

        @Override
        public void setPassword(String password) {
        }

        @Override
        public void setUsername(String username) {
        }

        @Override
        public void fetchFile(URI uri, Long size, FetchedFileDestination destination, FetchContext context) throws BagTransferException {
            String srcPath = uri.getPath();
            String dstPath = destination.getFilepath();
            log.trace(MessageFormat.format("Fetching local file from {0} to {1}", srcPath, dstPath));
            File src = new File(srcPath);
            FileInputStream in = null;
            OutputStream out = null;
            try {
                log.trace(MessageFormat.format("Opening input file: {0}", src.getAbsolutePath()));
                in = new FileInputStream(src);
                log.trace(MessageFormat.format("Opening output file: {0}", dstPath));
                out = destination.openOutputStream(false);
                log.trace("Copying...");
                FetchStreamCopier copier = new FetchStreamCopier("Copying", srcPath, src.length());
                this.delegateProgress(copier);
                long bytesCopied = copier.copy(in, out);
                log.trace(MessageFormat.format("Successfully copied {0} bytes.", bytesCopied));
            }
            catch (IOException e) {
                try {
                    throw new BagTransferException(MessageFormat.format("Unable to copy from \"{0}\" to \"{1}\".", srcPath, dstPath), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }
}

