/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities.namevalue.impl;

import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.utilities.namevalue.NameValueReader;
import gov.loc.repository.bagit.utilities.namevalue.impl.NameValueReaderImpl;
import gov.loc.repository.bagit.utilities.namevalue.impl.NameValueWriterImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;

public abstract class AbstractNameValueBagFile
extends LinkedHashMap<String, String>
implements BagFile {
    private static final long serialVersionUID = 1L;
    String filepath;
    BagFile sourceBagFile = null;
    String originalFixity = null;
    String encoding;

    public AbstractNameValueBagFile(String filepath, BagFile bagFile, String encoding) {
        this.filepath = filepath;
        this.sourceBagFile = bagFile;
        this.encoding = encoding;
        NameValueReaderImpl reader = new NameValueReaderImpl(encoding, this.sourceBagFile.newInputStream(), this.getType());
        while (reader.hasNext()) {
            NameValueReader.NameValue nameValue = (NameValueReader.NameValue)reader.next();
            this.put(nameValue.getName(), nameValue.getValue());
        }
        this.originalFixity = MessageDigestHelper.generateFixity(this.generatedInputStream(), Manifest.Algorithm.MD5);
    }

    public AbstractNameValueBagFile(String filepath, String encoding) {
        this.filepath = filepath;
        this.encoding = encoding;
    }

    @Override
    public String getFilepath() {
        return this.filepath;
    }

    @Override
    public InputStream newInputStream() {
        if (MessageDigestHelper.fixityMatches(this.generatedInputStream(), Manifest.Algorithm.MD5, this.originalFixity)) {
            return this.sourceBagFile.newInputStream();
        }
        return this.generatedInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream generatedInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NameValueWriterImpl writer = new NameValueWriterImpl(out, this.encoding, this.getType());
        try {
            for (String name : this.keySet()) {
                writer.write(name, (String)this.get(name));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getSize() {
        InputStream in = this.newInputStream();
        long size = 0L;
        try {
            while (in.read() != -1) {
                ++size;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return size;
    }

    public abstract String getType();
}

