/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities.namevalue.impl;

import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.utilities.namevalue.NameValueMapList;
import gov.loc.repository.bagit.utilities.namevalue.NameValueReader;
import gov.loc.repository.bagit.utilities.namevalue.impl.NameValueReaderImpl;
import gov.loc.repository.bagit.utilities.namevalue.impl.NameValueWriterImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public abstract class AbstractNameValueMapListBagFile
extends AbstractMap<String, String>
implements BagFile,
NameValueMapList {
    String filepath;
    BagFile sourceBagFile = null;
    String originalFixity = null;
    String encoding;
    protected List<NameValueReader.NameValue> nameValueList = new ArrayList<NameValueReader.NameValue>();

    public AbstractNameValueMapListBagFile(String filepath, BagFile bagFile, String encoding) {
        this.filepath = filepath;
        this.sourceBagFile = bagFile;
        this.encoding = encoding;
        NameValueReaderImpl reader = new NameValueReaderImpl(encoding, this.sourceBagFile.newInputStream(), this.getType());
        while (reader.hasNext()) {
            this.nameValueList.add((NameValueReader.NameValue)reader.next());
        }
        this.originalFixity = MessageDigestHelper.generateFixity(this.generatedInputStream(), Manifest.Algorithm.MD5);
    }

    public AbstractNameValueMapListBagFile(String filepath, String encoding) {
        this.filepath = filepath;
        this.encoding = encoding;
    }

    @Override
    public String getFilepath() {
        return this.filepath;
    }

    @Override
    public InputStream newInputStream() {
        if (MessageDigestHelper.fixityMatches(this.generatedInputStream(), Manifest.Algorithm.MD5, this.originalFixity)) {
            return this.sourceBagFile.newInputStream();
        }
        return this.generatedInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream generatedInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NameValueWriterImpl writer = new NameValueWriterImpl(out, this.encoding, this.getType());
        try {
            for (NameValueReader.NameValue nameValue : this.nameValueList) {
                writer.write(nameValue.getName(), nameValue.getValue());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getSize() {
        InputStream in = this.newInputStream();
        long size = 0L;
        try {
            while (in.read() != -1) {
                ++size;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return size;
    }

    public abstract String getType();

    public boolean containsKeyCaseInsensitive(String key) {
        return this.getCaseInsensitive(key) != null;
    }

    public String getActualKey(String key) {
        for (String name : this.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return name;
        }
        return null;
    }

    public String getCaseInsensitive(String key) {
        if (key == null) {
            return (String)this.get(key);
        }
        for (String name : this.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return (String)this.get(name);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        ArrayList<String> keys = new ArrayList<String>();
        HashSet<Map.Entry<String, String>> entrySet = new HashSet<Map.Entry<String, String>>();
        for (NameValueReader.NameValue nameValue : this.nameValueList) {
            if (keys.contains(nameValue.getName())) continue;
            entrySet.add(nameValue);
            keys.add(nameValue.getName());
        }
        return entrySet;
    }

    @Override
    public String put(String key, String value) {
        return this.put(new NameValueReader.NameValue(key, value));
    }

    @Override
    public String put(NameValueReader.NameValue nameValue) {
        for (int i = 0; i < this.nameValueList.size(); ++i) {
            if (!this.nameValueList.get(i).getName().equals(nameValue.getName())) continue;
            this.nameValueList.set(i, nameValue);
            return nameValue.getValue();
        }
        this.nameValueList.add(nameValue);
        return nameValue.getValue();
    }

    @Override
    public String remove(Object key) {
        for (NameValueReader.NameValue nameValue : this.nameValueList) {
            if (!nameValue.getName().equals(key)) continue;
            this.nameValueList.remove(nameValue);
            return nameValue.getValue();
        }
        return null;
    }

    @Override
    public List<String> getList(String key) {
        ArrayList<String> values = new ArrayList<String>();
        for (NameValueReader.NameValue nameValue : this.nameValueList) {
            if (!nameValue.getName().equals(key)) continue;
            values.add(nameValue.getValue());
        }
        return values;
    }

    @Override
    public void putList(String key, Collection<String> values) {
        for (String value : values) {
            this.putList(key, value);
        }
    }

    @Override
    public void putListAll(Collection<NameValueReader.NameValue> nameValues) {
        this.nameValueList.addAll(nameValues);
    }

    @Override
    public boolean removeList(NameValueReader.NameValue nameValue) {
        return this.nameValueList.remove(nameValue);
    }

    @Override
    public boolean removeList(String key, String value) {
        return this.removeList(new NameValueReader.NameValue(key, value));
    }

    @Override
    public Iterator<NameValueReader.NameValue> iterator() {
        return this.nameValueList.iterator();
    }

    @Override
    public List<NameValueReader.NameValue> asList() {
        return this.nameValueList;
    }

    @Override
    public int sizeList() {
        return this.nameValueList.size();
    }

    @Override
    public void putList(NameValueReader.NameValue nameValue) {
        this.nameValueList.add(nameValue);
    }

    @Override
    public void putList(String key, String value) {
        this.nameValueList.add(new NameValueReader.NameValue(key, value));
    }

    @Override
    public boolean removeAllList(String key) {
        ArrayList<NameValueReader.NameValue> toRemove = new ArrayList<NameValueReader.NameValue>();
        for (NameValueReader.NameValue nameValue : this.nameValueList) {
            if (!nameValue.getName().equals(key)) continue;
            toRemove.add(nameValue);
        }
        return this.nameValueList.removeAll(toRemove);
    }

    @Override
    public void clear() {
        this.nameValueList.clear();
    }
}

