/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.ProgressListenable;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.utilities.CancelUtil;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.CompleteVerifier;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.ManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.ValidVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidVerifierImpl
extends LongRunningOperationBase
implements ValidVerifier,
FailModeSupporting {
    private static final Log log = LogFactory.getLog(ValidVerifierImpl.class);
    private CompleteVerifier completeVerifier;
    private ManifestChecksumVerifier manifestVerifier;
    private FailModeSupporting.FailMode failMode = FailModeSupporting.FailMode.FAIL_STAGE;

    public ValidVerifierImpl(CompleteVerifier completeVerifier, ManifestChecksumVerifier manifestVerifier) {
        this.completeVerifier = completeVerifier;
        this.manifestVerifier = manifestVerifier;
    }

    @Override
    public void addProgressListener(ProgressListener progressListener) {
        super.addProgressListener(progressListener);
        if (this.completeVerifier instanceof ProgressListenable) {
            ((ProgressListenable)((Object)this.completeVerifier)).addProgressListener(progressListener);
        }
        if (this.manifestVerifier instanceof ProgressListenable) {
            ((ProgressListenable)((Object)this.manifestVerifier)).addProgressListener(progressListener);
        }
    }

    @Override
    public FailModeSupporting.FailMode getFailMode() {
        return this.failMode;
    }

    @Override
    public void setFailMode(FailModeSupporting.FailMode failMode) {
        this.failMode = failMode;
        if (this.completeVerifier instanceof FailModeSupporting) {
            ((FailModeSupporting)((Object)this.completeVerifier)).setFailMode(failMode);
        }
        if (this.manifestVerifier instanceof FailModeSupporting) {
            ((FailModeSupporting)((Object)this.manifestVerifier)).setFailMode(failMode);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        CancelUtil.cancel(this.completeVerifier);
        CancelUtil.cancel(this.manifestVerifier);
    }

    @Override
    public SimpleResult verify(Bag bag) {
        SimpleResult result = this.completeVerifier.verify(bag);
        if (this.isCancelled()) {
            return null;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
            return result;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_STEP == this.failMode) {
            return result;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_STAGE == this.failMode) {
            return result;
        }
        result.merge(this.manifestVerifier.verify(bag.getTagManifests(), bag));
        if (this.isCancelled()) {
            return null;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
            return result;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_STEP == this.failMode) {
            return result;
        }
        result.merge(this.manifestVerifier.verify(bag.getPayloadManifests(), bag));
        if (this.isCancelled()) {
            return null;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_FAST == this.failMode) {
            return result;
        }
        if (!result.isSuccess() && FailModeSupporting.FailMode.FAIL_STEP == this.failMode) {
            return result;
        }
        log.info("Completed verification that bag is valid.");
        log.info("Validity check: " + result.toString());
        return result;
    }
}

