/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.cli;

import de.uzk.hki.da.cli.CliMessageWriter;
import de.uzk.hki.da.cli.CliProgressManager;
import de.uzk.hki.da.main.SIPBuilder;
import de.uzk.hki.da.sb.Feedback;
import de.uzk.hki.da.sb.MessageWriter;
import de.uzk.hki.da.sb.SIPFactory;
import de.uzk.hki.da.sb.UserInputValidator;
import de.uzk.hki.da.utils.FolderUtils;
import de.uzk.hki.da.utils.SimpleLicenseAppender;
import de.uzk.hki.da.utils.StringUtilities;
import de.uzk.hki.da.utils.Utilities;
import de.uzk.hki.da.utils.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Cli {
    private static Logger logger = LogManager.getLogger(Cli.class);
    private String confFolderPath;
    private String[] args;
    private SIPFactory sipFactory;
    private boolean alwaysOverwrite = false;
    private File fileListFile = null;
    private File sipListFile = null;

    public Cli(String confFolderPath, String dataFolderPath, String[] args) {
        this.confFolderPath = confFolderPath;
        this.args = args;
        this.sipFactory = new SIPFactory();
    }

    public int start() {
        Feedback returnValue = this.configureCLI();
        if (returnValue != Feedback.SUCCESS) {
            return returnValue.toInt();
        }
        this.sipFactory.startSIPBuilding();
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (this.sipFactory.isWorking());
        return this.sipFactory.getReturnCode().toInt();
    }

    private Feedback configureCLI() {
        Feedback returnValue = this.configureSipFactory();
        if (returnValue != Feedback.SUCCESS) {
            return returnValue;
        }
        returnValue = this.checkConfiguration();
        if (returnValue != Feedback.SUCCESS) {
            return returnValue;
        }
        returnValue = this.copyFilesFromList();
        if (returnValue != Feedback.SUCCESS) {
            return returnValue;
        }
        returnValue = this.checkSourceFolder();
        if (returnValue != Feedback.SUCCESS) {
            return returnValue;
        }
        return returnValue;
    }

    public int startAppendLicense() {
        Feedback returnValue = this.configureCLI();
        if (returnValue != Feedback.SUCCESS) {
            if (returnValue.equals((Object)Feedback.SOURCE_FOLDER_NOT_FOUND)) {
                returnValue = Feedback.SUCCESS;
                System.out.println("F\u00fcr Lizenzerg\u00e4nzung ist der angegebene Quellordner eigentliche eine Quelldatei");
            } else {
                return returnValue.toInt();
            }
        }
        SimpleLicenseAppender licenser = new SimpleLicenseAppender();
        try {
            returnValue = licenser.startModifyExistingSip(this.sipFactory.getSourcePath(), this.sipFactory.getDestinationPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            returnValue = Feedback.PREMIS_ERROR;
        }
        return returnValue.toInt();
    }

    private Feedback configureSipFactory() {
        boolean contractRightsLoaded = false;
        boolean allowDuplicateFilename = false;
        boolean checkFileExtensionOff = false;
        CliMessageWriter messageWriter = new CliMessageWriter();
        this.sipFactory.setKindofSIPBuilding(SIPFactory.KindOfSIPBuilding.MULTIPLE_FOLDERS);
        this.sipFactory.setCreateCollection(false);
        this.sipFactory.setIgnoreZeroByteFiles(true);
        this.sipFactory.setCompress(true);
        this.sipFactory.setProgressManager(new CliProgressManager());
        for (String arg : this.args) {
            if (arg.equals("-help") || arg.equals("-h")) {
                this.showHelp();
                return Feedback.EXIT_AFTER_HELP;
            }
            if (arg.startsWith("-source")) {
                this.sipFactory.setSourcePath(this.extractParameter(arg));
                continue;
            }
            if (arg.startsWith("-filelist")) {
                this.fileListFile = new File(this.extractParameter(arg));
                if (this.fileListFile.exists()) continue;
                System.out.println("Die Datei " + this.fileListFile.getAbsolutePath() + " konnte nicht gefunden werden.");
                return Feedback.FILELIST_NOT_FOUND;
            }
            if (arg.startsWith("-siplist")) {
                this.sipListFile = new File(this.extractParameter(arg));
                if (this.sipListFile.exists()) continue;
                System.out.println("Die Datei " + this.sipListFile.getAbsolutePath() + " konnte nicht gefunden werden.");
                return Feedback.SIPLIST_NOT_FOUND;
            }
            if (arg.startsWith("-destination")) {
                this.sipFactory.setDestinationPath(this.extractParameter(arg));
                continue;
            }
            if (arg.startsWith("-workspace")) {
                this.sipFactory.setWorkingPath(this.extractParameter(arg));
                continue;
            }
            if (arg.startsWith("-premis")) {
                File premisFile = new File(this.extractParameter(arg));
                if (!premisFile.exists()) {
                    System.out.println("Die Datei " + premisFile.getAbsolutePath() + " konnte nicht gefunden werden.");
                    return Feedback.PREMIS_FILE_NOT_FOUND;
                }
                this.sipFactory.setRightsSourcePremisFile(premisFile);
                continue;
            }
            if (arg.startsWith("-rights")) {
                File contractRightsFile = new File(this.extractParameter(arg));
                if (!contractRightsFile.exists()) {
                    System.out.println("Die Datei " + contractRightsFile.getAbsolutePath() + " konnte nicht gefunden werden.");
                    return Feedback.RIGHTS_FILE_NOT_FOUND;
                }
                try {
                    this.sipFactory.getContractRights().loadContractRightsFromFile(contractRightsFile);
                }
                catch (Exception e) {
                    logger.error("Die Rechteeinstellungen aus der Datei " + contractRightsFile.getAbsolutePath() + " konnten nicht gelesen werden.");
                    logger.error("Failed to load contract rights from file " + contractRightsFile.getAbsolutePath(), (Throwable)e);
                    return Feedback.RIGHTS_FILE_READ_ERROR;
                }
                contractRightsLoaded = true;
                continue;
            }
            if (arg.equals("-single")) {
                this.sipFactory.setKindofSIPBuilding(SIPFactory.KindOfSIPBuilding.SINGLE_FOLDER);
                continue;
            }
            if (arg.startsWith("-single")) {
                this.sipFactory.setKindofSIPBuilding(SIPFactory.KindOfSIPBuilding.SINGLE_FOLDER);
                String name = this.extractParameter(arg);
                if (name == null) continue;
                this.sipFactory.setName(name);
                continue;
            }
            if (arg.equals("-nested")) {
                this.sipFactory.setKindofSIPBuilding(SIPFactory.KindOfSIPBuilding.NESTED_FOLDERS);
            }
            if (arg.startsWith("-collection")) {
                this.sipFactory.setCreateCollection(true);
                this.sipFactory.setCollectionName(this.extractParameter(arg));
                continue;
            }
            if (arg.equals("-alwaysOverwrite")) {
                messageWriter.setStandardAnswerAlwaysOverwrite(MessageWriter.UserInput.YES);
                this.alwaysOverwrite = true;
                continue;
            }
            if (arg.equals("-alwaysIgnoreWrongReferencesInMetadata")) {
                messageWriter.setStandardAnswerIgnoreWrongReferencesInMetadata(MessageWriter.UserInput.YES);
                continue;
            }
            if (arg.startsWith("-ignoreExtensions")) {
                this.sipFactory.setForbiddenFileExtensions(this.extractParameters(arg));
                continue;
            }
            if (arg.equals("-noCompression")) {
                this.sipFactory.setCompress(false);
                continue;
            }
            if (arg.equals("-noTar")) {
                this.sipFactory.setTar(false);
                continue;
            }
            if (arg.equals("-allowDuplicateFilename")) {
                this.sipFactory.setAllowDuplicateFilename(true);
                allowDuplicateFilename = true;
                continue;
            }
            if (arg.equals("-checkFileExtensionOff")) {
                this.sipFactory.setCheckFileExtensionOff(true);
                checkFileExtensionOff = true;
                continue;
            }
            if (!allowDuplicateFilename && checkFileExtensionOff) {
                System.out.println("-checkFileExtensionOff ist nicht ohne den Parameter -allowDuplicateFilename g\u00fcltig. Starten Sie den SipBuilder mit dem Parameter -help, um eine Liste aller m\u00f6glichen Parameter anzuzeigen.");
                return Feedback.INVALID_PARAMETER_COMBINATION;
            }
            if (arg.startsWith("-destDir")) {
                this.sipFactory.setDestinationPath(this.sipFactory.getDestinationPath() + File.separator + this.extractParameter(arg));
                continue;
            }
            if (arg.startsWith("-noBagit")) {
                this.sipFactory.setBagit(false);
                continue;
            }
            if (arg.equals("-onlyAddLicense") || arg.equals("-default") || arg.equals("-multiple") || arg.equals("-neverOverwrite") || arg.equals("-compression") || arg.equals("-nested")) continue;
            System.out.println(arg + " ist kein g\u00fcltiger Parameter. Starten Sie den SipBuilder mit dem Parameter -help, um eine Liste aller m\u00f6glichen Parameter anzuzeigen.");
            return Feedback.INVALID_PARAMETER;
        }
        if (this.sipFactory.isTar() && this.sipFactory.getDestDir() != null) {
            System.out.println("-destDir ist nicht ohne den Parameter -noTar g\u00fcltig. Starten Sie den SipBuilder mit dem Parameter -help, um eine Liste aller m\u00f6glichen Parameter anzuzeigen.");
            return Feedback.INVALID_PARAMETER_COMBINATION;
        }
        this.sipFactory.setMessageWriter(messageWriter);
        if (!contractRightsLoaded) {
            try {
                this.sipFactory.getContractRights().loadContractRightsFromFile(new File(this.confFolderPath + File.separator + "standardRights.xml"));
            }
            catch (Exception e) {
                System.out.println("Die Standardrechte konnten nicht aus der Datei \"" + this.confFolderPath + File.separator + "standardRights.xml\" geladen werden.");
                return Feedback.STANDARD_RIGHTS_FILE_READ_ERROR;
            }
        }
        if (allowDuplicateFilename && !checkFileExtensionOff) {
            try {
                this.sipFactory.setFileExtensionsList(this.sipFactory.getFileExtensions().loadFileExtensionsFromFile(new File(this.confFolderPath + File.separator + "fileExtensions.xml")));
            }
            catch (IOException e) {
                e.printStackTrace();
                return Feedback.FILE_EXTENSIONS_READ_ERROR;
            }
        }
        return Feedback.SUCCESS;
    }

    private Feedback checkConfiguration() {
        UserInputValidator.Feedback feedback;
        if (this.sipFactory.getCreateCollection() && this.sipFactory.getKindofSIPBuilding() == SIPFactory.KindOfSIPBuilding.SINGLE_FOLDER) {
            System.out.println("Die Parameter -single und -collection sind nicht miteinander kompatibel. Lieferungen k\u00f6nnen nur bei Erstellung mehrerer SIPs angelegt werden.");
            return Feedback.INVALID_PARAMETER_COMBINATION;
        }
        if (this.sipFactory.getDestinationPath() == null || this.sipFactory.getDestinationPath().equals("")) {
            System.out.println("Bitte geben Sie einen Zielordner an.");
            return Feedback.NO_DESTINATION_FOLDER;
        }
        if (this.sipFactory.getWorkingPath() == null || this.sipFactory.getWorkingPath().equals("")) {
            this.sipFactory.setWorkingPath(this.sipFactory.getDestinationPath());
        }
        if (this.sipFactory.getDestDir() == null || this.sipFactory.getDestDir().equals("")) {
            this.sipFactory.setDestDir("output");
        }
        if (this.sipFactory.getCreateCollection()) {
            feedback = UserInputValidator.checkCollectionName(this.sipFactory.getCollectionName(), this.sipFactory.getDestinationPath());
            switch (feedback) {
                case NO_COLLECTION_NAME: {
                    System.out.println("Bitte geben Sie den gew\u00fcnschten Namen der Lieferung an.");
                    return Feedback.NO_COLLECTION_NAME;
                }
                case INVALID_COLLECTION_NAME: {
                    System.out.println("Der von Ihnen gew\u00e4hlte Lieferungsname enth\u00e4lt Zeichen, die auf manchen Betriebssystemen f\u00fcr die Benennung von Dateien nicht erlaubt sind.");
                    return Feedback.INVALID_COLLECTION_NAME;
                }
                case COLLECTION_ALREADY_EXISTS: {
                    if (this.alwaysOverwrite) {
                        FolderUtils.deleteQuietlySafe(new File(new File(this.sipFactory.getDestinationPath()), this.sipFactory.getCollectionName()));
                        break;
                    }
                    System.out.println("Im Zielverzeichnis existiert bereits eine Lieferung namens \"" + this.sipFactory.getCollectionName() + "\". Bitte w\u00e4hlen Sie einen anderen Namen oder starten Sie den SIP-Builder mit dem Parameter -alwaysOverwrite, um die bestehende Lieferung zu \u00fcberschreiben.");
                    return Feedback.COLLECTION_ALREADY_EXISTS;
                }
            }
        }
        if (this.sipFactory.getName() != null && !this.sipFactory.getName().equals("")) {
            feedback = UserInputValidator.checkSipName(this.sipFactory.getName());
            switch (feedback) {
                case INVALID_SIP_NAME: {
                    System.out.println("Der von Ihnen gew\u00e4hlte SIP-Name enth\u00e4lt Zeichen, die auf manchen Betriebssystemen f\u00fcr\ndie Benennung von Dateien nicht erlaubt sind.");
                    return Feedback.INVALID_SIP_NAME;
                }
            }
        }
        return Feedback.SUCCESS;
    }

    private Feedback copyFilesFromList() {
        String sourcePath;
        if (this.fileListFile != null && this.sipListFile != null) {
            System.out.println("Die Parameter -filelist und -siplist sind nicht miteinander kompatibel.");
            return Feedback.INVALID_PARAMETER_COMBINATION;
        }
        if (this.fileListFile != null) {
            if (this.sipFactory.getName() == null) {
                System.out.println("Bitte geben Sie mithilfe des Parameters -single=\"[Name]\" einen Namen f\u00fcr das SIP an, wenn Sie das SIP per Dateiliste erstellen m\u00f6chten.");
                return Feedback.NO_SIP_NAME;
            }
            System.out.println("\nTrage Dateien aus der Dateiliste zusammen...");
            sourcePath = this.copySipContentToFolder(this.fileListFile);
            if (sourcePath.equals("")) {
                return Feedback.FILELIST_READ_ERROR;
            }
            this.sipFactory.setSourcePath(sourcePath);
            this.sipFactory.setListCreationTempFolder(new File(sourcePath).getParentFile());
        }
        if (this.sipListFile != null) {
            if (this.sipFactory.getKindofSIPBuilding() != SIPFactory.KindOfSIPBuilding.MULTIPLE_FOLDERS) {
                System.out.println("Die Parameter -single und -siplist sind nicht miteinander kompatibel. Bitte w\u00e4hlen Sie bei Verwendung einer SIP-Liste den Parameter -multiple.");
                return Feedback.INVALID_PARAMETER_COMBINATION;
            }
            System.out.println("\nTrage Dateien aus der SIP-Liste zusammen...");
            sourcePath = this.copySipListContentToFolder(this.sipListFile);
            if (sourcePath.equals("")) {
                return Feedback.SIPLIST_READ_ERROR;
            }
            this.sipFactory.setSourcePath(sourcePath);
            this.sipFactory.setListCreationTempFolder(new File(sourcePath));
        }
        return Feedback.SUCCESS;
    }

    private Feedback checkSourceFolder() {
        UserInputValidator.Feedback feedback = UserInputValidator.checkPaths(this.sipFactory.getSourcePath(), this.sipFactory.getDestinationPath(), this.sipFactory.getKindofSIPBuilding());
        switch (feedback) {
            case NO_SOURCE_PATH: {
                System.out.println("Bitte geben Sie einen Quellordner an.");
                return Feedback.NO_SOURCE_FOLDER;
            }
            case SOURCE_PATH_DOES_NOT_EXIST: {
                System.out.println("Der von Ihnen angegebene Quellordner existiert nicht.");
                return Feedback.SOURCE_FOLDER_NOT_FOUND;
            }
            case FOLDER_EQUALITY: {
                System.out.println("Bitte stellen Sie sicher, dass Quell- und Zielordner nicht identisch sind.");
                return Feedback.SOURCE_AND_DESTINATION_IDENTITY;
            }
            case SUBFOLDER: {
                System.out.println("Bitte stellen Sie sicher, dass der Zielordner kein Unterordner des Quellordners ist. ");
                return Feedback.DESTINATION_FOLDER_IS_SUBFOLDER_OF_SOURCE_FOLDER;
            }
            case NON_DIRECTORY_FILES_EXIST: {
                System.out.println("Das von Ihnen angegebene Quellverzeichnis enth\u00e4lt Dateien, die keine Ordner sind. Bitte \u00fcberpr\u00fcfen Sie, ob Sie die richtige Einstellung zur SIP-Generierung gew\u00e4hlt haben.");
                return Feedback.SOURCE_FOLDER_CONTAINS_NON_DIRECTORY_FILES;
            }
        }
        return Feedback.SUCCESS;
    }

    private String extractParameter(String arg) {
        System.out.println();
        int index = arg.indexOf(61);
        if (index == -1) {
            return null;
        }
        String parameter = arg.substring(index + 1);
        if (parameter.startsWith("\"")) {
            parameter = parameter.substring(1);
        }
        if (parameter.endsWith("\"")) {
            parameter = parameter.substring(0, parameter.length() - 1);
        }
        return parameter;
    }

    private List<String> extractParameters(String arg) {
        String parameter;
        ArrayList<String> parameters = new ArrayList<String>();
        int startIndex = arg.indexOf(61);
        if (startIndex == -1) {
            return null;
        }
        int stopIndex = arg.indexOf(59, startIndex);
        while (stopIndex != -1) {
            parameter = arg.substring(startIndex + 1, stopIndex);
            if (parameter.startsWith("\"")) {
                parameter = parameter.substring(1);
            }
            if (parameter.endsWith("\"")) {
                parameter = parameter.substring(0, parameter.length() - 2);
            }
            if (!parameter.equals("")) {
                parameters.add(parameter);
            }
            startIndex = stopIndex;
            stopIndex = arg.indexOf(59, startIndex + 1);
        }
        if (startIndex + 1 < arg.length() && (parameter = arg.substring(startIndex + 1)) != null && !parameter.equals("")) {
            parameters.add(parameter);
        }
        return parameters;
    }

    private String copySipContentToFolder(File fileListFile) {
        int index;
        CliProgressManager progressManager = new CliProgressManager();
        String tempFolderName = this.getTempFolderName();
        String fileList = "";
        try {
            fileList = StringUtilities.readFile(fileListFile);
        }
        catch (Exception e) {
            logger.error("Failed to read file " + fileListFile.getAbsolutePath(), (Throwable)e);
            System.out.println("Die Datei " + fileListFile.getAbsolutePath() + " konnte nicht gelesen werden.");
            return "";
        }
        fileList = fileList.replace("\r", "");
        if (!fileList.endsWith("\n")) {
            fileList = fileList + "\n";
        }
        long files = 0L;
        for (int i = 0; i < fileList.length(); ++i) {
            if (fileList.charAt(i) != '\n') continue;
            ++files;
        }
        progressManager.setTotalSize(files);
        File tempDirectory = new File(tempFolderName + File.separator + this.sipFactory.getName());
        tempDirectory.mkdirs();
        while ((index = fileList.indexOf(10)) >= 0) {
            String filepath = fileList.substring(0, index);
            fileList = fileList.substring(index + 1);
            File file = new File(filepath);
            if (!file.exists()) {
                logger.error("File " + file.getAbsolutePath() + " is referenced in filelist, but does not exist");
                System.out.println("\nDie in der Dateiliste angegebene Datei " + file.getAbsolutePath() + " existiert nicht.");
                FolderUtils.deleteQuietlySafe(tempDirectory);
                return "";
            }
            try {
                if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory(file, tempDirectory);
                } else {
                    FileUtils.copyFileToDirectory(file, tempDirectory);
                }
                progressManager.copyFilesFromListProgress();
            }
            catch (IOException e) {
                logger.error("Failed to copy file " + file.getAbsolutePath() + " to folder " + tempDirectory.getAbsolutePath(), (Throwable)e);
                System.out.println("\nDie in der Dateiliste angegebene Datei " + file.getAbsolutePath() + " konnte nicht kopiert werden.");
                FolderUtils.deleteQuietlySafe(tempDirectory);
                return "";
            }
        }
        return tempDirectory.getAbsolutePath();
    }

    private String copySipListContentToFolder(File sipListFile) {
        CliProgressManager progressManager = new CliProgressManager();
        String tempFolderName = this.getTempFolderName();
        XMLReader xmlReader = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            xmlReader = XMLUtils.createValidatingSaxParser().getXMLReader();
        }
        catch (Exception e) {
            logger.error("Failed to create SAX parser", (Throwable)e);
            System.out.println("Fehler beim Einlesen der SIP-Liste: SAX-Parser konnte nicht erstellt werden.");
            return "";
        }
        xmlReader.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw new SAXException("Beim Einlesen der SIP-Liste ist ein Fehler aufgetreten.", e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw new SAXException("Beim Einlesen der SIP-Liste ist ein schwerer Fehler aufgetreten.", e);
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                logger.warn("Warning while parsing siplist", (Throwable)e);
                System.out.println("\nWarnung:\n" + e.getMessage());
            }
        });
        try {
            int i;
            FileInputStream inputStream = new FileInputStream(sipListFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            Builder parser = new Builder(xmlReader);
            Document doc = parser.build(reader);
            ((Reader)reader).close();
            Element root = doc.getRootElement();
            Elements sipElements = root.getChildElements("sip");
            long files = 0L;
            for (i = 0; i < sipElements.size(); ++i) {
                Elements fileElements = sipElements.get(i).getChildElements("file");
                if (fileElements == null) continue;
                files += (long)fileElements.size();
            }
            progressManager.setTotalSize(files);
            for (i = 0; i < sipElements.size(); ++i) {
                Element sipElement = sipElements.get(i);
                String sipName = sipElement.getAttributeValue("name");
                File tempDirectory = new File(tempFolderName + File.separator + sipName);
                if (tempDirectory.exists()) {
                    FolderUtils.deleteQuietlySafe(new File(tempFolderName));
                    System.out.println("\nDie SIP-Liste enth\u00e4lt mehrere SIPs mit dem Namen " + sipName + ". Bitte vergeben Sie f\u00fcr jedes SIP einen eigenen Namen.");
                    return "";
                }
                tempDirectory.mkdirs();
                Elements fileElements = sipElement.getChildElements("file");
                for (int j = 0; j < fileElements.size(); ++j) {
                    Element fileElement = fileElements.get(j);
                    String filepath = fileElement.getValue();
                    File file = new File(filepath);
                    if (!file.exists()) {
                        logger.error("File " + file.getAbsolutePath() + " is referenced in siplist, but does not exist");
                        System.out.println("\nDie in der SIP-Liste angegebene Datei " + file.getAbsolutePath() + " existiert nicht.");
                        FolderUtils.deleteQuietlySafe(new File(tempFolderName));
                        return "";
                    }
                    try {
                        if (file.isDirectory()) {
                            FileUtils.copyDirectoryToDirectory(file, tempDirectory);
                        } else {
                            FileUtils.copyFileToDirectory(file, tempDirectory);
                        }
                        progressManager.copyFilesFromListProgress();
                        continue;
                    }
                    catch (IOException e) {
                        logger.error("Failed to copy file " + file.getAbsolutePath() + " to folder " + tempDirectory.getAbsolutePath(), (Throwable)e);
                        System.out.println("\nDie in der SIP-Liste angegebene Datei " + file.getAbsolutePath() + " konnte nicht kopiert werden.");
                        FolderUtils.deleteQuietlySafe(new File(tempFolderName));
                        return "";
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to read siplist " + sipListFile.getAbsolutePath(), (Throwable)e);
            System.out.println("\nBeim Lesen der SIP-Liste ist ein Fehler aufgetreten. ");
            return "";
        }
        return new File(tempFolderName).getAbsolutePath();
    }

    private String getTempFolderName() {
        String tempFolderName;
        String destinationPath = this.sipFactory.getDestinationPath();
        if (!new File(destinationPath + File.separator + "temp").exists()) {
            return destinationPath + File.separator + "temp";
        }
        int i = 0;
        do {
            tempFolderName = "temp_" + i++;
        } while (new File(destinationPath + File.separator + tempFolderName).exists());
        return destinationPath + File.separator + tempFolderName;
    }

    private void showHelp() {
        System.out.println("");
        System.out.println("");
        System.out.println(SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder Build: " + Utilities.getBuildNumber());
        System.out.println("");
        System.out.println("Aufruf: java -jar SipBuilder.jar [-source | -filelist | -siplist] -destination [Weitere Optionen]");
        System.out.println("");
        System.out.println("M\u00f6gliche Optionen:");
        System.out.println("   -source=\"[Pfad]\"          Angabe eines Quellordners, aus dem die SIPs erstellt werden sollen");
        System.out.println("   -filelist=\"[Pfad]\"        Angabe einer Textdatei, die die Pfade zu den Dateien enth\u00e4lt, aus denen das SIP erstellt werden soll");
        System.out.println("   -siplist=\"[Pfad]\"         Angabe einer XML-Datei, die die Pfade zu den Dateien enth\u00e4lt, aus denen SIPs erstellt werden sollen");
        System.out.println("   -workspace=\"[Pfad]\"       Angabe eines Arbeitsverzeichnis, das zur Zwischenspeicherung genutzt werden soll");
        System.out.println("");
        System.out.println("   -destination=\"[Pfad]\"     Angabe des Zielordners, in dem die SIPs erstellt werden sollen");
        System.out.println("");
        System.out.println("   -default                  Standardrechte verwenden (Standard)");
        System.out.println("   -rights=\"[Pfad]\"          Angabe der Contract Rights durch eine vormals per SIP-Builder erstellte Rechte-Datei");
        System.out.println("");
        System.out.println("   -multiple                 SIPs aus Unterordnern des Quellverzeichnisses erstellen");
        System.out.println("   -nested                   SIPs aus verzweigter Ordnerstruktur erstellen (nur METS)");
        System.out.println("   -single                   Ein SIP aus dem Quellverzeichnis erstellen");
        System.out.println("   -single=\"[Name]\"          Einzelnes SIP mit dem angegebenen Namen aus dem Quellordner erstellen");
        System.out.println("");
        System.out.println("");
        System.out.println("   -compression              SIPs als komprimierte tgz-Files erstellen (Standard)");
        System.out.println("   -noCompression            SIPs als unkomprimierte tar-Files erstellen");
        System.out.println("");
        System.out.println("   -noTar                    SIPs als Verzeichnis erstellen");
        System.out.println("");
        System.out.println("   -destDir=\"[Name]\"         Verzeichnisname, in dem das SIP erstellt werden soll (abh\u00e4ngig vom gew\u00e4hlten Zielordner). Darf nur in Kombination mit -noTar verwendet werden");
        System.out.println("");
        System.out.println("\t-noBagit\t\t\t\t  SIP ohne bagit erstellen");
        System.out.println("   -allowDuplicateFilename   SIP erstellen, auch wenn Metadaten und Daten den gleichen Dateinamen haben");
        System.out.println("   -checkFileExtensionOff\t SIP erstellen, auch wenn Metadaten und Daten den gleichen Dateinamen haben ohne Pr\u00fcfung auf die Dateiendung, Nur in Verbindung mit dem Parameter -allowDuplicateFilename");
        System.out.println("");
        System.out.println("   -neverOverwrite           SIPs nicht erstellen, wenn sich im Zielordner bereits ein SIP gleichen Namens befindet (Standard)");
        System.out.println("   -alwaysOverwrite          Bereits existierende SIPs/Lieferungen gleichen Namens im Zielordner ohne Nachfrage \u00fcberschreiben");
        System.out.println("   -alwaysIgnoreWrongReferencesInMetadata          SIPs trotz falscher Referenzen in den mitgelieferten Metadaten erstellen");
        System.out.println("");
        System.out.println("   -ignoreExtensions");
        System.out.println("       =\"ext1;ext2;ext3...\"  Dateien mit den angegebenen Dateiendungen nicht ins SIP aufnehmen");
        System.out.println("");
        System.out.println("   -help                     Diese Hilfe anzeigen");
    }
}

