/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ContractSettings {
    private static Logger logger = LogManager.getLogger(ContractSettings.class);
    private String[] duration = new String[4];
    private String[] widthImage = new String[3];
    private String[] heightImage = new String[3];
    private String[] percentImage = new String[3];
    private String[] opacityImage = new String[5];
    private String[] textSizeImage = new String[4];
    private String[] heightVideo = new String[3];

    public ContractSettings(String confFolderPath) throws Exception {
        File settingsFile = new File(confFolderPath + File.separator + "settings.xml");
        if (settingsFile.exists()) {
            this.loadContractSettingsFromFile(settingsFile);
        } else {
            this.setStandardSettings();
        }
    }

    private void loadContractSettingsFromFile(File settingsFile) throws IOException, ValidityException, ParsingException, NullPointerException, SAXException {
        XMLReader xmlReader = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            xmlReader = spf.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new IOException("Error creating SAX parser", e);
        }
        xmlReader.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw new SAXException("Error while parsing settings file", e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw new SAXException("Fatal error while parsing settings file", e);
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                logger.warn("Warning while parsing settings file:\n" + e.getMessage());
            }
        });
        FileReader reader = new FileReader(settingsFile);
        Builder parser = new Builder(xmlReader);
        Document doc = parser.build(reader);
        reader.close();
        Element root = doc.getRootElement();
        Element durationEl = root.getFirstChildElement("duration");
        this.duration[0] = durationEl.getFirstChildElement("firstOption").getValue();
        this.duration[1] = durationEl.getFirstChildElement("secondOption").getValue();
        this.duration[2] = durationEl.getFirstChildElement("thirdOption").getValue();
        this.duration[3] = durationEl.getFirstChildElement("fourthOption").getValue();
        Element imageEl = root.getFirstChildElement("image");
        Element widthImageEl = imageEl.getFirstChildElement("width");
        this.widthImage[0] = widthImageEl.getFirstChildElement("firstOption").getValue();
        this.widthImage[1] = widthImageEl.getFirstChildElement("secondOption").getValue();
        this.widthImage[2] = widthImageEl.getFirstChildElement("thirdOption").getValue();
        Element heightImageEl = imageEl.getFirstChildElement("height");
        this.heightImage[0] = heightImageEl.getFirstChildElement("firstOption").getValue();
        this.heightImage[1] = heightImageEl.getFirstChildElement("secondOption").getValue();
        this.heightImage[2] = heightImageEl.getFirstChildElement("thirdOption").getValue();
        Element percentImageEl = imageEl.getFirstChildElement("percent");
        this.percentImage[0] = percentImageEl.getFirstChildElement("firstOption").getValue();
        this.percentImage[1] = percentImageEl.getFirstChildElement("secondOption").getValue();
        this.percentImage[2] = percentImageEl.getFirstChildElement("thirdOption").getValue();
        Element opacityImageEl = imageEl.getFirstChildElement("opacity");
        this.opacityImage[0] = opacityImageEl.getFirstChildElement("firstOption").getValue();
        this.opacityImage[1] = opacityImageEl.getFirstChildElement("secondOption").getValue();
        this.opacityImage[2] = opacityImageEl.getFirstChildElement("thirdOption").getValue();
        this.opacityImage[3] = opacityImageEl.getFirstChildElement("fourthOption").getValue();
        this.opacityImage[4] = opacityImageEl.getFirstChildElement("fifthOption").getValue();
        Element textSizeImageEl = imageEl.getFirstChildElement("textSize");
        this.textSizeImage[0] = textSizeImageEl.getFirstChildElement("firstOption").getValue();
        this.textSizeImage[1] = textSizeImageEl.getFirstChildElement("secondOption").getValue();
        this.textSizeImage[2] = textSizeImageEl.getFirstChildElement("thirdOption").getValue();
        this.textSizeImage[3] = textSizeImageEl.getFirstChildElement("fourthOption").getValue();
        Element videoEl = root.getFirstChildElement("video");
        Element heightVideoEl = videoEl.getFirstChildElement("height");
        this.heightVideo[0] = heightVideoEl.getFirstChildElement("firstOption").getValue();
        this.heightVideo[1] = heightVideoEl.getFirstChildElement("secondOption").getValue();
        this.heightVideo[2] = heightVideoEl.getFirstChildElement("thirdOption").getValue();
    }

    private void setStandardSettings() {
        this.duration[0] = "5";
        this.duration[1] = "15";
        this.duration[2] = "60";
        this.duration[3] = "120";
        this.widthImage[0] = "480";
        this.widthImage[1] = "800";
        this.widthImage[2] = "1280";
        this.heightImage[0] = "360";
        this.heightImage[1] = "600";
        this.heightImage[2] = "960";
        this.percentImage[0] = "12.5%";
        this.percentImage[1] = "25%";
        this.percentImage[2] = "50%";
        this.opacityImage[0] = "5";
        this.opacityImage[1] = "10";
        this.opacityImage[2] = "25";
        this.opacityImage[3] = "50";
        this.opacityImage[4] = "100";
        this.textSizeImage[0] = "10";
        this.textSizeImage[1] = "20";
        this.textSizeImage[2] = "40";
        this.textSizeImage[3] = "60";
        this.heightVideo[0] = "360";
        this.heightVideo[1] = "720";
        this.heightVideo[2] = "1080";
    }

    public String getDuration(int index) {
        return this.duration[index];
    }

    public String getWidthImage(int index) {
        if (index <= 2) {
            return this.widthImage[index];
        }
        return this.percentImage[index - 3];
    }

    public String getHeightImage(int index) {
        if (index <= 2) {
            return this.heightImage[index];
        }
        return this.percentImage[index - 3];
    }

    public String getPercentImage(int index) {
        return this.percentImage[index];
    }

    public String getOpacityImage(int index) {
        return this.opacityImage[index];
    }

    public String getTextSizeImage(int index) {
        return this.textSizeImage[index];
    }

    public String getHeightVideo(int index) {
        return this.heightVideo[index];
    }

    public int getDurationIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.duration.length; ++i) {
            if (!value.equals(this.duration[i])) continue;
            return i;
        }
        return -1;
    }

    public int getWidthImageIndex(String value) {
        int i;
        if (value == null) {
            return -1;
        }
        for (i = 0; i < this.widthImage.length; ++i) {
            if (!value.equals(this.widthImage[i])) continue;
            return i;
        }
        for (i = 0; i < this.percentImage.length; ++i) {
            if (!value.equals(this.percentImage[i])) continue;
            return i + this.widthImage.length;
        }
        return -1;
    }

    public int getHeightImageIndex(String value) {
        int i;
        if (value == null) {
            return -1;
        }
        for (i = 0; i < this.heightImage.length; ++i) {
            if (!value.equals(this.heightImage[i])) continue;
            return i;
        }
        for (i = 0; i < this.percentImage.length; ++i) {
            if (!value.equals(this.percentImage[i])) continue;
            return i + this.heightImage.length;
        }
        return -1;
    }

    public int getOpacityImageIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.opacityImage.length; ++i) {
            if (!value.equals(this.opacityImage[i])) continue;
            return i;
        }
        return -1;
    }

    public int getTextSizeImageIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.textSizeImage.length; ++i) {
            if (!value.equals(this.textSizeImage[i])) continue;
            return i;
        }
        return -1;
    }

    public int getHeightVideoIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.heightVideo.length; ++i) {
            if (!value.equals(this.heightVideo[i])) continue;
            return i;
        }
        return -1;
    }
}

