/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EadParser {
    public Logger logger = LoggerFactory.getLogger(EadParser.class);
    private Document eadDoc = new Document();
    private Namespace EAD_NS;

    public EadParser(Document doc) throws JDOMException {
        this.eadDoc = doc;
        this.EAD_NS = this.eadDoc.getRootElement().getNamespace();
        this.logger.debug("Setting namespace " + this.EAD_NS);
    }

    public List<String> getReferences() throws JDOMException, IOException {
        ArrayList<String> metsReferences = new ArrayList<String>();
        String namespaceUri = this.eadDoc.getRootElement().getNamespace().getURI();
        XPath xPath = XPath.newInstance("//daoloc/@href");
        if (!namespaceUri.equals("")) {
            xPath = XPath.newInstance("//isbn:daoloc/@href");
            xPath.addNamespace("isbn", this.eadDoc.getRootElement().getNamespace().getURI());
        }
        List allNodes = xPath.selectNodes(this.eadDoc);
        for (Object node : allNodes) {
            Attribute attr = (Attribute)node;
            String href = attr.getValue();
            metsReferences.add(href);
        }
        return metsReferences;
    }

    List<String> getTitle(Element element) {
        ArrayList<String> title = new ArrayList<String>();
        String t = "";
        try {
            t = element.getChild("unittitle", this.EAD_NS).getValue();
        }
        catch (Exception e) {
            this.logger.error("No unittitle element found");
        }
        title.add(t);
        return title;
    }

    List<String> getDate(Element element) {
        ArrayList<String> date = new ArrayList<String>();
        String d = "";
        try {
            d = element.getChild("unitdate", this.EAD_NS).getAttribute("normal").getValue();
            if (d.equals("")) {
                d = element.getChild("unitdate", this.EAD_NS).getValue();
            }
        }
        catch (Exception e) {
            this.logger.debug("No unitdate element found");
        }
        date.add(d);
        return date;
    }

    List<String> getUnitIDs(Element did) {
        ArrayList<String> unitIDs = new ArrayList<String>();
        List children = did.getChildren("unitid", this.EAD_NS);
        for (Element child : children) {
            String unitID = "";
            try {
                unitID = child.getValue();
                if (unitID.equals("")) continue;
                unitIDs.add(unitID);
            }
            catch (Exception e) {
                this.logger.debug("No unitid element found");
            }
        }
        return unitIDs;
    }

    List<String> getHref(Element daogrp) {
        ArrayList<String> hrefs = new ArrayList<String>();
        String href = "";
        try {
            href = daogrp.getChild("daoloc", this.EAD_NS).getAttributeValue("href");
        }
        catch (Exception e) {
            this.logger.debug("No unitdate element found");
        }
        hrefs.add(href);
        return hrefs;
    }
}

