/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import de.uzk.hki.da.main.SIPBuilder;
import de.uzk.hki.da.metadata.ContractRights;
import de.uzk.hki.da.metadata.PublicationRights;
import de.uzk.hki.da.sb.SIPFactory;
import de.uzk.hki.da.utils.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PremisXmlWriter {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat dayDateFormat = new SimpleDateFormat("yyyy-MM-dd'T00:00:00.000+01:00'");
    private XMLStreamWriter writer = null;

    public void createPremisFile(SIPFactory sip, File f, String packageName) throws Exception {
        this.createPremisFile(sip, f, null, packageName);
    }

    public void createPremisFile(SIPFactory sip, File f, File rightsSourcePremisFile, String packageName) throws Exception {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        FileOutputStream outputStream = new FileOutputStream(f);
        try {
            this.writer = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to create XMLStreamWriter", e);
        }
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createOpenElement("premis", 0);
            this.createAttribute("xmlns", "info:lc/xmlns/premis-v2");
            this.createAttribute("xmlns:premis", "info:lc/xmlns/premis-v2");
            this.createAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.createAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "info:lc/xmlns/premis-v2 http://www.loc.gov/standards/premis/v2/premis-v2-2.xsd");
            this.createAttribute("version", "2.2");
            this.generateObjectElement(packageName);
            this.generateEventElement(packageName);
            this.generateAgentElement();
            if (rightsSourcePremisFile == null) {
                this.generateRightsElement(sip.getContractRights());
            } else {
                this.copyRightsElementFromPremisFile(rightsSourcePremisFile);
            }
            this.createCloseElement(0);
            this.writer.writeDTD("\n");
            this.writer.writeEndDocument();
            this.writer.close();
            outputStream.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize premis.xml", e);
        }
    }

    public void createContractRightsFile(ContractRights contractRights, File f) throws Exception {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        FileOutputStream outputStream = new FileOutputStream(f);
        try {
            this.writer = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to create XMLStreamWriter", e);
        }
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.createOpenElement("contractRights", 0);
            this.createOpenElement("institutionRights", 1);
            this.generatePublicationRightsElement(contractRights.getInstitutionRights());
            this.createCloseElement(1);
            this.createOpenElement("publicRights", 1);
            this.generatePublicationRightsElement(contractRights.getPublicRights());
            this.createCloseElement(1);
            this.createOpenElement("conversionRights", 1);
            this.createTextElement("condition", contractRights.getConversionCondition().toString(), 2);
            this.createCloseElement(1);
            this.createTextElement("ddbExclusion", String.valueOf(contractRights.getDdbExclusion()), 1);
            if (contractRights.getCclincense() != null) {
                this.generatePublicationLicenseElement(contractRights.getCclincense(), 1);
            }
            if (contractRights.getMinimalIngestQuality() > 0) {
                this.createTextElement("minimalIngestQualityLevel", String.valueOf(contractRights.getMinimalIngestQuality()), 1);
            }
            this.createCloseElement(0);
            this.writer.writeDTD("\n");
            this.writer.writeEndDocument();
            this.writer.close();
            outputStream.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize contract rights", e);
        }
    }

    private void generatePublicationLicenseElement(ContractRights.CCLicense license, int level) throws XMLStreamException {
        this.createOpenElement("publicationLicense", level);
        this.createAttribute("href", license.getHref());
        this.createAttribute("displayLabel", license.getDisplayLabel());
        this.writer.writeCharacters(license.getText());
        this.writer.writeEndElement();
    }

    private void generatePublicationRightsElement(PublicationRights pubRights) throws Exception {
        this.createTextElement("allowed", String.valueOf(pubRights.getAllowPublication()), 2);
        this.createTextElement("tempPublication", String.valueOf(pubRights.getTempPublication()), 2);
        this.createTextElement("lawPublication", String.valueOf(pubRights.getLawPublication()), 2);
        if (pubRights.getStartDate() != null) {
            this.createTextElement("startDate", this.formatDate(pubRights.getStartDate(), dayDateFormat), 2);
        }
        if (pubRights.getLaw() != null) {
            this.createTextElement("law", pubRights.getLaw().toString(), 2);
        }
        this.createOpenElement("restrictions", 2);
        this.createTextElement("textRestriction", String.valueOf(pubRights.getTextRestriction()), 3);
        this.createTextElement("imageRestriction", String.valueOf(pubRights.getImageRestriction()), 3);
        this.createTextElement("imageRestrictionText", String.valueOf(pubRights.getImageRestrictionText()), 3);
        this.createTextElement("audioRestriction", String.valueOf(pubRights.getAudioRestriction()), 3);
        this.createTextElement("videoRestriction", String.valueOf(pubRights.getVideoRestriction()), 3);
        this.createTextElement("videoDurationRestriction", String.valueOf(pubRights.getVideoDurationRestriction()), 3);
        if (pubRights.getPages() != null && !pubRights.getPages().equals("")) {
            this.createTextElement("pages", pubRights.getPages(), 3);
        }
        if (pubRights.getImageWidth() != null && !pubRights.getImageWidth().equals("")) {
            this.createTextElement("imageWidth", pubRights.getImageWidth(), 3);
        }
        if (pubRights.getImageHeight() != null && !pubRights.getImageHeight().equals("")) {
            this.createTextElement("imageHeight", pubRights.getImageHeight(), 3);
        }
        if (pubRights.getFooterText() != null && !pubRights.getFooterText().equals("")) {
            this.createTextElement("footerText", pubRights.getFooterText(), 3);
        }
        if (pubRights.getImageTextType() != null) {
            this.createTextElement("imageTextType", pubRights.getImageTextType().toString(), 3);
        }
        if (pubRights.getWatermarkOpacity() != null) {
            this.createTextElement("watermarkOpacity", pubRights.getWatermarkOpacity(), 3);
        }
        if (pubRights.getWatermarkSize() != null) {
            this.createTextElement("watermarkSize", pubRights.getWatermarkSize(), 3);
        }
        if (pubRights.getAudioDuration() != null && !pubRights.getAudioDuration().equals("")) {
            this.createTextElement("audioDuration", pubRights.getAudioDuration(), 3);
        }
        if (pubRights.getVideoSize() != null && !pubRights.getVideoSize().equals("")) {
            this.createTextElement("videoSize", pubRights.getVideoSize(), 3);
        }
        if (pubRights.getVideoDuration() != null && !pubRights.getVideoDuration().equals("")) {
            this.createTextElement("videoDuration", pubRights.getVideoDuration(), 3);
        }
        this.createCloseElement(2);
    }

    private void generateObjectElement(String packageName) throws XMLStreamException {
        this.createOpenElement("object", 1);
        this.createAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "representation");
        this.createOpenElement("objectIdentifier", 2);
        this.createTextElement("objectIdentifierType", "PACKAGE_NAME", 3);
        this.createTextElement("objectIdentifierValue", packageName, 3);
        this.createCloseElement(2);
        this.createCloseElement(1);
    }

    private void generateEventElement(String packageName) throws XMLStreamException {
        Date creationDate = new Date();
        this.createOpenElement("event", 1);
        this.createOpenElement("eventIdentifier", 2);
        this.createTextElement("eventIdentifierType", "SIP_CREATION_ID", 3);
        this.createTextElement("eventIdentifierValue", "Sip_Creation_" + this.formatDate(creationDate, dateFormat), 3);
        this.createCloseElement(2);
        this.createTextElement("eventType", "SIP_CREATION", 2);
        this.createTextElement("eventDateTime", this.formatDate(creationDate, dateFormat), 2);
        this.createOpenElement("linkingAgentIdentifier", 2);
        this.createTextElement("linkingAgentIdentifierType", "APPLICATION_NAME", 3);
        this.createTextElement("linkingAgentIdentifierValue", SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder Build: " + Utilities.getBuildNumber(), 3);
        this.createCloseElement(2);
        this.createOpenElement("linkingObjectIdentifier", 2);
        this.createTextElement("linkingObjectIdentifierType", "PACKAGE_NAME", 3);
        this.createTextElement("linkingObjectIdentifierValue", packageName, 3);
        this.createCloseElement(2);
        this.createCloseElement(1);
    }

    private void generateAgentElement() throws XMLStreamException {
        this.createOpenElement("agent", 1);
        this.createOpenElement("agentIdentifier", 2);
        this.createTextElement("agentIdentifierType", "APPLICATION_NAME", 3);
        this.createTextElement("agentIdentifierValue", SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder " + Utilities.getBuildNumber(), 3);
        this.createCloseElement(2);
        this.createTextElement("agentType", "APPLICATION", 2);
        this.createCloseElement(1);
    }

    private void generateRightsElement(ContractRights contractRights) throws XMLStreamException {
        String pages;
        PublicationRights publicRights = contractRights.getPublicRights();
        PublicationRights institutionRights = contractRights.getInstitutionRights();
        this.createOpenElement("rights", 1);
        this.createOpenElement("rightsStatement", 2);
        this.createOpenElement("rightsStatementIdentifier", 3);
        this.createTextElement("rightsStatementIdentifierType", "rightsid", 4);
        this.createTextElement("rightsStatementIdentifierValue", "", 4);
        this.createCloseElement(3);
        this.createTextElement("rightsBasis", "license", 3);
        if (publicRights.getAllowPublication()) {
            this.createOpenElement("rightsGranted", 3);
            this.createTextElement("act", "PUBLICATION_PUBLIC", 4);
            this.createTextElement("restriction", "see rightsExtension", 4);
            this.createOpenElement("termOfGrant", 4);
            if (publicRights.getTempPublication()) {
                this.createTextElement("startDate", this.formatDate(publicRights.getStartDate(), dayDateFormat), 5);
            } else {
                this.createTextElement("startDate", this.formatDate(new Date(), dayDateFormat), 5);
            }
            this.createCloseElement(4);
            this.createCloseElement(3);
        }
        if (institutionRights.getAllowPublication()) {
            this.createOpenElement("rightsGranted", 3);
            this.createTextElement("act", "PUBLICATION_INSTITUTION", 4);
            this.createTextElement("restriction", "see rightsExtension", 4);
            this.createOpenElement("termOfGrant", 4);
            if (institutionRights.getTempPublication()) {
                this.createTextElement("startDate", this.formatDate(institutionRights.getStartDate(), dayDateFormat), 5);
            } else {
                this.createTextElement("startDate", this.formatDate(new Date(), dayDateFormat), 5);
            }
            this.createCloseElement(4);
            this.createCloseElement(3);
        }
        this.createOpenElement("rightsGranted", 3);
        this.createTextElement("act", "MIGRATION", 4);
        this.createTextElement("restriction", "see rightsExtension", 4);
        this.createOpenElement("termOfGrant", 4);
        this.createTextElement("startDate", this.formatDate(new Date(), dayDateFormat), 5);
        this.createCloseElement(4);
        this.createCloseElement(3);
        this.createCloseElement(2);
        this.createOpenElement("rightsExtension", 2);
        this.createOpenElement("rightsGranted", 3);
        this.createAttribute("xmlns", "http://www.danrw.de/contract/v1");
        this.createAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.createAttribute("xsi:schemaLocation", "http://www.danrw.de/contract/v1 http://www.danrw.de/schemas/contract/v1/danrw-contract-v1-02.xsd");
        this.createOpenElement("migrationRight", 4);
        this.createTextElement("condition", contractRights.getConversionCondition().toString(), 5);
        this.createCloseElement(4);
        if (publicRights.getAllowPublication()) {
            this.createOpenElement("publicationRight", 4);
            this.createTextElement("audience", "PUBLIC", 5);
            if (publicRights.getTempPublication()) {
                this.createTextElement("startDate", this.formatDate(publicRights.getStartDate(), dayDateFormat), 6);
            } else {
                this.createTextElement("startDate", this.formatDate(new Date(), dayDateFormat), 6);
            }
            if (publicRights.getLawPublication()) {
                this.createTextElement("lawID", publicRights.getLaw().toString(), 6);
            }
            boolean publicImageRestrictionText = false;
            if (publicRights.getImageRestrictionText() && publicRights.getFooterText() != null && !publicRights.getFooterText().equals("")) {
                publicImageRestrictionText = true;
            }
            if (publicRights.getAudioRestriction() || publicRights.getImageRestriction() || publicRights.getTextRestriction() || publicRights.getVideoRestriction() || publicRights.getVideoDurationRestriction() || publicImageRestrictionText) {
                this.createOpenElement("restrictions", 5);
                if (publicRights.getAudioRestriction()) {
                    this.createOpenElement("restrictAudio", 6);
                    this.createTextElement("duration", String.valueOf(publicRights.getAudioDuration()), 7);
                    this.createCloseElement(6);
                }
                if (publicRights.getImageRestriction() || publicImageRestrictionText) {
                    this.createOpenElement("restrictImage", 6);
                    if (publicRights.getImageRestriction()) {
                        this.createTextElement("width", publicRights.getImageWidth(), 7);
                        this.createTextElement("height", publicRights.getImageHeight(), 7);
                    }
                    if (publicImageRestrictionText) {
                        if (publicRights.getImageTextType() == PublicationRights.TextType.footer) {
                            this.createTextElement("footerText", publicRights.getFooterText(), 7);
                        } else {
                            this.createOpenElement("watermark", 7);
                            this.createTextElement("watermarkString", publicRights.getFooterText(), 8);
                            this.createTextElement("pointSize", publicRights.getWatermarkSize(), 8);
                            this.createTextElement("position", publicRights.getImageTextType().toString(), 8);
                            this.createTextElement("opacity", publicRights.getWatermarkOpacity(), 8);
                            this.createCloseElement(7);
                        }
                    }
                    this.createCloseElement(6);
                }
                if (publicRights.getTextRestriction()) {
                    this.createOpenElement("restrictText", 6);
                    pages = publicRights.parsePages();
                    if (pages != "") {
                        this.createTextElement("certainPages", pages, 7);
                    }
                    this.createCloseElement(6);
                }
                if (publicRights.getVideoRestriction() || publicRights.getVideoDurationRestriction()) {
                    this.createOpenElement("restrictVideo", 6);
                    if (publicRights.getVideoRestriction()) {
                        this.createTextElement("height", publicRights.getVideoSize(), 7);
                    }
                    if (publicRights.getVideoDurationRestriction()) {
                        this.createTextElement("duration", String.valueOf(publicRights.getVideoDuration()), 7);
                    }
                    this.createCloseElement(6);
                }
                this.createCloseElement(5);
            } else {
                this.createEmptyElement("restrictions", 5);
            }
            this.createCloseElement(4);
        }
        if (institutionRights.getAllowPublication()) {
            this.createOpenElement("publicationRight", 4);
            this.createTextElement("audience", "INSTITUTION", 5);
            if (institutionRights.getTempPublication()) {
                this.createTextElement("startDate", this.formatDate(institutionRights.getStartDate(), dayDateFormat), 6);
            } else {
                this.createTextElement("startDate", this.formatDate(new Date(), dayDateFormat), 6);
            }
            if (institutionRights.getLawPublication()) {
                this.createTextElement("lawID", institutionRights.getLaw().toString(), 6);
            }
            boolean institutionImageRestrictionText = false;
            if (institutionRights.getImageRestrictionText() && institutionRights.getFooterText() != null && !institutionRights.getFooterText().equals("")) {
                institutionImageRestrictionText = true;
            }
            if (institutionRights.getAudioRestriction() || institutionRights.getImageRestriction() || institutionRights.getTextRestriction() || institutionRights.getVideoRestriction() || institutionRights.getVideoDurationRestriction() || institutionImageRestrictionText) {
                this.createOpenElement("restrictions", 5);
                if (institutionRights.getAudioRestriction()) {
                    this.createOpenElement("restrictAudio", 6);
                    this.createTextElement("duration", String.valueOf(institutionRights.getAudioDuration()), 7);
                    this.createCloseElement(6);
                }
                if (institutionRights.getImageRestriction() || institutionImageRestrictionText) {
                    this.createOpenElement("restrictImage", 6);
                    if (institutionRights.getImageRestriction()) {
                        this.createTextElement("width", institutionRights.getImageWidth(), 7);
                        this.createTextElement("height", institutionRights.getImageHeight(), 7);
                    }
                    if (institutionImageRestrictionText) {
                        if (institutionRights.getImageTextType() == PublicationRights.TextType.footer) {
                            this.createTextElement("footerText", institutionRights.getFooterText(), 7);
                        } else {
                            this.createOpenElement("watermark", 7);
                            this.createTextElement("watermarkString", institutionRights.getFooterText(), 8);
                            this.createTextElement("pointSize", institutionRights.getWatermarkSize(), 8);
                            this.createTextElement("position", institutionRights.getImageTextType().toString(), 8);
                            this.createTextElement("opacity", institutionRights.getWatermarkOpacity(), 8);
                            this.createCloseElement(7);
                        }
                    }
                    this.createCloseElement(6);
                }
                if (institutionRights.getTextRestriction()) {
                    this.createOpenElement("restrictText", 6);
                    pages = institutionRights.parsePages();
                    if (pages != "") {
                        this.createTextElement("certainPages", pages, 7);
                    }
                    this.createCloseElement(6);
                }
                if (institutionRights.getVideoRestriction() || institutionRights.getVideoDurationRestriction()) {
                    this.createOpenElement("restrictVideo", 6);
                    if (institutionRights.getVideoRestriction()) {
                        this.createTextElement("height", institutionRights.getVideoSize(), 7);
                    }
                    if (institutionRights.getVideoDurationRestriction()) {
                        this.createTextElement("duration", String.valueOf(institutionRights.getVideoDuration()), 7);
                    }
                    this.createCloseElement(6);
                }
                this.createCloseElement(5);
            } else {
                this.createEmptyElement("restrictions", 5);
            }
            this.createCloseElement(4);
        }
        if (publicRights.getAllowPublication() && contractRights.getDdbExclusion()) {
            this.createEmptyElement("DDBexclusion", 4);
        }
        if (contractRights.getMinimalIngestQuality() > 0) {
            this.createTextElement("minimalIngestQualityLevel", "" + contractRights.getMinimalIngestQuality(), 4);
        }
        if (publicRights.getAllowPublication() && contractRights.getCclincense() != null) {
            this.generatePublicationLicenseElement(contractRights.getCclincense(), 4);
        }
        this.createCloseElement(3);
        this.createCloseElement(2);
        this.createCloseElement(1);
    }

    private void copyRightsElementFromPremisFile(File rightsSourcePremisFile) throws XMLStreamException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(rightsSourcePremisFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Couldn't find file " + rightsSourcePremisFile.getAbsolutePath(), e);
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(inputStream);
        boolean textElement = false;
        boolean inRightsElement = false;
        int tab = 1;
        String name = null;
        String text = null;
        while (streamReader.hasNext()) {
            int event = streamReader.next();
            switch (event) {
                case 1: {
                    if (streamReader.getLocalName().equals("rights")) {
                        inRightsElement = true;
                    }
                    if (!inRightsElement) break;
                    if (name != null) {
                        this.writer.writeStartElement(name);
                        if (name.equals("rightsExtension")) {
                            this.createAttribute("xmlns", "http://www.danrw.de/contract/v1");
                            this.createAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                            this.createAttribute("xsi:schemaLocation", "http://www.danrw.de/contract/v1 http://www.danrw.de/schemas/contract/v1/danrw-contract-v1-02.xsd");
                        }
                        name = null;
                        text = null;
                    }
                    this.writer.writeDTD("\n");
                    this.indent(tab);
                    ++tab;
                    name = streamReader.getLocalName();
                    break;
                }
                case 4: {
                    if (!inRightsElement || streamReader.isWhiteSpace()) break;
                    text = streamReader.getText();
                    textElement = true;
                    break;
                }
                case 2: {
                    if (inRightsElement) {
                        if (!textElement && streamReader.getLocalName().equals(name)) {
                            this.writer.writeEmptyElement(name);
                            name = null;
                            text = null;
                            --tab;
                            break;
                        }
                        if (textElement) {
                            this.writer.writeStartElement(streamReader.getLocalName());
                            this.writer.writeCharacters(text);
                            name = null;
                            text = null;
                        }
                        --tab;
                        if (!textElement) {
                            this.writer.writeDTD("\n");
                            this.indent(tab);
                        }
                        this.writer.writeEndElement();
                        textElement = false;
                    }
                    if (!streamReader.getLocalName().equals("rights")) break;
                    inRightsElement = false;
                    break;
                }
            }
        }
        streamReader.close();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close input stream", e);
        }
    }

    private String formatDate(Date date, SimpleDateFormat format) {
        format.setTimeZone(TimeZone.getTimeZone("Europe/Berlin"));
        String dateString = format.format(date);
        if (dateString.endsWith("00") && !dateString.endsWith(":00")) {
            dateString = dateString.substring(0, dateString.length() - 2) + ":00";
        }
        return dateString;
    }

    private void indent(int tab) throws XMLStreamException {
        for (int i = 0; i < tab; ++i) {
            this.writer.writeDTD("    ");
        }
    }

    private void createOpenElement(String namespace, String name, int tab) throws XMLStreamException {
        this.writer.writeDTD("\n");
        this.indent(tab);
        if (namespace.equals("")) {
            this.writer.writeStartElement(name);
        } else {
            this.writer.writeStartElement(namespace, name);
        }
    }

    private void createOpenElement(String name, int tab) throws XMLStreamException {
        this.createOpenElement("", name, tab);
    }

    private void createCloseElement(int tab) throws XMLStreamException {
        this.writer.writeDTD("\n");
        this.indent(tab);
        this.writer.writeEndElement();
    }

    private void createTextElement(String namespace, String name, String text, int tab) throws XMLStreamException {
        this.writer.writeDTD("\n");
        this.indent(tab);
        if (namespace.equals("")) {
            this.writer.writeStartElement(name);
        } else {
            this.writer.writeStartElement(namespace, name);
        }
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    private void createTextElement(String name, String text, int tab) throws XMLStreamException {
        this.createTextElement("", name, text, tab);
    }

    private void createEmptyElement(String name, int tab) throws XMLStreamException {
        this.writer.writeDTD("\n");
        this.indent(tab);
        this.writer.writeEmptyElement(name);
    }

    private void createAttribute(String namespace, String name, String value) throws XMLStreamException {
        if (namespace.equals("")) {
            this.writer.writeAttribute(name, value);
        } else {
            this.writer.writeAttribute(namespace, name, value);
        }
    }

    private void createAttribute(String name, String value) throws XMLStreamException {
        this.createAttribute("", name, value);
    }
}

