/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PublicationRights {
    private boolean allowPublication;
    private boolean tempPublication;
    private boolean lawPublication;
    private boolean textRestriction;
    private boolean imageRestriction;
    private boolean audioRestriction;
    private boolean videoRestriction;
    private boolean videoDurationRestriction;
    private boolean imageRestrictionText;
    private Date startDate;
    private Law law;
    private String pages;
    private String imageWidth;
    private String imageHeight;
    private String footerText;
    private String watermarkOpacity;
    private String watermarkSize;
    private TextType imageTextType;
    private String audioDuration;
    private String videoSize;
    private String videoDuration;

    public boolean getAllowPublication() {
        return this.allowPublication;
    }

    public void setAllowPublication(boolean allowPublication) {
        this.allowPublication = allowPublication;
    }

    public boolean getTempPublication() {
        return this.tempPublication;
    }

    public void setTempPublication(boolean tempPublication) {
        this.tempPublication = tempPublication;
    }

    public boolean getLawPublication() {
        return this.lawPublication;
    }

    public void setLawPublication(boolean lawPublication) {
        this.lawPublication = lawPublication;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean setStartDate(String startDate) {
        Date date = this.checkDate(startDate);
        if (date != null) {
            this.startDate = date;
            return true;
        }
        return false;
    }

    public Law getLaw() {
        return this.law;
    }

    public void setLaw(Law law) {
        this.law = law;
    }

    public String getPages() {
        return this.pages;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }

    public String getAudioDuration() {
        return this.audioDuration;
    }

    public void setAudioDuration(String audioDuration) {
        this.audioDuration = audioDuration;
    }

    public String getVideoSize() {
        return this.videoSize;
    }

    public void setVideoSize(String videoSize) {
        this.videoSize = videoSize;
    }

    public String getVideoDuration() {
        return this.videoDuration;
    }

    public void setVideoDuration(String videoDuration) {
        this.videoDuration = videoDuration;
    }

    public String getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(String imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(String imageHeight) {
        this.imageHeight = imageHeight;
    }

    public boolean getTextRestriction() {
        return this.textRestriction;
    }

    public void setTextRestriction(boolean textRestriction) {
        this.textRestriction = textRestriction;
    }

    public boolean getImageRestriction() {
        return this.imageRestriction;
    }

    public void setImageRestriction(boolean imageRestriction) {
        this.imageRestriction = imageRestriction;
    }

    public boolean getAudioRestriction() {
        return this.audioRestriction;
    }

    public void setAudioRestriction(boolean audioRestriction) {
        this.audioRestriction = audioRestriction;
    }

    public boolean getVideoRestriction() {
        return this.videoRestriction;
    }

    public void setVideoRestriction(boolean videoRestriction) {
        this.videoRestriction = videoRestriction;
    }

    public boolean getVideoDurationRestriction() {
        return this.videoDurationRestriction;
    }

    public void setVideoDurationRestriction(boolean videoDurationRestriction) {
        this.videoDurationRestriction = videoDurationRestriction;
    }

    public String getWatermarkOpacity() {
        return this.watermarkOpacity;
    }

    public void setWatermarkOpacity(String watermarkOpacity) {
        this.watermarkOpacity = watermarkOpacity;
    }

    public String getWatermarkSize() {
        return this.watermarkSize;
    }

    public void setWatermarkSize(String watermarkSize) {
        this.watermarkSize = watermarkSize;
    }

    public TextType getImageTextType() {
        return this.imageTextType;
    }

    public void setImageTextType(TextType imageTextType) {
        this.imageTextType = imageTextType;
    }

    public boolean getImageRestrictionText() {
        return this.imageRestrictionText;
    }

    public void setImageRestrictionText(boolean imageRestrictionText) {
        this.imageRestrictionText = imageRestrictionText;
    }

    public String parsePages() {
        char[] charPages;
        if (this.pages.contains("$")) {
            return "";
        }
        String tempPages = this.pages + "$";
        int number1 = -1;
        int number2 = -1;
        String numberText = "";
        boolean range = false;
        boolean space = false;
        HashSet<Integer> pagesSet = new HashSet<Integer>();
        block9: for (char c : charPages = tempPages.toCharArray()) {
            switch (c) {
                case '$': 
                case ',': 
                case ';': {
                    if (numberText.equals("")) continue block9;
                    try {
                        if (!range) {
                            number1 = Integer.parseInt(numberText);
                        } else {
                            number2 = Integer.parseInt(numberText);
                        }
                    }
                    catch (NumberFormatException e) {
                        return "";
                    }
                    numberText = "";
                    range = false;
                    space = false;
                    if (number1 == -1) continue block9;
                    if (number2 != -1) {
                        if (!this.addPagesToList(number1, number2, pagesSet)) {
                            return "";
                        }
                        number1 = -1;
                        number2 = -1;
                        continue block9;
                    }
                    if (!pagesSet.contains(number1)) {
                        pagesSet.add(number1);
                    }
                    number1 = -1;
                    continue block9;
                }
                case '-': {
                    if (range || numberText.equals("")) {
                        return "";
                    }
                    try {
                        number1 = Integer.parseInt(numberText);
                    }
                    catch (NumberFormatException e) {
                        return "";
                    }
                    numberText = "";
                    range = true;
                    space = false;
                    continue block9;
                }
                case ' ': {
                    if (numberText.equals("")) continue block9;
                    space = true;
                    continue block9;
                }
                default: {
                    if (space) {
                        return "";
                    }
                    if (c >= '0' && c <= '9') {
                        numberText = numberText + c;
                        continue block9;
                    }
                    return "";
                }
            }
        }
        ArrayList pagesList = new ArrayList(pagesSet);
        Collections.sort(pagesList);
        StringBuilder builder = new StringBuilder();
        Iterator iterator = pagesList.iterator();
        while (iterator.hasNext()) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(iterator.next());
        }
        return builder.toString();
    }

    private boolean addPagesToList(int startPage, int endPage, Set<Integer> pagesList) {
        if (startPage > endPage || endPage - startPage > 1000000) {
            return false;
        }
        for (int i = startPage; i <= endPage; ++i) {
            if (pagesList.contains(i)) continue;
            pagesList.add(i);
        }
        return true;
    }

    private Date checkDate(String dateString) {
        Date date;
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat dateFormat3 = new SimpleDateFormat("dd.MM.yy");
        try {
            date = dateFormat1.parse(dateString);
        }
        catch (ParseException e1) {
            try {
                date = dateFormat2.parse(dateString);
            }
            catch (ParseException e2) {
                try {
                    date = dateFormat3.parse(dateString);
                }
                catch (ParseException e3) {
                    return null;
                }
            }
        }
        return date;
    }

    public static enum TextType {
        footer,
        north,
        south,
        center;

    }

    public static enum Law {
        EPFLICHT,
        URHG_DE,
        PUBLICDOMAIN_DE;

    }
}

