/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ConsistencyChecker;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.reader.BagReader;
import gov.loc.repository.bagit.verify.BagVerifier;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagitConsistencyChecker
implements ConsistencyChecker {
    private static Logger logger = LoggerFactory.getLogger(BagitConsistencyChecker.class);
    String packagePath;
    List<String> messages;

    public BagitConsistencyChecker(String packagePath) {
        this.packagePath = packagePath;
        this.messages = new ArrayList<String>();
    }

    @Override
    public boolean checkPackage() {
        logger.debug("Starting BagIt consistency check.");
        BagVerifier sut = new BagVerifier();
        BagReader reader = new BagReader();
        try {
            Bag bagVer = reader.read(Paths.get(this.packagePath, new String[0]));
            sut.isValid(bagVer, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.messages = Arrays.asList(e.getMessage());
            logger.debug("BagIt verification failed: " + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }
}

