/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import gov.loc.repository.bagit.creator.BagCreator;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.hash.StandardSupportedAlgorithms;
import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import gov.loc.repository.bagit.reader.BagReader;
import gov.loc.repository.bagit.verify.BagVerifier;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagitUtils {
    static final Logger logger = LoggerFactory.getLogger(BagitUtils.class);
    public static final SupportedAlgorithm DEFAULT_BAGIT_ALGORITHM = StandardSupportedAlgorithms.SHA512;
    public static final RegexFileFilter MANIFEST_FILE_FILTER = new RegexFileFilter("manifest\\-\\w*\\.txt");
    public static final RegexFileFilter TAG_MANIFEST_FILE_FILTER = new RegexFileFilter("tagmanifest\\-\\w*\\.txt");

    public static void buildBagit(String packagePath) {
        Bag bag;
        File[] fileToDel;
        if (new File(packagePath + "/bagit.txt").exists()) {
            new File(packagePath + "/bagit.txt").delete();
        }
        if (new File(packagePath + "/bag-info.txt").exists()) {
            new File(packagePath + "/bag-info.txt").delete();
        }
        for (File f : fileToDel = new File(packagePath).listFiles(MANIFEST_FILE_FILTER)) {
            f.delete();
        }
        for (File f : fileToDel = new File(packagePath).listFiles(TAG_MANIFEST_FILE_FILTER)) {
            f.delete();
        }
        try {
            bag = BagCreator.bagInPlace(Paths.get(packagePath, new String[0]), Arrays.asList(DEFAULT_BAGIT_ALGORITHM), false);
        }
        catch (Exception e) {
            throw new RuntimeException("BagIt couldn't create Bag: " + e.toString());
        }
        BagVerifier sut = new BagVerifier();
        try {
            sut.isValid(bag, false);
        }
        catch (Exception e) {
            throw new RuntimeException("BagIt couldn't be validated after its creation: " + e.toString());
        }
    }

    public static boolean isBagItStyle(File packagePath) {
        return new File(packagePath, "bagit.txt").exists() && new File(packagePath, "bag-info.txt").exists() && packagePath.listFiles(TAG_MANIFEST_FILE_FILTER).length != 0 && packagePath.listFiles(MANIFEST_FILE_FILTER).length != 0;
    }

    public static boolean bagIsValid(File folder) throws IOException {
        return BagitUtils.bagIsValid(folder.toURI().getPath());
    }

    public static boolean bagIsValid(String unpackedObjectPath) throws IOException {
        BagReader reader = new BagReader();
        BagVerifier sut = new BagVerifier();
        try {
            Bag bagVer = reader.read(Paths.get(unpackedObjectPath, new String[0]));
            sut.isValid(bagVer, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static class RegexFileFilter
    implements FileFilter {
        final Pattern p;

        public RegexFileFilter(String regex) {
            this.p = Pattern.compile(regex);
        }

        public boolean accept(File file) {
            boolean ret = this.p.matcher(file.getName()).matches();
            return ret;
        }
    }
}

