/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.sb.SIPFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SipArchiveBuilder {
    private ProgressManager progressManager;
    private int jobId;
    private SIPFactory.SipBuildingProcess sipBuildingProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean archiveFolder(File srcFolder, File destFile, boolean includeFolder, boolean compress) throws Exception {
        FileOutputStream fOut = null;
        GzipCompressorOutputStream gzOut = null;
        TarArchiveOutputStream tOut = null;
        try {
            fOut = new FileOutputStream(destFile);
            if (compress) {
                gzOut = new GzipCompressorOutputStream(fOut);
                tOut = new TarArchiveOutputStream((OutputStream)gzOut, "UTF-8");
            } else {
                tOut = new TarArchiveOutputStream((OutputStream)fOut, "UTF-8");
            }
            tOut.setLongFileMode(2);
            tOut.setBigNumberMode(2);
            if (includeFolder) {
                if (!this.addFileToArchive(tOut, srcFolder, "")) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                File[] children = srcFolder.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    if (this.addFileToArchive(tOut, children[i], "")) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            tOut.finish();
            tOut.close();
            if (gzOut != null) {
                gzOut.close();
            }
            fOut.close();
        }
        return true;
    }

    private boolean addFileToArchive(TarArchiveOutputStream tOut, File file, String base) throws IOException {
        if (this.sipBuildingProcess.isAborted()) {
            return false;
        }
        String entryName = base + file.getName();
        TarArchiveEntry entry = (TarArchiveEntry)tOut.createArchiveEntry(file, entryName);
        tOut.putArchiveEntry(entry);
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            IOUtils.copy((InputStream)fis, (OutputStream)tOut);
            tOut.closeArchiveEntry();
            fis.close();
            this.progressManager.archiveProgress(this.jobId, FileUtils.sizeOf(file));
        }
        if (file.isDirectory()) {
            tOut.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children == null) {
                return true;
            }
            for (int i = 0; i < children.length; ++i) {
                if (this.addFileToArchive(tOut, children[i], entryName + "/")) continue;
                return false;
            }
        }
        return true;
    }

    public void unarchiveFolder(File srcFile, File destFolder, boolean uncompress) throws Exception {
        TarArchiveEntry entry;
        FileInputStream fIn = new FileInputStream(srcFile);
        BufferedInputStream in = new BufferedInputStream(fIn);
        TarArchiveInputStream tIn = null;
        GzipCompressorInputStream gzIn = null;
        if (uncompress) {
            gzIn = new GzipCompressorInputStream(in);
            tIn = new TarArchiveInputStream(gzIn);
        } else {
            tIn = new TarArchiveInputStream(fIn);
        }
        while ((entry = tIn.getNextTarEntry()) != null) {
            File entryFile = new File(destFolder.getAbsolutePath() + "/" + entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            new File(entryFile.getAbsolutePath().substring(0, entryFile.getAbsolutePath().lastIndexOf(47))).mkdirs();
            FileOutputStream out = new FileOutputStream(entryFile);
            IOUtils.copy((InputStream)tIn, (OutputStream)out);
            out.close();
        }
        tIn.close();
        if (gzIn != null) {
            gzIn.close();
        }
        in.close();
        fIn.close();
    }

    public void setProgressManager(ProgressManager progressManager) {
        this.progressManager = progressManager;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public void setSipBuildingProcess(SIPFactory.SipBuildingProcess sipBuildingProcess) {
        this.sipBuildingProcess = sipBuildingProcess;
    }
}

