/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ArchiveBuilder;
import de.uzk.hki.da.utils.CommandLineConnector;
import de.uzk.hki.da.utils.ProcessInformation;
import java.io.File;

public class TarArchiveBuilder
implements ArchiveBuilder {
    public void unarchiveFolder(File srcTar, File destFolder) throws Exception {
        ProcessInformation pi = new CommandLineConnector().runCmdSynchronously(new String[]{"/bin/tar", "xf", srcTar.getAbsolutePath(), "-C", destFolder.getAbsolutePath(), "--keep-old-files"});
        if (pi == null || pi.getExitValue() != 0) {
            String msg = "Failed to unarchive file " + srcTar + " to folder " + destFolder;
            if (pi != null) {
                msg = msg + "\n" + pi.getStdErr();
            }
            throw new RuntimeException(msg);
        }
    }

    public void archiveFolder(File srcFile, File destFile, boolean includeFolder) throws Exception {
        if (includeFolder) {
            String parent = srcFile.getParentFile().getAbsolutePath();
            ProcessInformation pi = new CommandLineConnector().runCmdSynchronously(new String[]{"/bin/tar", "-C", parent, "-cf", destFile.getAbsolutePath(), srcFile.getName()});
            if (pi == null || pi.getExitValue() != 0) {
                String msg = "Failed to archive folder " + srcFile + " to file " + destFile;
                if (pi != null) {
                    msg = msg + "\n" + pi.getStdErr();
                }
                throw new RuntimeException(msg);
            }
        } else {
            String folder = srcFile.getAbsolutePath();
            ProcessInformation pi = new CommandLineConnector().runCmdSynchronously(new String[]{"/bin/tar", "-C", folder, "-cf", destFile.getAbsolutePath(), "."});
            if (pi == null || pi.getExitValue() != 0) {
                String msg = "Failed to archive folder " + srcFile + " to file " + destFile;
                if (pi != null) {
                    msg = msg + "\n" + pi.getStdErr();
                }
                throw new RuntimeException(msg);
            }
        }
    }
}

