/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ArchiveBuilder;
import de.uzk.hki.da.utils.CommandLineConnector;
import de.uzk.hki.da.utils.ProcessInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipArchiveBuilder
implements ArchiveBuilder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    public final String unzipPath = "/usr/bin/jar";

    ZipArchiveBuilder() {
    }

    public void unarchiveFolder(File srcTar, File destFolder) throws Exception {
        this.logger.debug("moving {} to folder {}", (Object)srcTar, (Object)destFolder);
        FileUtils.copyFileToDirectory(srcTar, destFolder, false);
        ProcessInformation pi = new CommandLineConnector().runCmdSynchronously(new String[]{"/usr/bin/jar", "-xf", FilenameUtils.getName(srcTar.getAbsolutePath())}, destFolder, 0L);
        if (pi == null || pi.getExitValue() != 0) {
            if (pi != null) {
                this.logger.error(pi.getStdErr());
            }
            throw new RuntimeException("Couldnt unpack package");
        }
        new File(destFolder.getAbsolutePath() + "/" + FilenameUtils.getName(srcTar.getAbsolutePath())).delete();
    }

    public void archiveFolder(File srcFolder, File destFile, boolean includeFolder) throws Exception {
        FileOutputStream fileWriter = new FileOutputStream(destFile);
        ZipOutputStream zip = new ZipOutputStream(fileWriter);
        this.addFolderToArchive("", srcFolder, zip, includeFolder);
        zip.close();
        fileWriter.close();
    }

    private void addFileToArchive(String path, File srcFile, ZipOutputStream zip, boolean includeFolder) throws Exception {
        if (srcFile.isDirectory()) {
            this.addFolderToArchive(path, srcFile, zip, includeFolder);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + "/" + srcFile.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
        zip.flush();
    }

    private void addFolderToArchive(String path, File srcFolder, ZipOutputStream zip, boolean includeFolder) throws Exception {
        for (String fileName : srcFolder.list()) {
            if (path.equals("")) {
                if (includeFolder) {
                    this.addFileToArchive(srcFolder.getName(), new File(srcFolder + "/" + fileName), zip, includeFolder);
                    continue;
                }
                this.addFileToArchive(".", new File(srcFolder + "/" + fileName), zip, includeFolder);
                continue;
            }
            this.addFileToArchive(path + "/" + srcFolder.getName(), new File(srcFolder + "/" + fileName), zip, includeFolder);
        }
    }
}

