/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderUtils {
    public static final long TIME_TO_END_FILE_OPERATION = 5000L;

    public static List<String> listFolderContents(File folder) {
        String[] fileNames = folder.list();
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (new File(folder.getAbsolutePath() + "/" + fileName).isDirectory()) {
                List<String> folderFileNames = FolderUtils.listFolderContents(new File(folder.getAbsoluteFile() + "/" + fileName));
                for (String folderFileName : folderFileNames) {
                    fileList.add(fileName + "/" + folderFileName);
                }
                continue;
            }
            fileList.add(fileName);
        }
        return fileList;
    }

    public static boolean compareFolders(File lhs, File rhs) throws IOException {
        String rhsParentPath = rhs.getAbsolutePath();
        String lhsParentPath = lhs.getAbsolutePath();
        Object[] lhsChildren = lhs.list();
        Object[] rhsChildren = rhs.list();
        Arrays.sort(lhsChildren);
        Arrays.sort(rhsChildren);
        boolean filesAreEqual = true;
        for (int i = 0; i < lhsChildren.length; ++i) {
            File lhsf = new File(lhsParentPath + "/" + (String)lhsChildren[i]);
            File rhsf = new File(rhsParentPath + "/" + (String)rhsChildren[i]);
            if (lhsf.isFile() && !FileUtils.contentEquals(lhsf, rhsf)) {
                filesAreEqual = false;
            }
            if (!lhsf.isDirectory() || FolderUtils.compareFolders(lhsf, rhsf)) continue;
            filesAreEqual = false;
        }
        return filesAreEqual;
    }

    public static void deleteDirectorySafe(File directory) throws IOException {
        boolean successful = false;
        int i = 1;
        while (i < 15 & !successful) {
            block3: {
                successful = true;
                try {
                    FileUtils.deleteDirectory(directory);
                }
                catch (IOException e) {
                    successful = false;
                    System.out.println("FolderUtils::deleteDirectorySafe(): delete " + directory + " fails: " + i + " x " + 5000L);
                    FolderUtils.waitToCompleteNFSAwareFileOperation();
                    if (i != 14) break block3;
                    throw e;
                }
            }
            ++i;
        }
    }

    public static boolean deleteQuietlySafe(File file) {
        boolean result = FileUtils.deleteQuietly(file);
        if (!result) {
            FolderUtils.waitToCompleteNFSAwareFileOperation();
            result = FileUtils.deleteQuietly(file);
        }
        return result;
    }

    public static void waitToCompleteNFSAwareFileOperation() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

