/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import gov.loc.repository.bagit.conformance.profile.BagInfoRequirement;
import gov.loc.repository.bagit.conformance.profile.BagitProfile;
import gov.loc.repository.bagit.conformance.profile.BagitProfileDeserializer;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Metadata;
import gov.loc.repository.bagit.exceptions.conformance.BagitVersionIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.FetchFileNotAllowedException;
import gov.loc.repository.bagit.exceptions.conformance.MetatdataValueIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredManifestNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredMetadataFieldNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredTagFileNotPresentException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class BagProfileChecker {
    private static final Logger logger = LoggerFactory.getLogger(BagProfileChecker.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private BagProfileChecker() {
    }

    public static void bagConformsToProfile(InputStream jsonProfile, Bag bag) throws JsonParseException, JsonMappingException, IOException, FetchFileNotAllowedException, RequiredMetadataFieldNotPresentException, MetatdataValueIsNotAcceptableException, RequiredManifestNotPresentException, BagitVersionIsNotAcceptableException, RequiredTagFileNotPresentException {
        BagitProfile profile = BagProfileChecker.parseBagitProfile(jsonProfile);
        BagProfileChecker.checkFetch(bag.getRootDir(), profile.isFetchFileAllowed(), bag.getItemsToFetch());
        BagProfileChecker.checkMetadata(bag.getMetadata(), profile.getBagInfoRequirements());
        BagProfileChecker.requiredManifestsExist(bag.getPayLoadManifests(), profile.getManifestTypesRequired(), true);
        BagProfileChecker.requiredManifestsExist(bag.getTagManifests(), profile.getTagManifestTypesRequired(), false);
        if (!profile.getAcceptableBagitVersions().contains(bag.getVersion().toString())) {
            throw new BagitVersionIsNotAcceptableException(messages.getString("bagit_version_not_acceptable_error"), bag.getVersion(), profile.getAcceptableBagitVersions());
        }
        BagProfileChecker.requiredTagFilesExist(bag.getRootDir(), profile.getTagFilesRequired());
    }

    private static BagitProfile parseBagitProfile(InputStream jsonProfile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BagitProfile.class, new BagitProfileDeserializer());
        mapper.registerModule(module);
        return mapper.readValue(jsonProfile, BagitProfile.class);
    }

    private static void checkFetch(Path rootDir, boolean allowFetchFile, List<FetchItem> itemsToFetch) throws FetchFileNotAllowedException {
        logger.debug(messages.getString("checking_fetch_file_allowed"), (Object)rootDir);
        if (!allowFetchFile && !itemsToFetch.isEmpty()) {
            throw new FetchFileNotAllowedException(messages.getString("fetch_file_not_allowed_error"), rootDir);
        }
    }

    private static void checkMetadata(Metadata bagMetadata, Map<String, BagInfoRequirement> bagInfoEntryRequirements) throws RequiredMetadataFieldNotPresentException, MetatdataValueIsNotAcceptableException {
        for (Map.Entry<String, BagInfoRequirement> bagInfoEntryRequirement : bagInfoEntryRequirements.entrySet()) {
            boolean metadataContainsKey = bagMetadata.contains(bagInfoEntryRequirement.getKey());
            logger.debug(messages.getString("checking_metadata_entry_required"), (Object)bagInfoEntryRequirement.getKey());
            if (bagInfoEntryRequirement.getValue().isRequired() && !metadataContainsKey) {
                throw new RequiredMetadataFieldNotPresentException(messages.getString("required_metadata_field_not_present_error"), bagInfoEntryRequirement.getKey());
            }
            if (bagInfoEntryRequirement.getValue().getAcceptableValues().isEmpty()) continue;
            logger.debug(messages.getString("check_values_acceptable"), (Object)bagInfoEntryRequirement.getKey());
            for (String metadataValue : bagMetadata.get(bagInfoEntryRequirement.getKey())) {
                if (bagInfoEntryRequirement.getValue().getAcceptableValues().contains(metadataValue)) continue;
                throw new MetatdataValueIsNotAcceptableException(messages.getString("metadata_value_not_acceptable_error"), bagInfoEntryRequirement.getKey(), bagInfoEntryRequirement.getValue().getAcceptableValues(), metadataValue);
            }
        }
    }

    private static void requiredManifestsExist(Set<Manifest> manifests, List<String> requiredManifestTypes, boolean isPayloadManifest) throws RequiredManifestNotPresentException {
        HashSet<String> manifestTypesPresent = new HashSet<String>();
        logger.debug(messages.getString("check_required_manifests_present"));
        for (Manifest manifest : manifests) {
            manifestTypesPresent.add(manifest.getAlgorithm().getBagitName());
        }
        for (String requiredManifestType : requiredManifestTypes) {
            if (manifestTypesPresent.contains(requiredManifestType)) continue;
            StringBuilder sb = new StringBuilder();
            if (isPayloadManifest) {
                sb.append("tag");
                sb.append(MessageFormatter.format(messages.getString("required_tag_manifest_type_not_present"), requiredManifestType).getMessage());
            } else {
                sb.append(MessageFormatter.format(messages.getString("required_manifest_type_not_present"), requiredManifestType).getMessage());
            }
            throw new RequiredManifestNotPresentException(sb.toString());
        }
    }

    private static void requiredTagFilesExist(Path rootDir, List<String> requiredTagFilePaths) throws RequiredTagFileNotPresentException {
        logger.debug(messages.getString("checking_required_tag_file_exists"));
        for (String requiredTagFilePath : requiredTagFilePaths) {
            Path requiredTagFile = rootDir.resolve(requiredTagFilePath);
            if (Files.exists(requiredTagFile, new LinkOption[0])) continue;
            throw new RequiredTagFileNotPresentException(messages.getString("required_tag_file_not_found_error"), requiredTagFilePath);
        }
    }
}

