/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.UnparsableVersionException;
import gov.loc.repository.bagit.reader.KeyValueReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class BagitTextFileReader {
    private static final Logger logger = LoggerFactory.getLogger(BagitTextFileReader.class);
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private BagitTextFileReader() {
    }

    public static AbstractMap.SimpleImmutableEntry<Version, Charset> readBagitTextFile(Path bagitFile) throws IOException, UnparsableVersionException, InvalidBagMetadataException, InvalidBagitFileFormatException {
        logger.debug(messages.getString("reading_version_and_encoding"), (Object)bagitFile);
        BagitTextFileReader.throwErrorIfByteOrderMarkIsPresent(bagitFile);
        List<AbstractMap.SimpleImmutableEntry<String, String>> pairs = KeyValueReader.readKeyValuesFromFile(bagitFile, ":", StandardCharsets.UTF_8);
        String version = null;
        Charset encoding = null;
        for (AbstractMap.SimpleImmutableEntry<String, String> pair : pairs) {
            if ("BagIt-Version".equals(pair.getKey())) {
                version = pair.getValue();
                logger.debug(messages.getString("bagit_version"), (Object)version);
            }
            if (!"Tag-File-Character-Encoding".equals(pair.getKey())) continue;
            encoding = Charset.forName(pair.getValue());
            logger.debug(messages.getString("tag_file_encoding"), (Object)encoding);
        }
        if (version == null || encoding == null) {
            throw new InvalidBagitFileFormatException(messages.getString("invalid_bagit_text_file_error"));
        }
        return new AbstractMap.SimpleImmutableEntry<Version, Object>(BagitTextFileReader.parseVersion(version), encoding);
    }

    private static void throwErrorIfByteOrderMarkIsPresent(Path bagitFile) throws IOException, InvalidBagitFileFormatException {
        byte[] firstFewBytesInFile = Arrays.copyOfRange(Files.readAllBytes(bagitFile), 0, BOM.length);
        if (Arrays.equals(BOM, firstFewBytesInFile)) {
            String formattedMessage = messages.getString("bom_present_error");
            throw new InvalidBagitFileFormatException(MessageFormatter.format(formattedMessage, bagitFile).getMessage());
        }
    }

    public static Version parseVersion(String version) throws UnparsableVersionException {
        if (!version.contains(".")) {
            throw new UnparsableVersionException(messages.getString("unparsable_version_error"), version);
        }
        String[] parts = version.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return new Version(major, minor);
    }
}

