/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.exceptions.UnsupportedAlgorithmException;
import gov.loc.repository.bagit.hash.BagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import gov.loc.repository.bagit.reader.TagFileReader;
import gov.loc.repository.bagit.util.PathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestReader {
    private static final Logger logger = LoggerFactory.getLogger(ManifestReader.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private ManifestReader() {
    }

    static void readAllManifests(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping, Path rootDir, Bag bag) throws IOException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        logger.info(messages.getString("attempting_read_manifests"));
        try (DirectoryStream<Path> manifests = ManifestReader.getAllManifestFiles(rootDir);){
            for (Path path : manifests) {
                String filename = PathUtils.getFilename(path);
                if (filename.startsWith("tagmanifest-")) {
                    logger.debug(messages.getString("found_tagmanifest"), (Object)path);
                    bag.getTagManifests().add(ManifestReader.readManifest(nameMapping, path, bag.getRootDir(), bag.getFileEncoding()));
                    continue;
                }
                if (!filename.startsWith("manifest-")) continue;
                logger.debug(messages.getString("found_payload_manifest"), (Object)path);
                bag.getPayLoadManifests().add(ManifestReader.readManifest(nameMapping, path, bag.getRootDir(), bag.getFileEncoding()));
            }
        }
    }

    private static DirectoryStream<Path> getAllManifestFiles(Path rootDir) throws IOException {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) throws IOException {
                if (file == null || file.getFileName() == null) {
                    return false;
                }
                String filename = PathUtils.getFilename(file);
                return filename.startsWith("tagmanifest-") || filename.startsWith("manifest-");
            }
        };
        return Files.newDirectoryStream(rootDir, (DirectoryStream.Filter<? super Path>)filter);
    }

    public static Manifest readManifest(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping, Path manifestFile, Path bagRootDir, Charset charset) throws IOException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        logger.debug(messages.getString("reading_manifest"), (Object)manifestFile);
        String alg = PathUtils.getFilename(manifestFile).split("[-\\.]")[1];
        SupportedAlgorithm algorithm = nameMapping.getSupportedAlgorithm(alg);
        Manifest manifest = new Manifest(algorithm);
        Map<Path, String> filetToChecksumMap = ManifestReader.readChecksumFileMap(manifestFile, bagRootDir, charset);
        manifest.setFileToChecksumMap(filetToChecksumMap);
        return manifest;
    }

    static Map<Path, String> readChecksumFileMap(Path manifestFile, Path bagRootDir, Charset charset) throws IOException, MaliciousPathException, InvalidBagitFileFormatException {
        HashMap<Path, String> map = new HashMap<Path, String>();
        try (BufferedReader br = Files.newBufferedReader(manifestFile, charset);){
            String line = br.readLine();
            while (line != null) {
                String[] parts = line.split("\\s+", 2);
                Path file = TagFileReader.createFileFromManifest(bagRootDir, parts[1]);
                logger.debug("Read checksum [{}] and file [{}] from manifest [{}]", parts[0], file, manifestFile);
                map.put(file, parts[0]);
                line = br.readLine();
            }
        }
        return map;
    }
}

