/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.exceptions.FileNotInManifestException;
import gov.loc.repository.bagit.verify.AbstractPayloadFileExistsInManifestsVistor;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import org.slf4j.helpers.MessageFormatter;

public class PayloadFileExistsInAllManifestsVistor
extends AbstractPayloadFileExistsInManifestsVistor {
    private final transient Set<Manifest> manifests;

    public PayloadFileExistsInAllManifestsVistor(Set<Manifest> manifests, boolean ignoreHiddenFiles) {
        super(ignoreHiddenFiles);
        this.manifests = manifests;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws FileNotInManifestException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            for (Manifest manifest : this.manifests) {
                if (manifest.getFileToChecksumMap().keySet().contains(path.normalize())) continue;
                String formattedMessage = messages.getString("file_not_in_manifest_error");
                throw new FileNotInManifestException(MessageFormatter.format(formattedMessage, path, manifest.getAlgorithm().getBagitName()).getMessage());
            }
        }
        logger.debug(messages.getString("file_in_all_manifests"), (Object)path);
        return FileVisitResult.CONTINUE;
    }
}

