/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.exceptions.FileNotInManifestException;
import gov.loc.repository.bagit.verify.AbstractPayloadFileExistsInManifestsVistor;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import org.slf4j.helpers.MessageFormatter;

public class PayloadFileExistsInAtLeastOneManifestVistor
extends AbstractPayloadFileExistsInManifestsVistor {
    private final transient Set<Path> filesListedInManifests;

    public PayloadFileExistsInAtLeastOneManifestVistor(Set<Path> filesListedInManifests, boolean ignoreHiddenFiles) {
        super(ignoreHiddenFiles);
        this.filesListedInManifests = filesListedInManifests;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws FileNotInManifestException {
        if (Files.isRegularFile(path, new LinkOption[0]) && !this.filesListedInManifests.contains(path.normalize())) {
            String formattedMessage = messages.getString("file_not_in_any_manifest_error");
            throw new FileNotInManifestException(MessageFormatter.format(formattedMessage, path).getMessage());
        }
        logger.debug("[{}] is in at least one manifest", (Object)path);
        return FileVisitResult.CONTINUE;
    }
}

