/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArrayAssert
extends ArrayAssert<BooleanArrayAssert, boolean[]> {
    protected BooleanArrayAssert(boolean ... actual) {
        super(BooleanArrayAssert.class, actual);
    }

    public BooleanArrayAssert contains(boolean ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public BooleanArrayAssert containsOnly(boolean ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public BooleanArrayAssert excludes(boolean ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public BooleanArrayAssert isEqualTo(boolean[] expected) {
        if (Arrays.equals((boolean[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public BooleanArrayAssert isNotEqualTo(boolean[] array) {
        if (!Arrays.equals((boolean[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

