/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.cli;

import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.sb.SIPCreationJob;

class CliProgressManager
extends ProgressManager {
    private long copiedFilesFromListCount = 0L;

    CliProgressManager() {
    }

    @Override
    public void abort() {
        System.out.println("\nSIP-Erstellungsvorgang abgebrochen");
    }

    @Override
    public void createStartMessage() {
        System.out.println("\n\nSIP-Erstellung l\u00e4uft...");
    }

    @Override
    public void startJob(int id) {
        SIPCreationJob job = (SIPCreationJob)this.jobMap.get(id);
        job.initialTotalProgress = this.totalProgress;
        this.updateProgressBar();
    }

    @Override
    public void copyProgress(int id, long processedData) {
        super.copyProgress(id, processedData);
        this.updateProgressBar();
    }

    @Override
    public void premisProgress(int id, double progress) {
        super.premisProgress(id, progress);
        this.updateProgressBar();
    }

    @Override
    public void bagitProgress(int id, double progress) {
        super.bagitProgress(id, progress);
        this.updateProgressBar();
    }

    @Override
    public void archiveProgress(int id, long archivedData) {
        super.archiveProgress(id, archivedData);
        this.updateProgressBar();
    }

    @Override
    public void deleteTempProgress(int id, double progress) {
        super.deleteTempProgress(id, progress);
        this.updateProgressBar();
    }

    public void copyFilesFromListProgress() {
        ++this.copiedFilesFromListCount;
        this.totalProgress = (double)this.copiedFilesFromListCount / (double)this.totalSize * 100.0;
        this.updateProgressBar();
    }

    @Override
    public void skipJob(int id) {
        super.skipJob(id);
        this.updateProgressBar();
    }

    @Override
    public void createSuccessMessage(boolean skippedFiles) {
        super.createSuccessMessage(skippedFiles);
        this.updateProgressBar();
        System.out.println("\n\nDie SIP-Erstellung wurde erfolgreich abgeschlossen.");
        if (skippedFiles) {
            System.out.println("Bereits existierende SIPs wurden nicht neu erstellt. Starten Sie den SIP-Builder mit der Option -alwaysOverwrite, um s\u00e4mtliche SIPs neu zu generieren und existierende SIPs gleichen Namens im Zielordner zu \u00fcberschreiben.");
        }
    }

    private void updateProgressBar() {
        System.out.print("\r\r[");
        for (int i = 0; i < 25; ++i) {
            if (i < (int)(this.totalProgress / 4.0)) {
                System.out.print("=");
                continue;
            }
            System.out.print(" ");
        }
        System.out.print("] " + (double)Math.round(this.totalProgress * 10.0) / 10.0 + "%");
    }

    public void setTotalSize(long size) {
        this.totalSize = size;
    }
}

