/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.gui;

import de.uzk.hki.da.main.SIPBuilder;
import de.uzk.hki.da.sb.MessageWriter;
import java.awt.Component;
import java.awt.Image;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GuiMessageWriter
extends MessageWriter {
    private Component gui;
    private Image iconImage;

    @Override
    public void showMessage(String message) {
        this.showMessage(message, 0);
    }

    @Override
    public void showMessage(String message, int type) {
        if (type == -1) {
            JOptionPane.showMessageDialog(this.gui, message, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", type, new ImageIcon(this.iconImage));
        } else {
            JOptionPane.showMessageDialog(this.gui, message, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", type);
        }
    }

    @Override
    public void showLongErrorMessage(String message) {
        String prettyMsg = message.replace(",", ",\n");
        JTextArea textArea = new JTextArea(5, 40);
        textArea.setText(prettyMsg);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        JOptionPane.showMessageDialog(this.gui, scrollPane, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", 0, new ImageIcon(this.iconImage));
    }

    @Override
    public MessageWriter.UserInput showOverwriteDialog(String message) {
        Object[] options = new String[]{"Ja", "Nein", "Alle \u00fcberschreiben"};
        int answer = JOptionPane.showOptionDialog(this.gui, message, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", 0, 1, new ImageIcon(this.iconImage), options, null);
        switch (answer) {
            case 0: {
                return MessageWriter.UserInput.YES;
            }
            case 1: {
                return MessageWriter.UserInput.NO;
            }
            case 2: {
                return MessageWriter.UserInput.ALWAYS_OVERWRITE;
            }
        }
        return MessageWriter.UserInput.NO;
    }

    @Override
    public MessageWriter.UserInput showCollectionOverwriteDialog(String message) {
        Object[] options = new String[]{"Ja", "Nein"};
        int answer = JOptionPane.showOptionDialog(this.gui, message, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", 0, 1, new ImageIcon(this.iconImage), options, null);
        switch (answer) {
            case 0: {
                return MessageWriter.UserInput.YES;
            }
            case 1: {
                return MessageWriter.UserInput.NO;
            }
        }
        return MessageWriter.UserInput.NO;
    }

    @Override
    public void showZeroByteFileMessage() {
        Collections.sort(this.zeroByteFiles);
        String sipName = ((String)this.zeroByteFiles.get(0)).substring(((String)this.zeroByteFiles.get(0)).lastIndexOf(40) + 1, ((String)this.zeroByteFiles.get(0)).lastIndexOf(41));
        String message = "";
        if (this.zeroByteFiles.size() == 1) {
            message = "Bei der Erstellung des SIPs " + sipName + " wurde eine Datei\nder Gr\u00f6\u00dfe 0 Byte gefunden:\n\n" + ((String)this.zeroByteFiles.get(0)).substring(0, ((String)this.zeroByteFiles.get(0)).lastIndexOf(40)) + "\n\nBitte \u00fcberpr\u00fcfen Sie die Datei.";
        } else if (this.zeroByteFiles.size() < 11) {
            message = "Bei der Erstellung des SIPs " + sipName + " wurden Dateien\nder Gr\u00f6\u00dfe 0 Byte gefunden:\n\n";
            for (String s : this.zeroByteFiles) {
                message = message + s.substring(0, s.lastIndexOf(40));
                message = message + "\n";
            }
            message = message + "\nBitte \u00fcberpr\u00fcfen Sie die Dateien.";
        } else {
            message = "Bei der Erstellung des SIPs " + sipName + " wurden Dateien\nder Gr\u00f6\u00dfe 0 Byte gefunden:\n\n";
            for (int i = 0; i < 10; ++i) {
                message = message + ((String)this.zeroByteFiles.get(i)).substring(0, ((String)this.zeroByteFiles.get(i)).lastIndexOf(40));
                message = message + "\n";
            }
            message = message + "und ";
            message = message + String.valueOf(this.zeroByteFiles.size() - 10);
            message = message + " weitere Dateien.\n\n";
            message = message + "Bitte \u00fcberpr\u00fcfen Sie Ihre Daten.";
        }
        JOptionPane.showMessageDialog(this.gui, message, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", 0);
    }

    public void setGui(Component gui) {
        this.gui = gui;
    }

    public void setIconImage(Image iconImage) {
        this.iconImage = iconImage;
    }

    @Override
    public MessageWriter.UserInput showWrongReferencesInMetadataDialog(String message) {
        String prettyMsg = message.replace(",", ",\n");
        JTextArea textArea = new JTextArea(5, 40);
        textArea.setText(prettyMsg);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        Object[] options = new String[]{"Ja", "Nein"};
        int answer = JOptionPane.showOptionDialog(this.gui, scrollPane, SIPBuilder.getProperties().getProperty("ARCHIVE_NAME") + " SIP-Builder", 0, 1, new ImageIcon(this.iconImage), options, null);
        switch (answer) {
            case 0: {
                return MessageWriter.UserInput.YES;
            }
            case 1: {
                return MessageWriter.UserInput.NO;
            }
        }
        return MessageWriter.UserInput.NO;
    }
}

