/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.metadata;

import de.uzk.hki.da.metadata.LidoLicense;
import de.uzk.hki.da.metadata.NullLastComparator;
import de.uzk.hki.da.utils.C;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LidoParser {
    public Logger logger = LoggerFactory.getLogger(LidoParser.class);
    private Document lidoDoc = new Document();
    private List<Element> lidoLinkResources;
    private List<Element> lidoElements;

    public LidoParser(Document doc) throws JDOMException {
        this.lidoDoc = doc;
        this.lidoElements = this.getLidoElements();
        this.lidoLinkResources = this.getLinkResourceElements(this.lidoElements);
    }

    public List<Element> getLidoLinkResources() {
        return this.lidoLinkResources;
    }

    public void setLidoLinkResources(List<Element> lidoLinkResources) {
        this.lidoLinkResources = lidoLinkResources;
    }

    List<Element> getLidoElements() {
        List lidoElements = this.lidoDoc.getRootElement().getChildren("lido", C.LIDO_NS);
        return lidoElements;
    }

    private String getLidoRecID(Element lidoElement) {
        String recID = lidoElement.getChild("lidoRecID", C.LIDO_NS).getValue();
        return recID;
    }

    private static List<Element> xmlChainElements(Element element, String[] chain, Namespace[] spacy, int chainIndex) {
        ArrayList<Element> retti = new ArrayList<Element>();
        if (chainIndex == chain.length) {
            retti.add(element);
        } else {
            List childi;
            String nnn = chain[chainIndex];
            List childs = nnn.isEmpty() ? (childi = element.getChildren()) : (childi = element.getChildren(nnn, spacy[chainIndex]));
            ++chainIndex;
            for (Element child : childs) {
                List<Element> wallies = LidoParser.xmlChainElements(child, chain, spacy, chainIndex);
                if (wallies == null) continue;
                retti.addAll(wallies);
            }
        }
        return retti;
    }

    private static List<String> xmlChainValues(Element element, String[] chain, Namespace[] spacy, int chainIndex) {
        HashSet<String> hashies = new HashSet<String>();
        List<Element> descs = LidoParser.xmlChainElements(element, chain, spacy, chainIndex);
        for (Element desc : descs) {
            String wally = desc.getValue();
            if (wally == null || wally.isEmpty()) continue;
            hashies.add(wally);
        }
        ArrayList<String> retti = new ArrayList<String>(hashies);
        return retti;
    }

    private static List<String> lidoChainValues(Element element, String chainString) {
        String[] deffiArr = chainString.split("/", -1);
        Namespace[] spacyArr = new Namespace[deffiArr.length];
        for (int sss = 0; sss < spacyArr.length; ++sss) {
            spacyArr[sss] = C.LIDO_NS;
        }
        List<String> strings = LidoParser.xmlChainValues(element, deffiArr, spacyArr, 0);
        return strings;
    }

    private static List<Element> lidoChainElements(Element element, String chainString) {
        String[] deffiArr = chainString.split("/", -1);
        Namespace[] spacyArr = new Namespace[deffiArr.length];
        for (int sss = 0; sss < spacyArr.length; ++sss) {
            spacyArr[sss] = C.LIDO_NS;
        }
        List<Element> elements = LidoParser.xmlChainElements(element, deffiArr, spacyArr, 0);
        return elements;
    }

    private List<String> getTitle(Element lidoElement) {
        String deffi = "descriptiveMetadata/objectIdentificationWrap/titleWrap/titleSet/appellationValue";
        List<String> titles = LidoParser.lidoChainValues(lidoElement, deffi);
        return titles;
    }

    private List<String> getDescription(Element lidoElement) {
        String deffi = "descriptiveMetadata/objectIdentificationWrap/objectDescriptionWrap/objectDescriptionSet/descriptiveNoteValue";
        List<String> descries = LidoParser.lidoChainValues(lidoElement, deffi);
        return descries;
    }

    private List<String> getIdentifier(Element lidoElement) {
        String inve = "";
        String inveDef = "descriptiveMetadata/objectIdentificationWrap/repositoryWrap/repositorySet/workID";
        List<Element> workies = LidoParser.lidoChainElements(lidoElement, inveDef);
        for (Element worky : workies) {
            try {
                String typpi = worky.getAttributeValue("type", C.LIDO_NS);
                if (!"inventory number".equals(typpi)) continue;
                inve = worky.getValue();
                break;
            }
            catch (Exception e) {
                this.logger.error("No identifier inventory number Element found!");
            }
        }
        String ise = "";
        String iseDef = "administrativeMetadata/resourceWrap/resourceSet/resourceSource/legalBodyID";
        List<Element> isies = LidoParser.lidoChainElements(lidoElement, iseDef);
        for (Element isy : isies) {
            try {
                String sourcy = isy.getAttributeValue("source", C.LIDO_NS);
                if (!"isil".equals(sourcy)) continue;
                ise = isy.getValue();
                break;
            }
            catch (Exception e) {
                this.logger.error("No identifier legalBodyID Element found!");
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (inve != null && !inve.equals("")) {
            if (ise != null && !ise.equals("")) {
                ret.add(inve + " " + ise);
            } else {
                ret.add(inve);
            }
        } else if (ise != null && !ise.equals("")) {
            ret.add(ise);
        }
        return ret;
    }

    private List<String> getEdmDataProvider(Element lidoElement) {
        String deffi = "administrativeMetadata/recordWrap/recordSource";
        List<Element> recSors = LidoParser.lidoChainElements(lidoElement, deffi);
        ArrayList<String> ret = new ArrayList<String>();
        for (Element recSor : recSors) {
            String legalBodyName = "";
            try {
                legalBodyName = recSor.getChild("legalBodyName", C.LIDO_NS).getChild("appellationValue", C.LIDO_NS).getValue();
            }
            catch (Exception e) {
                this.logger.error("No legalBodyName Element found!");
            }
            String legalBodyID = "";
            try {
                legalBodyID = recSor.getChild("legalBodyID", C.LIDO_NS).getValue();
            }
            catch (Exception e) {
                this.logger.error("No legalBodyID Element found!");
            }
            if (legalBodyName != null && !legalBodyName.equals("")) {
                if (legalBodyID != null && !legalBodyID.equals("")) {
                    ret.add(legalBodyName + " " + legalBodyID);
                    continue;
                }
                ret.add(legalBodyName);
                continue;
            }
            if (legalBodyID == null || legalBodyID.equals("")) continue;
            ret.add(legalBodyID);
        }
        return ret;
    }

    private List<String> getDcRightsHolder(Element lidoElement) {
        String deffi = "administrativeMetadata/resourceWrap/resourceSet/rightsResource/rightsHolder/legalBodyName/appellationValue";
        List<String> retti = LidoParser.lidoChainValues(lidoElement, deffi);
        return retti;
    }

    private List<String> getDcRights(Element lidoElement) {
        ArrayList<String> rightIds = new ArrayList<String>();
        List<LidoLicense> licenses = this.getLicenseFromOneLidoPart(lidoElement);
        Collections.sort(licenses, new NullLastComparator());
        if (licenses.size() != 0 && licenses.get(0) != null) {
            rightIds.add(licenses.get(0).getHref());
        }
        return rightIds;
    }

    private List<String> getDate(Element lidoElement) {
        HashSet<String> dates = new HashSet<String>();
        String deffi = "descriptiveMetadata/eventWrap/eventSet/event/eventDate/";
        List<Element> eventDatesChildren = LidoParser.lidoChainElements(lidoElement, deffi);
        for (Element e : eventDatesChildren) {
            String date = "";
            if (e.getName().equals("displayDate")) {
                date = e.getValue();
            }
            if (date.equals("") && e.getName().equals("date")) {
                try {
                    String earliestDate = e.getChild("earliestDate", C.LIDO_NS).getValue();
                    String latestDate = e.getChild("latestDate", C.LIDO_NS).getValue();
                    if (!earliestDate.equals(latestDate)) {
                        date = earliestDate + "-" + latestDate;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (date.equals("")) continue;
            dates.add(date);
        }
        ArrayList<String> ret = new ArrayList<String>(dates);
        return ret;
    }

    private List<String> getType(Element lidoElement) {
        String deffi = "administrativeMetadata/resourceWrap/resourceSet/resourceType/term";
        List<String> retti = LidoParser.lidoChainValues(lidoElement, deffi);
        for (int iii = 0; iii < retti.size(); ++iii) {
            retti.set(iii, retti.get(iii).toUpperCase());
        }
        return retti;
    }

    private List<String> getProvenance(Element lidoElement) {
        String deffi = "descriptiveMetadata/eventWrap/eventSet/event/eventDescriptionSet/descriptiveNoteValue";
        List<String> retti = LidoParser.lidoChainValues(lidoElement, deffi);
        return retti;
    }

    private List<String> getEdmProvider(Element lidoElement) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("Digitales Archiv NRW");
        return ret;
    }

    private List<String> getExtent(Element lidoElement) {
        HashSet<String> extents = new HashSet<String>();
        String deffi = "descriptiveMetadata/objectIdentificationWrap/objectMeasurementsWrap/objectMeasurementsSet";
        List<Element> messies = LidoParser.lidoChainElements(lidoElement, deffi);
        for (Element messy : messies) {
            String ext = "";
            try {
                ext = messy.getChild("displayObjectMeasurements", C.LIDO_NS).getValue();
            }
            catch (Exception e) {
                this.logger.error("No displayObjectMeasurements Element found!");
            }
            String unit = "";
            try {
                unit = messy.getChild("objectMeasurements", C.LIDO_NS).getChild("measurementsSet", C.LIDO_NS).getChild("measurementUnit", C.LIDO_NS).getValue();
            }
            catch (Exception e) {
                this.logger.error("No measurementUnit Element found!");
            }
            ext = ext + " " + unit;
            extents.add(ext);
        }
        ArrayList<String> ret = new ArrayList<String>(extents);
        return ret;
    }

    private List<String> getSpatial(Element lidoElement) {
        HashSet<String> spatials = new HashSet<String>();
        String cS = "descriptiveMetadata/eventWrap/eventSet/event/eventPlace/displayPlace";
        List<String> spatials1 = LidoParser.lidoChainValues(lidoElement, cS);
        spatials.addAll(spatials1);
        cS = "descriptiveMetadata/eventWrap/eventSet/event/eventPlace/place/namePlaceSet/appellationValue";
        List<String> spatials2 = LidoParser.lidoChainValues(lidoElement, cS);
        spatials.addAll(spatials2);
        cS = "descriptiveMetadata/objectIdentificationWrap/repositoryWrap/repositorySet/repositoryLocation/namePlaceSet/appellationValue";
        List<String> spatials3 = LidoParser.lidoChainValues(lidoElement, cS);
        spatials.addAll(spatials3);
        ArrayList<String> ret = new ArrayList<String>(spatials);
        return ret;
    }

    public HashMap<String, HashMap<String, List<String>>> getIndexInfo(String objectId) {
        HashMap<String, HashMap<String, List<String>>> indexInfo = new HashMap<String, HashMap<String, List<String>>>();
        try {
            List<Element> lidoElements = this.getLidoElements();
            for (Element lidoElement : lidoElements) {
                HashMap<String, List<String>> lidoElementInfo = new HashMap<String, List<String>>();
                String id = objectId + "-" + this.getLidoRecID(lidoElement);
                this.logger.debug("ID: " + id);
                lidoElementInfo.put("dc:title", this.getTitle(lidoElement));
                lidoElementInfo.put("dc:date", this.getDate(lidoElement));
                lidoElementInfo.put("dcterms:spatial", this.getSpatial(lidoElement));
                lidoElementInfo.put("edm:type", this.getType(lidoElement));
                lidoElementInfo.put("dc:rightsHolder", this.getDcRightsHolder(lidoElement));
                lidoElementInfo.put("edm:dataProvider", this.getEdmDataProvider(lidoElement));
                lidoElementInfo.put("edm:provider", this.getEdmProvider(lidoElement));
                lidoElementInfo.put("dc:rights", this.getDcRights(lidoElement));
                lidoElementInfo.put("edm:rights", this.getDcRights(lidoElement));
                lidoElementInfo.put("dc:creator", this.getCreators(lidoElement));
                lidoElementInfo.put("dc:description", this.getDescription(lidoElement));
                lidoElementInfo.put("dc:identifier", this.getIdentifier(lidoElement));
                lidoElementInfo.put("dcterms:extent", this.getExtent(lidoElement));
                lidoElementInfo.put("dcterms:provenance", this.getProvenance(lidoElement));
                List<String> references = this.getReferencesFromLidoElement(lidoElement);
                if (references != null && !references.isEmpty()) {
                    ArrayList<String> shownBy = new ArrayList<String>();
                    shownBy.add(references.get(0));
                    lidoElementInfo.put("edm:isShownBy", shownBy);
                    if (references.size() == 1) {
                        lidoElementInfo.put("edm:object", references);
                    } else {
                        lidoElementInfo.put("edm:object", shownBy);
                        lidoElementInfo.put("edm:hasView", references);
                    }
                }
                indexInfo.put(id, lidoElementInfo);
            }
        }
        catch (Exception e) {
            new RuntimeException("Unable to parse the lido file for edm serialization.");
        }
        return indexInfo;
    }

    private List<String> getCreators(Element lidoElement) {
        String deffi = "descriptiveMetadata/eventWrap/eventSet/event/eventActor/displayActorInRole";
        List<String> namePartValue = LidoParser.lidoChainValues(lidoElement, deffi);
        return namePartValue;
    }

    public List<String> getReferencesFromLidoElement(Element lidoElement) {
        ArrayList<String> references = new ArrayList<String>();
        try {
            List<Element> currentLinkResources = this.getLinkResourceElemensFromLidoElement(lidoElement);
            for (Element resourceElement : currentLinkResources) {
                references.add(resourceElement.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to find references in lido element " + lidoElement.getName());
        }
        return references;
    }

    public List<Element> getLinkResourceElemensFromLidoElement(Element lidoElement) {
        ArrayList<Element> currentLinkResources = new ArrayList<Element>();
        if (lidoElement.getName().equalsIgnoreCase("lido")) {
            Element currentLinkResource = lidoElement.getChild("administrativeMetadata", C.LIDO_NS).getChild("resourceWrap", C.LIDO_NS).getChild("resourceSet", C.LIDO_NS).getChild("resourceRepresentation", C.LIDO_NS).getChild("linkResource", C.LIDO_NS);
            currentLinkResources.add(currentLinkResource);
        }
        return currentLinkResources;
    }

    private List<Element> getLinkResourceElements(List<Element> lidoElements) {
        ArrayList<Element> linkResourceElements = new ArrayList<Element>();
        for (Element element : lidoElements) {
            List<Element> elements = this.getLinkResourceElemensFromLidoElement(element);
            for (Element resourceElement : elements) {
                linkResourceElements.add(resourceElement);
            }
        }
        return linkResourceElements;
    }

    public List<String> getReferences() {
        ArrayList<String> linkResources = new ArrayList<String>();
        for (Element element : this.lidoLinkResources) {
            linkResources.add(element.getValue());
        }
        return linkResources;
    }

    public LidoLicense getLicenseForWholeLido() {
        return this.getLicenseForWholeLido(false);
    }

    protected LidoLicense getLicenseForWholeLido(boolean quiet) {
        ArrayList<LidoLicense> licenseAl = new ArrayList<LidoLicense>();
        List lidoSecs = this.lidoDoc.getRootElement().getChildren("lido", C.LIDO_NS);
        for (Element lido : lidoSecs) {
            licenseAl.addAll(this.getLicenseFromOneLidoPart(lido));
        }
        if (licenseAl.size() == 0) {
            return null;
        }
        Collections.sort(licenseAl, new NullLastComparator());
        if (licenseAl.get(0) == null) {
            return null;
        }
        if (!((LidoLicense)licenseAl.get(0)).equals(licenseAl.get(licenseAl.size() - 1)) && !quiet) {
            throw new RuntimeException("LIDO-Metadata contains different licenses(" + licenseAl.size() + ") e.g.:" + licenseAl.get(licenseAl.size() - 1) + " " + licenseAl.get(0));
        }
        return (LidoLicense)licenseAl.get(0);
    }

    protected List<LidoLicense> getLicenseFromOneLidoPart(Element lidoSec) {
        ArrayList<LidoLicense> lidoLicenses = new ArrayList<LidoLicense>();
        List admSections = lidoSec.getChildren("administrativeMetadata", C.LIDO_NS);
        for (int i = 0; i < admSections.size(); ++i) {
            Element resourceWrap = ((Element)admSections.get(i)).getChild("resourceWrap", C.LIDO_NS);
            if (resourceWrap == null) {
                lidoLicenses.add(null);
                continue;
            }
            List resourceSets = resourceWrap.getChildren("resourceSet", C.LIDO_NS);
            if (resourceSets.size() == 0) {
                lidoLicenses.add(null);
                continue;
            }
            for (int j = 0; j < resourceSets.size(); ++j) {
                List rightsResources = ((Element)resourceSets.get(j)).getChildren("rightsResource", C.LIDO_NS);
                if (rightsResources.size() == 0) {
                    lidoLicenses.add(null);
                    continue;
                }
                for (int k = 0; k < rightsResources.size(); ++k) {
                    List rightsTypes = ((Element)rightsResources.get(k)).getChildren("rightsType", C.LIDO_NS);
                    if (rightsTypes.size() == 0) {
                        lidoLicenses.add(null);
                        continue;
                    }
                    for (int m = 0; m < rightsTypes.size(); ++m) {
                        lidoLicenses.add(this.getLicenseFromOneRightsType((Element)rightsTypes.get(m)));
                    }
                }
            }
        }
        return lidoLicenses;
    }

    protected LidoLicense getLicenseFromOneRightsType(Element rightsType) {
        List conceptIDs = rightsType.getChildren("conceptID", C.LIDO_NS);
        List terms = rightsType.getChildren("term", C.LIDO_NS);
        if (conceptIDs.size() == 0 || terms.size() == 0) {
            throw new RuntimeException("LIDO-Metadata RightsType has no conceptID and/or term " + rightsType.toString());
        }
        if (conceptIDs.size() != 1 || terms.size() != 1) {
            throw new RuntimeException("LIDO-Metadata RightsType has more as one conceptID and/or term: " + rightsType.getValue());
        }
        String licenseURI = ((Element)conceptIDs.get(0)).getText();
        String type = ((Element)conceptIDs.get(0)).getAttribute("type", C.LIDO_NS).getValue();
        if (!"URI".equals(type)) {
            this.logger.debug("lido:conceptID type is not URI: " + type);
        }
        String term = ((Element)terms.get(0)).getText();
        return new LidoLicense(licenseURI, term);
    }
}

