/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ArchiveBuilder;
import de.uzk.hki.da.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeJavaTarArchiveBuilder
implements ArchiveBuilder {
    static final Logger logger = LoggerFactory.getLogger(NativeJavaTarArchiveBuilder.class);
    private String firstLevelEntryName = "";
    private int longFileMode = 2;
    private int bigNumberMode = 2;

    @Override
    public void unarchiveFolder(File srcTar, File destFolder) throws Exception {
        TarArchiveEntry entry;
        FileInputStream fin = new FileInputStream(srcTar);
        BufferedInputStream in = new BufferedInputStream(fin);
        TarArchiveInputStream tIn = new TarArchiveInputStream(in);
        HashMap<String, Long> modDateMap = new HashMap<String, Long>();
        while ((entry = tIn.getNextTarEntry()) != null) {
            logger.debug(entry.getName());
            String dstName = destFolder.getAbsolutePath() + "/" + entry.getName();
            File entryFile = new File(dstName);
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                modDateMap.put(dstName, new Long(entry.getModTime().getTime()));
                continue;
            }
            new File(entryFile.getAbsolutePath().substring(0, entryFile.getAbsolutePath().lastIndexOf(47))).mkdirs();
            FileOutputStream out = new FileOutputStream(entryFile);
            IOUtils.copy((InputStream)tIn, (OutputStream)out);
            out.close();
            entryFile.setLastModified(entry.getModTime().getTime());
        }
        tIn.close();
        in.close();
        fin.close();
        for (Map.Entry moddi : modDateMap.entrySet()) {
            String key = (String)moddi.getKey();
            Long value = (Long)moddi.getValue();
            new File(key).setLastModified(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveFolder(File srcFolder, File destFile, boolean includeFolder) throws Exception {
        FileOutputStream fOut = null;
        BufferedOutputStream bOut = null;
        TarArchiveOutputStream tOut = null;
        fOut = new FileOutputStream(destFile);
        bOut = new BufferedOutputStream(fOut);
        tOut = new TarArchiveOutputStream(bOut);
        tOut.setLongFileMode(this.longFileMode);
        tOut.setBigNumberMode(this.bigNumberMode);
        try {
            String base = "";
            if (this.firstLevelEntryName.isEmpty()) {
                this.firstLevelEntryName = srcFolder.getName() + "/";
            }
            if (includeFolder) {
                logger.debug("addFileToTar: " + this.firstLevelEntryName);
                TarArchiveEntry entry = (TarArchiveEntry)tOut.createArchiveEntry(srcFolder, this.firstLevelEntryName);
                tOut.putArchiveEntry(entry);
                tOut.closeArchiveEntry();
                base = this.firstLevelEntryName;
            }
            File[] children = srcFolder.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.addFileToTar(tOut, children[i], base);
            }
        }
        finally {
            tOut.finish();
            tOut.close();
            bOut.close();
            fOut.close();
            this.firstLevelEntryName = "";
        }
    }

    private void addFileToTar(TarArchiveOutputStream tOut, File file, String base) throws IOException {
        String entryName = base + file.getName();
        logger.debug("addFileToTar: " + entryName);
        TarArchiveEntry entry = (TarArchiveEntry)tOut.createArchiveEntry(file, entryName);
        tOut.putArchiveEntry(entry);
        if (file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)tOut);
            fileInputStream.close();
            tOut.closeArchiveEntry();
        }
        if (file.isDirectory()) {
            tOut.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.addFileToTar(tOut, children[i], entryName + "/");
            }
        }
    }

    public String getFirstLevelEntryName() {
        return this.firstLevelEntryName;
    }

    public void setFirstLevelEntryName(String firstLevelEntryName) {
        if (firstLevelEntryName == null) {
            this.firstLevelEntryName = "";
        }
        this.firstLevelEntryName = StringUtilities.slashize(firstLevelEntryName);
    }

    public int getBigNumberMode() {
        return this.bigNumberMode;
    }

    public void setBigNumberMode(int bigNumberMode) {
        this.bigNumberMode = bigNumberMode;
    }

    public int getLongFileMode() {
        return this.longFileMode;
    }

    public void setLongFileMode(int longFileMode) {
        this.longFileMode = longFileMode;
    }
}

